/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_INTEGRACAO_FERIAS_FOLHA")
public class ItemIntegracaoFeriasFolha
implements InterfaceVO {
    private Long identificador;
    private ItemMovimentoFerias itemFerias;
    private ItemMovimentoFolha itemFolha;
    private Double valorEvento = 0.0;
    private Double vlrIrrf = 0.0;
    private Double bcIrrfFerias = 0.0;
    private Double aliquotaIrrfFerias = 0.0;
    private ItemMovimentoRescisao itemRecisao;

    @Id
    @Column(nullable=false, unique=true, name="ID_FOLHA_FERIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FOLHA_FERIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_MOVIMENTO_FERIAS", foreignKey=@ForeignKey(name="FK_ITEM_INTEGRACAO_FERIAS_FOLHA"))
    public ItemMovimentoFerias getItemFerias() {
        return this.itemFerias;
    }

    public void setItemFerias(ItemMovimentoFerias itemFerias) {
        this.itemFerias = itemFerias;
    }

    @OneToOne(mappedBy="itemFeriasFolha", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.SAVE_UPDATE})
    public ItemMovimentoFolha getItemFolha() {
        return this.itemFolha;
    }

    public void setItemFolha(ItemMovimentoFolha itemFolha) {
        this.itemFolha = itemFolha;
    }

    @Column(name="VALOR_EVENTO", precision=15, scale=4)
    public Double getValorEvento() {
        return this.valorEvento;
    }

    public void setValorEvento(Double valorEvento) {
        this.valorEvento = valorEvento;
    }

    @Column(name="VLR_IRRF", precision=15, scale=4)
    public Double getVlrIrrf() {
        return this.vlrIrrf;
    }

    public void setVlrIrrf(Double vlrIrrf) {
        this.vlrIrrf = vlrIrrf;
    }

    @Column(name="BC_IRRF_FERIAS", precision=15, scale=4)
    public Double getBcIrrfFerias() {
        return this.bcIrrfFerias;
    }

    public void setBcIrrfFerias(Double bcIrrfFerias) {
        this.bcIrrfFerias = bcIrrfFerias;
    }

    @Column(nullable=false, name="ALIQUOTA_IRRF_FERIAS", precision=15, scale=4)
    public Double getAliquotaIrrfFerias() {
        return this.aliquotaIrrfFerias;
    }

    public void setAliquotaIrrfFerias(Double aliquotaIrrfFerias) {
        this.aliquotaIrrfFerias = aliquotaIrrfFerias;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="itemFeriasRescisao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.SAVE_UPDATE})
    public ItemMovimentoRescisao getItemRecisao() {
        return this.itemRecisao;
    }

    public void setItemRecisao(ItemMovimentoRescisao itemRecisao) {
        this.itemRecisao = itemRecisao;
    }
}

