/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOReinf;
import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemReinfDeducao4010;
import com.touchcomp.basementor.model.vo.ReinfNaturezaRendimento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="item_reinf_4040")
public class ItemReinf4040
implements InterfaceVO,
InterfaceVOReinf {
    private Long identificador;
    private ApuracaoReinf apuracaoReinf;
    private Date dataPagamento;
    private Double baseIrrf = 0.0;
    private Double vlrIrrf = 0.0;
    private Double liquido = 0.0;
    private Date dataEscrituracao;
    private String descricaoPagamento;
    private ReinfNaturezaRendimento naturezaRendimento;
    private List<ItemReinfDeducao4010> deducoes;
    private Empresa empresa;
    private List<ReinfPreEvento> preEventosReinf = new ArrayList<ReinfPreEvento>();
    private String cpf;

    public ItemReinf4040() {
        this.deducoes = new ArrayList<ItemReinfDeducao4010>();
    }

    public ItemReinf4040(Empresa empresa) {
        this.empresa = empresa;
        this.deducoes = new ArrayList<ItemReinfDeducao4010>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_REINF_4040")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_REINF_4040")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_apuracao_reinf")
    public ApuracaoReinf getApuracaoReinf() {
        return this.apuracaoReinf;
    }

    public void setApuracaoReinf(ApuracaoReinf apuracaoReinf) {
        this.apuracaoReinf = apuracaoReinf;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="data_pagamento")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Column(name="base_irrf")
    public Double getBaseIrrf() {
        return this.baseIrrf;
    }

    public void setBaseIrrf(Double baseIrrf) {
        this.baseIrrf = baseIrrf;
    }

    @Column(name="vlr_irrf")
    public Double getVlrIrrf() {
        return this.vlrIrrf;
    }

    public void setVlrIrrf(Double vlrIrrf) {
        this.vlrIrrf = vlrIrrf;
    }

    @Column(name="liquido")
    public Double getLiquido() {
        return this.liquido;
    }

    public void setLiquido(Double liquido) {
        this.liquido = liquido;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="data_escrituracao")
    public Date getDataEscrituracao() {
        return this.dataEscrituracao;
    }

    public void setDataEscrituracao(Date dataEscrituracao) {
        this.dataEscrituracao = dataEscrituracao;
    }

    @Column(name="descricao_pagamento")
    public String getDescricaoPagamento() {
        return this.descricaoPagamento;
    }

    public void setDescricaoPagamento(String descricaoPagamento) {
        this.descricaoPagamento = descricaoPagamento;
    }

    @JoinColumn(name="id_natureza_rendimento")
    @ManyToOne(fetch=FetchType.LAZY)
    public ReinfNaturezaRendimento getNaturezaRendimento() {
        return this.naturezaRendimento;
    }

    public void setNaturezaRendimento(ReinfNaturezaRendimento naturezaRendimento) {
        this.naturezaRendimento = naturezaRendimento;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @Override
    @OneToMany(mappedBy="itemReinf4040", fetch=FetchType.LAZY)
    public List<ReinfPreEvento> getPreEventosReinf() {
        return this.preEventosReinf;
    }

    public void setPreEventosReinf(List<ReinfPreEvento> preEventosReinf) {
        this.preEventosReinf = preEventosReinf;
    }

    @JoinColumn(name="id_empresa")
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="CPF")
    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinfDeducao4010> getDeducoes() {
        return this.deducoes;
    }

    public void setDeducoes(List<ItemReinfDeducao4010> deducoes) {
        this.deducoes = deducoes;
    }
}

