/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_TRANSF_CENTRO_ESTOQUE")
public class ItemTransfCentroEstoque
implements InterfaceVO {
    private Long identificador;
    private Produto produto;
    private Double quantidadeTotal = 0.0;
    private TransferenciaCentroEstoque transfCentroEstoque;
    private List<GradeItemTransfCentroEstoque> gradeItemTransCentroEst = new ArrayList<GradeItemTransfCentroEstoque>();
    private CentroEstoque destino;
    private CentroEstoque origem;

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_TRANSF_CENTRO_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_TRANSF_CENTRO_EST")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_TRANSF_CENTRO_EST_PROD"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=15, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @JoinColumn(name="ID_TRANSF_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_TRANSF_CENTRO_EST_TRA_E"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TransferenciaCentroEstoque getTransfCentroEstoque() {
        return this.transfCentroEstoque;
    }

    public void setTransfCentroEstoque(TransferenciaCentroEstoque transfCentroEstoque) {
        this.transfCentroEstoque = transfCentroEstoque;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="itemTransfCentroEst")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<GradeItemTransfCentroEstoque> getGradeItemTransCentroEst() {
        return this.gradeItemTransCentroEst;
    }

    public void setGradeItemTransCentroEst(List<GradeItemTransfCentroEstoque> gradeItemTransCentroEst) {
        this.gradeItemTransCentroEst = gradeItemTransCentroEst;
    }

    @JoinColumn(updatable=false, name="ID_CENTRO_EST_DESTINO", foreignKey=@ForeignKey(name="FK_ITEM_TRANSF_CENTRO_EST_DESTI"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getDestino() {
        return this.destino;
    }

    public void setDestino(CentroEstoque destino) {
        this.destino = destino;
    }

    @JoinColumn(updatable=false, name="ID_CENTRO_EST_ORIGEM", foreignKey=@ForeignKey(name="FK_ITEM_TRANSF_CENTRO_EST_ORIGE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getOrigem() {
        return this.origem;
    }

    public void setOrigem(CentroEstoque origem) {
        this.origem = origem;
    }
}

