/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemLancamentoRubrica;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LANCAMENTO_RUBRICA_EM_FOLHA")
public class LancamentoRubricaEmFolha
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualiazacao;
    private Usuario usuario;
    private TipoCalculoEvento tipoCalculoEvento;
    private Short tipoEvento = 1;
    private Short desfazerOperacao = 0;
    private List<ItemLancamentoRubrica> lancamentos = new ArrayList<ItemLancamentoRubrica>();
    private AberturaPeriodo abertura;
    private CentroCusto centroCusto;
    private Sindicato sindicato;
    private Double valorReferencia = 0.0;
    private Short buscarColaboradoresComEvento = 0;
    private Short buscarAdicionaisNaoPagos = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_LANCAMENTO_RUBRICA_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANCAMENTO_RUBRICA_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_LANC_RUBRICA_FOLHA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualiazacao() {
        return this.dataAtualiazacao;
    }

    public void setDataAtualiazacao(Timestamp dataAtualiazacao) {
        this.dataAtualiazacao = dataAtualiazacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_USUARIO_LANC_RUBRICA"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_EVENTO", foreignKey=@ForeignKey(name="FK_TP_CALCULO_RUBRICA"))
    public TipoCalculoEvento getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(TipoCalculoEvento tipoCalculoEvento) {
        this.tipoCalculoEvento = tipoCalculoEvento;
    }

    @Column(name="TIPO_EVENTO")
    public Short getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(Short tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @Column(name="DESFAZER_OPERACAO")
    public Short getDesfazerOperacao() {
        return this.desfazerOperacao;
    }

    public void setDesfazerOperacao(Short desfazerOperacao) {
        this.desfazerOperacao = desfazerOperacao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="lancamentoRubrica", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemLancamentoRubrica> getLancamentos() {
        return this.lancamentos;
    }

    public void setLancamentos(List<ItemLancamentoRubrica> lancamentos) {
        this.lancamentos = lancamentos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ABERTURA", foreignKey=@ForeignKey(name="FK_ABERTURA_LANCAMENTO_RUBRICA"))
    public AberturaPeriodo getAbertura() {
        return this.abertura;
    }

    public void setAbertura(AberturaPeriodo abertura) {
        this.abertura = abertura;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_CENTRO_CUSTO_LANC_RUBRICA"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SINDICATO", foreignKey=@ForeignKey(name="FK_SINDICATO_LANC_RUBRICA"))
    public Sindicato getSindicato() {
        return this.sindicato;
    }

    public void setSindicato(Sindicato sindicato) {
        this.sindicato = sindicato;
    }

    @Column(name="VALOR_REFERENCIA", precision=15, scale=2)
    public Double getValorReferencia() {
        return this.valorReferencia;
    }

    public void setValorReferencia(Double valorReferencia) {
        this.valorReferencia = valorReferencia;
    }

    @Column(name="BUSCAR_COLABORADORES_COM_EVENTO")
    public Short getBuscarColaboradoresComEvento() {
        return this.buscarColaboradoresComEvento;
    }

    public void setBuscarColaboradoresComEvento(Short buscarColaboradoresComEvento) {
        this.buscarColaboradoresComEvento = buscarColaboradoresComEvento;
    }

    @Column(name="BUSCAR_ADICIONAIS_NAO_PAGOS")
    public Short getBuscarAdicionaisNaoPagos() {
        return this.buscarAdicionaisNaoPagos;
    }

    public void setBuscarAdicionaisNaoPagos(Short buscarAdicionaisNaoPagos) {
        this.buscarAdicionaisNaoPagos = buscarAdicionaisNaoPagos;
    }
}

