/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LIBERACAO_PEDIDO")
public class LiberacaoPedido
implements InterfaceVO {
    private Long identificador;
    private List<Pedido> pedido = new ArrayList<Pedido>();
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Usuario usuario;
    private Short tipoLiberacaoPedido = 0;
    private Double valorPreLiberado = 0.0;
    private UnidadeFatCliente unidadeFatCliente;
    private Short liberacaoUtilizada = 0;

    @Id
    @Column(name="ID_LIBERACAO_PEDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LIBERACAO_PEDIDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.SAVE_UPDATE})
    @JoinTable(name="liberacao_ped_pedido", joinColumns={@JoinColumn(name="id_liberacao_pedido")}, inverseJoinColumns={@JoinColumn(name="id_pedido")})
    public List<Pedido> getPedido() {
        return this.pedido;
    }

    public void setPedido(List<Pedido> pedido) {
        this.pedido = pedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LIBERACAO_PEDIDO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LIBERACAO_PEDIDO_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="TIPO_LIBERACAO_PEDIDO")
    public Short getTipoLiberacaoPedido() {
        return this.tipoLiberacaoPedido;
    }

    public void setTipoLiberacaoPedido(Short tipoLiberacaoPedido) {
        this.tipoLiberacaoPedido = tipoLiberacaoPedido;
    }

    @Column(nullable=false, name="VALOR_PRE_LIBERADO", precision=15, scale=2)
    public Double getValorPreLiberado() {
        return this.valorPreLiberado;
    }

    public void setValorPreLiberado(Double valorPreLiberado) {
        this.valorPreLiberado = valorPreLiberado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_LIBERACAO_PEDIDO_UNID_FAT_CL"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @Column(name="LIBERACAO_UTILIZADA")
    public Short getLiberacaoUtilizada() {
        return this.liberacaoUtilizada;
    }

    public void setLiberacaoUtilizada(Short liberacaoUtilizada) {
        this.liberacaoUtilizada = liberacaoUtilizada;
    }
}

