/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ModeloCheckList;
import com.touchcomp.basementor.model.vo.ModeloCheckListItemOpcao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="MODELO_CHECK_LIST_ITEM", indexes={@Index(name="idx_indice", columnList="indice")})
public class ModeloCheckListItem
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String observacao;
    private List<ModeloCheckListItemOpcao> opcoes = new ArrayList<ModeloCheckListItemOpcao>();
    private ModeloCheckList modeloCheckList;
    private Short ativo = 1;
    private Timestamp dataAtualizacao;
    private Integer indice = 0;
    private Short itemAvaliativo = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_MODELO_CHECK_LIST_ITEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_CHECK_LIST_ITEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="itemCheckList")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ModeloCheckListItemOpcao> getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(List<ModeloCheckListItemOpcao> opcoes) {
        this.opcoes = opcoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_MODELO_CHECK_LIST", foreignKey=@ForeignKey(name="FK_MOD_CHECK_L_ITEM_MOD_CH"))
    public ModeloCheckList getModeloCheckList() {
        return this.modeloCheckList;
    }

    public void setModeloCheckList(ModeloCheckList modeloCheckList) {
        this.modeloCheckList = modeloCheckList;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="INDICE")
    public Integer getIndice() {
        return this.indice;
    }

    public void setIndice(Integer indice) {
        this.indice = indice;
    }

    @Column(name="ITEM_AVALIATIVO")
    public Short getItemAvaliativo() {
        return this.itemAvaliativo;
    }

    public void setItemAvaliativo(Short itemAvaliativo) {
        this.itemAvaliativo = itemAvaliativo;
    }
}

