/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.modelofiscalicmsst.EnumConstModFiscalIcmsSTFatorCalculo;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalICMSST;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="MODELO_FISCAL_ICMSST_ITEM")
public class ModeloFiscalICMSSTItem
implements InterfaceVO {
    private Long identificador;
    private Short inativo = 0;
    private String descricao;
    private List<CNAE> cnaes = new ArrayList<CNAE>();
    private List<Ncm> ncms = new ArrayList<Ncm>();
    private List<CategoriaSt> categoriaST = new ArrayList<CategoriaSt>();
    private Double aliquotaIcms = 0.0;
    private Double descontoPadrao = 0.0;
    private Double indiceAlteracao = 0.0;
    private ModeloFiscalICMSST modeloFiscalICMSST;
    private Short contribuinteEstado = 0;
    private List<IncidenciaIcms> incidenciaIcms;
    private Short consumidorFinal = 0;
    private List<CategoriaPessoa> categoriaPessoa = new ArrayList<CategoriaPessoa>();
    private Short fatorCalculo;

    public ModeloFiscalICMSSTItem() {
        this.incidenciaIcms = new ArrayList<IncidenciaIcms>();
        this.fatorCalculo = EnumConstModFiscalIcmsSTFatorCalculo.FATOR_CALCULO_MULTIPLICADOR.getValue();
    }

    @Id
    @Column(name="ID_MODELO_FISCAL_ICMSST_ITEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_FISCAL_ICMSST_ITEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="INATIVO")
    public Short getInativo() {
        return this.inativo;
    }

    public void setInativo(Short inativo) {
        this.inativo = inativo;
    }

    @Column(name="DESCRICAO", length=250)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany
    @JoinTable(name="modelo_fiscal_icmst_it_cnaes", joinColumns={@JoinColumn(name="id_modelo_fiscal_icmst_it_cnae")}, inverseJoinColumns={@JoinColumn(name="id_cnae")})
    public List<CNAE> getCnaes() {
        return this.cnaes;
    }

    public void setCnaes(List<CNAE> cnaes) {
        this.cnaes = cnaes;
    }

    @OneToMany
    @JoinTable(name="modelo_fiscal_icmst_it_ncms", joinColumns={@JoinColumn(name="id_modelo_fiscal_icmst_it_ncm")}, inverseJoinColumns={@JoinColumn(name="id_ncm")})
    public List<Ncm> getNcms() {
        return this.ncms;
    }

    public void setNcms(List<Ncm> ncms) {
        this.ncms = ncms;
    }

    @Column(name="ALIQUOTA_ICMS", precision=15, scale=2)
    public Double getAliquotaIcms() {
        return this.aliquotaIcms;
    }

    public void setAliquotaIcms(Double aliquotaIcms) {
        this.aliquotaIcms = aliquotaIcms;
    }

    @Column(nullable=false, name="DESCONTO_PADRAO", precision=15, scale=2)
    public Double getDescontoPadrao() {
        return this.descontoPadrao;
    }

    public void setDescontoPadrao(Double descontoPadrao) {
        this.descontoPadrao = descontoPadrao;
    }

    @Column(nullable=false, name="INDICE_ALTERACAO", precision=15, scale=6)
    public Double getIndiceAlteracao() {
        return this.indiceAlteracao;
    }

    public void setIndiceAlteracao(Double indiceAlteracao) {
        this.indiceAlteracao = indiceAlteracao;
    }

    @JoinColumn(name="ID_MODELO_FISCAL_ICMSST", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_ICMSST_ITEM_MO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModeloFiscalICMSST getModeloFiscalICMSST() {
        return this.modeloFiscalICMSST;
    }

    public void setModeloFiscalICMSST(ModeloFiscalICMSST modeloFiscalICMSST) {
        this.modeloFiscalICMSST = modeloFiscalICMSST;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CONTRIBUINTE_ESTADO")
    public Short getContribuinteEstado() {
        return this.contribuinteEstado;
    }

    public void setContribuinteEstado(Short contribuinteEstado) {
        this.contribuinteEstado = contribuinteEstado;
    }

    @OneToMany
    @JoinTable(name="modelo_fiscal_icmst_inc_icms", joinColumns={@JoinColumn(name="id_modelo_fiscal_icmst_item")}, inverseJoinColumns={@JoinColumn(name="id_incidencia_icms")})
    public List<IncidenciaIcms> getIncidenciaIcms() {
        return this.incidenciaIcms;
    }

    public void setIncidenciaIcms(List<IncidenciaIcms> incidenciaIcms) {
        this.incidenciaIcms = incidenciaIcms;
    }

    @OneToMany
    @JoinTable(name="modelo_fiscal_icmst_cat_st", joinColumns={@JoinColumn(name="id_modelo_fiscal_icmst_item")}, inverseJoinColumns={@JoinColumn(name="id_categoria_st")})
    public List<CategoriaSt> getCategoriaST() {
        return this.categoriaST;
    }

    public void setCategoriaST(List<CategoriaSt> categoriaST) {
        this.categoriaST = categoriaST;
    }

    @Column(name="CONSUMIDOR_FINAL")
    public Short getConsumidorFinal() {
        return this.consumidorFinal;
    }

    public void setConsumidorFinal(Short consumidorFinal) {
        this.consumidorFinal = consumidorFinal;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="modelo_fiscal_icmst_cat_pessoa", joinColumns={@JoinColumn(name="id_modelo_fiscal_icmst_item")}, inverseJoinColumns={@JoinColumn(name="id_categoria_pessoa")})
    public List<CategoriaPessoa> getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(List<CategoriaPessoa> categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @Column(name="FATOR_CALCULO")
    public Short getFatorCalculo() {
        return this.fatorCalculo;
    }

    public void setFatorCalculo(Short fatorCalculo) {
        this.fatorCalculo = fatorCalculo;
    }
}

