/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.modelolancamentobancario.EnumConstModeloLancamentoBancario;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemModeloLancBancario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="MODELO_LANC_BANCARIO", uniqueConstraints={@UniqueConstraint(name="UNQ1_MODELO_LANC_BANCARIO", columnNames={"NOME"})})
public class ModeloLancBancario
implements InterfaceVO {
    private static final long serialVersionUID = 1L;
    private Long identificador;
    private String nome;
    private List<ItemModeloLancBancario> itemModeloLancBancario;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short ativo = 1;
    private Short naoContabilizarMov = 0;
    private Short tipoAplicacaoCredDeb = EnumConstModeloLancamentoBancario.AMBOS.getValue();

    public ModeloLancBancario(Long identificador, String nome, Short ativo) {
        this();
        this.identificador = identificador;
        this.nome = nome;
        this.ativo = ativo;
    }

    public ModeloLancBancario() {
        this.itemModeloLancBancario = new ArrayList<ItemModeloLancBancario>();
    }

    @Id
    @Column(nullable=false, name="ID_MODELO_LANC_BANCARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_LANC_BANCARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MODELO_LANC_BANCARIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="modeloLancBancario", orphanRemoval=true)
    @Fetch(value=FetchMode.SELECT)
    public List<ItemModeloLancBancario> getItemModeloLancBancario() {
        return this.itemModeloLancBancario;
    }

    @Column(nullable=false, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setItemModeloLancBancario(List<ItemModeloLancBancario> itemModeloLancBancario) {
        this.itemModeloLancBancario = itemModeloLancBancario;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NAO_CONTABILIZAR_MOV")
    public Short getNaoContabilizarMov() {
        return this.naoContabilizarMov;
    }

    public void setNaoContabilizarMov(Short naoContabilizarMov) {
        this.naoContabilizarMov = naoContabilizarMov;
    }

    @Column(name="TIPO_APLICACAO_CRED_DEB")
    public Short getTipoAplicacaoCredDeb() {
        return this.tipoAplicacaoCredDeb;
    }

    public void setTipoAplicacaoCredDeb(Short tipoAplicacaoCredDeb) {
        this.tipoAplicacaoCredDeb = tipoAplicacaoCredDeb;
    }
}

