/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeFonteImpressao;
import com.touchcomp.basementor.constants.enums.tef.EnumTEFTipoTef;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="NFCE_CAIXA", uniqueConstraints={@UniqueConstraint(name="UNQ1_NFCE_CAIXA", columnNames={"DESCRICAO"})})
public class NFCeCaixa
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private ContaValores contaValorCaixa;
    private ContaValores contaValorRetaguarda;
    private CarteiraCobranca carteiraCobrancaOrigem;
    private CarteiraCobranca carteiraCobrancaDestino;
    private Timestamp dataAtualizacao;
    private String descricao;
    private ModeloLancBancario modeloLancBancarioDevedor;
    private ModeloLancBancario modeloLancBancarioCredor;
    private Double valorMaxDinheiroCaixa = 0.0;
    private Integer serieCaixaNFCe = 0;
    private Integer serieCaixaNFe = 0;
    private Integer numeroCaixa = 0;
    private Long numeroInicialNFCe = 0L;
    private String nrLojaSitef;
    private String nrTerminalSitef;
    private String enderecoSiTef;
    private Short tipoTEF = EnumTEFTipoTef.TIPO_TEF_NAO_UTILIZA.getValue();
    private Short restricoesSitef = 1;
    private Short caixaSlave = 1;
    private Long numeroInicialNFe = 0L;
    private Short fonteImpressao = EnumConstNFCeFonteImpressao.SANS_SERIF_PADRAO.getValue();

    @Id
    @Column(name="ID_NFCE_CAIXA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NFCE_CAIXA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NFCE_CAIXA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR_CAIXA", foreignKey=@ForeignKey(name="FK_NFCE_CAIXA_CONTA_VLR_CAIXA"))
    public ContaValores getContaValorCaixa() {
        return this.contaValorCaixa;
    }

    public void setContaValorCaixa(ContaValores contaValorCaixa) {
        this.contaValorCaixa = contaValorCaixa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR_RETAGUARDA", foreignKey=@ForeignKey(name="FK_NFCE_CAIXA_CONTA_VLR_RETAG"))
    public ContaValores getContaValorRetaguarda() {
        return this.contaValorRetaguarda;
    }

    public void setContaValorRetaguarda(ContaValores contaValorRetaguarda) {
        this.contaValorRetaguarda = contaValorRetaguarda;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_LANC_BANC_DEVEDOR", foreignKey=@ForeignKey(name="FK_NFCE_CAIXA_MOD_LANC_B_DEVEDO"))
    public ModeloLancBancario getModeloLancBancarioDevedor() {
        return this.modeloLancBancarioDevedor;
    }

    public void setModeloLancBancarioDevedor(ModeloLancBancario modeloLancBancarioDevedor) {
        this.modeloLancBancarioDevedor = modeloLancBancarioDevedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_LANC_BANC_CREDOR", foreignKey=@ForeignKey(name="FK_NFCE_CAIXA_MOD_LANC_CRED"))
    public ModeloLancBancario getModeloLancBancarioCredor() {
        return this.modeloLancBancarioCredor;
    }

    public void setModeloLancBancarioCredor(ModeloLancBancario modeloLancBancarioCredor) {
        this.modeloLancBancarioCredor = modeloLancBancarioCredor;
    }

    @Column(nullable=false, name="VALOR_MAX_DINHEIRO_CAIXA", precision=15, scale=2)
    public Double getValorMaxDinheiroCaixa() {
        return this.valorMaxDinheiroCaixa;
    }

    public void setValorMaxDinheiroCaixa(Double valorMaxDinheiroCaixa) {
        this.valorMaxDinheiroCaixa = valorMaxDinheiroCaixa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="SERIE_CAIXA_NFCE")
    public Integer getSerieCaixaNFCe() {
        return this.serieCaixaNFCe;
    }

    public void setSerieCaixaNFCe(Integer serieCaixaNFCe) {
        this.serieCaixaNFCe = serieCaixaNFCe;
    }

    @Column(nullable=false, name="SERIE_CAIXA_NFE")
    public Integer getSerieCaixaNFe() {
        return this.serieCaixaNFe;
    }

    public void setSerieCaixaNFe(Integer serieCaixaNFe) {
        this.serieCaixaNFe = serieCaixaNFe;
    }

    @Column(nullable=false, name="NUMERO_CAIXA")
    public Integer getNumeroCaixa() {
        return this.numeroCaixa;
    }

    public void setNumeroCaixa(Integer numeroCaixa) {
        this.numeroCaixa = numeroCaixa;
    }

    @Column(nullable=false, name="NUMERO_INICIAL_NFCE")
    public Long getNumeroInicialNFCe() {
        return this.numeroInicialNFCe;
    }

    public void setNumeroInicialNFCe(Long numeroInicialNFCe) {
        this.numeroInicialNFCe = numeroInicialNFCe;
    }

    @Column(name="NR_LOJA_SITEF", length=100)
    public String getNrLojaSitef() {
        return this.nrLojaSitef;
    }

    public void setNrLojaSitef(String nrLojaSitef) {
        this.nrLojaSitef = nrLojaSitef;
    }

    @Column(name="NR_TERMINAL_SITEF", length=100)
    public String getNrTerminalSitef() {
        return this.nrTerminalSitef;
    }

    public void setNrTerminalSitef(String nrTerminalSitef) {
        this.nrTerminalSitef = nrTerminalSitef;
    }

    @Column(name="ENDERECO_SITEF", length=100)
    public String getEnderecoSiTef() {
        return this.enderecoSiTef;
    }

    public void setEnderecoSiTef(String enderecoSiTef) {
        this.enderecoSiTef = enderecoSiTef;
    }

    @Column(name="TIPO_TEF")
    public Short getTipoTEF() {
        return this.tipoTEF;
    }

    public void setTipoTEF(Short tipoTEF) {
        this.tipoTEF = tipoTEF;
    }

    @Column(name="RESTRICOES_SITEF")
    public Short getRestricoesSitef() {
        return this.restricoesSitef;
    }

    public void setRestricoesSitef(Short restricoesSitef) {
        this.restricoesSitef = restricoesSitef;
    }

    @Column(name="NUMERO_INICIAL_NFE")
    public Long getNumeroInicialNFe() {
        return this.numeroInicialNFe;
    }

    public void setNumeroInicialNFe(Long numeroInicialNFe) {
        this.numeroInicialNFe = numeroInicialNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_ORI", foreignKey=@ForeignKey(name="FK_NFCE_CAIXA_CART_COB_O"))
    public CarteiraCobranca getCarteiraCobrancaOrigem() {
        return this.carteiraCobrancaOrigem;
    }

    public void setCarteiraCobrancaOrigem(CarteiraCobranca carteiraCobrancaOrigem) {
        this.carteiraCobrancaOrigem = carteiraCobrancaOrigem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_DES", foreignKey=@ForeignKey(name="FK_NFCE_CAIXA_CART_COB_D"))
    public CarteiraCobranca getCarteiraCobrancaDestino() {
        return this.carteiraCobrancaDestino;
    }

    public void setCarteiraCobrancaDestino(CarteiraCobranca carteiraCobrancaDestino) {
        this.carteiraCobrancaDestino = carteiraCobrancaDestino;
    }

    @Column(name="CAIXA_SLAVE")
    public Short getCaixaSlave() {
        return this.caixaSlave;
    }

    public void setCaixaSlave(Short caixaSlave) {
        this.caixaSlave = caixaSlave;
    }

    @Column(name="FONTE_IMPRESSAO")
    public Short getFonteImpressao() {
        return this.fonteImpressao;
    }

    public void setFonteImpressao(Short fonteImpressao) {
        this.fonteImpressao = fonteImpressao;
    }
}

