/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.LancGerencialNFCeControleCaixa;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.NFCeCaixa;
import com.touchcomp.basementor.model.vo.NFCeControleCaixaRes;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TransferenciaContaValor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="NFCE_CONTROLE_CAIXA")
public class NFCeControleCaixa
implements InterfaceVO {
    @Id
    @Column(name="ID_NFCE_CONTROLE_CAIXA", precision=18, scale=0)
    @GeneratedValue(generator="gen", strategy=GenerationType.SEQUENCE)
    @GenericGenerator(name="gen", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="GEN_NFCE_CONTROLE_CAIXA")})
    private Long identificador;
    @JoinColumn(name="ID_NFCE_CAIXA", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_NFCE_CX"))
    @ManyToOne(fetch=FetchType.LAZY)
    private NFCeCaixa nfceCaixa;
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuario;
    @JoinColumn(name="ID_USUARIO_CONF_MOV", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_USU_CONF_MOV"))
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioConfMov;
    @Column(name="STATUS")
    private Short status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ABERTURA")
    private Date dataAbertura = new Date();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FECHAMENTO")
    private Date dataFechamento;
    @Column(name="VALOR_TOTAL_SISTEMA", precision=15, scale=2)
    private Double valorTotalSistema = 0.0;
    @Column(name="VALOR_TOTAL_SISTEMA_DINH", precision=15, scale=2)
    private Double valorTotalSistemaDinh = 0.0;
    @Column(name="VALOR_TOTAL_INFORMADO_DINH", precision=15, scale=2)
    private Double valorTotalInformadoDinh = 0.0;
    @Column(name="VALOR_TOTAL_INFORMADO_DIF_DINH", precision=15, scale=2)
    private Double valorTotalInformadoDifDinh = 0.0;
    @Column(name="VALOR_REMASCENTE_CAIXA_DINH", precision=15, scale=2)
    private Double valorRemanescenteCaixaDinh = 0.0;
    @Column(name="VALOR_SAIDA_CAIXA_FECHAMENTO", precision=15, scale=2)
    private Double valorSaidaCaixaFechamento = 0.0;
    @Column(name="VALOR_REMASCENTE_CAIXA_ANT", precision=15, scale=2)
    private Double valorRemanescenteCaixaAnterior = 0.0;
    @Column(name="VALOR_TOTAL_ENTRADAS_MOV", precision=15, scale=2)
    private Double valorTotalEntradasMov = 0.0;
    @Column(name="VALOR_TOTAL_SAIDAS_MOV", precision=15, scale=2)
    private Double valorTotalSaidasMov = 0.0;
    @Column(name="REALIZADO")
    private Short realizado = 0;
    @Transient
    @OneToMany(mappedBy="nfCeControleCaixa", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<NFCeControleCaixaRes> resumoRecebimentos;
    @Column(name="SERIAL_FOR_SINC", length=100)
    private String serialForSinc;
    @Version
    @Column(name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_MOVIMENTO_BANCARIO", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_MOV_BAN"))
    private MovimentoBancario movimentoBancario;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BORDERO_CHEQUE_TERCEIRO", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_BORDERO_CH"))
    private BorderoChequesTerceiros borderoChequeTerceiros;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_MOVIMENTO_BANCARIO_DIFERENCA", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_MOV_BAN_DIF"))
    private MovimentoBancario movimentoBancarioDiferenca;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOVIMENTO_BANCARIO_CHEQUE", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_MOV_BAN_CH"))
    private MovimentoBancario movimentoBancarioCheque;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="ID_TRANSFERENCIA_CONTA_VALOR", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_TRANS_CV"))
    private TransferenciaContaValor transferenciaContaValor;
    @OneToMany(mappedBy="nfCeControleCaixa", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Titulo> titulos;
    @Column(name="VALOR_DINHEIRO", precision=15, scale=2)
    private Double valorDinheiro = 0.0;
    @Column(name="VALOR_CARTAO_CREDITO", precision=15, scale=2)
    private Double valorCartaoCredito = 0.0;
    @Column(name="VALOR_CARTAO_DEBITO", precision=15, scale=2)
    private Double valorCartaoDebito = 0.0;
    @Column(name="VALOR_CHEQUE", precision=15, scale=2)
    private Double valorCheque = 0.0;
    @Column(name="VALOR_CREDIARIO", precision=15, scale=2)
    private Double valorCrediario = 0.0;
    @Column(name="VALOR_BOLETO", precision=15, scale=2)
    private Double valorBoleto = 0.0;
    @Column(name="VALOR_TROCO", precision=15, scale=2)
    private Double valorTroco = 0.0;
    @Column(name="VALOR_SANGRIA", precision=15, scale=2)
    private Double valorSangria = 0.0;
    @Column(name="VALOR_SUPRIMENTO", precision=15, scale=2)
    private Double valorSuprimento = 0.0;
    @Column(name="VALOR_TEF_DEBITO", precision=15, scale=2)
    private Double valorTEFDebito = 0.0;
    @Column(name="VALOR_TEF_CREDITO", precision=15, scale=2)
    private Double valorTEFCredito = 0.0;
    @Column(name="VALOR_DINHEIRO_INF", precision=15, scale=2)
    private Double valorDinheiroInf = 0.0;
    @Column(name="VALOR_CARTAO_CREDITO_INF", precision=15, scale=2)
    private Double valorCartaoCreditoInf = 0.0;
    @Column(name="VALOR_CARTAO_DEBITO_INF", precision=15, scale=2)
    private Double valorCartaoDebitoInf = 0.0;
    @Column(name="VALOR_CHEQUE_INF", precision=15, scale=2)
    private Double valorChequeInf = 0.0;
    @Column(name="VALOR_CREDIARIO_INF", precision=15, scale=2)
    private Double valorCrediarioInf = 0.0;
    @Column(name="VALOR_TEF_DEBITO_INF", precision=15, scale=2)
    private Double valorTEFDebitoInf = 0.0;
    @Column(name="VALOR_TEF_CREDITO_INF", precision=15, scale=2)
    private Double valorTEFCreditoInf = 0.0;
    @Column(name="VALOR_BOLETO_INF", precision=15, scale=2)
    private Double valorBoletoInf = 0.0;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CAIXA_LOTE_CONTAB"))
    private LoteContabil loteContabil;
    @OneToMany(mappedBy="nfceControleCaixa", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<MovimentoBancario> movimentosBancarioPix;
    @Column(name="VALOR_PIX", precision=15, scale=2)
    private Double valorPix = 0.0;
    @Column(name="VALOR_PIX_INF", precision=15, scale=2)
    private Double valorPixInf = 0.0;
    @OneToMany(mappedBy="nfceControleCaixa", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<LancGerencialNFCeControleCaixa> lancamentosGerenciais;
    @Column(name="VALOR_VALE_ALIMENTACAO", precision=15, scale=2)
    private Double valorValeAlimentacao = 0.0;
    @Column(name="VALOR_VALE_REFEICAO", precision=15, scale=2)
    private Double valorValeRefeicao = 0.0;
    @Column(name="VALOR_VALE_COMBUSTIVEL", precision=15, scale=2)
    private Double valorValeCombustivel = 0.0;
    @Column(name="VALOR_VALE_ALIMENTACAO_INF", precision=15, scale=2)
    private Double valorValeAlimentacaoInf = 0.0;
    @Column(name="VALOR_VALE_REFEICAO_INF", precision=15, scale=2)
    private Double valorValeRefeicaoInf = 0.0;
    @Column(name="VALOR_VALE_COMBUSTIVEL_INF", precision=15, scale=2)
    private Double valorValeCombustivelInf = 0.0;
    @Column(name="VALOR_OUTROS", precision=15, scale=2)
    private Double valorOutros = 0.0;
    @Column(name="VALOR_OUTROS_INF", precision=15, scale=2)
    private Double valorOutrosInf = 0.0;
    @Column(name="VALOR_DEPOSITO_BANCARIO", precision=15, scale=2)
    private Double valorDepositoBancario = 0.0;
    @Column(name="VALOR_DEPOSITO_BANCARIO_INF", precision=15, scale=2)
    private Double valorDepositoBancarioInf = 0.0;
    @Column(name="VALOR_CARTEIRA_DIGITAL", precision=15, scale=2)
    private Double valorCarteiraDigital = 0.0;
    @Column(name="VALOR_CARTEIRA_DIGITAL_INF", precision=15, scale=2)
    private Double valorCarteiraDigitalInf = 0.0;
    @Column(name="VALOR_CASHBACK", precision=15, scale=2)
    private Double valorCashBack = 0.0;
    @Column(name="VALOR_CASHBACK_INF", precision=15, scale=2)
    private Double valorCashBackInf = 0.0;
    @Column(name="VALOR_CONSIGNADO", precision=15, scale=2)
    private Double valorConsignado = 0.0;
    @Column(name="VALOR_CONSIGNADO_INF", precision=15, scale=2)
    private Double valorConsignadoInf = 0.0;

    public NFCeControleCaixa() {
        this.status = EnumConstAbertoFechado.ABERTO.getValue();
        this.resumoRecebimentos = new LinkedList<NFCeControleCaixaRes>();
        this.titulos = new LinkedList<Titulo>();
        this.movimentosBancarioPix = new ArrayList<MovimentoBancario>();
        this.lancamentosGerenciais = new ArrayList<LancGerencialNFCeControleCaixa>();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNfceCaixa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public NFCeCaixa getNfceCaixa() {
        return this.nfceCaixa;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public Usuario getUsuarioConfMov() {
        return this.usuarioConfMov;
    }

    @Generated
    public Short getStatus() {
        return this.status;
    }

    @Generated
    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    @Generated
    public Double getValorTotalSistema() {
        return this.valorTotalSistema;
    }

    @Generated
    public Double getValorTotalSistemaDinh() {
        return this.valorTotalSistemaDinh;
    }

    @Generated
    public Double getValorTotalInformadoDinh() {
        return this.valorTotalInformadoDinh;
    }

    @Generated
    public Double getValorTotalInformadoDifDinh() {
        return this.valorTotalInformadoDifDinh;
    }

    @Generated
    public Double getValorRemanescenteCaixaDinh() {
        return this.valorRemanescenteCaixaDinh;
    }

    @Generated
    public Double getValorSaidaCaixaFechamento() {
        return this.valorSaidaCaixaFechamento;
    }

    @Generated
    public Double getValorRemanescenteCaixaAnterior() {
        return this.valorRemanescenteCaixaAnterior;
    }

    @Generated
    public Double getValorTotalEntradasMov() {
        return this.valorTotalEntradasMov;
    }

    @Generated
    public Double getValorTotalSaidasMov() {
        return this.valorTotalSaidasMov;
    }

    @Generated
    public Short getRealizado() {
        return this.realizado;
    }

    @Generated
    public List<NFCeControleCaixaRes> getResumoRecebimentos() {
        return this.resumoRecebimentos;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public MovimentoBancario getMovimentoBancario() {
        return this.movimentoBancario;
    }

    @Generated
    public BorderoChequesTerceiros getBorderoChequeTerceiros() {
        return this.borderoChequeTerceiros;
    }

    @Generated
    public MovimentoBancario getMovimentoBancarioDiferenca() {
        return this.movimentoBancarioDiferenca;
    }

    @Generated
    public MovimentoBancario getMovimentoBancarioCheque() {
        return this.movimentoBancarioCheque;
    }

    @Generated
    public TransferenciaContaValor getTransferenciaContaValor() {
        return this.transferenciaContaValor;
    }

    @Generated
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    @Generated
    public Double getValorDinheiro() {
        return this.valorDinheiro;
    }

    @Generated
    public Double getValorCartaoCredito() {
        return this.valorCartaoCredito;
    }

    @Generated
    public Double getValorCartaoDebito() {
        return this.valorCartaoDebito;
    }

    @Generated
    public Double getValorCheque() {
        return this.valorCheque;
    }

    @Generated
    public Double getValorCrediario() {
        return this.valorCrediario;
    }

    @Generated
    public Double getValorBoleto() {
        return this.valorBoleto;
    }

    @Generated
    public Double getValorTroco() {
        return this.valorTroco;
    }

    @Generated
    public Double getValorSangria() {
        return this.valorSangria;
    }

    @Generated
    public Double getValorSuprimento() {
        return this.valorSuprimento;
    }

    @Generated
    public Double getValorTEFDebito() {
        return this.valorTEFDebito;
    }

    @Generated
    public Double getValorTEFCredito() {
        return this.valorTEFCredito;
    }

    @Generated
    public Double getValorDinheiroInf() {
        return this.valorDinheiroInf;
    }

    @Generated
    public Double getValorCartaoCreditoInf() {
        return this.valorCartaoCreditoInf;
    }

    @Generated
    public Double getValorCartaoDebitoInf() {
        return this.valorCartaoDebitoInf;
    }

    @Generated
    public Double getValorChequeInf() {
        return this.valorChequeInf;
    }

    @Generated
    public Double getValorCrediarioInf() {
        return this.valorCrediarioInf;
    }

    @Generated
    public Double getValorTEFDebitoInf() {
        return this.valorTEFDebitoInf;
    }

    @Generated
    public Double getValorTEFCreditoInf() {
        return this.valorTEFCreditoInf;
    }

    @Generated
    public Double getValorBoletoInf() {
        return this.valorBoletoInf;
    }

    @Generated
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    @Generated
    public List<MovimentoBancario> getMovimentosBancarioPix() {
        return this.movimentosBancarioPix;
    }

    @Generated
    public Double getValorPix() {
        return this.valorPix;
    }

    @Generated
    public Double getValorPixInf() {
        return this.valorPixInf;
    }

    @Generated
    public List<LancGerencialNFCeControleCaixa> getLancamentosGerenciais() {
        return this.lancamentosGerenciais;
    }

    @Generated
    public Double getValorValeAlimentacao() {
        return this.valorValeAlimentacao;
    }

    @Generated
    public Double getValorValeRefeicao() {
        return this.valorValeRefeicao;
    }

    @Generated
    public Double getValorValeCombustivel() {
        return this.valorValeCombustivel;
    }

    @Generated
    public Double getValorValeAlimentacaoInf() {
        return this.valorValeAlimentacaoInf;
    }

    @Generated
    public Double getValorValeRefeicaoInf() {
        return this.valorValeRefeicaoInf;
    }

    @Generated
    public Double getValorValeCombustivelInf() {
        return this.valorValeCombustivelInf;
    }

    @Generated
    public Double getValorOutros() {
        return this.valorOutros;
    }

    @Generated
    public Double getValorOutrosInf() {
        return this.valorOutrosInf;
    }

    @Generated
    public Double getValorDepositoBancario() {
        return this.valorDepositoBancario;
    }

    @Generated
    public Double getValorDepositoBancarioInf() {
        return this.valorDepositoBancarioInf;
    }

    @Generated
    public Double getValorCarteiraDigital() {
        return this.valorCarteiraDigital;
    }

    @Generated
    public Double getValorCarteiraDigitalInf() {
        return this.valorCarteiraDigitalInf;
    }

    @Generated
    public Double getValorCashBack() {
        return this.valorCashBack;
    }

    @Generated
    public Double getValorCashBackInf() {
        return this.valorCashBackInf;
    }

    @Generated
    public Double getValorConsignado() {
        return this.valorConsignado;
    }

    @Generated
    public Double getValorConsignadoInf() {
        return this.valorConsignadoInf;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setNfceCaixa(NFCeCaixa nfceCaixa) {
        this.nfceCaixa = nfceCaixa;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioConfMov(Usuario usuarioConfMov) {
        this.usuarioConfMov = usuarioConfMov;
    }

    @Generated
    public void setStatus(Short status) {
        this.status = status;
    }

    @Generated
    public void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @Generated
    public void setValorTotalSistema(Double valorTotalSistema) {
        this.valorTotalSistema = valorTotalSistema;
    }

    @Generated
    public void setValorTotalSistemaDinh(Double valorTotalSistemaDinh) {
        this.valorTotalSistemaDinh = valorTotalSistemaDinh;
    }

    @Generated
    public void setValorTotalInformadoDinh(Double valorTotalInformadoDinh) {
        this.valorTotalInformadoDinh = valorTotalInformadoDinh;
    }

    @Generated
    public void setValorTotalInformadoDifDinh(Double valorTotalInformadoDifDinh) {
        this.valorTotalInformadoDifDinh = valorTotalInformadoDifDinh;
    }

    @Generated
    public void setValorRemanescenteCaixaDinh(Double valorRemanescenteCaixaDinh) {
        this.valorRemanescenteCaixaDinh = valorRemanescenteCaixaDinh;
    }

    @Generated
    public void setValorSaidaCaixaFechamento(Double valorSaidaCaixaFechamento) {
        this.valorSaidaCaixaFechamento = valorSaidaCaixaFechamento;
    }

    @Generated
    public void setValorRemanescenteCaixaAnterior(Double valorRemanescenteCaixaAnterior) {
        this.valorRemanescenteCaixaAnterior = valorRemanescenteCaixaAnterior;
    }

    @Generated
    public void setValorTotalEntradasMov(Double valorTotalEntradasMov) {
        this.valorTotalEntradasMov = valorTotalEntradasMov;
    }

    @Generated
    public void setValorTotalSaidasMov(Double valorTotalSaidasMov) {
        this.valorTotalSaidasMov = valorTotalSaidasMov;
    }

    @Generated
    public void setRealizado(Short realizado) {
        this.realizado = realizado;
    }

    @Generated
    public void setResumoRecebimentos(List<NFCeControleCaixaRes> resumoRecebimentos) {
        this.resumoRecebimentos = resumoRecebimentos;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setMovimentoBancario(MovimentoBancario movimentoBancario) {
        this.movimentoBancario = movimentoBancario;
    }

    @Generated
    public void setBorderoChequeTerceiros(BorderoChequesTerceiros borderoChequeTerceiros) {
        this.borderoChequeTerceiros = borderoChequeTerceiros;
    }

    @Generated
    public void setMovimentoBancarioDiferenca(MovimentoBancario movimentoBancarioDiferenca) {
        this.movimentoBancarioDiferenca = movimentoBancarioDiferenca;
    }

    @Generated
    public void setMovimentoBancarioCheque(MovimentoBancario movimentoBancarioCheque) {
        this.movimentoBancarioCheque = movimentoBancarioCheque;
    }

    @Generated
    public void setTransferenciaContaValor(TransferenciaContaValor transferenciaContaValor) {
        this.transferenciaContaValor = transferenciaContaValor;
    }

    @Generated
    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @Generated
    public void setValorDinheiro(Double valorDinheiro) {
        this.valorDinheiro = valorDinheiro;
    }

    @Generated
    public void setValorCartaoCredito(Double valorCartaoCredito) {
        this.valorCartaoCredito = valorCartaoCredito;
    }

    @Generated
    public void setValorCartaoDebito(Double valorCartaoDebito) {
        this.valorCartaoDebito = valorCartaoDebito;
    }

    @Generated
    public void setValorCheque(Double valorCheque) {
        this.valorCheque = valorCheque;
    }

    @Generated
    public void setValorCrediario(Double valorCrediario) {
        this.valorCrediario = valorCrediario;
    }

    @Generated
    public void setValorBoleto(Double valorBoleto) {
        this.valorBoleto = valorBoleto;
    }

    @Generated
    public void setValorTroco(Double valorTroco) {
        this.valorTroco = valorTroco;
    }

    @Generated
    public void setValorSangria(Double valorSangria) {
        this.valorSangria = valorSangria;
    }

    @Generated
    public void setValorSuprimento(Double valorSuprimento) {
        this.valorSuprimento = valorSuprimento;
    }

    @Generated
    public void setValorTEFDebito(Double valorTEFDebito) {
        this.valorTEFDebito = valorTEFDebito;
    }

    @Generated
    public void setValorTEFCredito(Double valorTEFCredito) {
        this.valorTEFCredito = valorTEFCredito;
    }

    @Generated
    public void setValorDinheiroInf(Double valorDinheiroInf) {
        this.valorDinheiroInf = valorDinheiroInf;
    }

    @Generated
    public void setValorCartaoCreditoInf(Double valorCartaoCreditoInf) {
        this.valorCartaoCreditoInf = valorCartaoCreditoInf;
    }

    @Generated
    public void setValorCartaoDebitoInf(Double valorCartaoDebitoInf) {
        this.valorCartaoDebitoInf = valorCartaoDebitoInf;
    }

    @Generated
    public void setValorChequeInf(Double valorChequeInf) {
        this.valorChequeInf = valorChequeInf;
    }

    @Generated
    public void setValorCrediarioInf(Double valorCrediarioInf) {
        this.valorCrediarioInf = valorCrediarioInf;
    }

    @Generated
    public void setValorTEFDebitoInf(Double valorTEFDebitoInf) {
        this.valorTEFDebitoInf = valorTEFDebitoInf;
    }

    @Generated
    public void setValorTEFCreditoInf(Double valorTEFCreditoInf) {
        this.valorTEFCreditoInf = valorTEFCreditoInf;
    }

    @Generated
    public void setValorBoletoInf(Double valorBoletoInf) {
        this.valorBoletoInf = valorBoletoInf;
    }

    @Generated
    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    @Generated
    public void setMovimentosBancarioPix(List<MovimentoBancario> movimentosBancarioPix) {
        this.movimentosBancarioPix = movimentosBancarioPix;
    }

    @Generated
    public void setValorPix(Double valorPix) {
        this.valorPix = valorPix;
    }

    @Generated
    public void setValorPixInf(Double valorPixInf) {
        this.valorPixInf = valorPixInf;
    }

    @Generated
    public void setLancamentosGerenciais(List<LancGerencialNFCeControleCaixa> lancamentosGerenciais) {
        this.lancamentosGerenciais = lancamentosGerenciais;
    }

    @Generated
    public void setValorValeAlimentacao(Double valorValeAlimentacao) {
        this.valorValeAlimentacao = valorValeAlimentacao;
    }

    @Generated
    public void setValorValeRefeicao(Double valorValeRefeicao) {
        this.valorValeRefeicao = valorValeRefeicao;
    }

    @Generated
    public void setValorValeCombustivel(Double valorValeCombustivel) {
        this.valorValeCombustivel = valorValeCombustivel;
    }

    @Generated
    public void setValorValeAlimentacaoInf(Double valorValeAlimentacaoInf) {
        this.valorValeAlimentacaoInf = valorValeAlimentacaoInf;
    }

    @Generated
    public void setValorValeRefeicaoInf(Double valorValeRefeicaoInf) {
        this.valorValeRefeicaoInf = valorValeRefeicaoInf;
    }

    @Generated
    public void setValorValeCombustivelInf(Double valorValeCombustivelInf) {
        this.valorValeCombustivelInf = valorValeCombustivelInf;
    }

    @Generated
    public void setValorOutros(Double valorOutros) {
        this.valorOutros = valorOutros;
    }

    @Generated
    public void setValorOutrosInf(Double valorOutrosInf) {
        this.valorOutrosInf = valorOutrosInf;
    }

    @Generated
    public void setValorDepositoBancario(Double valorDepositoBancario) {
        this.valorDepositoBancario = valorDepositoBancario;
    }

    @Generated
    public void setValorDepositoBancarioInf(Double valorDepositoBancarioInf) {
        this.valorDepositoBancarioInf = valorDepositoBancarioInf;
    }

    @Generated
    public void setValorCarteiraDigital(Double valorCarteiraDigital) {
        this.valorCarteiraDigital = valorCarteiraDigital;
    }

    @Generated
    public void setValorCarteiraDigitalInf(Double valorCarteiraDigitalInf) {
        this.valorCarteiraDigitalInf = valorCarteiraDigitalInf;
    }

    @Generated
    public void setValorCashBack(Double valorCashBack) {
        this.valorCashBack = valorCashBack;
    }

    @Generated
    public void setValorCashBackInf(Double valorCashBackInf) {
        this.valorCashBackInf = valorCashBackInf;
    }

    @Generated
    public void setValorConsignado(Double valorConsignado) {
        this.valorConsignado = valorConsignado;
    }

    @Generated
    public void setValorConsignadoInf(Double valorConsignadoInf) {
        this.valorConsignadoInf = valorConsignadoInf;
    }
}

