/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstPercentualValor;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cest;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeItemCbs;
import com.touchcomp.basementor.model.vo.NFCeItemCofins;
import com.touchcomp.basementor.model.vo.NFCeItemICMS;
import com.touchcomp.basementor.model.vo.NFCeItemIbs;
import com.touchcomp.basementor.model.vo.NFCeItemIpi;
import com.touchcomp.basementor.model.vo.NFCeItemPis;
import com.touchcomp.basementor.model.vo.NFCePreAbastecimento;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="NFCE_ITEM")
public class NFCeItem
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_NFCE_ITEM", precision=18, scale=0)
    @GeneratedValue(generator="gen", strategy=GenerationType.SEQUENCE)
    @GenericGenerator(name="gen", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="GEN_NFCE_ITEM")})
    private Long identificador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_NFCE"))
    private NFCe nfce;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_GRADE_COR"))
    private GradeCor gradeCor;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_PRODUTO"))
    private Produto produto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CFOP", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_CFOP"))
    private Cfop cfop;
    @Column(nullable=false, name="QUANTIDADE_COMERCIAL", precision=15, scale=6)
    private Double quantidadeComercial = 0.0;
    @Column(nullable=false, name="QUANTIDADE_TRIBURARIA", precision=15, scale=6)
    private Double quantidadeTributaria = 0.0;
    @Column(nullable=false, name="VALOR_UNITARIO_COMERCIAL", precision=15, scale=2)
    private Double valorUnitarioComercial = 0.0;
    @Column(nullable=false, name="VALOR_UNITARIO_TRIBUTADO", precision=15, scale=2)
    private Double valorUnitarioTributario = 0.0;
    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    private Double valorTotal = 0.0;
    @Column(nullable=false, name="VALOR_TOTAL_BRUTO", precision=15, scale=2)
    private Double valorTotalBruto = 0.0;
    @Column(nullable=false, name="COMPOE_TOTAL")
    private Short compoeTotal = 1;
    @Column(nullable=false, name="NUMERO_ITEM")
    private Integer numeroItem = 1;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ICMS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_ICMS"))
    private NFCeItemICMS icms;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PIS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_PIS"))
    private NFCeItemPis pis;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COFINS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_COFINS"))
    private NFCeItemCofins cofins;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_IPI", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_IPI"))
    private NFCeItemIpi ipi;
    @Column(name="INF_ADICIONAL_PROD", length=500)
    private String infAdicionalProd;
    @Column(nullable=false, name="PERCENTUAL_FRETE", precision=15, scale=2)
    private Double percentualFrete = 0.0;
    @Column(nullable=false, name="VALOR_FRETE", precision=15, scale=2)
    private Double valorFrete = 0.0;
    @Column(nullable=false, name="PERCENTUAL_SEGURO", precision=15, scale=2)
    private Double percentualSeguro = 0.0;
    @Column(nullable=false, name="VALOR_SEGURO", precision=15, scale=2)
    private Double valorSeguro = 0.0;
    @Column(nullable=false, name="PERCENTUAL_DESCONTO", precision=15, scale=2)
    private Double percentualDesconto = 0.0;
    @Column(name="PERC_DESCONTO_PROMOCAO", precision=15, scale=2)
    private Double percentualDescontoPromocional = 0.0;
    @Column(name="VALOR_DESCONTO_PROMOCAO", precision=15, scale=2)
    private Double valorDescontoPromocional = 0.0;
    @Column(nullable=false, name="VALOR_DESCONTO", precision=15, scale=2)
    private Double valorDesconto = 0.0;
    @Column(nullable=false, name="PERCENTUAL_DESP_ACESS", precision=15, scale=2)
    private Double percentualDespAcess = 0.0;
    @Column(nullable=false, name="VALOR_DESP_ACESSORIAS", precision=15, scale=2)
    private Double valorDespesasAcessorias = 0.0;
    @Column(nullable=false, name="PERC_VALOR_FRETE", precision=15, scale=2)
    private Short percValorFrete;
    @Column(nullable=false, name="PERCENTUAL_FRETE_INF", precision=15, scale=2)
    private Double percentualFreteInf = 0.0;
    @Column(nullable=false, name="VALOR_FRETE_INF", precision=15, scale=2)
    private Double valorFreteInf = 0.0;
    @Column(nullable=false, name="PERC_VALOR_SEGURO", precision=15, scale=2)
    private Short percValorSeguro;
    @Column(nullable=false, name="PERCENTUAL_SEGURO_INF", precision=15, scale=2)
    private Double percentualSeguroInf = 0.0;
    @Column(nullable=false, name="VALOR_SEGURO_INF", precision=15, scale=2)
    private Double valorSeguroInf = 0.0;
    @Column(nullable=false, name="PERC_VALOR_DESCONTO", precision=15, scale=2)
    private Short percValorDesconto = EnumConstPercentualValor.PERCENTUAL.getValue();
    @Column(nullable=false, name="PERCENTUAL_DESCONTO_INF", precision=15, scale=2)
    private Double percentualDescontoInf = 0.0;
    @Column(nullable=false, name="VALOR_DESCONTO_INF", precision=15, scale=2)
    private Double valorDescontoInf = 0.0;
    @Column(nullable=false, name="PERC_VALOR_DESP_ACESS", precision=15, scale=2)
    private Short percValorDespAcess = EnumConstPercentualValor.PERCENTUAL.getValue();
    @Column(nullable=false, name="PERCENTUAL_DESP_ACESS_INF", precision=15, scale=2)
    private Double percentualDespAcessInf = 0.0;
    @Column(nullable=false, name="VALOR_DESP_ACESSORIAS_INF", precision=15, scale=2)
    private Double valorDespesasAcessoriasInf = 0.0;
    @Column(nullable=false, name="PERCENTUAL_FRETE_RAT", precision=15, scale=2)
    private Double percentualFreteRat = 0.0;
    @Column(nullable=false, name="VALOR_FRETE_RAT", precision=15, scale=2)
    private Double valorFreteRat = 0.0;
    @Column(nullable=false, name="PERCENTUAL_SEGURO_RAT", precision=15, scale=2)
    private Double percentualSeguroRat = 0.0;
    @Column(nullable=false, name="VALOR_SEGURO_RAT", precision=15, scale=2)
    private Double valorSeguroRat = 0.0;
    @Column(nullable=false, name="PERCENTUAL_DESCONTO_RAT", precision=15, scale=2)
    private Double percentualDescontoRat = 0.0;
    @Column(nullable=false, name="VALOR_DESCONTO_RAT", precision=15, scale=2)
    private Double valorDescontoRat = 0.0;
    @Column(nullable=false, name="PERCENTUAL_DESP_ACESS_RAT", precision=15, scale=2)
    private Double percentualDespAcessRat = 0.0;
    @Column(nullable=false, name="VALOR_DESP_ACESSORIAS_RAT", precision=15, scale=2)
    private Double valorDespesasAcessoriasRat = 0.0;
    @Column(name="NUMERO_PEDIDO_CLIENTE", length=15)
    private String numeroPedidoCliente;
    @Column(nullable=false, name="STATUS")
    private Short status = 1;
    @Column(name="NUMERO_PED_ITEM_CLIENTE")
    private Integer numeroPedidoItemCliente = 0;
    @Column(nullable=false, name="VALOR_TOTAL_TRIBUTOS", precision=15, scale=2)
    private Double valorTotalTributos = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_MOD_FISCAL"))
    private ModeloFiscal modeloFiscal;
    @Column(name="CODIGO_BARRAS", length=30)
    private String codigoBarras;
    @Column(name="CODIGO_BARRAS_TRIBUTAVEL", length=30)
    private String codigoBarrasTributavel;
    @Column(name="PERCENTUAL_COMISSAO", precision=15, scale=2)
    private Double percentualComissao = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_REPRESENTANTE"))
    private Representante representante;
    @Column(name="PERC_TRIBUTOS_PREVISTOS", precision=15, scale=2)
    private Double percTributosPrevistos = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_CANCELAMENTO", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_USUARIO_CANC"))
    private Usuario usuarioCancelamento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_ABASTECIMENTO", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_NFCE_PRE_ABASTECIM"))
    private NFCePreAbastecimento preAbastecimento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_CENTRO_ESTOQUE"))
    private CentroEstoque centroEstoque;
    @Column(name="VALOR_PARTIDA", precision=15, scale=2)
    private Double valorPartida = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_MEDIDA_TRIB", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_UNID_MED"))
    private UnidadeMedida unidadeMedidaTrib;
    @Column(name="FATOR_CONVERSAO", precision=15, scale=4)
    private Double fatorConversao = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_LOTE_FABRICACAO"))
    private LoteFabricacao loteFabricacao;
    @Column(name="MOVIMENTACAO_FISICA")
    private Short movimentacaoFisica = 0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_EMPRESA"))
    private Empresa empresa;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    private Date dataEmissao;
    @Column(name="SERIAL_FOR_SINC")
    private String serialForSinc;
    @Column(name="VALOR_CUSTO", precision=6, scale=15)
    private Double valorCusto = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NCM", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_NCM"))
    private Ncm ncm;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CEST", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_CEST"))
    private Cest cest;
    @Column(name="NR_LOTE_FABRICACAO", length=100)
    private String nrLoteFabricacao;
    @Column(name="DATA_FABRICACAO")
    private Date dataFabricacao;
    @Column(name="DATA_VALIDADE")
    private Date dataValidade;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="ID_CBS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_CBS"))
    private NFCeItemCbs cbs;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="ID_IBS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_IBS"))
    private NFCeItemIbs ibs;
    @Column(name="VALOR_TOTAL_ITEM_DOC", precision=15, scale=2)
    private Double valorTotalItemDoc = 0.0;

    public NFCeItem() {
        this.percValorFrete = EnumConstPercentualValor.PERCENTUAL.getValue();
        this.percValorSeguro = EnumConstPercentualValor.PERCENTUAL.getValue();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public NFCe getNfce() {
        return this.nfce;
    }

    @Generated
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @Generated
    public Produto getProduto() {
        return this.produto;
    }

    @Generated
    public Cfop getCfop() {
        return this.cfop;
    }

    @Generated
    public Double getQuantidadeComercial() {
        return this.quantidadeComercial;
    }

    @Generated
    public Double getQuantidadeTributaria() {
        return this.quantidadeTributaria;
    }

    @Generated
    public Double getValorUnitarioComercial() {
        return this.valorUnitarioComercial;
    }

    @Generated
    public Double getValorUnitarioTributario() {
        return this.valorUnitarioTributario;
    }

    @Generated
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    @Generated
    public Short getCompoeTotal() {
        return this.compoeTotal;
    }

    @Generated
    public Integer getNumeroItem() {
        return this.numeroItem;
    }

    @Generated
    public NFCeItemICMS getIcms() {
        return this.icms;
    }

    @Generated
    public NFCeItemPis getPis() {
        return this.pis;
    }

    @Generated
    public NFCeItemCofins getCofins() {
        return this.cofins;
    }

    @Generated
    public NFCeItemIpi getIpi() {
        return this.ipi;
    }

    @Generated
    public String getInfAdicionalProd() {
        return this.infAdicionalProd;
    }

    @Generated
    public Double getPercentualFrete() {
        return this.percentualFrete;
    }

    @Generated
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Generated
    public Double getPercentualSeguro() {
        return this.percentualSeguro;
    }

    @Generated
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    @Generated
    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    @Generated
    public Double getPercentualDescontoPromocional() {
        return this.percentualDescontoPromocional;
    }

    @Generated
    public Double getValorDescontoPromocional() {
        return this.valorDescontoPromocional;
    }

    @Generated
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public Double getPercentualDespAcess() {
        return this.percentualDespAcess;
    }

    @Generated
    public Double getValorDespesasAcessorias() {
        return this.valorDespesasAcessorias;
    }

    @Generated
    public Short getPercValorFrete() {
        return this.percValorFrete;
    }

    @Generated
    public Double getPercentualFreteInf() {
        return this.percentualFreteInf;
    }

    @Generated
    public Double getValorFreteInf() {
        return this.valorFreteInf;
    }

    @Generated
    public Short getPercValorSeguro() {
        return this.percValorSeguro;
    }

    @Generated
    public Double getPercentualSeguroInf() {
        return this.percentualSeguroInf;
    }

    @Generated
    public Double getValorSeguroInf() {
        return this.valorSeguroInf;
    }

    @Generated
    public Short getPercValorDesconto() {
        return this.percValorDesconto;
    }

    @Generated
    public Double getPercentualDescontoInf() {
        return this.percentualDescontoInf;
    }

    @Generated
    public Double getValorDescontoInf() {
        return this.valorDescontoInf;
    }

    @Generated
    public Short getPercValorDespAcess() {
        return this.percValorDespAcess;
    }

    @Generated
    public Double getPercentualDespAcessInf() {
        return this.percentualDespAcessInf;
    }

    @Generated
    public Double getValorDespesasAcessoriasInf() {
        return this.valorDespesasAcessoriasInf;
    }

    @Generated
    public Double getPercentualFreteRat() {
        return this.percentualFreteRat;
    }

    @Generated
    public Double getValorFreteRat() {
        return this.valorFreteRat;
    }

    @Generated
    public Double getPercentualSeguroRat() {
        return this.percentualSeguroRat;
    }

    @Generated
    public Double getValorSeguroRat() {
        return this.valorSeguroRat;
    }

    @Generated
    public Double getPercentualDescontoRat() {
        return this.percentualDescontoRat;
    }

    @Generated
    public Double getValorDescontoRat() {
        return this.valorDescontoRat;
    }

    @Generated
    public Double getPercentualDespAcessRat() {
        return this.percentualDespAcessRat;
    }

    @Generated
    public Double getValorDespesasAcessoriasRat() {
        return this.valorDespesasAcessoriasRat;
    }

    @Generated
    public String getNumeroPedidoCliente() {
        return this.numeroPedidoCliente;
    }

    @Generated
    public Short getStatus() {
        return this.status;
    }

    @Generated
    public Integer getNumeroPedidoItemCliente() {
        return this.numeroPedidoItemCliente;
    }

    @Generated
    public Double getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    @Generated
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getCodigoBarrasTributavel() {
        return this.codigoBarrasTributavel;
    }

    @Generated
    public Double getPercentualComissao() {
        return this.percentualComissao;
    }

    @Generated
    public Representante getRepresentante() {
        return this.representante;
    }

    @Generated
    public Double getPercTributosPrevistos() {
        return this.percTributosPrevistos;
    }

    @Generated
    public Usuario getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public NFCePreAbastecimento getPreAbastecimento() {
        return this.preAbastecimento;
    }

    @Generated
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    @Generated
    public Double getValorPartida() {
        return this.valorPartida;
    }

    @Generated
    public UnidadeMedida getUnidadeMedidaTrib() {
        return this.unidadeMedidaTrib;
    }

    @Generated
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    @Generated
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    @Generated
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public Double getValorCusto() {
        return this.valorCusto;
    }

    @Generated
    public Ncm getNcm() {
        return this.ncm;
    }

    @Generated
    public Cest getCest() {
        return this.cest;
    }

    @Generated
    public String getNrLoteFabricacao() {
        return this.nrLoteFabricacao;
    }

    @Generated
    public Date getDataFabricacao() {
        return this.dataFabricacao;
    }

    @Generated
    public Date getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public NFCeItemCbs getCbs() {
        return this.cbs;
    }

    @Generated
    public NFCeItemIbs getIbs() {
        return this.ibs;
    }

    @Generated
    public Double getValorTotalItemDoc() {
        return this.valorTotalItemDoc;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @Generated
    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Generated
    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Generated
    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    @Generated
    public void setQuantidadeComercial(Double quantidadeComercial) {
        this.quantidadeComercial = quantidadeComercial;
    }

    @Generated
    public void setQuantidadeTributaria(Double quantidadeTributaria) {
        this.quantidadeTributaria = quantidadeTributaria;
    }

    @Generated
    public void setValorUnitarioComercial(Double valorUnitarioComercial) {
        this.valorUnitarioComercial = valorUnitarioComercial;
    }

    @Generated
    public void setValorUnitarioTributario(Double valorUnitarioTributario) {
        this.valorUnitarioTributario = valorUnitarioTributario;
    }

    @Generated
    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    @Generated
    public void setCompoeTotal(Short compoeTotal) {
        this.compoeTotal = compoeTotal;
    }

    @Generated
    public void setNumeroItem(Integer numeroItem) {
        this.numeroItem = numeroItem;
    }

    @Generated
    public void setIcms(NFCeItemICMS icms) {
        this.icms = icms;
    }

    @Generated
    public void setPis(NFCeItemPis pis) {
        this.pis = pis;
    }

    @Generated
    public void setCofins(NFCeItemCofins cofins) {
        this.cofins = cofins;
    }

    @Generated
    public void setIpi(NFCeItemIpi ipi) {
        this.ipi = ipi;
    }

    @Generated
    public void setInfAdicionalProd(String infAdicionalProd) {
        this.infAdicionalProd = infAdicionalProd;
    }

    @Generated
    public void setPercentualFrete(Double percentualFrete) {
        this.percentualFrete = percentualFrete;
    }

    @Generated
    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Generated
    public void setPercentualSeguro(Double percentualSeguro) {
        this.percentualSeguro = percentualSeguro;
    }

    @Generated
    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    @Generated
    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    @Generated
    public void setPercentualDescontoPromocional(Double percentualDescontoPromocional) {
        this.percentualDescontoPromocional = percentualDescontoPromocional;
    }

    @Generated
    public void setValorDescontoPromocional(Double valorDescontoPromocional) {
        this.valorDescontoPromocional = valorDescontoPromocional;
    }

    @Generated
    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setPercentualDespAcess(Double percentualDespAcess) {
        this.percentualDespAcess = percentualDespAcess;
    }

    @Generated
    public void setValorDespesasAcessorias(Double valorDespesasAcessorias) {
        this.valorDespesasAcessorias = valorDespesasAcessorias;
    }

    @Generated
    public void setPercValorFrete(Short percValorFrete) {
        this.percValorFrete = percValorFrete;
    }

    @Generated
    public void setPercentualFreteInf(Double percentualFreteInf) {
        this.percentualFreteInf = percentualFreteInf;
    }

    @Generated
    public void setValorFreteInf(Double valorFreteInf) {
        this.valorFreteInf = valorFreteInf;
    }

    @Generated
    public void setPercValorSeguro(Short percValorSeguro) {
        this.percValorSeguro = percValorSeguro;
    }

    @Generated
    public void setPercentualSeguroInf(Double percentualSeguroInf) {
        this.percentualSeguroInf = percentualSeguroInf;
    }

    @Generated
    public void setValorSeguroInf(Double valorSeguroInf) {
        this.valorSeguroInf = valorSeguroInf;
    }

    @Generated
    public void setPercValorDesconto(Short percValorDesconto) {
        this.percValorDesconto = percValorDesconto;
    }

    @Generated
    public void setPercentualDescontoInf(Double percentualDescontoInf) {
        this.percentualDescontoInf = percentualDescontoInf;
    }

    @Generated
    public void setValorDescontoInf(Double valorDescontoInf) {
        this.valorDescontoInf = valorDescontoInf;
    }

    @Generated
    public void setPercValorDespAcess(Short percValorDespAcess) {
        this.percValorDespAcess = percValorDespAcess;
    }

    @Generated
    public void setPercentualDespAcessInf(Double percentualDespAcessInf) {
        this.percentualDespAcessInf = percentualDespAcessInf;
    }

    @Generated
    public void setValorDespesasAcessoriasInf(Double valorDespesasAcessoriasInf) {
        this.valorDespesasAcessoriasInf = valorDespesasAcessoriasInf;
    }

    @Generated
    public void setPercentualFreteRat(Double percentualFreteRat) {
        this.percentualFreteRat = percentualFreteRat;
    }

    @Generated
    public void setValorFreteRat(Double valorFreteRat) {
        this.valorFreteRat = valorFreteRat;
    }

    @Generated
    public void setPercentualSeguroRat(Double percentualSeguroRat) {
        this.percentualSeguroRat = percentualSeguroRat;
    }

    @Generated
    public void setValorSeguroRat(Double valorSeguroRat) {
        this.valorSeguroRat = valorSeguroRat;
    }

    @Generated
    public void setPercentualDescontoRat(Double percentualDescontoRat) {
        this.percentualDescontoRat = percentualDescontoRat;
    }

    @Generated
    public void setValorDescontoRat(Double valorDescontoRat) {
        this.valorDescontoRat = valorDescontoRat;
    }

    @Generated
    public void setPercentualDespAcessRat(Double percentualDespAcessRat) {
        this.percentualDespAcessRat = percentualDespAcessRat;
    }

    @Generated
    public void setValorDespesasAcessoriasRat(Double valorDespesasAcessoriasRat) {
        this.valorDespesasAcessoriasRat = valorDespesasAcessoriasRat;
    }

    @Generated
    public void setNumeroPedidoCliente(String numeroPedidoCliente) {
        this.numeroPedidoCliente = numeroPedidoCliente;
    }

    @Generated
    public void setStatus(Short status) {
        this.status = status;
    }

    @Generated
    public void setNumeroPedidoItemCliente(Integer numeroPedidoItemCliente) {
        this.numeroPedidoItemCliente = numeroPedidoItemCliente;
    }

    @Generated
    public void setValorTotalTributos(Double valorTotalTributos) {
        this.valorTotalTributos = valorTotalTributos;
    }

    @Generated
    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setCodigoBarrasTributavel(String codigoBarrasTributavel) {
        this.codigoBarrasTributavel = codigoBarrasTributavel;
    }

    @Generated
    public void setPercentualComissao(Double percentualComissao) {
        this.percentualComissao = percentualComissao;
    }

    @Generated
    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @Generated
    public void setPercTributosPrevistos(Double percTributosPrevistos) {
        this.percTributosPrevistos = percTributosPrevistos;
    }

    @Generated
    public void setUsuarioCancelamento(Usuario usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setPreAbastecimento(NFCePreAbastecimento preAbastecimento) {
        this.preAbastecimento = preAbastecimento;
    }

    @Generated
    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @Generated
    public void setValorPartida(Double valorPartida) {
        this.valorPartida = valorPartida;
    }

    @Generated
    public void setUnidadeMedidaTrib(UnidadeMedida unidadeMedidaTrib) {
        this.unidadeMedidaTrib = unidadeMedidaTrib;
    }

    @Generated
    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    @Generated
    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @Generated
    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    @Generated
    public void setNcm(Ncm ncm) {
        this.ncm = ncm;
    }

    @Generated
    public void setCest(Cest cest) {
        this.cest = cest;
    }

    @Generated
    public void setNrLoteFabricacao(String nrLoteFabricacao) {
        this.nrLoteFabricacao = nrLoteFabricacao;
    }

    @Generated
    public void setDataFabricacao(Date dataFabricacao) {
        this.dataFabricacao = dataFabricacao;
    }

    @Generated
    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public void setCbs(NFCeItemCbs cbs) {
        this.cbs = cbs;
    }

    @Generated
    public void setIbs(NFCeItemIbs ibs) {
        this.ibs = ibs;
    }

    @Generated
    public void setValorTotalItemDoc(Double valorTotalItemDoc) {
        this.valorTotalItemDoc = valorTotalItemDoc;
    }
}

