/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpSugVlrNFCe;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpSugVlrNFe;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoNatOperacaoRelNat;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoEmpresa;
import com.touchcomp.basementor.model.vo.TipoMovimento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="NATUREZA_OPERACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_NATUREZA_OPERACAO", columnNames={"DESCRICAO"})})
public class NaturezaOperacao
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Short ativo = 1;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private ModeloDocFiscal modeloDocFiscal;
    private Short entradaSaida = 0;
    private Short tipoEstoque = 0;
    private Short permitirInfSerieNota = 0;
    private TipoMovimento tipoMovimento;
    private Long numDiasVencimento = 0L;
    private Short tipoBonusRep = 0;
    private Short gerarComissaoRep = 0;
    private Short tipoLancCampVendas = 0;
    private Short natOperacaoDispMobile = 0;
    private List<GrupoNatOperacaoRelNat> grupoNaturezasRel;
    private String descricaoAuxiliar;
    private List<NaturezaOperacaoEmpresa> empresas;
    private Short natOperacaoDispPedAlmox = 0;
    private Short natOperacaoDispNecCompra = 0;
    private Short natOperacaoDispNFCe = 0;
    private Short contabilizarPorIntegracao = 0;
    private Short natOperacaoDevolucao = 0;
    private Short finalidadeEmissao = 0;
    private Short sugValorUnitarioFatNFe = EnumConstNatOpSugVlrNFe.VALOR_NAO_SUGERIR.getValue();
    private Short sugValorUnitarioFatNFCe = EnumConstNatOpSugVlrNFCe.VALOR_VENDA_TAB_PRECO.getValue();
    private Short gerarOCAutGerarReq = 0;
    private Short naoValidarChaveDeAcesso;

    public NaturezaOperacao() {
        this.grupoNaturezasRel = new ArrayList<GrupoNatOperacaoRelNat>();
        this.empresas = new ArrayList<NaturezaOperacaoEmpresa>();
        this.setNaoValidarChaveDeAcesso(EnumConstantsMentorSimNao.SIM.getValue());
    }

    @Id
    @Column(nullable=false, name="ID_NATUREZA_OPERACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NATUREZA_OPERACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NATUREZA_OPERACAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricaoAuxiliar()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_NATUREZA_OPERACAO_MOD_DOC_FI"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Column(nullable=false, name="ENTRADA_SAIDA")
    public Short getEntradaSaida() {
        return this.entradaSaida;
    }

    public void setEntradaSaida(Short entradaSaida) {
        this.entradaSaida = entradaSaida;
    }

    @Column(nullable=false, name="TIPO_ESTOQUE")
    public Short getTipoEstoque() {
        return this.tipoEstoque;
    }

    public void setTipoEstoque(Short tipoEstoque) {
        this.tipoEstoque = tipoEstoque;
    }

    @Transient
    public short getEntradaSaidaNatOperacao() {
        if (this.getEntradaSaida() == 0 || this.getEntradaSaida() == 2) {
            return 0;
        }
        return 1;
    }

    @Column(name="PERMITIR_INF_SERIE_NOTA")
    public Short getPermitirInfSerieNota() {
        return this.permitirInfSerieNota;
    }

    public void setPermitirInfSerieNota(Short permitirInfSerieNota) {
        this.permitirInfSerieNota = permitirInfSerieNota;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_MOVIMENTO", foreignKey=@ForeignKey(name="FK_NATUREZA_OPERACAO_TIPO_MOV"))
    public TipoMovimento getTipoMovimento() {
        return this.tipoMovimento;
    }

    public void setTipoMovimento(TipoMovimento tipoMovimento) {
        this.tipoMovimento = tipoMovimento;
    }

    @Column(name="NUMERO_DIAS")
    public Long getNumDiasVencimento() {
        return this.numDiasVencimento;
    }

    public void setNumDiasVencimento(Long numDiasVencimento) {
        this.numDiasVencimento = numDiasVencimento;
    }

    @Column(name="TIPO_BONUS_REP")
    public Short getTipoBonusRep() {
        return this.tipoBonusRep;
    }

    public void setTipoBonusRep(Short tipoBonusRep) {
        this.tipoBonusRep = tipoBonusRep;
    }

    @Column(name="GERAR_COMISSAO_REP")
    public Short getGerarComissaoRep() {
        return this.gerarComissaoRep;
    }

    public void setGerarComissaoRep(Short gerarComissaoRep) {
        this.gerarComissaoRep = gerarComissaoRep;
    }

    @Column(name="TIPO_LANC_CAMP_VENDAS")
    public Short getTipoLancCampVendas() {
        return this.tipoLancCampVendas;
    }

    public void setTipoLancCampVendas(Short tipoLancCampVendas) {
        this.tipoLancCampVendas = tipoLancCampVendas;
    }

    @Column(name="NAT_OPERACAO_DISP_MOBILE")
    public Short getNatOperacaoDispMobile() {
        return this.natOperacaoDispMobile;
    }

    public void setNatOperacaoDispMobile(Short natOperacaoDispMobile) {
        this.natOperacaoDispMobile = natOperacaoDispMobile;
    }

    @OneToMany(mappedBy="naturezaOperacao")
    public List<GrupoNatOperacaoRelNat> getGrupoNaturezasRel() {
        return this.grupoNaturezasRel;
    }

    public void setGrupoNaturezasRel(List<GrupoNatOperacaoRelNat> grupoNaturezasRel) {
        this.grupoNaturezasRel = grupoNaturezasRel;
    }

    @Column(nullable=false, name="DESCRICAO_AUXILIAR", length=120)
    public String getDescricaoAuxiliar() {
        return this.descricaoAuxiliar;
    }

    public void setDescricaoAuxiliar(String descricaoAuxiliar) {
        this.descricaoAuxiliar = descricaoAuxiliar;
    }

    @OneToMany(mappedBy="naturezaOperacao", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<NaturezaOperacaoEmpresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<NaturezaOperacaoEmpresa> empresas) {
        this.empresas = empresas;
    }

    @Column(name="NAT_OP_DISP_PED_ALMOX")
    public Short getNatOperacaoDispPedAlmox() {
        return this.natOperacaoDispPedAlmox;
    }

    public void setNatOperacaoDispPedAlmox(Short natOperacaoDispPedAlmox) {
        this.natOperacaoDispPedAlmox = natOperacaoDispPedAlmox;
    }

    @Column(name="NAT_OP_DISP_NEC_COMPRA")
    public Short getNatOperacaoDispNecCompra() {
        return this.natOperacaoDispNecCompra;
    }

    public void setNatOperacaoDispNecCompra(Short natOperacaoDispNecCompra) {
        this.natOperacaoDispNecCompra = natOperacaoDispNecCompra;
    }

    @Column(name="NAT_OPERACAO_DISP_NFCE")
    public Short getNatOperacaoDispNFCe() {
        return this.natOperacaoDispNFCe;
    }

    public void setNatOperacaoDispNFCe(Short natOperacaoDispNFCe) {
        this.natOperacaoDispNFCe = natOperacaoDispNFCe;
    }

    @Column(name="contabilizar_por_integracao")
    public Short getContabilizarPorIntegracao() {
        return this.contabilizarPorIntegracao;
    }

    public void setContabilizarPorIntegracao(Short contabilizarPorIntegracao) {
        this.contabilizarPorIntegracao = contabilizarPorIntegracao;
    }

    @Column(name="NAT_OPERACAO_DEVOLUCAO")
    public Short getNatOperacaoDevolucao() {
        return this.natOperacaoDevolucao;
    }

    public void setNatOperacaoDevolucao(Short natOperacaoDevolucao) {
        this.natOperacaoDevolucao = natOperacaoDevolucao;
    }

    @Column(name="FINALIDADE_EMISSAO")
    public Short getFinalidadeEmissao() {
        return this.finalidadeEmissao;
    }

    public void setFinalidadeEmissao(Short finalidadeEmissao) {
        this.finalidadeEmissao = finalidadeEmissao;
    }

    @Column(name="SUG_VALOR_UNITARIO_FAT_NFE")
    public Short getSugValorUnitarioFatNFe() {
        return this.sugValorUnitarioFatNFe;
    }

    public void setSugValorUnitarioFatNFe(Short sugValorUnitarioFatNFe) {
        this.sugValorUnitarioFatNFe = sugValorUnitarioFatNFe;
    }

    @Column(name="SUG_VALOR_UNITARIO_FAT_NFCE")
    public Short getSugValorUnitarioFatNFCe() {
        return this.sugValorUnitarioFatNFCe;
    }

    public void setSugValorUnitarioFatNFCe(Short sugValorUnitarioFatNFCe) {
        this.sugValorUnitarioFatNFCe = sugValorUnitarioFatNFCe;
    }

    @Column(name="GERAR_OC_AUT_GERAR_REQ")
    public Short getGerarOCAutGerarReq() {
        return this.gerarOCAutGerarReq;
    }

    public void setGerarOCAutGerarReq(Short gerarOCAutGerarReq) {
        this.gerarOCAutGerarReq = gerarOCAutGerarReq;
    }

    @Column(name="nao_valid_chave_acesso")
    public Short getNaoValidarChaveDeAcesso() {
        return this.naoValidarChaveDeAcesso;
    }

    public void setNaoValidarChaveDeAcesso(Short naoValidarChaveDeAcesso) {
        this.naoValidarChaveDeAcesso = naoValidarChaveDeAcesso;
    }
}

