/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.AverbacaoCte;
import com.touchcomp.basementor.model.vo.CadastroNacionalObra;
import com.touchcomp.basementor.model.vo.CancelamentoNFe;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.DadosRecAgrNfPropria;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.DevolucaoVendas;
import com.touchcomp.basementor.model.vo.DpecNFe;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ErroAverbacaoCte;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeEpec;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GrupoDocumentosRefPR;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.IntegracaoNotaPropriaNotas;
import com.touchcomp.basementor.model.vo.IntermediadorComercial;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoNFe;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LocalEntregaNFPropria;
import com.touchcomp.basementor.model.vo.LocalRetiradaNFPropria;
import com.touchcomp.basementor.model.vo.LoteFaturamentoNFe;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCeLogPermissaoUsuario;
import com.touchcomp.basementor.model.vo.NFeAutDownloadXML;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropriaFreteCtrc;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceirosFreteCtrc;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PreFaturamentoNF;
import com.touchcomp.basementor.model.vo.ProcessoImportacao;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementor.model.vo.TransportadorRedespacho;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.ValoresNfPropria;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="NOTA_PROPRIA", uniqueConstraints={@UniqueConstraint(name="UNQ2_NOTA_PROPRIA", columnNames={"ID_EXPEDICAO"}), @UniqueConstraint(name="UNQ1_NOTA_PROPRIA", columnNames={"NUMERO_NOTA", "SERIE", "ID_MODELO_DOC_FISCAL", "ID_EMPRESA"})})
public class NotaFiscalPropria
implements InterfaceVO {
    private Long identificador;
    private String serie;
    private String serieInf;
    private String chaveNFE;
    private String chaveNFEAuxCont;
    private Integer codChaveAcesso;
    private Integer numeroNota;
    private Integer numeroNotaInf;
    private Empresa empresa;
    private Integer digitoVerificador;
    private UnidadeFatCliente unidadeFatCliente;
    private NaturezaOperacao naturezaOperacao;
    private ModeloDocFiscal modeloDocFiscal;
    private Expedicao expedicao;
    private LoteFaturamentoNFe loteFaturamentoNFe;
    private TransportadorRedespacho transportadorRedespacho;
    private String chaveNFEInf;
    private Date dataEmissaoNota;
    private VersaoNFe versaoNfe;
    private PeriodoEmissaoNFe periodoEmissaoNFe;
    private UnidadeFederativa ufEmbarque;
    private String localEmbarque;
    private DpecNFe dpecNFe;
    private String notaEmpenho;
    private String nrPedidoCompra;
    private String nrContrato;
    private CondicoesPagamento condicaoPagamento;
    private Short indicadorEmitente = 0;
    private SituacaoDocumento situacaoDocumento;
    private Short tipoEmissao = 0;
    private Short finalidadeEmissao = 0;
    private String motivo;
    private Short formatoImpressao = 0;
    private Short status = 0;
    private String nrProtocolo;
    private Short enviadoReceita = 0;
    private List<ObservacaoNotaPropria> observacaoNota;
    private List<VolumeNFe> volumes;
    private List<LivroFiscal> livrosFiscais;
    private String parcelas;
    private String inscricaoSuframa;
    private Short faturadoSuframa = 0;
    private Short notaManual = 0;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Date dataEntradaSaida;
    private ValoresNfPropria valoresNfPropria;
    private DadosTransNfPropria dadosTransNfPropria;
    private List<ItemNotaFiscalPropria> itensNotaPropria;
    private List<ObservacaoIntFiscalNotaFiscalPropria> observacaoIntFiscalNotaFiscalPropria;
    private CancelamentoNFe cancelamentoNFe;
    private EvtNFeCancelamento evtNFeCancelamento;
    private Short liberarImpDanfe;
    private LocalEntregaNFPropria localEntregaNFPropria;
    private LocalRetiradaNFPropria localRetiradaNFPropria;
    private Short informarLocalEntregaNFPropria;
    private Short informarLocalRetiradaNFPropria;
    private Short indicadorConsumidorFinal;
    private Short indicadorPresencaConsumidor;
    private Date horaEmissao;
    private Date horaEntradaSaida;
    private GrupoDocumentosRefPR grupoDocumentosRefPR;
    private List<PedidoComercio> pedidosComercio;
    private EvtNFeEpec evtentoEpec;
    private Short contribuinteEstado;
    private List<NFeAutDownloadXML> nfeAutDownloadXML;
    private CotacaoMoeda cotacaoMoeda;
    private DevolucaoVendas devolucaoVendas;
    private PreFaturamentoNF preFaturamentoNF;
    private ApuracidadeEstoque apuracidadeEntrada;
    private ApuracidadeEstoque apuracidadeSaida;
    private String observacao;
    private MeioPagamento meioPagamento;
    private List<InfPagamentoNfPropria> infPagamentoNfPropria;
    private ProcessoImportacao processoImportacao;
    private Short transferidaFilial;
    private CadastroNacionalObra cadastroNacionalObra;
    private Short informarNotaObra;
    private Short tipoObraConstrucao;
    private List<TicketFiscal> ticketsFiscal;
    private Pessoa pessoaAutorizada;
    private String serialForSinc;
    private Short geradaNFCe;
    private NFCeControleCaixa nfceControleCaixa;
    private InutilizacaoNumeracaoNFe inutilizacaoNFe;
    private Short gerarAverbacao;
    private List<AverbacaoCte> averbacaoCte;
    private ErroAverbacaoCte erroAverbacaoCte;
    private Representante representante;
    private List<NotaFiscalPropriaFreteCtrc> notaPropriaFreteCtrc;
    private String placaVeiculo;
    private Long km;
    private List<NFCeLogPermissaoUsuario> logsNFCe;
    private ClassificacaoClientes classificacaoCliente;
    private CategoriaPessoa categoriaPessoa;
    private Short tipoIntermediadorComercial = EnumConstNFeIndIntermediador.NAO_SE_APLICA.getValue();
    private IntermediadorComercial intermediadorComercial;
    private WmsEntradaEstoque wmsEntradaEstoque;
    private Short alterarTituloPedido;
    private IntegracaoNotaPropriaNotas integracaoNotaPropriaNotas;
    private String versaoPdv;
    private List<NotaFiscalTerceirosFreteCtrc> notaTerceirosFreteCtrc;
    private Short tipoGuiaTransProdPrimarios = 0;
    private String ufGuiaTransProdPrimarios;
    private String serieGuiaTransProdPrimarios;
    private String numeroGuiaTransProdPrimarios;
    private List<DadosRecAgrNfPropria> receitasAgronomicas;
    private Short informarDadosReformaTributaria;

    public NotaFiscalPropria() {
        this.setDadosTransNfPropria(new DadosTransNfPropria());
        this.setValoresNfPropria(new ValoresNfPropria());
        this.observacaoIntFiscalNotaFiscalPropria = new ArrayList<ObservacaoIntFiscalNotaFiscalPropria>();
        this.itensNotaPropria = new ArrayList<ItemNotaFiscalPropria>();
        this.livrosFiscais = new ArrayList<LivroFiscal>();
        this.volumes = new ArrayList<VolumeNFe>();
        this.observacaoNota = new ArrayList<ObservacaoNotaPropria>();
        this.informarLocalEntregaNFPropria = 0;
        this.informarLocalRetiradaNFPropria = 0;
        this.alterarTituloPedido = 0;
        this.liberarImpDanfe = 0;
        this.nfeAutDownloadXML = new ArrayList<NFeAutDownloadXML>();
        this.pedidosComercio = new ArrayList<PedidoComercio>();
        this.infPagamentoNfPropria = new ArrayList<InfPagamentoNfPropria>();
        this.codChaveAcesso = 0;
        this.numeroNota = 0;
        this.numeroNotaInf = 0;
        this.digitoVerificador = 0;
        this.indicadorConsumidorFinal = 0;
        this.indicadorPresencaConsumidor = EnumConstNFeIndicadorPresConsumidor.OPERACAO_PRESENCIAL_FORA_ESTABELECIMENTO.getValue();
        this.contribuinteEstado = 0;
        this.transferidaFilial = 0;
        this.informarNotaObra = 0;
        this.tipoObraConstrucao = 0;
        this.ticketsFiscal = new ArrayList<TicketFiscal>();
        this.geradaNFCe = 0;
        this.gerarAverbacao = 1;
        this.averbacaoCte = new ArrayList<AverbacaoCte>();
        this.notaPropriaFreteCtrc = new ArrayList<NotaFiscalPropriaFreteCtrc>();
        this.logsNFCe = new ArrayList<NFCeLogPermissaoUsuario>();
        this.km = 0L;
        this.notaTerceirosFreteCtrc = new ArrayList<NotaFiscalTerceirosFreteCtrc>();
        this.receitasAgronomicas = new ArrayList<DadosRecAgrNfPropria>();
        this.informarDadosReformaTributaria = 1;
    }

    @Id
    @Column(nullable=false, name="ID_NOTA_PROPRIA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NOTA_PROPRIA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="SERIE", length=3)
    @Generated(value=GenerationTime.ALWAYS)
    public String getSerie() {
        return this.serie;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="CHAVE_NFE", length=44)
    public String getChaveNFE() {
        return this.chaveNFE;
    }

    @Column(name="CHAVE_NFE_AUX_CONT", length=36)
    public String getChaveNFEAuxCont() {
        return this.chaveNFEAuxCont;
    }

    @Column(name="COD_ACESSO")
    public Integer getCodChaveAcesso() {
        return this.codChaveAcesso;
    }

    @Column(name="NUMERO_NOTA")
    @Generated(value=GenerationTime.ALWAYS)
    public Integer getNumeroNota() {
        return this.numeroNota;
    }

    @Column(name="NUMERO_NOTA_INF")
    public Integer getNumeroNotaInf() {
        return this.numeroNotaInf;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DIGITO_VERIFICADOR")
    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_UNIDADE_FAT_CLI"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_NAT_OPERACAO"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_MOD_DOC_FISCAL"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="ID_EXPEDICAO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_EXPEDICAO"))
    public Expedicao getExpedicao() {
        return this.expedicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FATURAMENTO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_LOTE_FAT_NFE"))
    public LoteFaturamentoNFe getLoteFaturamentoNFe() {
        return this.loteFaturamentoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR_REDESPACHO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_TRANSP_REDESPAC"))
    public TransportadorRedespacho getTransportadorRedespacho() {
        return this.transportadorRedespacho;
    }

    @Column(name="CHAVE_NFE_INF", length=44)
    public String getChaveNFEInf() {
        return this.chaveNFEInf;
    }

    @Column(nullable=false, name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissaoNota() {
        return this.dataEmissaoNota;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VERSAO_NFE", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_VERSAO_NFE"))
    public VersaoNFe getVersaoNfe() {
        return this.versaoNfe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_EMISSAO_NFE", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_PER_EMI_NFE"))
    public PeriodoEmissaoNFe getPeriodoEmissaoNFe() {
        return this.periodoEmissaoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_EMBARQUE", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_UF"))
    public UnidadeFederativa getUfEmbarque() {
        return this.ufEmbarque;
    }

    @Column(name="LOCAL_EMBARQUE", length=60)
    public String getLocalEmbarque() {
        return this.localEmbarque;
    }

    @OneToOne(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public DpecNFe getDpecNFe() {
        return this.dpecNFe;
    }

    @Column(name="NOTA_EMPENHO", length=17)
    public String getNotaEmpenho() {
        return this.notaEmpenho;
    }

    @Column(name="NR_PEDIDO_COMPRA", length=60)
    public String getNrPedidoCompra() {
        return this.nrPedidoCompra;
    }

    @Column(name="NR_CONTRATO", length=60)
    public String getNrContrato() {
        return this.nrContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_CP"))
    public CondicoesPagamento getCondicaoPagamento() {
        return this.condicaoPagamento;
    }

    @Column(name="INDICADOR_EMITENTE")
    public Short getIndicadorEmitente() {
        return this.indicadorEmitente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_DOCUMENTO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_SD"))
    public SituacaoDocumento getSituacaoDocumento() {
        return this.situacaoDocumento;
    }

    @Column(name="TIPO_EMISSAO")
    public Short getTipoEmissao() {
        return this.tipoEmissao;
    }

    @Column(name="FINALIDADE_EMISSAO")
    public Short getFinalidadeEmissao() {
        return this.finalidadeEmissao;
    }

    @Column(name="MOTIVO", length=255)
    public String getMotivo() {
        return this.motivo;
    }

    @Column(name="FORMATO_IMPRESSAO")
    public Short getFormatoImpressao() {
        return this.formatoImpressao;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    @Column(name="NR_PROTOCOLO", length=15)
    public String getNrProtocolo() {
        return this.nrProtocolo;
    }

    @Column(name="ENVIADO_RECEITA")
    public Short getEnviadoReceita() {
        return this.enviadoReceita;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ObservacaoNotaPropria> getObservacaoNota() {
        return this.observacaoNota;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<VolumeNFe> getVolumes() {
        return this.volumes;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="NOTA_PROPRIA_LV_FISCAL", joinColumns={@JoinColumn(name="ID_NOTA_PROPRIA")}, inverseJoinColumns={@JoinColumn(name="ID_LIVRO_FISCAL")})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LivroFiscal> getLivrosFiscais() {
        return this.livrosFiscais;
    }

    @Column(name="PARCELAS", length=100)
    public String getParcelas() {
        return this.parcelas;
    }

    @Column(name="INSCRICAO_SUFRAMA", length=18)
    public String getInscricaoSuframa() {
        return this.inscricaoSuframa;
    }

    @Column(name="FATURADO_SUFRAMA")
    public Short getFaturadoSuframa() {
        return this.faturadoSuframa;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ObservacaoIntFiscalNotaFiscalPropria> getObservacaoIntFiscalNotaFiscalPropria() {
        return this.observacaoIntFiscalNotaFiscalPropria;
    }

    @Column(name="NOTA_MANUAL")
    public Short getNotaManual() {
        return this.notaManual;
    }

    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(name="DATA_ENTRADA_SAIDA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    @OneToOne(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ValoresNfPropria getValoresNfPropria() {
        return this.valoresNfPropria;
    }

    @OneToOne(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public DadosTransNfPropria getDadosTransNfPropria() {
        return this.dadosTransNfPropria;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemNotaFiscalPropria> getItensNotaPropria() {
        return this.itensNotaPropria;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    public void setChaveNFE(String chaveNFE) {
        this.chaveNFE = chaveNFE;
    }

    public void setChaveNFEAuxCont(String chaveNFEAuxCont) {
        this.chaveNFEAuxCont = chaveNFEAuxCont;
    }

    public void setCodChaveAcesso(Integer codChaveAcesso) {
        this.codChaveAcesso = codChaveAcesso;
    }

    public void setNumeroNota(Integer numeroNota) {
        this.numeroNota = numeroNota;
    }

    public void setNumeroNotaInf(Integer numeroNotaInf) {
        this.numeroNotaInf = numeroNotaInf;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        this.digitoVerificador = digitoVerificador;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    public void setExpedicao(Expedicao expedicao) {
        this.expedicao = expedicao;
    }

    public void setLoteFaturamentoNFe(LoteFaturamentoNFe loteFaturamentoNFe) {
        this.loteFaturamentoNFe = loteFaturamentoNFe;
    }

    public void setTransportadorRedespacho(TransportadorRedespacho transportadorRedespacho) {
        this.transportadorRedespacho = transportadorRedespacho;
    }

    public void setChaveNFEInf(String chaveNFEInf) {
        this.chaveNFEInf = chaveNFEInf;
    }

    public void setDataEmissaoNota(Date dataEmissaoNota) {
        this.dataEmissaoNota = dataEmissaoNota;
    }

    public void setVersaoNfe(VersaoNFe versaoNfe) {
        this.versaoNfe = versaoNfe;
    }

    public void setPeriodoEmissaoNFe(PeriodoEmissaoNFe periodoEmissaoNFe) {
        this.periodoEmissaoNFe = periodoEmissaoNFe;
    }

    public void setUfEmbarque(UnidadeFederativa ufEmbarque) {
        this.ufEmbarque = ufEmbarque;
    }

    public void setLocalEmbarque(String localEmbarque) {
        this.localEmbarque = localEmbarque;
    }

    public void setDpecNFe(DpecNFe dpecNFe) {
        this.dpecNFe = dpecNFe;
    }

    public void setNotaEmpenho(String notaEmpenho) {
        this.notaEmpenho = notaEmpenho;
    }

    public void setNrPedidoCompra(String nrPedidoCompra) {
        this.nrPedidoCompra = nrPedidoCompra;
    }

    public void setNrContrato(String nrContrato) {
        this.nrContrato = nrContrato;
    }

    public void setCondicaoPagamento(CondicoesPagamento condicaoPagamento) {
        this.condicaoPagamento = condicaoPagamento;
    }

    public void setIndicadorEmitente(Short indicadorEmitente) {
        this.indicadorEmitente = indicadorEmitente;
    }

    public void setSituacaoDocumento(SituacaoDocumento situacaoDocumento) {
        this.situacaoDocumento = situacaoDocumento;
    }

    public void setTipoEmissao(Short tipoEmissao) {
        this.tipoEmissao = tipoEmissao;
    }

    public void setFinalidadeEmissao(Short finalidadeEmissao) {
        this.finalidadeEmissao = finalidadeEmissao;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public void setFormatoImpressao(Short formatoImpressao) {
        this.formatoImpressao = formatoImpressao;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public void setObservacaoNota(List<ObservacaoNotaPropria> observacaoNota) {
        this.observacaoNota = observacaoNota;
    }

    public void setVolumes(List<VolumeNFe> volumes) {
        this.volumes = volumes;
    }

    public void setLivrosFiscais(List<LivroFiscal> livrosFiscais) {
        this.livrosFiscais = livrosFiscais;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    public void setInscricaoSuframa(String inscricaoSuframa) {
        this.inscricaoSuframa = inscricaoSuframa;
    }

    public void setFaturadoSuframa(Short faturadoSuframa) {
        this.faturadoSuframa = faturadoSuframa;
    }

    public void setObservacaoIntFiscalNotaFiscalPropria(List<ObservacaoIntFiscalNotaFiscalPropria> observacaoIntFiscalNotaFiscalPropria) {
        this.observacaoIntFiscalNotaFiscalPropria = observacaoIntFiscalNotaFiscalPropria;
    }

    public void setNotaManual(Short notaManual) {
        this.notaManual = notaManual;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataEntradaSaida(Date dataEntradaSaida) {
        this.dataEntradaSaida = dataEntradaSaida;
    }

    public void setValoresNfPropria(ValoresNfPropria valoresNfPropria) {
        this.valoresNfPropria = valoresNfPropria;
    }

    public void setDadosTransNfPropria(DadosTransNfPropria dadosTransNfPropria) {
        this.dadosTransNfPropria = dadosTransNfPropria;
    }

    public void setItensNotaPropria(List<ItemNotaFiscalPropria> itensNotaPropria) {
        this.itensNotaPropria = itensNotaPropria;
    }

    public void setNrProtocolo(String nrProtocolo) {
        this.nrProtocolo = nrProtocolo;
    }

    public void setEnviadoReceita(Short enviadoReceita) {
        this.enviadoReceita = enviadoReceita;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getNumeroNota() != null && this.getSerie() != null ? ToolBaseMethodsVO.toString((String)"Nr Nota: {0} Serie: {1}", (Object[])new Object[]{this.getNumeroNota(), this.getSerie()}) : ToolBaseMethodsVO.toString((String)"{0} emissao: {1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getDataEmissaoNota())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="SERIE_INF", length=3)
    public String getSerieInf() {
        return this.serieInf;
    }

    public void setSerieInf(String serieInf) {
        this.serieInf = serieInf;
    }

    @OneToOne(mappedBy="notaFiscalPropria")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public CancelamentoNFe getCancelamentoNFe() {
        return this.cancelamentoNFe;
    }

    public void setCancelamentoNFe(CancelamentoNFe cancelamentoNFe) {
        this.cancelamentoNFe = cancelamentoNFe;
    }

    @OneToOne(mappedBy="notaFiscalPropria")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE})
    public EvtNFeCancelamento getEvtNFeCancelamento() {
        return this.evtNFeCancelamento;
    }

    public void setEvtNFeCancelamento(EvtNFeCancelamento evtNFeCancelamento) {
        this.evtNFeCancelamento = evtNFeCancelamento;
    }

    @Column(name="LIBERAR_IMP_DANFE")
    public Short getLiberarImpDanfe() {
        return this.liberarImpDanfe;
    }

    public void setLiberarImpDanfe(Short liberarImpDanfe) {
        this.liberarImpDanfe = liberarImpDanfe;
    }

    @OneToOne(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LocalEntregaNFPropria getLocalEntregaNFPropria() {
        return this.localEntregaNFPropria;
    }

    public void setLocalEntregaNFPropria(LocalEntregaNFPropria localEntregaNFPropria) {
        this.localEntregaNFPropria = localEntregaNFPropria;
    }

    @OneToOne(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LocalRetiradaNFPropria getLocalRetiradaNFPropria() {
        return this.localRetiradaNFPropria;
    }

    public void setLocalRetiradaNFPropria(LocalRetiradaNFPropria localRetiradaNFPropria) {
        this.localRetiradaNFPropria = localRetiradaNFPropria;
    }

    @Column(name="INF_LOCAL_ENTREGA")
    public Short getInformarLocalEntregaNFPropria() {
        return this.informarLocalEntregaNFPropria;
    }

    public void setInformarLocalEntregaNFPropria(Short informarLocalEntregaNFPropria) {
        this.informarLocalEntregaNFPropria = informarLocalEntregaNFPropria;
    }

    @Column(name="INF_LOCAL_RETIRADA")
    public Short getInformarLocalRetiradaNFPropria() {
        return this.informarLocalRetiradaNFPropria;
    }

    public void setInformarLocalRetiradaNFPropria(Short informarLocalRetiradaNFPropria) {
        this.informarLocalRetiradaNFPropria = informarLocalRetiradaNFPropria;
    }

    @Column(name="IND_CONSUMIDOR_FINAL")
    public Short getIndicadorConsumidorFinal() {
        return this.indicadorConsumidorFinal;
    }

    public void setIndicadorConsumidorFinal(Short indicadorConsumidorFinal) {
        this.indicadorConsumidorFinal = indicadorConsumidorFinal;
    }

    @Column(name="IND_PRESENCA_CONSUMIDOR")
    public Short getIndicadorPresencaConsumidor() {
        return this.indicadorPresencaConsumidor;
    }

    public void setIndicadorPresencaConsumidor(Short indicadorPresencaConsumidor) {
        this.indicadorPresencaConsumidor = indicadorPresencaConsumidor;
    }

    @Column(name="HORA_EMISSAO")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraEmissao() {
        return this.horaEmissao;
    }

    public void setHoraEmissao(Date horaEmissao) {
        this.horaEmissao = horaEmissao;
    }

    @Column(name="HORA_ENTRADA_SAIDA")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraEntradaSaida() {
        return this.horaEntradaSaida;
    }

    public void setHoraEntradaSaida(Date horaEntradaSaida) {
        this.horaEntradaSaida = horaEntradaSaida;
    }

    @OneToOne(mappedBy="notaFiscalPropria")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public GrupoDocumentosRefPR getGrupoDocumentosRefPR() {
        return this.grupoDocumentosRefPR;
    }

    public void setGrupoDocumentosRefPR(GrupoDocumentosRefPR grupoDocumentosRefPR) {
        this.grupoDocumentosRefPR = grupoDocumentosRefPR;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    public List<PedidoComercio> getPedidosComercio() {
        return this.pedidosComercio;
    }

    public void setPedidosComercio(List<PedidoComercio> pedidosComercio) {
        this.pedidosComercio = pedidosComercio;
    }

    @OneToOne(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public EvtNFeEpec getEvtentoEpec() {
        return this.evtentoEpec;
    }

    public void setEvtentoEpec(EvtNFeEpec evtentoEpec) {
        this.evtentoEpec = evtentoEpec;
    }

    @Column(name="CONTRIBUINTE_ESTADO")
    public Short getContribuinteEstado() {
        return this.contribuinteEstado;
    }

    public void setContribuinteEstado(Short contribuinteEstado) {
        this.contribuinteEstado = contribuinteEstado;
    }

    @OneToMany(mappedBy="notaFiscalPropria")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NFeAutDownloadXML> getNfeAutDownloadXML() {
        return this.nfeAutDownloadXML;
    }

    public void setNfeAutDownloadXML(List<NFeAutDownloadXML> nfeAutDownloadXML) {
        this.nfeAutDownloadXML = nfeAutDownloadXML;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_MOEDA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_COTACAO_MOEDA"))
    public CotacaoMoeda getCotacaoMoeda() {
        return this.cotacaoMoeda;
    }

    public void setCotacaoMoeda(CotacaoMoeda cotacaoMoeda) {
        this.cotacaoMoeda = cotacaoMoeda;
    }

    @OneToOne(optional=true, mappedBy="notaPropriaGerada", fetch=FetchType.LAZY)
    public DevolucaoVendas getDevolucaoVendas() {
        return this.devolucaoVendas;
    }

    public void setDevolucaoVendas(DevolucaoVendas devolucaoVendas) {
        this.devolucaoVendas = devolucaoVendas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_FATURAMENTO_NF", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_PRE_FAT_NF"))
    public PreFaturamentoNF getPreFaturamentoNF() {
        return this.preFaturamentoNF;
    }

    public void setPreFaturamentoNF(PreFaturamentoNF preFaturamentoNF) {
        this.preFaturamentoNF = preFaturamentoNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACIDADE_ENTRADA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_APUR_ENTRADA"))
    public ApuracidadeEstoque getApuracidadeEntrada() {
        return this.apuracidadeEntrada;
    }

    public void setApuracidadeEntrada(ApuracidadeEstoque apuracidadeEntrada) {
        this.apuracidadeEntrada = apuracidadeEntrada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACIDADE_SAIDA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_APUR_SAIDA"))
    public ApuracidadeEstoque getApuracidadeSaida() {
        return this.apuracidadeSaida;
    }

    public void setApuracidadeSaida(ApuracidadeEstoque apuracidadeSaida) {
        this.apuracidadeSaida = apuracidadeSaida;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_MEIO_PAG"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<InfPagamentoNfPropria> getInfPagamentoNfPropria() {
        return this.infPagamentoNfPropria;
    }

    public void setInfPagamentoNfPropria(List<InfPagamentoNfPropria> infPagamentoNfPropria) {
        this.infPagamentoNfPropria = infPagamentoNfPropria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROCESSO_IMPORTACAO", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_PROC_IMP"))
    public ProcessoImportacao getProcessoImportacao() {
        return this.processoImportacao;
    }

    public void setProcessoImportacao(ProcessoImportacao processoImportacao) {
        this.processoImportacao = processoImportacao;
    }

    @Column(name="TRANSFERIDA_FILIAL")
    public Short getTransferidaFilial() {
        return this.transferidaFilial;
    }

    public void setTransferidaFilial(Short transferidaFilial) {
        this.transferidaFilial = transferidaFilial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CADASTRO_NACIONAL_OBRA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_CNO"))
    public CadastroNacionalObra getCadastroNacionalObra() {
        return this.cadastroNacionalObra;
    }

    public void setCadastroNacionalObra(CadastroNacionalObra cadastroNacionalObra) {
        this.cadastroNacionalObra = cadastroNacionalObra;
    }

    @Column(name="INFORMAR_NOTA_OBRA")
    public Short getInformarNotaObra() {
        return this.informarNotaObra;
    }

    public void setInformarNotaObra(Short informarNotaObra) {
        this.informarNotaObra = informarNotaObra;
    }

    @Column(name="TIPO_OBRA_CONSTRUCAO")
    public Short getTipoObraConstrucao() {
        return this.tipoObraConstrucao;
    }

    public void setTipoObraConstrucao(Short tipoObraConstrucao) {
        this.tipoObraConstrucao = tipoObraConstrucao;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    public List<TicketFiscal> getTicketsFiscal() {
        return this.ticketsFiscal;
    }

    public void setTicketsFiscal(List<TicketFiscal> ticketsFiscal) {
        this.ticketsFiscal = ticketsFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_AUTORIZADA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_PESSOA_AUTORIZA"))
    public Pessoa getPessoaAutorizada() {
        return this.pessoaAutorizada;
    }

    public void setPessoaAutorizada(Pessoa pessoaAutorizada) {
        this.pessoaAutorizada = pessoaAutorizada;
    }

    @Column(name="SERIAL_FOR_SINC", length=100)
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Column(name="GERADA_NFCE")
    public Short getGeradaNFCe() {
        return this.geradaNFCe;
    }

    public void setGeradaNFCe(Short geradaNFCe) {
        this.geradaNFCe = geradaNFCe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE_CONTROLE_CAIXA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_CONTROLE_CAIXA"))
    public NFCeControleCaixa getNfceControleCaixa() {
        return this.nfceControleCaixa;
    }

    public void setNfceControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        this.nfceControleCaixa = nfceControleCaixa;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="notaFiscalPropria", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public InutilizacaoNumeracaoNFe getInutilizacaoNFe() {
        return this.inutilizacaoNFe;
    }

    public void setInutilizacaoNFe(InutilizacaoNumeracaoNFe inutilizacaoNFe) {
        this.inutilizacaoNFe = inutilizacaoNFe;
    }

    @Column(name="GERAR_AVERBACAO")
    public Short getGerarAverbacao() {
        return this.gerarAverbacao;
    }

    public void setGerarAverbacao(Short gerarAverbacao) {
        this.gerarAverbacao = gerarAverbacao;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    public List<AverbacaoCte> getAverbacaoCte() {
        return this.averbacaoCte;
    }

    public void setAverbacaoCte(List<AverbacaoCte> averbacaoCte) {
        this.averbacaoCte = averbacaoCte;
    }

    @OneToOne(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY)
    public ErroAverbacaoCte getErroAverbacaoCte() {
        return this.erroAverbacaoCte;
    }

    public void setErroAverbacaoCte(ErroAverbacaoCte erroAverbacaoCte) {
        this.erroAverbacaoCte = erroAverbacaoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA_REPRESENTANTE"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @OneToMany(mappedBy="notaPropria", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<NotaFiscalPropriaFreteCtrc> getNotaPropriaFreteCtrc() {
        return this.notaPropriaFreteCtrc;
    }

    public void setNotaPropriaFreteCtrc(List<NotaFiscalPropriaFreteCtrc> notaPropriaFreteCtrc) {
        this.notaPropriaFreteCtrc = notaPropriaFreteCtrc;
    }

    @Column(name="PLACA_VEICULO", length=10)
    public String getPlacaVeiculo() {
        return this.placaVeiculo;
    }

    public void setPlacaVeiculo(String placaVeiculo) {
        this.placaVeiculo = placaVeiculo;
    }

    @Column(name="KM_VEICULO")
    public Long getKm() {
        return this.km;
    }

    public void setKm(Long km) {
        this.km = km;
    }

    @OneToMany(mappedBy="notaFiscalPropria", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<NFCeLogPermissaoUsuario> getLogsNFCe() {
        return this.logsNFCe;
    }

    public void setLogsNFCe(List<NFCeLogPermissaoUsuario> logsNFCe) {
        this.logsNFCe = logsNFCe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_CLIENTE", foreignKey=@ForeignKey(name="FK_NFCE_UNID_FAT_CLIENTE"))
    public ClassificacaoClientes getClassificacaoCliente() {
        return this.classificacaoCliente;
    }

    public void setClassificacaoCliente(ClassificacaoClientes classificacaoCliente) {
        this.classificacaoCliente = classificacaoCliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_NFCE_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTERMEDIADOR_COMERCIAL")
    public IntermediadorComercial getIntermediadorComercial() {
        return this.intermediadorComercial;
    }

    public void setIntermediadorComercial(IntermediadorComercial intermediadorComercial) {
        this.intermediadorComercial = intermediadorComercial;
    }

    @Column(name="TIPO_INTERMEDIADOR_COMERCIAL")
    public Short getTipoIntermediadorComercial() {
        return this.tipoIntermediadorComercial;
    }

    public void setTipoIntermediadorComercial(Short tipoIntermediadorComercial) {
        this.tipoIntermediadorComercial = tipoIntermediadorComercial;
    }

    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="notaFiscalPropria")
    public WmsEntradaEstoque getWmsEntradaEstoque() {
        return this.wmsEntradaEstoque;
    }

    public void setWmsEntradaEstoque(WmsEntradaEstoque wmsEntradaEstoque) {
        this.wmsEntradaEstoque = wmsEntradaEstoque;
    }

    @Column(name="alterar_titulo_pedido")
    public Short getAlterarTituloPedido() {
        return this.alterarTituloPedido;
    }

    public void setAlterarTituloPedido(Short alterarTituloPedido) {
        this.alterarTituloPedido = alterarTituloPedido;
    }

    @OneToOne(mappedBy="notaPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public IntegracaoNotaPropriaNotas getIntegracaoNotaPropriaNotas() {
        return this.integracaoNotaPropriaNotas;
    }

    public void setIntegracaoNotaPropriaNotas(IntegracaoNotaPropriaNotas integracaoNotaPropriaNotas) {
        this.integracaoNotaPropriaNotas = integracaoNotaPropriaNotas;
    }

    @Column(name="VERSAO_PDV", length=15)
    public String getVersaoPdv() {
        return this.versaoPdv;
    }

    public void setVersaoPdv(String versaoPdv) {
        this.versaoPdv = versaoPdv;
    }

    @OneToMany(mappedBy="notaPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NotaFiscalTerceirosFreteCtrc> getNotaTerceirosFreteCtrc() {
        return this.notaTerceirosFreteCtrc;
    }

    public void setNotaTerceirosFreteCtrc(List<NotaFiscalTerceirosFreteCtrc> notaTerceirosFreteCtrc) {
        this.notaTerceirosFreteCtrc = notaTerceirosFreteCtrc;
    }

    @Column(name="TIPO_GUIA_TRANS_PROD_PRIM")
    public Short getTipoGuiaTransProdPrimarios() {
        return this.tipoGuiaTransProdPrimarios;
    }

    public void setTipoGuiaTransProdPrimarios(Short tipoGuiaTransProdPrimarios) {
        this.tipoGuiaTransProdPrimarios = tipoGuiaTransProdPrimarios;
    }

    @Column(name="UF_GUIA_TRANS_PROD_PRIM", length=2)
    public String getUfGuiaTransProdPrimarios() {
        return this.ufGuiaTransProdPrimarios;
    }

    public void setUfGuiaTransProdPrimarios(String ufGuiaTransProdPrimarios) {
        this.ufGuiaTransProdPrimarios = ufGuiaTransProdPrimarios;
    }

    @Column(name="SERIE_GUIA_TRANS_PROD_PRIM", length=3)
    public String getSerieGuiaTransProdPrimarios() {
        return this.serieGuiaTransProdPrimarios;
    }

    public void setSerieGuiaTransProdPrimarios(String serieGuiaTransProdPrimarios) {
        this.serieGuiaTransProdPrimarios = serieGuiaTransProdPrimarios;
    }

    @Column(name="NUM_GUIA_TRANS_PROD_PRIM", length=10)
    public String getNumeroGuiaTransProdPrimarios() {
        return this.numeroGuiaTransProdPrimarios;
    }

    public void setNumeroGuiaTransProdPrimarios(String numeroGuiaTransProdPrimarios) {
        this.numeroGuiaTransProdPrimarios = numeroGuiaTransProdPrimarios;
    }

    @OneToMany(mappedBy="notaFiscalPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DadosRecAgrNfPropria> getReceitasAgronomicas() {
        return this.receitasAgronomicas;
    }

    public void setReceitasAgronomicas(List<DadosRecAgrNfPropria> receitasAgronomicas) {
        this.receitasAgronomicas = receitasAgronomicas;
    }

    @Column(name="INF_DADOS_REFORMA_TRIBUTARIA")
    public Short getInformarDadosReformaTributaria() {
        return this.informarDadosReformaTributaria;
    }

    public void setInformarDadosReformaTributaria(Short informarDadosReformaTributaria) {
        this.informarDadosReformaTributaria = informarDadosReformaTributaria;
    }
}

