/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ParamImpFreteNcmMod;
import com.touchcomp.basementor.model.vo.ParamImpFreteProdMod;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PARAM_IMPOSTOS_FRETE")
public class ParametrizacaoImpostosFrete
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String descricao;
    private GrupoEmpresa grupoEmpresa;
    private List<ParamImpFreteProdMod> paramImpFreteProdMod = new ArrayList<ParamImpFreteProdMod>();
    private List<ParamImpFreteNcmMod> paramImpFreteNcmMod = new ArrayList<ParamImpFreteNcmMod>();
    private Short tipoParametrizacao = EnumConstantsMentorSimNao.NAO.getValue();

    @Id
    @Column(nullable=false, unique=true, name="ID_PARAM_IMPOSTOS_FRETE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAM_IMPOSTOS_FRETE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAM_IMPOSTOS_FRETE_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="parametrizacaoImpostosFrete", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ParamImpFreteProdMod> getParamImpFreteProdMod() {
        return this.paramImpFreteProdMod;
    }

    public void setParamImpFreteProdMod(List<ParamImpFreteProdMod> paramImpFreteProdMod) {
        this.paramImpFreteProdMod = paramImpFreteProdMod;
    }

    @OneToMany(mappedBy="parametrizacaoImpostosFrete", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ParamImpFreteNcmMod> getParamImpFreteNcmMod() {
        return this.paramImpFreteNcmMod;
    }

    public void setParamImpFreteNcmMod(List<ParamImpFreteNcmMod> paramImpFreteNcmMod) {
        this.paramImpFreteNcmMod = paramImpFreteNcmMod;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_PARAMETRIZACAO", nullable=false)
    public Short getTipoParametrizacao() {
        return this.tipoParametrizacao;
    }

    public void setTipoParametrizacao(Short tipoParametrizacao) {
        this.tipoParametrizacao = tipoParametrizacao;
    }

    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAM_IMPOSTOS_FRETE_GE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }
}

