/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ParametrizacaoMTCFrete;
import com.touchcomp.basementor.model.vo.ParametrizacaoMTCSubEspecie;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PARAMETRIZACAO_MTC")
public class ParametrizacaoMTC
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private SituacaoPedidos situacaoPedidosAprovada;
    private SituacaoPedidos situacaoPedidosReprovada;
    private List<ParametrizacaoMTCFrete> parametrizacaoMTCFrete = new ArrayList<ParametrizacaoMTCFrete>();
    private List<ParametrizacaoMTCSubEspecie> parametrizacaoMTCSubEspecie = new ArrayList<ParametrizacaoMTCSubEspecie>();
    private Empresa empresa;

    @Id
    @Column(name="ID_PARAMETRIZACAO_MTC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAMETRIZACAO_MTC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_SIT_PEDIDOS_APROVADA", foreignKey=@ForeignKey(name="FK_PARAM_MTC_SIT_PED_APROVADA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SituacaoPedidos getSituacaoPedidosAprovada() {
        return this.situacaoPedidosAprovada;
    }

    public void setSituacaoPedidosAprovada(SituacaoPedidos situacaoPedidosAprovada) {
        this.situacaoPedidosAprovada = situacaoPedidosAprovada;
    }

    @JoinColumn(name="ID_SIT_PEDIDOS_REPROVADA", foreignKey=@ForeignKey(name="FK_PARAM_MTC_SIT_PED_REPROVADA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SituacaoPedidos getSituacaoPedidosReprovada() {
        return this.situacaoPedidosReprovada;
    }

    public void setSituacaoPedidosReprovada(SituacaoPedidos situacaoPedidosReprovada) {
        this.situacaoPedidosReprovada = situacaoPedidosReprovada;
    }

    @OneToMany(mappedBy="parametrizacaoMTC")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ParametrizacaoMTCFrete> getParametrizacaoMTCFrete() {
        return this.parametrizacaoMTCFrete;
    }

    public void setParametrizacaoMTCFrete(List<ParametrizacaoMTCFrete> parametrizacaoMTCFrete) {
        this.parametrizacaoMTCFrete = parametrizacaoMTCFrete;
    }

    @OneToMany(mappedBy="parametrizacaoMTC")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ParametrizacaoMTCSubEspecie> getParametrizacaoMTCSubEspecie() {
        return this.parametrizacaoMTCSubEspecie;
    }

    public void setParametrizacaoMTCSubEspecie(List<ParametrizacaoMTCSubEspecie> parametrizacaoMTCSubEspecie) {
        this.parametrizacaoMTCSubEspecie = parametrizacaoMTCSubEspecie;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAM_MTC_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

