/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EdicaoPesquisa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloEnvioMensagens;
import com.touchcomp.basementor.model.vo.PesquisaSetorUsuario;
import com.touchcomp.basementor.model.vo.QuestaoPesquisa;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementor.model.vo.TipoPesquisa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PESQUISA")
public class Pesquisa
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<QuestaoPesquisa> questoesPesquisa = new ArrayList<QuestaoPesquisa>();
    private List<PesquisaSetorUsuario> pesquisaSetorUsuario = new ArrayList<PesquisaSetorUsuario>();
    private Date dataEncerramento;
    private List<EdicaoPesquisa> edicaoPesquisa = new ArrayList<EdicaoPesquisa>();
    private TipoPesquisa tipoPesquisa;
    private Short status = EnumConstStatusObjeto.ATIVO.getValue();
    private SmartComponentPref smartComponent;
    private ModeloEnvioMensagens modeloEnvioMensagens;

    @Id
    @Column(name="ID_PESQUISA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PESQUISA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PESQUISA_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="pesquisa")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<QuestaoPesquisa> getQuestoesPesquisa() {
        return this.questoesPesquisa;
    }

    public void setQuestoesPesquisa(List<QuestaoPesquisa> questoesPesquisa) {
        this.questoesPesquisa = questoesPesquisa;
    }

    @OneToMany(mappedBy="pesquisa", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<PesquisaSetorUsuario> getPesquisaSetorUsuario() {
        return this.pesquisaSetorUsuario;
    }

    public void setPesquisaSetorUsuario(List<PesquisaSetorUsuario> pesquisaSetorUsuario) {
        this.pesquisaSetorUsuario = pesquisaSetorUsuario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENCERRAMENTO")
    public Date getDataEncerramento() {
        return this.dataEncerramento;
    }

    public void setDataEncerramento(Date dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    @OneToMany(mappedBy="pesquisa")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EdicaoPesquisa> getEdicaoPesquisa() {
        return this.edicaoPesquisa;
    }

    public void setEdicaoPesquisa(List<EdicaoPesquisa> edicaoPesquisa) {
        this.edicaoPesquisa = edicaoPesquisa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PESQUISA", foreignKey=@ForeignKey(name="FK_PESQUISA_TIPO_PESQUISA"))
    public TipoPesquisa getTipoPesquisa() {
        return this.tipoPesquisa;
    }

    public void setTipoPesquisa(TipoPesquisa tipoPesquisa) {
        this.tipoPesquisa = tipoPesquisa;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SMART_COMPONENT", foreignKey=@ForeignKey(name="FK_PESQUISA_SMART_COMP"))
    public SmartComponentPref getSmartComponent() {
        return this.smartComponent;
    }

    public void setSmartComponent(SmartComponentPref smartComponent) {
        this.smartComponent = smartComponent;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_ENVIO_MSG", foreignKey=@ForeignKey(name="FK_PESQUISA_MOD_ENVIO_MSG"))
    public ModeloEnvioMensagens getModeloEnvioMensagens() {
        return this.modeloEnvioMensagens;
    }

    public void setModeloEnvioMensagens(ModeloEnvioMensagens modeloEnvioMensagens) {
        this.modeloEnvioMensagens = modeloEnvioMensagens;
    }
}

