/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeSituacoes;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.ItemPlanejamentoProdLinProd;
import com.touchcomp.basementor.model.vo.PeriodoProducao;
import com.touchcomp.basementor.model.vo.PlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPLin;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PLANEJAMENTO_PROD_OS_LIN_P")
public class PlanejamentoProdLinhaProd
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private GrupoDeSituacoes grupoSituacoesPedido;
    private Short exibirEstoque = 0;
    private Short simulacao = 0;
    private Short analisarPontoRessuprimento = 0;
    private CentroEstoque centroEstoque;
    private List<ItemPlanejamentoProdLinProd> itemplanProdLinProd = new ArrayList<ItemPlanejamentoProdLinProd>();
    private PeriodoProducao periodoProducao;
    private Date dataConsultaEstoque;
    private Short liberarCompras = 0;
    private Date dataLiberacaoCompras;
    private List<PlanejProdLinProdPrevConsProd> previsaoConsProdutos = new ArrayList<PlanejProdLinProdPrevConsProd>();
    private String observacao;
    private GrupoNecCompra grupoNecCompra;
    private CentroCusto centroCustoCompras;
    private Usuario usuarioLibCompras;
    private Short liberarReservaEstoque = 0;
    private TransfEstoquePCPLin transfEstoquePCPLinReserva;
    private Date dataLiberacaoResEstoque;
    private String observacaoReservaEst;
    private Usuario usuarioLibReservaEst;
    private Short tipoPlanejamento = 0;
    private Short listarPrevSomentePlan = 0;
    private Short travarProducao = 0;
    private String observacaoGeral;
    private Short analisaEstoqueSeguranca = 0;
    private Short expMelhorRotForm = 0;
    private Short filtrarGrupoSituacao = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_PLANEJ_PROD_OS_LIN_P")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PLANEJAMENTO_PROD_OS_LIN_P")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="planejamentoProdLinProd")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemPlanejamentoProdLinProd> getItemplanProdLinProd() {
        return this.itemplanProdLinProd;
    }

    public void setItemplanProdLinProd(List<ItemPlanejamentoProdLinProd> itemplanProdLinProd) {
        this.itemplanProdLinProd = itemplanProdLinProd;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="EXIBIR_ESTOQUE")
    public Short getExibirEstoque() {
        return this.exibirEstoque;
    }

    public void setExibirEstoque(Short exibirEstoque) {
        this.exibirEstoque = exibirEstoque;
    }

    @Column(name="ANALISAR_PONTO_RESSUPRIMENTO")
    public Short getAnalisarPontoRessuprimento() {
        return this.analisarPontoRessuprimento;
    }

    public void setAnalisarPontoRessuprimento(Short analisarPontoRessuprimento) {
        this.analisarPontoRessuprimento = analisarPontoRessuprimento;
    }

    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_CEN_EST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @JoinColumn(name="ID_PERIODO_PRODUCAO", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_PER_PRO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PeriodoProducao getPeriodoProducao() {
        return this.periodoProducao;
    }

    public void setPeriodoProducao(PeriodoProducao periodoProducao) {
        this.periodoProducao = periodoProducao;
    }

    @JoinColumn(name="ID_GRUPO_SIT_PEDIDOS", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_GR_SIT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoDeSituacoes getGrupoSituacoesPedido() {
        return this.grupoSituacoesPedido;
    }

    public void setGrupoSituacoesPedido(GrupoDeSituacoes grupoSituacoesPedido) {
        this.grupoSituacoesPedido = grupoSituacoesPedido;
    }

    @Column(name="SIMULACAO")
    public Short getSimulacao() {
        return this.simulacao;
    }

    public void setSimulacao(Short simulacao) {
        this.simulacao = simulacao;
    }

    @Column(name="DATA_CONSULTA_ESTOQUE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataConsultaEstoque() {
        return this.dataConsultaEstoque;
    }

    public void setDataConsultaEstoque(Date dataConsultaEstoque) {
        this.dataConsultaEstoque = dataConsultaEstoque;
    }

    @Column(name="LIBERAR_COMPRAS")
    public Short getLiberarCompras() {
        return this.liberarCompras;
    }

    public void setLiberarCompras(Short liberarCompras) {
        this.liberarCompras = liberarCompras;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIBERACAO_COMPRAS")
    public Date getDataLiberacaoCompras() {
        return this.dataLiberacaoCompras;
    }

    public void setDataLiberacaoCompras(Date dataLiberacaoCompras) {
        this.dataLiberacaoCompras = dataLiberacaoCompras;
    }

    @OneToMany(mappedBy="planejamentoProdLinhaProd")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<PlanejProdLinProdPrevConsProd> getPrevisaoConsProdutos() {
        return this.previsaoConsProdutos;
    }

    public void setPrevisaoConsProdutos(List<PlanejProdLinProdPrevConsProd> previsaoConsProdutos) {
        this.previsaoConsProdutos = previsaoConsProdutos;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @JoinColumn(name="ID_GRUPO_NEC_COMPRA", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_GR_NEC"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoNecCompra getGrupoNecCompra() {
        return this.grupoNecCompra;
    }

    public void setGrupoNecCompra(GrupoNecCompra grupoNecCompra) {
        this.grupoNecCompra = grupoNecCompra;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO_COMPRAS", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_CC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getCentroCustoCompras() {
        return this.centroCustoCompras;
    }

    public void setCentroCustoCompras(CentroCusto centroCustoCompras) {
        this.centroCustoCompras = centroCustoCompras;
    }

    @JoinColumn(name="ID_USUARIO_LIB_COMPRAS", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_USER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuarioLibCompras() {
        return this.usuarioLibCompras;
    }

    public void setUsuarioLibCompras(Usuario usuarioLibCompras) {
        this.usuarioLibCompras = usuarioLibCompras;
    }

    @Column(name="LIBERAR_RESERVA_ESTOQUE")
    public Short getLiberarReservaEstoque() {
        return this.liberarReservaEstoque;
    }

    public void setLiberarReservaEstoque(Short liberarReservaEstoque) {
        this.liberarReservaEstoque = liberarReservaEstoque;
    }

    @OneToOne(mappedBy="planejamentoProdLinhaProd")
    public TransfEstoquePCPLin getTransfEstoquePCPLinReserva() {
        return this.transfEstoquePCPLinReserva;
    }

    public void setTransfEstoquePCPLinReserva(TransfEstoquePCPLin transfEstoquePCPLinReserva) {
        this.transfEstoquePCPLinReserva = transfEstoquePCPLinReserva;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Planejamento: {0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getPeriodoProducao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIBERACAO_RES_ESTOQUE")
    public Date getDataLiberacaoResEstoque() {
        return this.dataLiberacaoResEstoque;
    }

    public void setDataLiberacaoResEstoque(Date dataLiberacaoResEstoque) {
        this.dataLiberacaoResEstoque = dataLiberacaoResEstoque;
    }

    @Column(name="OBSERVACAO_RESERVA_EST", length=500)
    public String getObservacaoReservaEst() {
        return this.observacaoReservaEst;
    }

    public void setObservacaoReservaEst(String observacaoReservaEst) {
        this.observacaoReservaEst = observacaoReservaEst;
    }

    @JoinColumn(name="ID_USUARIO_LIB_RES_EST", foreignKey=@ForeignKey(name="FK_PLANEJ_PROD_OS_LIN_P_US_RES"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuarioLibReservaEst() {
        return this.usuarioLibReservaEst;
    }

    public void setUsuarioLibReservaEst(Usuario usuarioLibReservaEst) {
        this.usuarioLibReservaEst = usuarioLibReservaEst;
    }

    @Column(name="TIPO_PLANEJAMENTO")
    public Short getTipoPlanejamento() {
        return this.tipoPlanejamento;
    }

    public void setTipoPlanejamento(Short tipoPlanejamento) {
        this.tipoPlanejamento = tipoPlanejamento;
    }

    @Column(name="LISTAR_PREV_SOM_PLAN")
    public Short getListarPrevSomentePlan() {
        return this.listarPrevSomentePlan;
    }

    public void setListarPrevSomentePlan(Short listarPrevSomentePlan) {
        this.listarPrevSomentePlan = listarPrevSomentePlan;
    }

    @Column(name="TRAVAR_PRODUCAO")
    public Short getTravarProducao() {
        return this.travarProducao;
    }

    public void setTravarProducao(Short travarProducao) {
        this.travarProducao = travarProducao;
    }

    @Column(name="OBSERVACAO_GERAL", length=5000)
    public String getObservacaoGeral() {
        return this.observacaoGeral;
    }

    public void setObservacaoGeral(String observacaoGeral) {
        this.observacaoGeral = observacaoGeral;
    }

    @Column(name="ANALISAR_ESTOQUE_SEG")
    public Short getAnalisaEstoqueSeguranca() {
        return this.analisaEstoqueSeguranca;
    }

    public void setAnalisaEstoqueSeguranca(Short analisaEstoqueSeguranca) {
        this.analisaEstoqueSeguranca = analisaEstoqueSeguranca;
    }

    @Column(name="MELHOR_ROTA_FORM")
    public Short getExpMelhorRotForm() {
        return this.expMelhorRotForm;
    }

    public void setExpMelhorRotForm(Short expMelhorRotForm) {
        this.expMelhorRotForm = expMelhorRotForm;
    }

    @Column(name="FILTRAR_GRUPO_SITUACAO")
    public Short getFiltrarGrupoSituacao() {
        return this.filtrarGrupoSituacao;
    }

    public void setFiltrarGrupoSituacao(Short filtrarGrupoSituacao) {
        this.filtrarGrupoSituacao = filtrarGrupoSituacao;
    }
}

