/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoProcSolicitacaoContatoRelProc;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.ProcedenciaSolContGrUsuarioReag;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacaoContatoGrupoUsuario;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PROC_SOL_CONTATO")
public class ProcedenciaSolicitacaoContato
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Short tipoProcedencia = 0;
    private String tituloEmail;
    private List<ProcedenciaSolicitacaoContatoGrupoUsuario> gruposUsuarios = new ArrayList<ProcedenciaSolicitacaoContatoGrupoUsuario>();
    private PlanoContaGerencial pcGerencialFaturamento;
    private List<GrupoProcSolicitacaoContatoRelProc> grupoRelProcSolCont = new ArrayList<GrupoProcSolicitacaoContatoRelProc>();
    private Short sugestao = 0;
    private Short procedenciaTarifada = 0;
    private Short exigirReembolsos = 0;
    private SetorUsuario setorUsuario;
    private ClienteContSistemas clienteContSistProc;
    private Integer nivel = 0;
    private Short ativo = 1;
    private Integer sequencia = 0;
    private Short sinteticoAnalitico;
    private String codigo;
    private ProcedenciaSolicitacaoContato procSolContatoPai;
    private Double prazoSla = 0.0;
    private Double margemReagPrazoSlaHoras = 0.0;
    private List<ProcedenciaSolContGrUsuarioReag> gruposUsuariosOpAvancadas = new LinkedList<ProcedenciaSolContGrUsuarioReag>();

    public ProcedenciaSolicitacaoContato() {
        this.sinteticoAnalitico = EnumConstSinteticoAnalitico.ANALITICO.getEnumId();
    }

    @Id
    @Column(nullable=false, name="ID_PROC_SOL_CONTATO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROC_SOL_CONTATO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, unique=true, name="NOME", length=40)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROC_SOL_CONTATO_1"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empreasa) {
        this.empresa = empreasa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_PROCEDENCIA")
    public Short getTipoProcedencia() {
        return this.tipoProcedencia;
    }

    public void setTipoProcedencia(Short tipoProcedencia) {
        this.tipoProcedencia = tipoProcedencia;
    }

    @Column(name="TITULO_EMAIL", length=100)
    public String getTituloEmail() {
        return this.tituloEmail;
    }

    public void setTituloEmail(String tituloEmail) {
        this.tituloEmail = tituloEmail;
    }

    @OneToMany(mappedBy="procedencia", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ProcedenciaSolicitacaoContatoGrupoUsuario> getGruposUsuarios() {
        return this.gruposUsuarios;
    }

    public void setGruposUsuarios(List<ProcedenciaSolicitacaoContatoGrupoUsuario> gruposUsuarios) {
        this.gruposUsuarios = gruposUsuarios;
    }

    @JoinColumn(name="ID_PC_GERENCIAL_FATURAMENTO", foreignKey=@ForeignKey(name="FK_PROC_SOLIC_CONT_PC_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPcGerencialFaturamento() {
        return this.pcGerencialFaturamento;
    }

    public void setPcGerencialFaturamento(PlanoContaGerencial pcGerencialFaturamento) {
        this.pcGerencialFaturamento = pcGerencialFaturamento;
    }

    @OneToMany(mappedBy="procSolCon")
    public List<GrupoProcSolicitacaoContatoRelProc> getGrupoRelProcSolCont() {
        return this.grupoRelProcSolCont;
    }

    public void setGrupoRelProcSolCont(List<GrupoProcSolicitacaoContatoRelProc> grupoRelProcSolCont) {
        this.grupoRelProcSolCont = grupoRelProcSolCont;
    }

    @Column(name="SUGESTAO")
    public Short getSugestao() {
        return this.sugestao;
    }

    public void setSugestao(Short sugestao) {
        this.sugestao = sugestao;
    }

    @JoinColumn(name="ID_SETOR_USUARIO", foreignKey=@ForeignKey(name="FK_PROC_SOL_CONT_SET_USU"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SetorUsuario getSetorUsuario() {
        return this.setorUsuario;
    }

    public void setSetorUsuario(SetorUsuario setorUsuario) {
        this.setorUsuario = setorUsuario;
    }

    @Column(name="PROCEDENCIA_TARIFADA")
    public Short getProcedenciaTarifada() {
        return this.procedenciaTarifada;
    }

    public void setProcedenciaTarifada(Short procedenciaTarifada) {
        this.procedenciaTarifada = procedenciaTarifada;
    }

    @Column(name="EXIGIR_REEMBOLSOS")
    public Short getExigirReembolsos() {
        return this.exigirReembolsos;
    }

    public void setExigirReembolsos(Short exigirReembolsos) {
        this.exigirReembolsos = exigirReembolsos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE_ATENDIMENTO_PROC")
    public ClienteContSistemas getClienteContSistProc() {
        return this.clienteContSistProc;
    }

    public void setClienteContSistProc(ClienteContSistemas clienteContSistProc) {
        this.clienteContSistProc = clienteContSistProc;
    }

    @Column(name="nivel")
    public Integer getNivel() {
        return this.nivel;
    }

    public void setNivel(Integer nivel) {
        this.nivel = nivel;
    }

    @Column(name="sintetico_analitico")
    public Short getSinteticoAnalitico() {
        return this.sinteticoAnalitico;
    }

    public void setSinteticoAnalitico(Short sinteticoAnalitico) {
        this.sinteticoAnalitico = sinteticoAnalitico;
    }

    @Column(name="codigo")
    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROC_SOL_CONTATO_PAI")
    public ProcedenciaSolicitacaoContato getProcSolContatoPai() {
        return this.procSolContatoPai;
    }

    public void setProcSolContatoPai(ProcedenciaSolicitacaoContato procSolContatoPai) {
        this.procSolContatoPai = procSolContatoPai;
    }

    @Column(name="prazo_sla")
    public Double getPrazoSla() {
        return this.prazoSla;
    }

    public void setPrazoSla(Double prazoSla) {
        this.prazoSla = prazoSla;
    }

    @OneToMany(mappedBy="procSolContato", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProcedenciaSolContGrUsuarioReag> getGruposUsuariosOpAvancadas() {
        return this.gruposUsuariosOpAvancadas;
    }

    public void setGruposUsuariosOpAvancadas(List<ProcedenciaSolContGrUsuarioReag> gruposUsuariosOpAvancadas) {
        this.gruposUsuariosOpAvancadas = gruposUsuariosOpAvancadas;
    }

    @Column(name="margem_reag_prazo_sla")
    public Double getMargemReagPrazoSlaHoras() {
        return this.margemReagPrazoSlaHoras;
    }

    public void setMargemReagPrazoSlaHoras(Double margemReagPrazoSlaHoras) {
        this.margemReagPrazoSlaHoras = margemReagPrazoSlaHoras;
    }

    @Column(name="sequencia")
    public Integer getSequencia() {
        return this.sequencia;
    }

    public void setSequencia(Integer sequencia) {
        this.sequencia = sequencia;
    }

    @Column(name="ativo")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

