/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CaracteristicaProduto;
import com.touchcomp.basementor.model.vo.CategoriaProdProduto;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.Cest;
import com.touchcomp.basementor.model.vo.ClasseEnquadramentoIPI;
import com.touchcomp.basementor.model.vo.ClassificacaoProdutoANP;
import com.touchcomp.basementor.model.vo.ClassificacaoProdutos;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.ConfiGerarLoteAutoProd;
import com.touchcomp.basementor.model.vo.ConversorExpressoesDinamico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.FormulacaoFases;
import com.touchcomp.basementor.model.vo.Genero;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.GrupoProdutosRelProd;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.Localizacao;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.ParamCodAuxProduto;
import com.touchcomp.basementor.model.vo.ParamReceitaPisCofinsNatReceita;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.ProdutoAliquotaUF;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.ProdutoInfoEcommerce;
import com.touchcomp.basementor.model.vo.ProdutoKitExpedicao;
import com.touchcomp.basementor.model.vo.ProdutoModeloFaturamento;
import com.touchcomp.basementor.model.vo.ProdutoOpcoesOp;
import com.touchcomp.basementor.model.vo.ProdutoTipoCompra;
import com.touchcomp.basementor.model.vo.ProdutosSimilaresItens;
import com.touchcomp.basementor.model.vo.RegraExcecaoNCM;
import com.touchcomp.basementor.model.vo.StatusLoteFabricacao;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.TipoConfNFTerceirosProduto;
import com.touchcomp.basementor.model.vo.TipoItemSped;
import com.touchcomp.basementor.model.vo.TipoMedicamento;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="PRODUTO")
public class Produto
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private Double aliquotaPis;
    private Double aliquotaCofins;
    private Integer entradaSaida;
    private UnidadeMedida unidadeMedida;
    private Double qtdMin;
    private Double qtdMax;
    private Double pesoUnitario;
    private String nomeAuxiliar;
    private String codigoAuxiliar;
    private Double qtdVolume;
    private Double aliquotaIpi;
    private Double aliquotaIrrf;
    private Double aliquotaInss;
    private Double aliquotaIcms;
    private Double aliquotaContSoc;
    private Double percRedSestSenat;
    private Date dataCadastro;
    private Short ativo;
    private Short loteUnico;
    private Double qtdMinVenda;
    private Double qtdMaxVenda;
    private String materialUtilizado;
    private Double reducaoBaseCalcIcms;
    private Double aliquotaIss;
    private Double aliquotaLei10833;
    private Double aliquotaFunrural;
    private Double aliquotaOutros;
    private Timestamp dataAtualizacao;
    private Double volume;
    private String codigoServico;
    private Double percRedBCINSS;
    private Double percSestSenat;
    private Especie especie;
    private SubEspecie subEspecie;
    private Localizacao localizacao;
    private Ncm ncm;
    private CategoriaSt categoriaSutr;
    private Fabricante fabricante;
    private Empresa empresa;
    private Genero genero;
    private PlanoConta planoConta;
    private List<ProdutoModeloFaturamento> modeloFiscal;
    private PlanoContaGerencial planoContaGerencial;
    private ClassificacaoProdutos classificacaoProdutos;
    private Double valorTabICMS;
    private Double valorTabICMSST;
    private Double percRedFunrural;
    private Double percRedIrrf;
    private Double percRedOutros;
    private Double percRedLei10833;
    private Double percRedContSoc;
    private TipoItemSped tipoIemSped;
    private TipoMedicamento tipoMedicamento;
    private Double valorMaximoConsumo;
    private List<ItemUnidadeMedida> itemUnidadeMedida;
    private List<CodigoBarras> codigoBarras;
    private ClasseEnquadramentoIPI classeEnqIpi;
    private ClassificacaoProdutoANP classificacaoProdutoANP;
    private Double aliquotaCide;
    private Double pontoRessupEstoque;
    private String codigoMD5;
    private Short liberarConferenciaManual;
    private Short tipoProduto;
    private Double aliqImpEstimada;
    private Double aliqImpEstimadaEst;
    private Double aliqImpEstimadaMun;
    private Double aliqImpEstimadaFed;
    private RegraExcecaoNCM regraExcecaoNCM;
    private Short ipiTributadoQuantidade;
    private Short pisCofinsTributadoQuantidade;
    private Double aliquotaPisQtde;
    private Double aliquotaCofinsQtde;
    private List<ProdutoGrade> gradesProduto;
    private GrupoProdutos grupoProdutos;
    private String observacao;
    private Double aliquotaImportacao;
    private List<CaracteristicaProduto> caracteristicasProdutos;
    private Short qtdeNaoFracionada;
    private String codigoReferencia;
    private List<ProdutoAliquotaUF> aliquotasUF;
    private FormulacaoFases formulacaoFases;
    private GradeFormulaProduto gradeFormulaProduto;
    private Cest cest;
    private Double pesoEmbalagem;
    private ConfiGerarLoteAutoProd configGerarLoteAuto;
    private ProdutoTipoCompra produtoTipoCompra;
    private Short gerarLoteFabricacaoBloqueado;
    private List<GrupoProdutosRelProd> grupoProdutosRel;
    private List<ProdutosSimilaresItens> produtosSimilaresItens;
    private String codBeneficioFiscal;
    private String codAnvisa;
    private Double densidade;
    private TipoConfNFTerceirosProduto tipoConfNFTerceirosProduto;
    private Double percGLP;
    private Double percGNN;
    private Double percGNI;
    private Double diametro;
    private Double espessura;
    private ConversorExpressoesDinamico conversorExpressoesDinamico;
    private Long periodoValLoteFab;
    private Double aliquotaPisSt;
    private Double aliquotaCofinsSt;
    private String motivoIsencaoAnvisa;
    private Double largura;
    private Double altura;
    private Double comprimento;
    private String dcb;
    private String registroMinisterioSaude;
    private String codigoFCI;
    private Short naoAplicaSuframa;
    private Short vinculadoAtividadeCooperado;
    private Double aliquotaSenar;
    private Double aliquotaRat;
    private Double taxaSanidadeAnimal;
    private Double fatorTaxaSanidadeAnimal;
    private Short utilizarProdutoKit;
    private List<ProdutoKitExpedicao> produtosKit;
    private Date dataUltModificacao;
    private String codigoMapa;
    private String codSincronizacao;
    private Short codProvServicoRec;
    private Short emitirReceitaAgro;
    private Double percentualDiferimento;
    private String numeroRegistroInmetro;
    private List<ParamReceitaPisCofinsNatReceita> naturezasReceita;
    private Short permitirVendaSomenteAutomacao;
    private List<CategoriaProdProduto> categoriasProduto;
    private ProdutoInfoEcommerce infoEcommerce;
    private Date dataInicioFaturamento;
    private Double percIndiceMisturaBioDiesel;
    private ParamCodAuxProduto paramCodAuxProduto;
    private Double fatorConversaoPCP;
    private Double pesoEspecifico;
    private StatusLoteFabricacao statusLoteFabricacao;
    private List<ProdutoOpcoesOp> outrasOpcoes;

    public Produto() {
        this.gerarLoteFabricacaoBloqueado = 0;
        this.codProvServicoRec = EnumConstProvedorRecAgro.SEM_VINCULO_SERVICO.getValue();
        this.valorMaximoConsumo = 0.0;
        this.largura = 0.0;
        this.altura = 0.0;
        this.comprimento = 0.0;
        this.diametro = 0.0;
        this.espessura = 0.0;
        this.percRedContSoc = 0.0;
        this.percRedLei10833 = 0.0;
        this.percRedOutros = 0.0;
        this.percRedIrrf = 0.0;
        this.percRedFunrural = 0.0;
        this.valorTabICMSST = 0.0;
        this.valorTabICMS = 0.0;
        this.percSestSenat = 0.0;
        this.fatorConversaoPCP = 0.0;
        this.pesoEspecifico = 0.0;
        this.percRedBCINSS = 0.0;
        this.qtdMinVenda = 0.0;
        this.qtdMaxVenda = 0.0;
        this.reducaoBaseCalcIcms = 0.0;
        this.aliquotaIss = 0.0;
        this.aliquotaLei10833 = 0.0;
        this.aliquotaFunrural = 0.0;
        this.aliquotaOutros = 0.0;
        this.aliquotaPis = 0.0;
        this.aliquotaCofins = 0.0;
        this.qtdMin = 0.0;
        this.qtdMax = 0.0;
        this.pesoUnitario = 0.0;
        this.qtdVolume = 0.0;
        this.aliquotaIpi = 0.0;
        this.aliquotaIrrf = 0.0;
        this.aliquotaInss = 0.0;
        this.aliquotaIcms = 0.0;
        this.aliquotaContSoc = 0.0;
        this.percRedSestSenat = 0.0;
        this.volume = 0.0;
        this.pontoRessupEstoque = 0.0;
        this.codigoBarras = new ArrayList<CodigoBarras>();
        this.itemUnidadeMedida = new ArrayList<ItemUnidadeMedida>();
        this.grupoProdutosRel = new ArrayList<GrupoProdutosRelProd>();
        this.outrasOpcoes = new ArrayList<ProdutoOpcoesOp>();
        this.modeloFiscal = new ArrayList<ProdutoModeloFaturamento>();
        this.aliquotaPisQtde = 0.0;
        this.aliquotaCofinsQtde = 0.0;
        this.tipoProduto = 0;
        this.liberarConferenciaManual = 0;
        this.aliquotaCide = 0.0;
        this.gradesProduto = new ArrayList<ProdutoGrade>();
        this.produtosSimilaresItens = new ArrayList<ProdutosSimilaresItens>();
        this.categoriasProduto = new ArrayList<CategoriaProdProduto>();
        this.caracteristicasProdutos = new ArrayList<CaracteristicaProduto>();
        this.ativo = 1;
        this.dataCadastro = new Date();
        this.qtdeNaoFracionada = 0;
        this.aliquotasUF = new ArrayList<ProdutoAliquotaUF>();
        this.entradaSaida = 0;
        this.loteUnico = 0;
        this.aliqImpEstimadaEst = 0.0;
        this.aliqImpEstimadaFed = 0.0;
        this.aliqImpEstimadaMun = 0.0;
        this.ipiTributadoQuantidade = 0;
        this.pisCofinsTributadoQuantidade = 0;
        this.aliquotaImportacao = 0.0;
        this.pesoEmbalagem = 0.0;
        this.densidade = 0.0;
        this.percGLP = 0.0;
        this.percGNN = 0.0;
        this.percGNI = 0.0;
        this.periodoValLoteFab = 0L;
        this.aliquotaPisSt = 0.0;
        this.aliquotaCofinsSt = 0.0;
        this.naoAplicaSuframa = 0;
        this.vinculadoAtividadeCooperado = 0;
        this.aliquotaSenar = 0.0;
        this.aliquotaRat = 0.0;
        this.taxaSanidadeAnimal = 0.0;
        this.fatorTaxaSanidadeAnimal = 0.0;
        this.utilizarProdutoKit = 0;
        this.emitirReceitaAgro = 0;
        this.produtosKit = new ArrayList<ProdutoKitExpedicao>();
        this.naturezasReceita = new ArrayList<ParamReceitaPisCofinsNatReceita>();
        this.percentualDiferimento = 0.0;
        this.permitirVendaSomenteAutomacao = 0;
        this.aliqImpEstimada = 0.0;
        this.percIndiceMisturaBioDiesel = 0.0;
    }

    public Produto(Long identificador, String nome, Short ativo) {
        this();
        this.identificador = identificador;
        this.nome = nome;
        this.ativo = ativo;
    }

    @Id
    @Column(nullable=false, name="ID_PRODUTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRODUTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=false, name="NOME", length=120)
    public String getNome() {
        return this.nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_PRODUTO_UNIDADE_MEDIDA"))
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GENERO", foreignKey=@ForeignKey(name="FK_PRODUTO_GENERO"))
    public Genero getGenero() {
        return this.genero;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_MEDICAMENTO", foreignKey=@ForeignKey(name="FK_PRODUTO_TP_MEDICAMENTO"))
    public TipoMedicamento getTipoMedicamento() {
        return this.tipoMedicamento;
    }

    public void setTipoMedicamento(TipoMedicamento tipoMedicamento) {
        this.tipoMedicamento = tipoMedicamento;
    }

    @Column(name="VALOR_MAXIMO_CONSUMIDOR", precision=12, scale=2)
    public Double getValorMaximoConsumo() {
        return this.valorMaximoConsumo;
    }

    public void setValorMaximoConsumo(Double valorMaximoConsumo) {
        this.valorMaximoConsumo = valorMaximoConsumo;
    }

    @Column(name="QTD_MIN", precision=12, scale=3)
    public Double getQtdMin() {
        return this.qtdMin;
    }

    @Column(name="QTD_MAX", precision=12, scale=3)
    public Double getQtdMax() {
        return this.qtdMax;
    }

    @Column(name="NOME_AUXILIAR", length=120)
    public String getNomeAuxiliar() {
        return this.nomeAuxiliar;
    }

    @Column(name="ALIQUOTA_ISS", precision=12, scale=3)
    public Double getAliquotaIss() {
        return this.aliquotaIss;
    }

    @Column(name="QTD_VOLUME", precision=12, scale=3)
    public Double getQtdVolume() {
        return this.qtdVolume;
    }

    @Column(name="ALIQUOTA_IPI", precision=12, scale=3)
    public Double getAliquotaIpi() {
        return this.aliquotaIpi;
    }

    @Column(name="ALIQUOTA_IRRF", precision=12, scale=3)
    public Double getAliquotaIrrf() {
        return this.aliquotaIrrf;
    }

    @Column(name="ALIQUOTA_INSS", precision=12, scale=3)
    public Double getAliquotaInss() {
        return this.aliquotaInss;
    }

    @Column(name="ALIQUOTA_ICMS", precision=12, scale=3)
    public Double getAliquotaIcms() {
        return this.aliquotaIcms;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    @Column(name="QTD_MIN_VENDA", precision=12, scale=3)
    public Double getQtdMinVenda() {
        return this.qtdMinVenda;
    }

    @Column(name="MATERIAL_UTILIZADO", length=100)
    public String getMaterialUtilizado() {
        return this.materialUtilizado;
    }

    @Column(name="ALIQUOTA_LEI10833", precision=12, scale=3)
    public Double getAliquotaLei10833() {
        return this.aliquotaLei10833;
    }

    @Column(name="ALIQUOTA_FUNRURAL", precision=12, scale=3)
    public Double getAliquotaFunrural() {
        return this.aliquotaFunrural;
    }

    @Column(name="ALIQUOTA_OUTROS", precision=12, scale=3)
    public Double getAliquotaOutros() {
        return this.aliquotaOutros;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="VOLUME", precision=12, scale=3)
    public Double getVolume() {
        return this.volume;
    }

    @Column(name="CODIGO_SERVICO", length=4)
    public String getCodigoServico() {
        return this.codigoServico;
    }

    @Column(nullable=false, name="ENTRADA_SAIDA")
    public Integer getEntradaSaida() {
        return this.entradaSaida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ESPECIE", foreignKey=@ForeignKey(name="FK_PRODUTO_ESPECIE"))
    public Especie getEspecie() {
        return this.especie;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SUB_ESPECIE", foreignKey=@ForeignKey(name="FK_PRODUTO_SUBESPECIE"))
    public SubEspecie getSubEspecie() {
        return this.subEspecie;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCALIZACAO", foreignKey=@ForeignKey(name="FK_PRODUTO_LOCALIZACAO"))
    public Localizacao getLocalizacao() {
        return this.localizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NCM", foreignKey=@ForeignKey(name="FK_PRODUTO_NCM"))
    public Ncm getNcm() {
        return this.ncm;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_ST", foreignKey=@ForeignKey(name="FK_PRODUTO_CATEGORIA_ST"))
    public CategoriaSt getCategoriaSutr() {
        return this.categoriaSutr;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FABRICANTE", foreignKey=@ForeignKey(name="FK_PRODUTO_FABRICANTE"))
    public Fabricante getFabricante() {
        return this.fabricante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRODUTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public Produto(Long identificador) {
    }

    public Produto(Long identificador, String nome, short ativo) {
        this.identificador = identificador;
        this.nome = nome;
        this.ativo = ativo;
    }

    public void setIdentificador(Long idProduto) {
        this.identificador = idProduto;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    public void setGenero(Genero genero) {
        this.genero = genero;
    }

    public void setQtdMin(Double qtdMin) {
        this.qtdMin = qtdMin;
    }

    public void setQtdMax(Double qtdMax) {
        this.qtdMax = qtdMax;
    }

    public void setPesoUnitario(Double pesoUnitario) {
        this.pesoUnitario = pesoUnitario;
    }

    public void setNomeAuxiliar(String nomeAuxiliar) {
        this.nomeAuxiliar = nomeAuxiliar;
    }

    public void setQtdVolume(Double qtdVolume) {
        this.qtdVolume = qtdVolume;
    }

    public void setAliquotaIpi(Double aliquotaIpi) {
        this.aliquotaIpi = aliquotaIpi;
    }

    public void setAliquotaIrrf(Double aliquotaIrrf) {
        this.aliquotaIrrf = aliquotaIrrf;
    }

    public void setAliquotaInss(Double aliquotaInss) {
        this.aliquotaInss = aliquotaInss;
    }

    public void setAliquotaIcms(Double aliquotaIcms) {
        this.aliquotaIcms = aliquotaIcms;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public void setQtdMinVenda(Double qtdMinVenda) {
        this.qtdMinVenda = qtdMinVenda;
    }

    public void setMaterialUtilizado(String materialUtilizado) {
        this.materialUtilizado = materialUtilizado;
    }

    public void setEspecie(Especie especie) {
        this.especie = especie;
    }

    public void setSubEspecie(SubEspecie idSubEspecie) {
        this.subEspecie = idSubEspecie;
    }

    public void setLocalizacao(Localizacao idLocalizacao) {
        this.localizacao = idLocalizacao;
    }

    public void setNcm(Ncm ncm) {
        this.ncm = ncm;
    }

    public void setCategoriaSutr(CategoriaSt idCategoriaSutr) {
        this.categoriaSutr = idCategoriaSutr;
    }

    public void setFabricante(Fabricante idFabricante) {
        this.fabricante = idFabricante;
    }

    public void setEmpresa(Empresa idEmp) {
        this.empresa = idEmp;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public void setAliquotaIss(Double aliquotaIss) {
        this.aliquotaIss = aliquotaIss;
    }

    public void setAliquotaLei10833(Double aliquotaLei10833) {
        this.aliquotaLei10833 = aliquotaLei10833;
    }

    public void setAliquotaFunrural(Double aliquotaFunrural) {
        this.aliquotaFunrural = aliquotaFunrural;
    }

    public void setAliquotaOutros(Double aliquotaOutros) {
        this.aliquotaOutros = aliquotaOutros;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setCentimetrosCubicos(Double centimetrosCubicos) {
        this.setVolume(centimetrosCubicos);
    }

    public void setCodigoServico(String codigoServico) {
        this.codigoServico = codigoServico;
    }

    public void setEntradaSaida(Integer entradaSaida) {
        this.entradaSaida = entradaSaida;
    }

    public void setVolume(Double volume) {
        this.volume = volume;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_PRODUTO_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @Column(name="LOTE_UNICO")
    public Short getLoteUnico() {
        return this.loteUnico;
    }

    public void setLoteUnico(Short controlarPorLote) {
        this.loteUnico = controlarPorLote;
    }

    @Column(name="PERC_COFINS", precision=15, scale=4)
    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    @Column(name="PERC_PIS", precision=15, scale=4)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaCofins(Double confins) {
        this.aliquotaCofins = confins;
    }

    public void setAliquotaPis(Double pis) {
        this.aliquotaPis = pis;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    public List<ProdutoModeloFaturamento> getModeloFiscal() {
        return this.modeloFiscal;
    }

    public void setModeloFiscal(List<ProdutoModeloFaturamento> modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_PRODUTO_PC_GERENCIAL"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Column(name="REDUCAO_BASE_CALC_ICMS", precision=15, scale=4)
    public Double getReducaoBaseCalcIcms() {
        return this.reducaoBaseCalcIcms;
    }

    public void setReducaoBaseCalcIcms(Double reducaoBaseCalcIcms) {
        this.reducaoBaseCalcIcms = reducaoBaseCalcIcms;
    }

    @Column(unique=true, name="CODIGO_AUXILIAR", length=60)
    public String getCodigoAuxiliar() {
        return this.codigoAuxiliar;
    }

    public void setCodigoAuxiliar(String codigoAuxiliar) {
        this.codigoAuxiliar = codigoAuxiliar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PRODUTOS", foreignKey=@ForeignKey(name="FK_PRODUTO_CLASS_PRODUTOS"))
    public ClassificacaoProdutos getClassificacaoProdutos() {
        return this.classificacaoProdutos;
    }

    public void setClassificacaoProdutos(ClassificacaoProdutos classificacaoProdutos) {
        this.classificacaoProdutos = classificacaoProdutos;
    }

    @Column(name="VALOR_TAB_ICMS", precision=15, scale=2)
    public Double getValorTabICMS() {
        return this.valorTabICMS;
    }

    public void setValorTabICMS(Double valorTabICMS) {
        this.valorTabICMS = valorTabICMS;
    }

    @Column(name="VALOR_TAB_ICMSST", precision=15, scale=2)
    public Double getValorTabICMSST() {
        return this.valorTabICMSST;
    }

    public void setValorTabICMSST(Double valorTabICMSST) {
        this.valorTabICMSST = valorTabICMSST;
    }

    @Column(name="ALIQUOTA_CONT_SOC", precision=15, scale=2)
    public Double getAliquotaContSoc() {
        return this.aliquotaContSoc;
    }

    public void setAliquotaContSoc(Double aliquotaContSoc) {
        this.aliquotaContSoc = aliquotaContSoc;
    }

    @Column(name="PERC_RED_BC_INSS", precision=15, scale=2)
    public Double getPercRedBCINSS() {
        return this.percRedBCINSS;
    }

    public void setPercRedBCINSS(Double percRedBCINSS) {
        this.percRedBCINSS = percRedBCINSS;
    }

    @Column(name="PERC_SEST_SENAT", precision=15, scale=2)
    public Double getPercSestSenat() {
        return this.percSestSenat;
    }

    public void setPercSestSenat(Double percSestSenat) {
        this.percSestSenat = percSestSenat;
    }

    @Column(name="PERC_RED_SEST_SENAT", precision=15, scale=2)
    public Double getPercRedSestSenat() {
        return this.percRedSestSenat;
    }

    public void setPercRedSestSenat(Double percRedSestSenat) {
        this.percRedSestSenat = percRedSestSenat;
    }

    @Column(name="PERC_RED_FUNRURAL", precision=15, scale=2)
    public Double getPercRedFunrural() {
        return this.percRedFunrural;
    }

    public void setPercRedFunrural(Double percRedFunrural) {
        this.percRedFunrural = percRedFunrural;
    }

    @Column(nullable=false, name="PERC_RED_IRRF", precision=15, scale=2)
    public Double getPercRedIrrf() {
        return this.percRedIrrf;
    }

    public void setPercRedIrrf(Double percRedIrrf) {
        this.percRedIrrf = percRedIrrf;
    }

    @Column(name="PERC_RED_OUTROS", precision=15, scale=2)
    public Double getPercRedOutros() {
        return this.percRedOutros;
    }

    public void setPercRedOutros(Double percRedOutros) {
        this.percRedOutros = percRedOutros;
    }

    @Column(name="PERC_RED_LEI10833", precision=15, scale=2)
    public Double getPercRedLei10833() {
        return this.percRedLei10833;
    }

    public void setPercRedLei10833(Double percRedLei10833) {
        this.percRedLei10833 = percRedLei10833;
    }

    @Column(name="PERC_RED_CONT_SOC", precision=15, scale=2)
    public Double getPercRedContSoc() {
        return this.percRedContSoc;
    }

    public void setPercRedContSoc(Double percRedContSoc) {
        this.percRedContSoc = percRedContSoc;
    }

    @JoinColumn(name="ID_TIPO_ITEM_SPED", foreignKey=@ForeignKey(name="FK_PRODUTO_TP_ITEM_SPED"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoItemSped getTipoIemSped() {
        return this.tipoIemSped;
    }

    public void setTipoIemSped(TipoItemSped tipoIemSped) {
        this.tipoIemSped = tipoIemSped;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ItemUnidadeMedida> getItemUnidadeMedida() {
        return this.itemUnidadeMedida;
    }

    public void setItemUnidadeMedida(List<ItemUnidadeMedida> itemUnidadeMedida) {
        this.itemUnidadeMedida = itemUnidadeMedida;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<CodigoBarras> getCodigoBarras() {
        return this.codigoBarras;
    }

    public void setCodigoBarras(List<CodigoBarras> codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSE_ENQ_IPI", foreignKey=@ForeignKey(name="FK_PRODUTO_CLASSE_ENQ_IPI"))
    public ClasseEnquadramentoIPI getClasseEnqIpi() {
        return this.classeEnqIpi;
    }

    public void setClasseEnqIpi(ClasseEnquadramentoIPI classeEnqIpi) {
        this.classeEnqIpi = classeEnqIpi;
    }

    @Column(nullable=false, name="PESO_UNITARIO", precision=15, scale=6)
    public Double getPesoUnitario() {
        return this.pesoUnitario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PRODUTO_ANP", foreignKey=@ForeignKey(name="FK_PRODUTO_CLAS_PROD_ANP"))
    public ClassificacaoProdutoANP getClassificacaoProdutoANP() {
        return this.classificacaoProdutoANP;
    }

    public void setClassificacaoProdutoANP(ClassificacaoProdutoANP classificacaoProdutoANP) {
        this.classificacaoProdutoANP = classificacaoProdutoANP;
    }

    @Column(nullable=false, name="ALIQUOTA_CIDE", precision=15, scale=4)
    public Double getAliquotaCide() {
        return this.aliquotaCide;
    }

    public void setAliquotaCide(Double aliquotaCide) {
        this.aliquotaCide = aliquotaCide;
    }

    @Column(name="PONTO_RESUPRIMENTO_EST", precision=15, scale=6)
    public Double getPontoRessupEstoque() {
        return this.pontoRessupEstoque;
    }

    public void setPontoRessupEstoque(Double pontoRessupEstoque) {
        this.pontoRessupEstoque = pontoRessupEstoque;
    }

    @Column(name="CODIGO_MD5", length=32)
    public String getCodigoMD5() {
        return this.codigoMD5;
    }

    public void setCodigoMD5(String codigoMD5) {
        this.codigoMD5 = codigoMD5;
    }

    @Column(name="LIBERAR_CONF_MANUAL")
    public Short getLiberarConferenciaManual() {
        return this.liberarConferenciaManual;
    }

    public void setLiberarConferenciaManual(Short liberarConferenciaManual) {
        this.liberarConferenciaManual = liberarConferenciaManual;
    }

    @Column(name="TIPO_PRODUTO")
    public Short getTipoProduto() {
        return this.tipoProduto;
    }

    public void setTipoProduto(Short tipoProduto) {
        this.tipoProduto = tipoProduto;
    }

    @Deprecated
    @Column(name="ALIQ_IMP_ESTIMADA", precision=15, scale=2)
    public Double getAliqImpEstimada() {
        return this.aliqImpEstimada;
    }

    @Deprecated
    public void setAliqImpEstimada(Double aliqImpEstimada) {
        this.aliqImpEstimada = aliqImpEstimada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGRA_EXCECAO_NCM", foreignKey=@ForeignKey(name="FK_PRODUTO_REGRA_EXC_NCM"))
    public RegraExcecaoNCM getRegraExcecaoNCM() {
        return this.regraExcecaoNCM;
    }

    public void setRegraExcecaoNCM(RegraExcecaoNCM regraExcecaoNCM) {
        this.regraExcecaoNCM = regraExcecaoNCM;
    }

    @Column(name="IPI_TRIBUTADO_QTDE")
    public Short getIpiTributadoQuantidade() {
        return this.ipiTributadoQuantidade;
    }

    public void setIpiTributadoQuantidade(Short ipiTributadoQuantidade) {
        this.ipiTributadoQuantidade = ipiTributadoQuantidade;
    }

    @Column(name="PIS_COFINS_TRIBUTADO_QTDE")
    public Short getPisCofinsTributadoQuantidade() {
        return this.pisCofinsTributadoQuantidade;
    }

    public void setPisCofinsTributadoQuantidade(Short pisCofinsTributadoQuantidade) {
        this.pisCofinsTributadoQuantidade = pisCofinsTributadoQuantidade;
    }

    @Column(name="ALIQUOTA_PIS_QTDE", precision=15, scale=4)
    public Double getAliquotaPisQtde() {
        return this.aliquotaPisQtde;
    }

    public void setAliquotaPisQtde(Double aliquotaPisQtde) {
        this.aliquotaPisQtde = aliquotaPisQtde;
    }

    @Column(name="ALIQUOTA_COFINS_QTDE", precision=15, scale=4)
    public Double getAliquotaCofinsQtde() {
        return this.aliquotaCofinsQtde;
    }

    public void setAliquotaCofinsQtde(Double aliquotaCofinsQtde) {
        this.aliquotaCofinsQtde = aliquotaCofinsQtde;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_PRODUTOS", foreignKey=@ForeignKey(name="FK_PRODUTO_GRUPO_PROD"))
    public GrupoProdutos getGrupoProdutos() {
        return this.grupoProdutos;
    }

    public void setGrupoProdutos(GrupoProdutos grupoProdutos) {
        this.grupoProdutos = grupoProdutos;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY)
    public List<ProdutoGrade> getGradesProduto() {
        return this.gradesProduto;
    }

    public void setGradesProduto(List<ProdutoGrade> gradesProduto) {
        this.gradesProduto = gradesProduto;
    }

    @Column(name="OBSERVACAO", length=10000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="ALIQUOTA_IMPORTACAO", precision=15, scale=4)
    public Double getAliquotaImportacao() {
        return this.aliquotaImportacao;
    }

    public void setAliquotaImportacao(Double aliquotaImportacao) {
        this.aliquotaImportacao = aliquotaImportacao;
    }

    @OneToMany
    @JoinTable(name="produto_caract_prod", joinColumns={@JoinColumn(name="id_produto")}, inverseJoinColumns={@JoinColumn(name="id_caracteristica_produtos")})
    public List<CaracteristicaProduto> getCaracteristicasProdutos() {
        return this.caracteristicasProdutos;
    }

    public void setCaracteristicasProdutos(List<CaracteristicaProduto> caracteristicasProdutos) {
        this.caracteristicasProdutos = caracteristicasProdutos;
    }

    @Column(name="QTDE_NAO_FRACIONADA")
    public Short getQtdeNaoFracionada() {
        return this.qtdeNaoFracionada;
    }

    public void setQtdeNaoFracionada(Short qtdeNaoFracionada) {
        this.qtdeNaoFracionada = qtdeNaoFracionada;
    }

    @Column(name="CODIGO_REFERENCIA", length=100)
    public String getCodigoReferencia() {
        return this.codigoReferencia;
    }

    public void setCodigoReferencia(String codigoReferencia) {
        this.codigoReferencia = codigoReferencia;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProdutoAliquotaUF> getAliquotasUF() {
        return this.aliquotasUF;
    }

    public void setAliquotasUF(List<ProdutoAliquotaUF> aliquotasUF) {
        this.aliquotasUF = aliquotasUF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMULACAO_FASES", foreignKey=@ForeignKey(name="FK_PRODUTO_FORM_FASES"))
    public FormulacaoFases getFormulacaoFases() {
        return this.formulacaoFases;
    }

    public void setFormulacaoFases(FormulacaoFases formulacaoFases) {
        this.formulacaoFases = formulacaoFases;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_FORMULA_PRODUTO", foreignKey=@ForeignKey(name="FK_PRODUTO_GRADE_FORM_PROD"))
    public GradeFormulaProduto getGradeFormulaProduto() {
        return this.gradeFormulaProduto;
    }

    public void setGradeFormulaProduto(GradeFormulaProduto gradeFormulaProduto) {
        this.gradeFormulaProduto = gradeFormulaProduto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CEST", foreignKey=@ForeignKey(name="FK_PRODUTO_CEST"))
    public Cest getCest() {
        return this.cest;
    }

    public void setCest(Cest cest) {
        this.cest = cest;
    }

    @Column(nullable=false, name="PESO_EMBALAGEM", precision=15, scale=2)
    public Double getPesoEmbalagem() {
        return this.pesoEmbalagem;
    }

    public void setPesoEmbalagem(Double pesoEmbalagem) {
        this.pesoEmbalagem = pesoEmbalagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONFIG_GERAR_LOTE_AUTO_PROD", foreignKey=@ForeignKey(name="FK_PRODUTO_CONF_GERAR_LOTE_AUTO"))
    public ConfiGerarLoteAutoProd getConfigGerarLoteAuto() {
        return this.configGerarLoteAuto;
    }

    public void setConfigGerarLoteAuto(ConfiGerarLoteAutoProd configGerarLoteAuto) {
        this.configGerarLoteAuto = configGerarLoteAuto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO_TIPO_COMPRA", foreignKey=@ForeignKey(name="FK_PRODUTO_PROD_TIPO_COMPRA"))
    public ProdutoTipoCompra getProdutoTipoCompra() {
        return this.produtoTipoCompra;
    }

    public void setProdutoTipoCompra(ProdutoTipoCompra produtoTipoCompra) {
        this.produtoTipoCompra = produtoTipoCompra;
    }

    @Column(name="GERAR_LOTE_FABRICACAO_BLOQUEADO")
    public Short getGerarLoteFabricacaoBloqueado() {
        return this.gerarLoteFabricacaoBloqueado;
    }

    public void setGerarLoteFabricacaoBloqueado(Short gerarLoteFabricacaoBloqueado) {
        this.gerarLoteFabricacaoBloqueado = gerarLoteFabricacaoBloqueado;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<GrupoProdutosRelProd> getGrupoProdutosRel() {
        return this.grupoProdutosRel;
    }

    public void setGrupoProdutosRel(List<GrupoProdutosRelProd> grupoProdutosRel) {
        this.grupoProdutosRel = grupoProdutosRel;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY)
    public List<ProdutosSimilaresItens> getProdutosSimilaresItens() {
        return this.produtosSimilaresItens;
    }

    public void setProdutosSimilaresItens(List<ProdutosSimilaresItens> produtosSimilaresItens) {
        this.produtosSimilaresItens = produtosSimilaresItens;
    }

    @Column(nullable=true, name="COD_BENEFICIO_FISCAL", length=10)
    public String getCodBeneficioFiscal() {
        return this.codBeneficioFiscal;
    }

    public void setCodBeneficioFiscal(String codBeneficioFiscal) {
        this.codBeneficioFiscal = codBeneficioFiscal;
    }

    @Column(nullable=true, name="COD_ANVISA", length=13)
    public String getCodAnvisa() {
        return this.codAnvisa;
    }

    public void setCodAnvisa(String codAnvisa) {
        this.codAnvisa = codAnvisa;
    }

    @Column(name="DENSIDADE", precision=15, scale=6)
    public Double getDensidade() {
        return this.densidade;
    }

    public void setDensidade(Double densidade) {
        this.densidade = densidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CONF_NF_TERC_PROD", foreignKey=@ForeignKey(name="FK_PRODUTO_P_TIPO_CONF_NF_TERC"))
    public TipoConfNFTerceirosProduto getTipoConfNFTerceirosProduto() {
        return this.tipoConfNFTerceirosProduto;
    }

    public void setTipoConfNFTerceirosProduto(TipoConfNFTerceirosProduto tipoConfNFTerceirosProduto) {
        this.tipoConfNFTerceirosProduto = tipoConfNFTerceirosProduto;
    }

    @Column(name="PERC_GLP", precision=15, scale=4)
    public Double getPercGLP() {
        return this.percGLP;
    }

    public void setPercGLP(Double percGLP) {
        this.percGLP = percGLP;
    }

    @Column(name="PERC_GNN", precision=15, scale=2)
    public Double getPercGNN() {
        return this.percGNN;
    }

    public void setPercGNN(Double percGNN) {
        this.percGNN = percGNN;
    }

    @Column(name="PERC_GNI", precision=15, scale=2)
    public Double getPercGNI() {
        return this.percGNI;
    }

    public void setPercGNI(Double percGNI) {
        this.percGNI = percGNI;
    }

    @Column(name="DIAMETRO", precision=15, scale=2)
    public Double getDiametro() {
        return this.diametro;
    }

    public void setDiametro(Double diametro) {
        this.diametro = diametro;
    }

    @Column(name="ESPESSURA", precision=15, scale=2)
    public Double getEspessura() {
        return this.espessura;
    }

    public void setEspessura(Double espessura) {
        this.espessura = espessura;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONVERSOR_EXPRESSOS_DINAMICO", foreignKey=@ForeignKey(name="FK_PRODUTO_CONV_EXP_DINAMICO"))
    public ConversorExpressoesDinamico getConversorExpressoesDinamico() {
        return this.conversorExpressoesDinamico;
    }

    public void setConversorExpressoesDinamico(ConversorExpressoesDinamico conversorExpressoesDinamico) {
        this.conversorExpressoesDinamico = conversorExpressoesDinamico;
    }

    @Column(name="PERIODO_VAL_LOTE_FAB")
    public Long getPeriodoValLoteFab() {
        return this.periodoValLoteFab;
    }

    public void setPeriodoValLoteFab(Long periodoValLoteFab) {
        this.periodoValLoteFab = periodoValLoteFab;
    }

    @Column(name="PERC_COFINS_ST", precision=15, scale=4)
    public Double getAliquotaCofinsSt() {
        return this.aliquotaCofinsSt;
    }

    public void setAliquotaCofinsSt(Double aliquotaCofinsSt) {
        this.aliquotaCofinsSt = aliquotaCofinsSt;
    }

    @Column(name="PERC_PIS_ST", precision=15, scale=4)
    public Double getAliquotaPisSt() {
        return this.aliquotaPisSt;
    }

    public void setAliquotaPisSt(Double aliquotaPisSt) {
        this.aliquotaPisSt = aliquotaPisSt;
    }

    @Column(name="MOTIVO_ISENCAO_ANVISA", length=255)
    public String getMotivoIsencaoAnvisa() {
        return this.motivoIsencaoAnvisa;
    }

    public void setMotivoIsencaoAnvisa(String motivoIsencaoAnvisa) {
        this.motivoIsencaoAnvisa = motivoIsencaoAnvisa;
    }

    @Column(name="LARGURA", precision=15, scale=3)
    public Double getLargura() {
        return this.largura;
    }

    public void setLargura(Double largura) {
        this.largura = largura;
    }

    @Column(name="ALTURA", precision=15, scale=3)
    public Double getAltura() {
        return this.altura;
    }

    public void setAltura(Double altura) {
        this.altura = altura;
    }

    @Column(name="COMPRIMENTO", precision=15, scale=3)
    public Double getComprimento() {
        return this.comprimento;
    }

    public void setComprimento(Double comprimento) {
        this.comprimento = comprimento;
    }

    @Column(name="QTD_MAX_VENDA", precision=15, scale=2)
    public Double getQtdMaxVenda() {
        return this.qtdMaxVenda;
    }

    public void setQtdMaxVenda(Double qtdMaxVenda) {
        this.qtdMaxVenda = qtdMaxVenda;
    }

    @Column(name="DCB", length=50)
    public String getDcb() {
        return this.dcb;
    }

    public void setDcb(String dcb) {
        this.dcb = dcb;
    }

    @Column(name="REGISTRO_MINISTERIO_SAUDE", length=13)
    public String getRegistroMinisterioSaude() {
        return this.registroMinisterioSaude;
    }

    public void setRegistroMinisterioSaude(String registroMinisterioSaude) {
        this.registroMinisterioSaude = registroMinisterioSaude;
    }

    @Column(name="CODIGO_FCI", length=36)
    public String getCodigoFCI() {
        return this.codigoFCI;
    }

    public void setCodigoFCI(String codigoFCI) {
        this.codigoFCI = codigoFCI;
    }

    @Column(name="NAO_APLICA_SUFRAMA")
    public Short getNaoAplicaSuframa() {
        return this.naoAplicaSuframa;
    }

    public void setNaoAplicaSuframa(Short naoAplicaSuframa) {
        this.naoAplicaSuframa = naoAplicaSuframa;
    }

    @Column(name="VINC_ATIVIDADE_COOPERADO")
    public Short getVinculadoAtividadeCooperado() {
        return this.vinculadoAtividadeCooperado;
    }

    public void setVinculadoAtividadeCooperado(Short vinculadoAtividadeCooperado) {
        this.vinculadoAtividadeCooperado = vinculadoAtividadeCooperado;
    }

    @Column(name="ALIQUOTA_SENAR", precision=15, scale=4)
    public Double getAliquotaSenar() {
        return this.aliquotaSenar;
    }

    public void setAliquotaSenar(Double aliquotaSenar) {
        this.aliquotaSenar = aliquotaSenar;
    }

    @Column(name="ALIQUOTA_RAT", precision=15, scale=4)
    public Double getAliquotaRat() {
        return this.aliquotaRat;
    }

    public void setAliquotaRat(Double aliquotaRat) {
        this.aliquotaRat = aliquotaRat;
    }

    @Column(name="TAXA_SANID_ANIMAL", precision=15, scale=4)
    public Double getTaxaSanidadeAnimal() {
        return this.taxaSanidadeAnimal;
    }

    public void setTaxaSanidadeAnimal(Double taxaSanidadeAnimal) {
        this.taxaSanidadeAnimal = taxaSanidadeAnimal;
    }

    @Column(name="FATOR_TAXA_SANID_ANIMAL", precision=15, scale=4)
    public Double getFatorTaxaSanidadeAnimal() {
        return this.fatorTaxaSanidadeAnimal;
    }

    public void setFatorTaxaSanidadeAnimal(Double fatorTaxaSanidadeAnimal) {
        this.fatorTaxaSanidadeAnimal = fatorTaxaSanidadeAnimal;
    }

    @Column(name="UTILIZAR_PRODUTO_KIT")
    public Short getUtilizarProdutoKit() {
        return this.utilizarProdutoKit;
    }

    public void setUtilizarProdutoKit(Short utilizarProdutoKit) {
        this.utilizarProdutoKit = utilizarProdutoKit;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProdutoKitExpedicao> getProdutosKit() {
        return this.produtosKit;
    }

    public void setProdutosKit(List<ProdutoKitExpedicao> produtosKit) {
        this.produtosKit = produtosKit;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ULT_MODIFICACAO")
    public Date getDataUltModificacao() {
        return this.dataUltModificacao;
    }

    public void setDataUltModificacao(Date dataUltModificacao) {
        this.dataUltModificacao = dataUltModificacao;
    }

    @Column(name="CODIGO_MAPA", length=20)
    public String getCodigoMapa() {
        return this.codigoMapa;
    }

    public void setCodigoMapa(String codigoMapa) {
        this.codigoMapa = codigoMapa;
    }

    @Column(name="COD_SINCRONIZACAO", length=30)
    public String getCodSincronizacao() {
        return this.codSincronizacao;
    }

    public void setCodSincronizacao(String codSincronizacao) {
        this.codSincronizacao = codSincronizacao;
    }

    @Column(name="COD_PROV_SERVICO_REC")
    public Short getCodProvServicoRec() {
        return this.codProvServicoRec;
    }

    public void setCodProvServicoRec(Short codProvServicoRec) {
        this.codProvServicoRec = codProvServicoRec;
    }

    @Column(name="EMITIR_RECEITA_AGRO")
    public Short getEmitirReceitaAgro() {
        return this.emitirReceitaAgro;
    }

    public void setEmitirReceitaAgro(Short emitirReceitaAgro) {
        this.emitirReceitaAgro = emitirReceitaAgro;
    }

    @Column(name="NUMERO_REGISTRO_INMETRO", length=20)
    public String getNumeroRegistroInmetro() {
        return this.numeroRegistroInmetro;
    }

    public void setNumeroRegistroInmetro(String numeroRegistroInmetro) {
        this.numeroRegistroInmetro = numeroRegistroInmetro;
    }

    @OneToMany(mappedBy="produto", fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL, CascadeType.REMOVE})
    public List<ParamReceitaPisCofinsNatReceita> getNaturezasReceita() {
        return this.naturezasReceita;
    }

    public void setNaturezasReceita(List<ParamReceitaPisCofinsNatReceita> naturezasReceita) {
        this.naturezasReceita = naturezasReceita;
    }

    @Column(name="PERCENTUAL_DIFERIMENTO", precision=15, scale=4)
    public Double getPercentualDiferimento() {
        return this.percentualDiferimento;
    }

    public void setPercentualDiferimento(Double percentualDiferimento) {
        this.percentualDiferimento = percentualDiferimento;
    }

    @Column(name="PERM_VENDA_SOMENTE_AUTOM")
    public Short getPermitirVendaSomenteAutomacao() {
        return this.permitirVendaSomenteAutomacao;
    }

    public void setPermitirVendaSomenteAutomacao(Short permitirVendaSomenteAutomacao) {
        this.permitirVendaSomenteAutomacao = permitirVendaSomenteAutomacao;
    }

    @OneToMany(mappedBy="produto", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<CategoriaProdProduto> getCategoriasProduto() {
        return this.categoriasProduto;
    }

    public void setCategoriasProduto(List<CategoriaProdProduto> categoriasProduto) {
        this.categoriasProduto = categoriasProduto;
    }

    @Column(name="ALIQ_IMP_ESTIMADA_EST", precision=15, scale=2)
    public Double getAliqImpEstimadaEst() {
        return this.aliqImpEstimadaEst;
    }

    public void setAliqImpEstimadaEst(Double aliqImpEstimadaEst) {
        this.aliqImpEstimadaEst = aliqImpEstimadaEst;
    }

    @Column(name="ALIQ_IMP_ESTIMADA_MUN", precision=15, scale=2)
    public Double getAliqImpEstimadaMun() {
        return this.aliqImpEstimadaMun;
    }

    public void setAliqImpEstimadaMun(Double aliqImpEstimadaMun) {
        this.aliqImpEstimadaMun = aliqImpEstimadaMun;
    }

    @Column(name="ALIQ_IMP_ESTIMADA_FED", precision=15, scale=2)
    public Double getAliqImpEstimadaFed() {
        return this.aliqImpEstimadaFed;
    }

    public void setAliqImpEstimadaFed(Double aliqImpEstimadaFed) {
        this.aliqImpEstimadaFed = aliqImpEstimadaFed;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_PRODUTO_INFO_ECOMMERCE", foreignKey=@ForeignKey(name="FK_PRODUTO_INFO_ECOMMERCE"))
    public ProdutoInfoEcommerce getInfoEcommerce() {
        return this.infoEcommerce;
    }

    public void setInfoEcommerce(ProdutoInfoEcommerce infoEcommerce) {
        this.infoEcommerce = infoEcommerce;
    }

    @Column(name="data_inicio_faturamento")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioFaturamento() {
        return this.dataInicioFaturamento;
    }

    public void setDataInicioFaturamento(Date dataInicioFaturamento) {
        this.dataInicioFaturamento = dataInicioFaturamento;
    }

    @Column(name="PERC_IND_MISTURA_BIODIESEL", precision=15, scale=4)
    public Double getPercIndiceMisturaBioDiesel() {
        return this.percIndiceMisturaBioDiesel;
    }

    public void setPercIndiceMisturaBioDiesel(Double percIndiceMisturaBioDiesel) {
        this.percIndiceMisturaBioDiesel = percIndiceMisturaBioDiesel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PARAM_COD_AUX_PROD", foreignKey=@ForeignKey(name=""))
    public ParamCodAuxProduto getParamCodAuxProduto() {
        return this.paramCodAuxProduto;
    }

    public void setParamCodAuxProduto(ParamCodAuxProduto paramCodAuxProduto) {
        this.paramCodAuxProduto = paramCodAuxProduto;
    }

    @Column(name="FATOR_CONVERSAO_PCP")
    public Double getFatorConversaoPCP() {
        return this.fatorConversaoPCP;
    }

    public void setFatorConversaoPCP(Double fatorConversaoPCP) {
        this.fatorConversaoPCP = fatorConversaoPCP;
    }

    @Column(name="PESO_ESPECIFICO")
    public Double getPesoEspecifico() {
        return this.pesoEspecifico;
    }

    public void setPesoEspecifico(Double pesoEspecifico) {
        this.pesoEspecifico = pesoEspecifico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_PROD_STATUS_LOTE_FABRICACAO"))
    public StatusLoteFabricacao getStatusLoteFabricacao() {
        return this.statusLoteFabricacao;
    }

    public void setStatusLoteFabricacao(StatusLoteFabricacao statusLoteFabricacao) {
        this.statusLoteFabricacao = statusLoteFabricacao;
    }

    @OneToMany(mappedBy="produto", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProdutoOpcoesOp> getOutrasOpcoes() {
        return this.outrasOpcoes;
    }

    public void setOutrasOpcoes(List<ProdutoOpcoesOp> outrasOpcoes) {
        this.outrasOpcoes = outrasOpcoes;
    }
}

