/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.PedidosTransportes;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PROGRAMACAO_VIAGENS")
public class ProgramacaoViagens
implements InterfaceVO {
    private Long identificador;
    private PedidosTransportes pedidosTransportes;
    private Date dataViagem;
    private Date previsaoEntrega;
    private ConjuntoTransportador conjuntoTransportador;
    private Double capacidade = 0.0;
    private Double quantidade = 0.0;
    private Double valorFrete = 0.0;
    private Double valorTotal = 0.0;
    private Cte cte;

    @Id
    @Column(nullable=false, name="ID_PROGRAMACAO_VIAGENS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROGRAMACAO_VIAGENS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PEDIDOS_TRANSPORTES", foreignKey=@ForeignKey(name="FK_PROGRAMACAO_VIAGENS_PED_TRAN"))
    public PedidosTransportes getPedidosTransportes() {
        return this.pedidosTransportes;
    }

    public void setPedidosTransportes(PedidosTransportes pedidosTransportes) {
        this.pedidosTransportes = pedidosTransportes;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_VIAGEM")
    public Date getDataViagem() {
        return this.dataViagem;
    }

    public void setDataViagem(Date dataViagem) {
        this.dataViagem = dataViagem;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="PREVISAO_ENTREGA")
    public Date getPrevisaoEntrega() {
        return this.previsaoEntrega;
    }

    public void setPrevisaoEntrega(Date previsaoEntrega) {
        this.previsaoEntrega = previsaoEntrega;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_PROGRAMACAO_VIAGENS_CON_TRAN"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @Column(nullable=false, name="CAPACIDADE", precision=15, scale=4)
    public Double getCapacidade() {
        return this.capacidade;
    }

    public void setCapacidade(Double capacidade) {
        this.capacidade = capacidade;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=3)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=15, scale=4)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @OneToOne(mappedBy="programacaoViagens", fetch=FetchType.LAZY)
    public Cte getCte() {
        return this.cte;
    }

    public void setCte(Cte cte) {
        this.cte = cte;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

