/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocTipoAcordoConvencao;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.RecisaoComplementarPeriodo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="RECISAO_COMPLEMENTAR")
public class RecisaoComplementar
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataAcordo;
    private Date periodoAcordo;
    private Date dataEfeitoAcordo;
    private String detalhamento;
    private EsocTipoAcordoConvencao tipoAcordoConvencao;
    private Recisao recisaoOriginal;
    private Recisao recisaoComplementar;
    private Short calcularVerbasFolhasAnteriores = EnumConstantsMentorSimNao.NAO.getValue();
    private Date periodoInicial;
    private Date periodoFinal;
    private Double percentualAumento = 0.0;
    private Date dataPagamento;
    private List<RecisaoComplementarPeriodo> recisaoPeriodo = new ArrayList<RecisaoComplementarPeriodo>();
    private Short alterarImpostosManualmente = EnumConstantsMentorSimNao.NAO.getValue();

    @Id
    @Column(nullable=false, unique=true, name="ID_RECISAO_COMPLEMENTAR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RECISAO_COMPLEMENTAR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_RECISAO_COMPLEMENTAR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ACORDO")
    public Date getDataAcordo() {
        return this.dataAcordo;
    }

    public void setDataAcordo(Date dataAcordo) {
        this.dataAcordo = dataAcordo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_ACORDO")
    public Date getPeriodoAcordo() {
        return this.periodoAcordo;
    }

    public void setPeriodoAcordo(Date periodoAcordo) {
        this.periodoAcordo = periodoAcordo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EFEITO_ACORDO")
    public Date getDataEfeitoAcordo() {
        return this.dataEfeitoAcordo;
    }

    public void setDataEfeitoAcordo(Date dataEfeitoAcordo) {
        this.dataEfeitoAcordo = dataEfeitoAcordo;
    }

    @Column(name="DETALHAMENTO", length=255)
    public String getDetalhamento() {
        return this.detalhamento;
    }

    public void setDetalhamento(String detalhamento) {
        this.detalhamento = detalhamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ACORDO_CONVENCAO", foreignKey=@ForeignKey(name="FK_TIPO_ACORDO_COMPLEMENTAR"))
    public EsocTipoAcordoConvencao getTipoAcordoConvencao() {
        return this.tipoAcordoConvencao;
    }

    public void setTipoAcordoConvencao(EsocTipoAcordoConvencao tipoAcordoConvencao) {
        this.tipoAcordoConvencao = tipoAcordoConvencao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RECISAO_ORIGINAL", foreignKey=@ForeignKey(name="FK_RECISAO_ORIGINAL_COMPLEMENTA"))
    public Recisao getRecisaoOriginal() {
        return this.recisaoOriginal;
    }

    public void setRecisaoOriginal(Recisao recisaoOriginal) {
        this.recisaoOriginal = recisaoOriginal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COMPLEMENTAR_RECISAO", foreignKey=@ForeignKey(name="FK_RECISAO_COMPLEMENTAR"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public Recisao getRecisaoComplementar() {
        return this.recisaoComplementar;
    }

    public void setRecisaoComplementar(Recisao recisaoComplementar) {
        this.recisaoComplementar = recisaoComplementar;
    }

    @Column(name="CALCULAR_VERBAS_FOLHA_ANT")
    public Short getCalcularVerbasFolhasAnteriores() {
        return this.calcularVerbasFolhasAnteriores;
    }

    public void setCalcularVerbasFolhasAnteriores(Short calcularVerbasFolhasAnteriores) {
        this.calcularVerbasFolhasAnteriores = calcularVerbasFolhasAnteriores;
    }

    @Column(name="PERIODO_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(Date periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Column(name="PERIODO_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @Column(name="PERCENTUAL_AUMENTO", precision=15, scale=2)
    public Double getPercentualAumento() {
        return this.percentualAumento;
    }

    public void setPercentualAumento(Double percentualAumento) {
        this.percentualAumento = percentualAumento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PAGAMENTO")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="recisaoComplementar", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RecisaoComplementarPeriodo> getRecisaoPeriodo() {
        return this.recisaoPeriodo;
    }

    public void setRecisaoPeriodo(List<RecisaoComplementarPeriodo> recisaoPeriodo) {
        this.recisaoPeriodo = recisaoPeriodo;
    }

    @Column(name="ALTERAR_IMPOSTOS_MANUALMENTE")
    public Short getAlterarImpostosManualmente() {
        return this.alterarImpostosManualmente;
    }

    public void setAlterarImpostosManualmente(Short alterarImpostosManualmente) {
        this.alterarImpostosManualmente = alterarImpostosManualmente;
    }
}

