/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfIdentificacaoAmbiente;
import com.touchcomp.basementor.model.vo.TipoEventoReinf;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="REINF_LOTE_EVENTOS")
public class ReinfLoteEventos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private String numeroProtEnvio;
    private String descricaoEnvio;
    private Long codStatusEnvio = 0L;
    private Usuario usuario;
    private List<ReinfEvento> eventos = new ArrayList<ReinfEvento>();
    private ReinfIdentificacaoAmbiente identificacaoAmbiente;
    private TipoEventoReinf tipoEvento;
    private Short excluirBaseTeste = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_LOTE_EVENTOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_LOTE_EVENTOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REINF_LOTE_EVENTOS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="NUMERO_PROT_ENVIO", length=200)
    public String getNumeroProtEnvio() {
        return this.numeroProtEnvio;
    }

    public void setNumeroProtEnvio(String numeroProtEnvio) {
        this.numeroProtEnvio = numeroProtEnvio;
    }

    @Column(name="DESCRICAO_ENVIO", length=30000)
    public String getDescricaoEnvio() {
        return this.descricaoEnvio;
    }

    public void setDescricaoEnvio(String descricaoEnvio) {
        this.descricaoEnvio = descricaoEnvio;
    }

    @Column(name="COD_STATUS_ENVIO")
    public Long getCodStatusEnvio() {
        return this.codStatusEnvio;
    }

    public void setCodStatusEnvio(Long codStatusEnvio) {
        this.codStatusEnvio = codStatusEnvio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_REINF_LOTE_EVENTOS_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="reinfLoteEventos")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE})
    public List<ReinfEvento> getEventos() {
        return this.eventos;
    }

    public void setEventos(List<ReinfEvento> eventos) {
        this.eventos = eventos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_IDENTIFICACAO_AMBIENTE", foreignKey=@ForeignKey(name="FK_REINF_LOTE_EVENTOS_ID_AMB"))
    public ReinfIdentificacaoAmbiente getIdentificacaoAmbiente() {
        return this.identificacaoAmbiente;
    }

    public void setIdentificacaoAmbiente(ReinfIdentificacaoAmbiente identificacaoAmbiente) {
        this.identificacaoAmbiente = identificacaoAmbiente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_EVENTO_REINF", foreignKey=@ForeignKey(name="FK_REINF_LOTE_EVENTOS_TIPO_EV"))
    public TipoEventoReinf getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(TipoEventoReinf tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @Column(name="EXCLUIR_BASE_TESTE")
    public Short getExcluirBaseTeste() {
        return this.excluirBaseTeste;
    }

    public void setExcluirBaseTeste(Short excluirBaseTeste) {
        this.excluirBaseTeste = excluirBaseTeste;
    }
}

