/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocClienteProducaoRural;
import com.touchcomp.basementor.model.vo.EsocFornecedorProducaoRural;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinf4010;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.ItemReinf4040;
import com.touchcomp.basementor.model.vo.ItemReinf4099;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.R1070;
import com.touchcomp.basementor.model.vo.ReinfComercializacaoProducaoRural;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfIdentificacaoAmbiente;
import com.touchcomp.basementor.model.vo.ReinfR2060;
import com.touchcomp.basementor.model.vo.ReinfR2099;
import com.touchcomp.basementor.model.vo.TipoEventoReinf;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="REINF_PRE_EVENTO")
public class ReinfPreEvento
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro = new Date();
    private Timestamp dataAtualizacao;
    private Usuario usuario;
    private Short desativarEnvio = 0;
    private String motivoDesativarEnvio;
    private Usuario usuarioDesativarEnvio;
    private Short formaGeracao;
    private Short tipoEvento;
    private ReinfEvento reinfEvento;
    private ReinfIdentificacaoAmbiente tipoAmbiente;
    private Empresa empresa;
    private Date dataInicioValidade;
    private Date dataFimVal;
    private ReinfPreEvento eventoAnterior;
    private ReinfPreEvento eventoPosterior;
    private TipoEventoReinf tipoEventoReinf;
    private Short eventoRetificacao;
    private R1000 r1000;
    private R1070 r1070;
    private ItemReinf2010 itemReinf2010;
    private ItemReinf2020 itemReinf2020;
    private ReinfR2060 r2060;
    private ReinfR2099 r2099;
    private ReinfComercializacaoProducaoRural reinfComercializacaoRural;
    private EsocClienteProducaoRural aquisicaoCliente;
    private EsocFornecedorProducaoRural aquisicaoFornecedor;
    private ItemReinf4010 itemReinf4010;
    private ItemReinf4020 itemReinf4020;
    private ItemReinf4040 itemReinf4040;
    private ItemReinf4020NaoIdentificado itemReinfNaoId;
    private ItemReinf4099 itemReinf4099;

    public ReinfPreEvento() {
        this.formaGeracao = EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value;
        this.tipoEvento = 0;
        this.eventoRetificacao = 0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_PRE_EVENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_PRE_EVENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        String textoAdicional = " ";
        if (this.getReinfEvento() != null && this.getReinfEvento().getNrRecibo() != null) {
            textoAdicional = this.getReinfEvento().getNrRecibo();
        }
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), textoAdicional});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="DESATIVAR_ENVIO")
    public Short getDesativarEnvio() {
        return this.desativarEnvio;
    }

    public void setDesativarEnvio(Short desativarEnvio) {
        this.desativarEnvio = desativarEnvio;
    }

    @Column(name="MOTIVO_DESATIVAR_ENVIO", length=500)
    public String getMotivoDesativarEnvio() {
        return this.motivoDesativarEnvio;
    }

    public void setMotivoDesativarEnvio(String motivoDesativarEnvio) {
        this.motivoDesativarEnvio = motivoDesativarEnvio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_DES_ENVIO", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_USU_DES_ENV"))
    public Usuario getUsuarioDesativarEnvio() {
        return this.usuarioDesativarEnvio;
    }

    public void setUsuarioDesativarEnvio(Usuario usuarioDesativarEnvio) {
        this.usuarioDesativarEnvio = usuarioDesativarEnvio;
    }

    @Column(name="FORMA_GERACAO")
    public Short getFormaGeracao() {
        return this.formaGeracao;
    }

    public void setFormaGeracao(Short formaGeracao) {
        this.formaGeracao = formaGeracao;
    }

    @OneToOne
    @JoinColumn(name="ID_EVENTO", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_EVENTO"))
    public ReinfEvento getReinfEvento() {
        return this.reinfEvento;
    }

    public void setReinfEvento(ReinfEvento reinfEvento) {
        this.reinfEvento = reinfEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="TIPO_EVENTO")
    public Short getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(Short tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_AMBIENTE", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_TP_AMB"))
    public ReinfIdentificacaoAmbiente getTipoAmbiente() {
        return this.tipoAmbiente;
    }

    public void setTipoAmbiente(ReinfIdentificacaoAmbiente tipoAmbiente) {
        this.tipoAmbiente = tipoAmbiente;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIO_VAL")
    public Date getDataInicioValidade() {
        return this.dataInicioValidade;
    }

    public void setDataInicioValidade(Date dataInicioValidade) {
        this.dataInicioValidade = dataInicioValidade;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FIM_VAL")
    public Date getDataFimVal() {
        return this.dataFimVal;
    }

    public void setDataFimVal(Date dataFimVal) {
        this.dataFimVal = dataFimVal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_ANTERIOR", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_REI_EVT_ANT"))
    public ReinfPreEvento getEventoAnterior() {
        return this.eventoAnterior;
    }

    public void setEventoAnterior(ReinfPreEvento eventoAnterior) {
        this.eventoAnterior = eventoAnterior;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_POSTERIOR", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_REI_EVT_POS"))
    public ReinfPreEvento getEventoPosterior() {
        return this.eventoPosterior;
    }

    public void setEventoPosterior(ReinfPreEvento eventoPosterior) {
        this.eventoPosterior = eventoPosterior;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_R_MIL", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_R_MIL"))
    public R1000 getR1000() {
        return this.r1000;
    }

    public void setR1000(R1000 r1000) {
        this.r1000 = r1000;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_EVENTO_REINF", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_TIPO_EVENTO"))
    public TipoEventoReinf getTipoEventoReinf() {
        return this.tipoEventoReinf;
    }

    public void setTipoEventoReinf(TipoEventoReinf tipoEventoReinf) {
        this.tipoEventoReinf = tipoEventoReinf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_R_MIL_E_SETENTA", foreignKey=@ForeignKey(name="FK_REINF_PRE_EV_R_MIL_SETENTA"))
    public R1070 getR1070() {
        return this.r1070;
    }

    public void setR1070(R1070 r1070) {
        this.r1070 = r1070;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_REINF_2010", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_ITEM_R_2010"))
    public ItemReinf2010 getItemReinf2010() {
        return this.itemReinf2010;
    }

    public void setItemReinf2010(ItemReinf2010 itemReinf2010) {
        this.itemReinf2010 = itemReinf2010;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_REINF_2020", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_IT_R_2020"))
    public ItemReinf2020 getItemReinf2020() {
        return this.itemReinf2020;
    }

    public void setItemReinf2020(ItemReinf2020 itemReinf2020) {
        this.itemReinf2020 = itemReinf2020;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_R_2060", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_R_2060"))
    public ReinfR2060 getR2060() {
        return this.r2060;
    }

    public void setR2060(ReinfR2060 r2060) {
        this.r2060 = r2060;
    }

    @Column(name="EVENTO_RETIFICACAO")
    public Short getEventoRetificacao() {
        return this.eventoRetificacao;
    }

    public void setEventoRetificacao(Short eventoRetificacao) {
        this.eventoRetificacao = eventoRetificacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_R_2099", foreignKey=@ForeignKey(name="FK_REINF_PRE_EVENTO_R_2099"))
    public ReinfR2099 getR2099() {
        return this.r2099;
    }

    public void setR2099(ReinfR2099 r2099) {
        this.r2099 = r2099;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_COM_RURAL", foreignKey=@ForeignKey(name="FK_REINF_COM_RURAL_EVENTO"))
    public ReinfComercializacaoProducaoRural getReinfComercializacaoRural() {
        return this.reinfComercializacaoRural;
    }

    public void setReinfComercializacaoRural(ReinfComercializacaoProducaoRural reinfComercializacaoRural) {
        this.reinfComercializacaoRural = reinfComercializacaoRural;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_aquisicao_cliente")
    public EsocClienteProducaoRural getAquisicaoCliente() {
        return this.aquisicaoCliente;
    }

    public void setAquisicaoCliente(EsocClienteProducaoRural aquisicaoCliente) {
        this.aquisicaoCliente = aquisicaoCliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_aquisicao_fornecedor")
    public EsocFornecedorProducaoRural getAquisicaoFornecedor() {
        return this.aquisicaoFornecedor;
    }

    public void setAquisicaoFornecedor(EsocFornecedorProducaoRural aquisicaoFornecedor) {
        this.aquisicaoFornecedor = aquisicaoFornecedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reinf_4010")
    public ItemReinf4010 getItemReinf4010() {
        return this.itemReinf4010;
    }

    public void setItemReinf4010(ItemReinf4010 itemReinf4010) {
        this.itemReinf4010 = itemReinf4010;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reinf_4020")
    public ItemReinf4020 getItemReinf4020() {
        return this.itemReinf4020;
    }

    public void setItemReinf4020(ItemReinf4020 itemReinf4020) {
        this.itemReinf4020 = itemReinf4020;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reinf_4040")
    public ItemReinf4040 getItemReinf4040() {
        return this.itemReinf4040;
    }

    public void setItemReinf4040(ItemReinf4040 itemReinf4040) {
        this.itemReinf4040 = itemReinf4040;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_item_reinf_nao_id")
    public ItemReinf4020NaoIdentificado getItemReinfNaoId() {
        return this.itemReinfNaoId;
    }

    public void setItemReinfNaoId(ItemReinf4020NaoIdentificado itemReinfNaoId) {
        this.itemReinfNaoId = itemReinfNaoId;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_item_reinf_4099")
    public ItemReinf4099 getItemReinf4099() {
        return this.itemReinf4099;
    }

    public void setItemReinf4099(ItemReinf4099 itemReinf4099) {
        this.itemReinf4099 = itemReinf4099;
    }
}

