/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.TipoRemessaCnab;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="REMESSA_CNAB_PAGAMENTO")
public class RemessaCnabPagamento
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Long numeroSequenciaArquivo;
    private Timestamp horaGeracao;
    private InstituicaoValores instituicaoValores;
    private List<ItemRemessaCnabPagamento> itemRemessaPagamento = new ArrayList<ItemRemessaCnabPagamento>();
    private TipoRemessaCnab tipoRemessa;
    private String codificacaoArquivo;

    @Id
    @Column(nullable=false, unique=true, name="ID_REMESSA_CNAB_PAGAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REMESSA_CNAB_PAGAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REMESSA_CNAB_PAG_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="NUMERO_SEQUENCIAL_ARQUIVO")
    @Generated(value=GenerationTime.ALWAYS)
    public Long getNumeroSequenciaArquivo() {
        return this.numeroSequenciaArquivo;
    }

    public void setNumeroSequenciaArquivo(Long numeroSequenciaArquivo) {
        this.numeroSequenciaArquivo = numeroSequenciaArquivo;
    }

    @Column(nullable=false, name="HORA_GERACAO")
    public Timestamp getHoraGeracao() {
        return this.horaGeracao;
    }

    public void setHoraGeracao(Timestamp horaGeracao) {
        this.horaGeracao = horaGeracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_INSTITUICAO_VALORES", foreignKey=@ForeignKey(name="FK_REMESSA_CNAB_PAG_INST_VALOR"))
    public InstituicaoValores getInstituicaoValores() {
        return this.instituicaoValores;
    }

    public void setInstituicaoValores(InstituicaoValores instituicaoValores) {
        this.instituicaoValores = instituicaoValores;
    }

    @OneToMany(mappedBy="remessaPagamento", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemRemessaCnabPagamento> getItemRemessaPagamento() {
        return this.itemRemessaPagamento;
    }

    public void setItemRemessaPagamento(List<ItemRemessaCnabPagamento> itemRemessaPagamento) {
        this.itemRemessaPagamento = itemRemessaPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_REMESSA_CNAB", foreignKey=@ForeignKey(name="FK_REMESSA_CNAB_PAG_TIPO"))
    public TipoRemessaCnab getTipoRemessa() {
        return this.tipoRemessa;
    }

    public void setTipoRemessa(TipoRemessaCnab tipoRemessa) {
        this.tipoRemessa = tipoRemessa;
    }

    @Column(name="CODIFICACAO_ARQUIVO", length=100)
    public String getCodificacaoArquivo() {
        return this.codificacaoArquivo;
    }

    public void setCodificacaoArquivo(String codificacaoArquivo) {
        this.codificacaoArquivo = codificacaoArquivo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

