/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ClassificacaoProdutoRepresentante;
import com.touchcomp.basementor.model.vo.ClassificacaoRepresentantes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoRepresentantesRelRep;
import com.touchcomp.basementor.model.vo.ItemRepresentanteRegiao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.RepresentanteEmpresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="REPRESENTANTE", uniqueConstraints={@UniqueConstraint(name="UNQ1_REPRESENTANTE", columnNames={"ID_PESSOA"})})
public class Representante
implements InterfaceVO {
    private Double comissaoFaturamento;
    private Double comissaoVencimento;
    private Double comissaoPagamento;
    private Date dataCadastro;
    private Empresa empresa;
    private Long identificador;
    private Pessoa pessoa;
    private PlanoContaGerencial planoContaGer;
    private Timestamp dataAtualizacao;
    private ClassificacaoRepresentantes classificacaoRepresentantes;
    private List classificacoes;
    private List<ItemRepresentanteRegiao> itemRepresentanteRegiao;
    private Double percentualComissao;
    private CentroEstoque centroEstoque;
    private List<RepresentanteEmpresa> representanteEmpresa;
    private List<GrupoRepresentantesRelRep> grupoRepresentantesRel;
    private Representante supervisor;
    private String siglaRepresentante;
    private Double percIrrf;
    private Short ativo;

    public Representante() {
        this.comissaoFaturamento = 0.0;
        this.comissaoVencimento = 0.0;
        this.comissaoPagamento = 0.0;
        this.percentualComissao = 0.0;
        this.percIrrf = 0.0;
        this.itemRepresentanteRegiao = new ArrayList<ItemRepresentanteRegiao>();
        this.classificacoes = new ArrayList();
        this.representanteEmpresa = new ArrayList<RepresentanteEmpresa>();
        this.grupoRepresentantesRel = new ArrayList<GrupoRepresentantesRelRep>();
        this.ativo = EnumConstantsMentorSimNao.SIM.value;
    }

    public Representante(Long identificador, Pessoa pessoa) {
        this.identificador = identificador;
        this.pessoa = pessoa;
        this.comissaoFaturamento = 0.0;
        this.comissaoVencimento = 0.0;
        this.comissaoPagamento = 0.0;
        this.percentualComissao = 0.0;
        this.percIrrf = 0.0;
        this.itemRepresentanteRegiao = new ArrayList<ItemRepresentanteRegiao>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_REPRESENTANTE")
    @SequenceGenerator(name="sequence", sequenceName="GEN_REPRESENTANTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(mappedBy="representante", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemRepresentanteRegiao> getItemRepresentanteRegiao() {
        return this.itemRepresentanteRegiao;
    }

    public void setItemRepresentanteRegiao(List<ItemRepresentanteRegiao> ItemRepresentanteRegiao2) {
        this.itemRepresentanteRegiao = ItemRepresentanteRegiao2;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REPRESENTANTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="COMISSAO_FATURAMENTO", precision=12, scale=2)
    public Double getComissaoFaturamento() {
        return this.comissaoFaturamento;
    }

    @Column(name="COMISSAO_VENCIMENTO", precision=12, scale=2)
    public Double getComissaoVencimento() {
        return this.comissaoVencimento;
    }

    @Column(name="COMISSAO_PAGAMENTO", precision=12, scale=2)
    public Double getComissaoPagamento() {
        return this.comissaoPagamento;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setComissaoFaturamento(Double comissaoFaturamento) {
        this.comissaoFaturamento = comissaoFaturamento;
    }

    public void setComissaoVencimento(Double comissaoVencimento) {
        this.comissaoVencimento = comissaoVencimento;
    }

    public void setComissaoPagamento(Double comissaoPagamento) {
        this.comissaoPagamento = comissaoPagamento;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa idEmp) {
        this.empresa = idEmp;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPessoa() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_REPRESENTANTE_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GER", foreignKey=@ForeignKey(name="FK_REPRESENTANTE_PLANO_CONTA_GE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGer() {
        return this.planoContaGer;
    }

    public void setPlanoContaGer(PlanoContaGerencial planoContaGer) {
        this.planoContaGer = planoContaGer;
    }

    @OneToMany(mappedBy="representante", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ClassificacaoProdutoRepresentante> getClassificacoes() {
        return this.classificacoes;
    }

    public void setClassificacoes(List<ClassificacaoProdutoRepresentante> classificacoes) {
        this.classificacoes = classificacoes;
    }

    @JoinColumn(name="ID_CLASSIFICACAO_REPRESENTANTES", foreignKey=@ForeignKey(name="FK_REPRESENTANTE_CLASS_REPRESEN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ClassificacaoRepresentantes getClassificacaoRepresentantes() {
        return this.classificacaoRepresentantes;
    }

    public void setClassificacaoRepresentantes(ClassificacaoRepresentantes classificacaoRepresentantes) {
        this.classificacaoRepresentantes = classificacaoRepresentantes;
    }

    @Column(nullable=false, name="PERC_COMISSAO_CUPOM_FISCAL", precision=18, scale=6)
    public Double getPercentualComissao() {
        return this.percentualComissao;
    }

    public void setPercentualComissao(Double percentualComissao) {
        this.percentualComissao = percentualComissao;
    }

    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_REPRESENTANTE_CENTRO_ESTOQUE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @OneToMany(mappedBy="representante", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RepresentanteEmpresa> getRepresentanteEmpresa() {
        return this.representanteEmpresa;
    }

    public void setRepresentanteEmpresa(List<RepresentanteEmpresa> representanteEmpresa) {
        this.representanteEmpresa = representanteEmpresa;
    }

    @OneToMany(mappedBy="representante")
    public List<GrupoRepresentantesRelRep> getGrupoRepresentantesRel() {
        return this.grupoRepresentantesRel;
    }

    public void setGrupoRepresentantesRel(List<GrupoRepresentantesRelRep> grupoRepresentantesRel) {
        this.grupoRepresentantesRel = grupoRepresentantesRel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SUPERVISOR", foreignKey=@ForeignKey(name="FK_REPRESENTANTE_SUPERVISOR"))
    public Representante getSupervisor() {
        return this.supervisor;
    }

    public void setSupervisor(Representante supervisor) {
        this.supervisor = supervisor;
    }

    @Column(name="SIGLA_REPRESENTANTE", length=3)
    public String getSiglaRepresentante() {
        return this.siglaRepresentante;
    }

    public void setSiglaRepresentante(String siglaRepresentante) {
        this.siglaRepresentante = siglaRepresentante;
    }

    @Column(name="PERC_IRRF", precision=12, scale=2)
    public Double getPercIrrf() {
        return this.percIrrf;
    }

    public void setPercIrrf(Double percIrrf) {
        this.percIrrf = percIrrf;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

