/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.RotaClientePedidoPedido;
import com.touchcomp.basementor.model.vo.RotaClientes;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ROTA_CLIENTE_PEDIDO")
public class RotaClientePedido
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private RotaClientes rotaClientes;
    private Date dataEmissao;
    private List<RotaClientePedidoPedido> rotaClientePedidoPedido = new ArrayList<RotaClientePedidoPedido>();
    private Transportador transportador;

    @Id
    @Column(nullable=false, name="ID_ROTA_CLIENTE_PEDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ROTA_CLIENTE_PEDIDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ROTA_CLIENTE_PEDIDO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTA_CLIENTES", foreignKey=@ForeignKey(name="FK_ROTA_CLIENTE_PEDIDO_ROTA_CLI"))
    public RotaClientes getRotaClientes() {
        return this.rotaClientes;
    }

    public void setRotaClientes(RotaClientes rotaClientes) {
        this.rotaClientes = rotaClientes;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="rotaClientePedido")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<RotaClientePedidoPedido> getRotaClientePedidoPedido() {
        return this.rotaClientePedidoPedido;
    }

    public void setRotaClientePedidoPedido(List<RotaClientePedidoPedido> rotaClientePedidoPedido) {
        this.rotaClientePedidoPedido = rotaClientePedidoPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_ROTA_CLIENTE_PEDIDO_TRANSP"))
    public Transportador getTransportador() {
        return this.transportador;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getDataEmissao() != null) {
            if (this.getRotaClientes() != null) {
                return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.dataEmissao), this.getRotaClientes()});
            }
            return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.dataEmissao)});
        }
        if (this.getRotaClientes() != null) {
            return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getRotaClientes()});
        }
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

