/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.rps.EnumConstRpsExigibilidadeIss;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CadastroNacionalObra;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EnderecoWebServNFSe;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.GrupoApuracaoLocacao;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ItemProdNFCTeInf;
import com.touchcomp.basementor.model.vo.ItemServicoRPSRPS;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.LoteRps;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloRPS;
import com.touchcomp.basementor.model.vo.NaturezaBCCredito;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoRps;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementor.model.vo.PedidoRps;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PreRpsTransporte;
import com.touchcomp.basementor.model.vo.RegimeEspecialTributacaoRPS;
import com.touchcomp.basementor.model.vo.ReinfTipoServico;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaRps;
import com.touchcomp.basementor.model.vo.RepresentanteContratoComissao;
import com.touchcomp.basementor.model.vo.RpsItemCbs;
import com.touchcomp.basementor.model.vo.RpsItemIbs;
import com.touchcomp.basementor.model.vo.RpsPagtoTranspAgregado;
import com.touchcomp.basementor.model.vo.RpsTransporteNFe;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.TipoOperacao;
import com.touchcomp.basementor.model.vo.TipoRps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="RPS")
public class Rps
implements InterfaceVO {
    private Long identificador;
    private Long numero;
    private String serie;
    private Date dataEmissao;
    private Short status;
    private Double valorServico = 0.0;
    private Double valorDeducoes = 0.0;
    private Double aliquotaPis = 0.0;
    private Double valorPis = 0.0;
    private Double valorPisST = 0.0;
    private Double aliquotaCofins = 0.0;
    private Double valorCofins = 0.0;
    private Double valorCofinsST = 0.0;
    private Double aliquotaInss = 0.0;
    private Double valorInss = 0.0;
    private Double aliquotaIr = 0.0;
    private Double valorIr = 0.0;
    private Double aliquotaContSoc = 0.0;
    private Double valorContSoc = 0.0;
    private Double aliquotaOutros = 0.0;
    private Double valorOutros = 0.0;
    private Double valorBaseCalculo = 0.0;
    private Double aliquotaIss = 0.0;
    private Double valorIss = 0.0;
    private Double valorLiquidoNfse = 0.0;
    private Double valorIssRetido = 0.0;
    private Double percDescontoIncondicionado = 0.0;
    private Double valorDescontoIncondicionado = 0.0;
    private Double valorDescontoCondicionado = 0.0;
    private Double valorUnitario = 0.0;
    private Double quantidadeTotalCarga = 0.0;
    private String discriminacao;
    private UnidadeFatTomPrestRPS unidadeTomPrestRPS;
    private LoteRps loteRps;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Short tipoIss;
    private Short entradaSaida;
    private Short movimentaEstoque;
    private Long numeroNFse;
    private List<Titulo> titulos;
    private CondicoesPagamento condicoesPagamento;
    private String parcelas;
    private ModeloRPS modeloRps;
    private LoteContabil loteContabil;
    private Rps rpsSubstituto;
    private TipoRps tipoRps;
    private NaturezaOperacaoRps naturezaOperacaoRps;
    private Pessoa intermediario;
    private Short isObra;
    private String artObra;
    private String codigoObra;
    private RegimeEspecialTributacaoRPS regimeEspTributacao;
    private Short regimeEspecialRecol;
    private EnderecoWebServNFSe enderecoWebServ;
    private TipoOperacao tipoOperacao;
    private FaturaCte faturaCte;
    private List<PreRpsTransporte> preRpsTransporte;
    private RpsPagtoTranspAgregado rpsPagtoTranspAgregado;
    private Pessoa destinatario;
    private ConjuntoTransportador conjuntoTransportador;
    private RpsTransporteNFe rpsTransporteNfe;
    private List<ItemProdNFCTeInf> itemProdNFCteInf = new ArrayList<ItemProdNFCTeInf>();
    private CNAE cnae;
    private String email;
    private String codigoTributacaoServ;
    private IncidenciaPisCofins incidenciaPisCofins;
    private List<RepresentanteContratoComissao> representantes;
    private ServicoRPS servicoRPS;
    private ApuracaoLocacaoContrato apuracaoContratoLocacao;
    private String codigoVerificacao;
    private Cidade cidade;
    private String descricaoTributosRps;
    private Double taxaTributacaoMunicipal = 0.0;
    private Double taxaTributacaoFederal = 0.0;
    private Double valorTributacaoMunicipal = 0.0;
    private Double valorTributacaoFederal = 0.0;
    private GrupoApuracaoLocacao grupoApuracaoLocacao;
    private Short modoArredondamento = 4;
    private String motivoCancelamento;
    private Date competencia;
    private Short tipoPis;
    private Short tipoCofins;
    private NaturezaBCCredito naturezaBCCredito;
    private SituacaoDocumento situacaoDocumento;
    private Date dataExecucaoServico;
    private PlanoConta planoContaCred;
    private PlanoConta planoContaDeb;
    private Short gerarFinanceiro;
    private Date horaEmissao;
    private List<ItemServicoRPSRPS> itensRps;
    private Double bcIss = 0.0;
    private Double bcInss = 0.0;
    private Double bcPis = 0.0;
    private Double bcCofins = 0.0;
    private Double bcCsll = 0.0;
    private Double bcIr = 0.0;
    private Double bcOutros = 0.0;
    private String observacao;
    private ObjectObsDinamica obsDinamica;
    private RelacionamentoPessoaRps relacionamentoPessoa;
    private ReinfTipoServico tipoServico;
    private CadastroNacionalObra cadastroNacionalObra;
    private Short tipoObraConstrucao = 0;
    private String codigoControle;
    private MeioPagamento meioPagamento;
    private CategoriaPessoa categoriaPessoa;
    private ClassificacaoClientes classificacaoPessoas;
    private Short exigibilidadeISS;
    private Short incentivoFiscal;
    private List<PedidoRps> pedidos;
    private RpsItemCbs impostoCBS;
    private RpsItemIbs impostoIBS;
    private Double valorTotalDoc = 0.0;

    public Rps() {
        this.preRpsTransporte = new ArrayList<PreRpsTransporte>();
        this.itensRps = new ArrayList<ItemServicoRPSRPS>();
        this.titulos = new ArrayList<Titulo>();
        this.representantes = new ArrayList<RepresentanteContratoComissao>();
        this.pedidos = new ArrayList<PedidoRps>();
        this.gerarFinanceiro = EnumConstantsMentorSimNao.SIM.getValue();
        this.status = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoIss = EnumConstantsMentorSimNao.NAO.getValue();
        this.entradaSaida = EnumConstantsMentorSimNao.NAO.getValue();
        this.movimentaEstoque = EnumConstantsMentorSimNao.NAO.getValue();
        this.isObra = EnumConstantsMentorSimNao.NAO.getValue();
        this.regimeEspecialRecol = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoPis = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoCofins = EnumConstantsMentorSimNao.NAO.getValue();
        this.exigibilidadeISS = EnumConstRpsExigibilidadeIss.EXIGIVEL.getValue();
        this.incentivoFiscal = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(name="ID_RPS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RPS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="ALIQUOTA_COFINS", precision=7, scale=3)
    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    public void setAliquotaCofins(Double aliquotaCofins) {
        this.aliquotaCofins = aliquotaCofins;
    }

    @Column(name="ALIQUOTA_CONT_SOC", precision=7, scale=3)
    public Double getAliquotaContSoc() {
        return this.aliquotaContSoc;
    }

    public void setAliquotaContSoc(Double aliquotaContSoc) {
        this.aliquotaContSoc = aliquotaContSoc;
    }

    @Column(name="ALIQUOTA_INSS", precision=7, scale=3)
    public Double getAliquotaInss() {
        return this.aliquotaInss;
    }

    public void setAliquotaInss(Double aliquotaInss) {
        this.aliquotaInss = aliquotaInss;
    }

    @Column(name="ALIQUOTA_IR", precision=7, scale=3)
    public Double getAliquotaIr() {
        return this.aliquotaIr;
    }

    public void setAliquotaIr(Double aliquotaIr) {
        this.aliquotaIr = aliquotaIr;
    }

    @Column(name="ALIQUOTA_ISS", precision=15, scale=6)
    public Double getAliquotaIss() {
        return this.aliquotaIss;
    }

    public void setAliquotaIss(Double aliquotaIss) {
        this.aliquotaIss = aliquotaIss;
    }

    @Column(name="ALIQUOTA_OUTROS", precision=7, scale=3)
    public Double getAliquotaOutros() {
        return this.aliquotaOutros;
    }

    public void setAliquotaOutros(Double aliquotaOutros) {
        this.aliquotaOutros = aliquotaOutros;
    }

    @Column(name="ALIQUOTA_PIS", precision=7, scale=3)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = aliquotaPis;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="DISCRIMINACAO", length=2000)
    public String getDiscriminacao() {
        return this.discriminacao;
    }

    public void setDiscriminacao(String discriminacao) {
        this.discriminacao = discriminacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_RPS", foreignKey=@ForeignKey(name="FK_LOTE_RPS"))
    public LoteRps getLoteRps() {
        return this.loteRps;
    }

    public void setLoteRps(LoteRps loteRps) {
        this.loteRps = loteRps;
    }

    @Ignore
    @Column(name="NUMERO")
    @Generated(value=GenerationTime.INSERT)
    public Long getNumero() {
        return this.numero;
    }

    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Column(name="PERC_DESCONTO_INCONDICIONADO", precision=15, scale=6)
    public Double getPercDescontoIncondicionado() {
        return this.percDescontoIncondicionado;
    }

    public void setPercDescontoIncondicionado(Double percDescontoIncondicionado) {
        this.percDescontoIncondicionado = percDescontoIncondicionado;
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(name="STATUS", precision=12, scale=2)
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Column(name="VALOR_BASE_CALCULO", precision=12, scale=2)
    public Double getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public void setValorBaseCalculo(Double valorBaseCalculo) {
        this.valorBaseCalculo = valorBaseCalculo;
    }

    @Column(name="VALOR_COFINS", precision=12, scale=2)
    public Double getValorCofins() {
        return this.valorCofins;
    }

    public void setValorCofins(Double valorCofins) {
        this.valorCofins = valorCofins;
    }

    @Column(name="VALOR_CONT_SOC", precision=12, scale=2)
    public Double getValorContSoc() {
        return this.valorContSoc;
    }

    public void setValorContSoc(Double valorContSoc) {
        this.valorContSoc = valorContSoc;
    }

    @Column(name="VALOR_DEDUCOES", precision=12, scale=2)
    public Double getValorDeducoes() {
        return this.valorDeducoes;
    }

    public void setValorDeducoes(Double valorDeducoes) {
        this.valorDeducoes = valorDeducoes;
    }

    @Column(name="VALOR_DESCONTO_CONDICIONADO", precision=12, scale=2)
    public Double getValorDescontoCondicionado() {
        return this.valorDescontoCondicionado;
    }

    public void setValorDescontoCondicionado(Double valorDescontoCondicionado) {
        this.valorDescontoCondicionado = valorDescontoCondicionado;
    }

    @Column(name="VALOR_DESCONTO_INCONDICIONADO", precision=12, scale=2)
    public Double getValorDescontoIncondicionado() {
        return this.valorDescontoIncondicionado;
    }

    public void setValorDescontoIncondicionado(Double valorDescontoIncondicionado) {
        this.valorDescontoIncondicionado = valorDescontoIncondicionado;
    }

    @Column(name="VALOR_INSS", precision=12, scale=2)
    public Double getValorInss() {
        return this.valorInss;
    }

    public void setValorInss(Double valorInss) {
        this.valorInss = valorInss;
    }

    @Column(name="VALOR_IR", precision=12, scale=2)
    public Double getValorIr() {
        return this.valorIr;
    }

    public void setValorIr(Double valorIr) {
        this.valorIr = valorIr;
    }

    @Column(name="VALOR_ISS", precision=12, scale=2)
    public Double getValorIss() {
        return this.valorIss;
    }

    public void setValorIss(Double valorIss) {
        this.valorIss = valorIss;
    }

    @Column(name="VALOR_ISS_RETIDO", precision=12, scale=2)
    public Double getValorIssRetido() {
        return this.valorIssRetido;
    }

    public void setValorIssRetido(Double valorIssRetido) {
        this.valorIssRetido = valorIssRetido;
    }

    @Ignore
    @Column(name="NUMERO_NFE_SE", precision=18, scale=0)
    public Long getNumeroNFse() {
        return this.numeroNFse;
    }

    public void setNumeroNFse(Long numeroNFse) {
        this.numeroNFse = numeroNFse;
    }

    @Column(name="VALOR_LIQUIDO_NFSE", precision=12, scale=2)
    public Double getValorLiquidoNfse() {
        return this.valorLiquidoNfse;
    }

    public void setValorLiquidoNfse(Double valorLiquidoNfse) {
        this.valorLiquidoNfse = valorLiquidoNfse;
    }

    @Column(name="VALOR_OUTROS", precision=12, scale=2)
    public Double getValorOutros() {
        return this.valorOutros;
    }

    public void setValorOutros(Double valorOutros) {
        this.valorOutros = valorOutros;
    }

    @Column(name="VALOR_PIS", precision=12, scale=2)
    public Double getValorPis() {
        return this.valorPis;
    }

    public void setValorPis(Double valorPis) {
        this.valorPis = valorPis;
    }

    @Column(name="VALOR_SERVICOS", precision=12, scale=2)
    public Double getValorServico() {
        return this.valorServico;
    }

    public void setValorServico(Double valorServico) {
        this.valorServico = valorServico;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_ISS")
    public Short getTipoIss() {
        return this.tipoIss;
    }

    public void setTipoIss(Short tipoIss) {
        this.tipoIss = tipoIss;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_RPS_CONDICOES_PAGAMENTO"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="PARCELAS", length=100)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @OneToMany(mappedBy="rps", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_RPS", foreignKey=@ForeignKey(name="FK_RPS_MODELO_RPS"))
    public ModeloRPS getModeloRps() {
        return this.modeloRps;
    }

    public void setModeloRps(ModeloRPS modeloRps) {
        this.modeloRps = modeloRps;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_RPS_LOTE_CONTABIL"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    @Column(name="ENTRADA_SAIDA")
    public Short getEntradaSaida() {
        return this.entradaSaida;
    }

    public void setEntradaSaida(Short entradaSaida) {
        this.entradaSaida = entradaSaida;
    }

    @Column(name="MOVIMENTA_ESTOQUE")
    public Short getMovimentaEstoque() {
        return this.movimentaEstoque;
    }

    public void setMovimentaEstoque(Short movimentaEstoque) {
        this.movimentaEstoque = movimentaEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RPS_SUBSTITUTO", foreignKey=@ForeignKey(name="FK_RPS_RPS"))
    public Rps getRpsSubstituto() {
        return this.rpsSubstituto;
    }

    public void setRpsSubstituto(Rps rpsSubstituto) {
        this.rpsSubstituto = rpsSubstituto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_RPS", foreignKey=@ForeignKey(name="FK_RPS_TIPO_RPS"))
    public TipoRps getTipoRps() {
        return this.tipoRps;
    }

    public void setTipoRps(TipoRps tipoRps) {
        this.tipoRps = tipoRps;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OP_RPS", foreignKey=@ForeignKey(name="FK_RPS_NATUREZA_OP_RPS"))
    public NaturezaOperacaoRps getNaturezaOperacaoRps() {
        return this.naturezaOperacaoRps;
    }

    public void setNaturezaOperacaoRps(NaturezaOperacaoRps naturezaOperacaoRps) {
        this.naturezaOperacaoRps = naturezaOperacaoRps;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTERMEDIARIO", foreignKey=@ForeignKey(name="FK_RPS_INTERMEDIARIO"))
    public Pessoa getIntermediario() {
        return this.intermediario;
    }

    public void setIntermediario(Pessoa intermediario) {
        this.intermediario = intermediario;
    }

    @Column(name="IS_OBRA")
    public Short getIsObra() {
        return this.isObra;
    }

    public void setIsObra(Short isObra) {
        this.isObra = isObra;
    }

    @Column(name="ART_OBRA", length=15)
    public String getArtObra() {
        return this.artObra;
    }

    public void setArtObra(String artObra) {
        this.artObra = artObra;
    }

    @Column(name="CODIGO_OBRA", length=15)
    public String getCodigoObra() {
        return this.codigoObra;
    }

    public void setCodigoObra(String codigoObra) {
        this.codigoObra = codigoObra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_TOM_PRES_RPS", foreignKey=@ForeignKey(name="FK_RPS_UNIDADE_FAT_TOM_PREST_RP"))
    public UnidadeFatTomPrestRPS getUnidadeTomPrestRPS() {
        return this.unidadeTomPrestRPS;
    }

    public void setUnidadeTomPrestRPS(UnidadeFatTomPrestRPS unidadeTomPrestRPS) {
        this.unidadeTomPrestRPS = unidadeTomPrestRPS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_ESPECIAL_TRIB_RPS", foreignKey=@ForeignKey(name="FK_RPS_REG_ESPECIAL_TRIBUTACAO"))
    public RegimeEspecialTributacaoRPS getRegimeEspTributacao() {
        return this.regimeEspTributacao;
    }

    public void setRegimeEspTributacao(RegimeEspecialTributacaoRPS regimeEspTributacao) {
        this.regimeEspTributacao = regimeEspTributacao;
    }

    @Column(name="REGIME_ESPECIAL_RECOL")
    public Short getRegimeEspecialRecol() {
        return this.regimeEspecialRecol;
    }

    public void setRegimeEspecialRecol(Short regimeEspecialRecol) {
        this.regimeEspecialRecol = regimeEspecialRecol;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ENDERECO_WEB_SERV", foreignKey=@ForeignKey(name="FK_RPS_END_WEBSERVICE_NFSE"))
    public EnderecoWebServNFSe getEnderecoWebServ() {
        return this.enderecoWebServ;
    }

    public void setEnderecoWebServ(EnderecoWebServNFSe enderecoWebServ) {
        this.enderecoWebServ = enderecoWebServ;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OPERACAO", foreignKey=@ForeignKey(name="FK_RPS_TIPO_OPERACAO"))
    public TipoOperacao getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(TipoOperacao tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FATURA_CTE", foreignKey=@ForeignKey(name="FK_RPS_FATURA_CTE"))
    public FaturaCte getFaturaCte() {
        return this.faturaCte;
    }

    public void setFaturaCte(FaturaCte faturaCte) {
        this.faturaCte = faturaCte;
    }

    @OneToMany(mappedBy="rps", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<PreRpsTransporte> getPreRpsTransporte() {
        return this.preRpsTransporte;
    }

    public void setPreRpsTransporte(List<PreRpsTransporte> preRpsTransporte) {
        this.preRpsTransporte = preRpsTransporte;
    }

    @OneToOne(mappedBy="rps", fetch=FetchType.LAZY)
    public RpsPagtoTranspAgregado getRpsPagtoTranspAgregado() {
        return this.rpsPagtoTranspAgregado;
    }

    public void setRpsPagtoTranspAgregado(RpsPagtoTranspAgregado rpsPagtoTranspAgregado) {
        this.rpsPagtoTranspAgregado = rpsPagtoTranspAgregado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DESTINATARIO", foreignKey=@ForeignKey(name="FK_RPS_PESSOA"))
    public Pessoa getDestinatario() {
        return this.destinatario;
    }

    public void setDestinatario(Pessoa destinatario) {
        this.destinatario = destinatario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_RPS_CONJUNTO_TRANSPORTADOR"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @OneToOne(mappedBy="rps", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public RpsTransporteNFe getRpsTransporteNfe() {
        return this.rpsTransporteNfe;
    }

    public void setRpsTransporteNfe(RpsTransporteNFe rpsTransporteNfe) {
        this.rpsTransporteNfe = rpsTransporteNfe;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="rps_transp_nfe_item_pr_inf", joinColumns={@JoinColumn(name="id_rps_transp")}, inverseJoinColumns={@JoinColumn(name="id_item_prod_nf_cte_inf")})
    public List<ItemProdNFCTeInf> getItemProdNFCteInf() {
        return this.itemProdNFCteInf;
    }

    public void setItemProdNFCteInf(List<ItemProdNFCTeInf> itemProdNFCteInf) {
        this.itemProdNFCteInf = itemProdNFCteInf;
    }

    @Column(name="QUANTIDADE_TOTAL_CARGA", precision=15, scale=2)
    public Double getQuantidadeTotalCarga() {
        return this.quantidadeTotalCarga;
    }

    public void setQuantidadeTotalCarga(Double quantidadeTotalCarga) {
        this.quantidadeTotalCarga = quantidadeTotalCarga;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CNAE", foreignKey=@ForeignKey(name="FK_RPS_CNAE"))
    public CNAE getCnae() {
        return this.cnae;
    }

    public void setCnae(CNAE cnae) {
        this.cnae = cnae;
    }

    @Column(name="EMAIL", length=250)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String emailPessoa) {
        this.email = emailPessoa;
    }

    @Column(name="CODIGO_TRIBUTACAO_SERV", length=20)
    public String getCodigoTributacaoServ() {
        return this.codigoTributacaoServ;
    }

    public void setCodigoTributacaoServ(String codigoTributacaoServ) {
        this.codigoTributacaoServ = codigoTributacaoServ;
    }

    @JoinColumn(name="ID_INCIDENCIA_PIS_COFINS", foreignKey=@ForeignKey(name="FK_RPS_INCIDENCIA_PIS_COFINS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IncidenciaPisCofins getIncidenciaPisCofins() {
        return this.incidenciaPisCofins;
    }

    public void setIncidenciaPisCofins(IncidenciaPisCofins incidenciaPisCofins) {
        this.incidenciaPisCofins = incidenciaPisCofins;
    }

    @OneToMany(mappedBy="RPS", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.MERGE})
    public List<RepresentanteContratoComissao> getRepresentantes() {
        return this.representantes;
    }

    public void setRepresentantes(List<RepresentanteContratoComissao> representantes) {
        this.representantes = representantes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVICO_RPS", foreignKey=@ForeignKey(name="FK_RPS_SERV_RPS"))
    public ServicoRPS getServicoRPS() {
        return this.servicoRPS;
    }

    public void setServicoRPS(ServicoRPS servicoRPS) {
        this.servicoRPS = servicoRPS;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_CONT_LOCACAO", foreignKey=@ForeignKey(name="FK_RPS_APUR_LOC_CONTRATO"))
    public ApuracaoLocacaoContrato getApuracaoContratoLocacao() {
        return this.apuracaoContratoLocacao;
    }

    public void setApuracaoContratoLocacao(ApuracaoLocacaoContrato apuracaoContratoLocacao) {
        this.apuracaoContratoLocacao = apuracaoContratoLocacao;
    }

    @Column(name="CODIGO_VERIFICACAO")
    public String getCodigoVerificacao() {
        return this.codigoVerificacao;
    }

    public void setCodigoVerificacao(String codigoVerificacao) {
        this.codigoVerificacao = codigoVerificacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE", foreignKey=@ForeignKey(name="FK_RPS_CIDADE"))
    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Column(name="DESCRICAO_TRIBUTOS_RPS", length=200)
    public String getDescricaoTributosRps() {
        return this.descricaoTributosRps;
    }

    public void setDescricaoTributosRps(String descricaoTributosRps) {
        this.descricaoTributosRps = descricaoTributosRps;
    }

    @Column(name="TAXA_TRIBUTACAO_MUNICIPAL", precision=15, scale=4)
    public Double getTaxaTributacaoMunicipal() {
        return this.taxaTributacaoMunicipal;
    }

    public void setTaxaTributacaoMunicipal(Double taxaTributacaoMunicipal) {
        this.taxaTributacaoMunicipal = taxaTributacaoMunicipal;
    }

    @Column(name="TAXA_TRIBUTACAO_FEDERAL", precision=15, scale=4)
    public Double getTaxaTributacaoFederal() {
        return this.taxaTributacaoFederal;
    }

    public void setTaxaTributacaoFederal(Double taxaTributacaoFederal) {
        this.taxaTributacaoFederal = taxaTributacaoFederal;
    }

    @Column(name="VALOR_TRIBUTACAO_MUNICIPAL", precision=15, scale=4)
    public Double getValorTributacaoMunicipal() {
        return this.valorTributacaoMunicipal;
    }

    public void setValorTributacaoMunicipal(Double valorTributacaoMunicipal) {
        this.valorTributacaoMunicipal = valorTributacaoMunicipal;
    }

    @Column(name="VALOR_TRIBUTACAO_FEDERAL", precision=15, scale=4)
    public Double getValorTributacaoFederal() {
        return this.valorTributacaoFederal;
    }

    public void setValorTributacaoFederal(Double valorTributacaoFederal) {
        this.valorTributacaoFederal = valorTributacaoFederal;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_APURACAO", foreignKey=@ForeignKey(name="FK_RPS_GR_APURACAO_LOCACAO"))
    public GrupoApuracaoLocacao getGrupoApuracaoLocacao() {
        return this.grupoApuracaoLocacao;
    }

    public void setGrupoApuracaoLocacao(GrupoApuracaoLocacao grupoApuracaoLocacao) {
        this.grupoApuracaoLocacao = grupoApuracaoLocacao;
    }

    @Column(name="MODO_ARREDONDAMENTO")
    public Short getModoArredondamento() {
        return this.modoArredondamento;
    }

    public void setModoArredondamento(Short modoArredondamento) {
        this.modoArredondamento = modoArredondamento;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=500)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_COMPETENCIA")
    public Date getCompetencia() {
        return this.competencia;
    }

    public void setCompetencia(Date competencia) {
        this.competencia = competencia;
    }

    @Column(name="TIPO_PIS")
    public Short getTipoPis() {
        return this.tipoPis;
    }

    public void setTipoPis(Short tipoPis) {
        this.tipoPis = tipoPis;
    }

    @Column(name="TIPO_COFINS")
    public Short getTipoCofins() {
        return this.tipoCofins;
    }

    public void setTipoCofins(Short tipoCofins) {
        this.tipoCofins = tipoCofins;
    }

    @Column(nullable=false, name="VALOR_PIS_ST", precision=15, scale=2)
    public Double getValorPisST() {
        return this.valorPisST;
    }

    public void setValorPisST(Double valorPisST) {
        this.valorPisST = valorPisST;
    }

    @Column(nullable=false, name="VALOR_COFINS_ST", precision=15, scale=2)
    public Double getValorCofinsST() {
        return this.valorCofinsST;
    }

    public void setValorCofinsST(Double valorCofinsST) {
        this.valorCofinsST = valorCofinsST;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_BC_CREDITO", foreignKey=@ForeignKey(name="FK_RPS_NAT_BC_CRED"))
    public NaturezaBCCredito getNaturezaBCCredito() {
        return this.naturezaBCCredito;
    }

    public void setNaturezaBCCredito(NaturezaBCCredito naturezaBCCredito) {
        this.naturezaBCCredito = naturezaBCCredito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_DOCUMENTO", foreignKey=@ForeignKey(name="FK_RPS_SIT_DOC"))
    public SituacaoDocumento getSituacaoDocumento() {
        return this.situacaoDocumento;
    }

    public void setSituacaoDocumento(SituacaoDocumento situacaoDocumento) {
        this.situacaoDocumento = situacaoDocumento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EXECUCAO_SERVICO")
    public Date getDataExecucaoServico() {
        return this.dataExecucaoServico;
    }

    public void setDataExecucaoServico(Date dataExecucaoServico) {
        this.dataExecucaoServico = dataExecucaoServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CRED", foreignKey=@ForeignKey(name="FK_RPS_PC_CRED"))
    public PlanoConta getPlanoContaCred() {
        return this.planoContaCred;
    }

    public void setPlanoContaCred(PlanoConta planoContaCred) {
        this.planoContaCred = planoContaCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEB", foreignKey=@ForeignKey(name="FK_RPS_PC_DEB"))
    public PlanoConta getPlanoContaDeb() {
        return this.planoContaDeb;
    }

    public void setPlanoContaDeb(PlanoConta planoContaDeb) {
        this.planoContaDeb = planoContaDeb;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="HORA_EMISSAO")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraEmissao() {
        return this.horaEmissao;
    }

    public void setHoraEmissao(Date horaEmissao) {
        this.horaEmissao = horaEmissao;
    }

    @OneToMany(mappedBy="rps")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemServicoRPSRPS> getItensRps() {
        return this.itensRps;
    }

    public void setItensRps(List<ItemServicoRPSRPS> itensRps) {
        this.itensRps = itensRps;
    }

    @Column(name="BC_ISS", precision=15, scale=2)
    public Double getBcIss() {
        return this.bcIss;
    }

    public void setBcIss(Double bcIss) {
        this.bcIss = bcIss;
    }

    @Column(name="BC_INSS", precision=15, scale=2)
    public Double getBcInss() {
        return this.bcInss;
    }

    public void setBcInss(Double bcInss) {
        this.bcInss = bcInss;
    }

    @Column(name="BC_PIS", precision=15, scale=2)
    public Double getBcPis() {
        return this.bcPis;
    }

    public void setBcPis(Double bcPis) {
        this.bcPis = bcPis;
    }

    @Column(name="BC_COFINS", precision=15, scale=2)
    public Double getBcCofins() {
        return this.bcCofins;
    }

    public void setBcCofins(Double bcCofins) {
        this.bcCofins = bcCofins;
    }

    @Column(name="BC_CSLL", precision=15, scale=2)
    public Double getBcCsll() {
        return this.bcCsll;
    }

    public void setBcCsll(Double bcCsll) {
        this.bcCsll = bcCsll;
    }

    @Column(name="BC_IR", precision=15, scale=2)
    public Double getBcIr() {
        return this.bcIr;
    }

    public void setBcIr(Double bcIr) {
        this.bcIr = bcIr;
    }

    @Column(name="BC_OUTROS", precision=15, scale=2)
    public Double getBcOutros() {
        return this.bcOutros;
    }

    public void setBcOutros(Double bcOutros) {
        this.bcOutros = bcOutros;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBSERVACAO_DINAMICA", foreignKey=@ForeignKey(name="FK_RPS_OBS_DINAMICA"))
    public ObjectObsDinamica getObsDinamica() {
        return this.obsDinamica;
    }

    public void setObsDinamica(ObjectObsDinamica obsDinamica) {
        this.obsDinamica = obsDinamica;
    }

    @OneToOne(mappedBy="rps")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public RelacionamentoPessoaRps getRelacionamentoPessoa() {
        return this.relacionamentoPessoa;
    }

    public void setRelacionamentoPessoa(RelacionamentoPessoaRps relacionamentoPessoa) {
        this.relacionamentoPessoa = relacionamentoPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SERVICO_REINF", foreignKey=@ForeignKey(name="FK_RPS_SERVICO_REINF"))
    public ReinfTipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(ReinfTipoServico tipoServico) {
        this.tipoServico = tipoServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CADASTRO_NACIONAL_OBRA", foreignKey=@ForeignKey(name="FK_RPS_CNO"))
    public CadastroNacionalObra getCadastroNacionalObra() {
        return this.cadastroNacionalObra;
    }

    public void setCadastroNacionalObra(CadastroNacionalObra cadastroNacionalObra) {
        this.cadastroNacionalObra = cadastroNacionalObra;
    }

    @Column(name="TIPO_OBRA_CONSTRUCAO")
    public Short getTipoObraConstrucao() {
        return this.tipoObraConstrucao;
    }

    public void setTipoObraConstrucao(Short tipoObraConstrucao) {
        this.tipoObraConstrucao = tipoObraConstrucao;
    }

    @Column(name="CODIGO_CONTROLE")
    public String getCodigoControle() {
        return this.codigoControle;
    }

    public void setCodigoControle(String codigoControle) {
        this.codigoControle = codigoControle;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_RPS_MEIO_PAGAMENTO"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_RPS_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA", foreignKey=@ForeignKey(name="FK_RPS_CLA_PESSOA"))
    public ClassificacaoClientes getClassificacaoPessoas() {
        return this.classificacaoPessoas;
    }

    public void setClassificacaoPessoas(ClassificacaoClientes classificacaoPessoas) {
        this.classificacaoPessoas = classificacaoPessoas;
    }

    @Column(name="EXIGIBILIDADE_ISS")
    public Short getExigibilidadeISS() {
        return this.exigibilidadeISS;
    }

    public void setExigibilidadeISS(Short exigibilidadeISS) {
        this.exigibilidadeISS = exigibilidadeISS;
    }

    @Column(name="INCENTIVO_FISCAL")
    public Short getIncentivoFiscal() {
        return this.incentivoFiscal;
    }

    public void setIncentivoFiscal(Short incentivoFiscal) {
        this.incentivoFiscal = incentivoFiscal;
    }

    @OneToMany(mappedBy="rps", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PedidoRps> getPedidos() {
        return this.pedidos;
    }

    public void setPedidos(List<PedidoRps> pedidos) {
        this.pedidos = pedidos;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_RPS_ITEM_CBS")
    public RpsItemCbs getImpostoCBS() {
        return this.impostoCBS;
    }

    public void setImpostoCBS(RpsItemCbs impostoCBS) {
        this.impostoCBS = impostoCBS;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_RPS_ITEM_IBS")
    public RpsItemIbs getImpostoIBS() {
        return this.impostoIBS;
    }

    public void setImpostoIBS(RpsItemIbs impostoIbs) {
        this.impostoIBS = impostoIbs;
    }

    @Column(name="VALOR_TOTAL_DOC")
    public Double getValorTotalDoc() {
        return this.valorTotalDoc;
    }

    public void setValorTotalDoc(Double valorTotalNF) {
        this.valorTotalDoc = valorTotalNF;
    }
}

