/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.OcorrenciaCausa;
import com.touchcomp.basementor.model.vo.PreServicoProcedimento;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ServicoManutencao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="SERVICO_PROCEDIMENTOS")
public class ServicoProcedimento
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private ServicoManutencao servico;
    private List<Procedimento> procedimento = new ArrayList<Procedimento>();
    private Short executado = 0;
    private FechamentoOrdemServico fechamentoOrdemServico;
    private PreServicoProcedimento preServicoProcedimento;
    private List<OcorrenciaCausa> ocorrenciaCausa = new ArrayList<OcorrenciaCausa>();
    private DiagnosticoOSAtivoServico diagnosticoOSServico;

    @Id
    @Column(nullable=false, name="ID_SERVICO_PROCEDIMENTOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SERVICO_PROCEDIMENTOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SERVICO_PROC_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVICO", foreignKey=@ForeignKey(name="FK_SERVICO_PROC_SERVICO"))
    public ServicoManutencao getServico() {
        return this.servico;
    }

    public void setServico(ServicoManutencao servico) {
        this.servico = servico;
    }

    @OneToMany(mappedBy="servicoProcedimento", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<Procedimento> getProcedimento() {
        return this.procedimento;
    }

    public void setProcedimento(List<Procedimento> procedimento) {
        this.procedimento = procedimento;
    }

    @Column(name="EXECUTADO")
    public Short getExecutado() {
        return this.executado;
    }

    public void setExecutado(Short executado) {
        this.executado = executado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FECHAMENTO_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_SERVICO_PROC_FECH_OS"))
    public FechamentoOrdemServico getFechamentoOrdemServico() {
        return this.fechamentoOrdemServico;
    }

    public void setFechamentoOrdemServico(FechamentoOrdemServico fechamentoOrdemServico) {
        this.fechamentoOrdemServico = fechamentoOrdemServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_SERVICO_PROCEDIMENTO", foreignKey=@ForeignKey(name="FK_SERVICO_PROC_PRE_SERV_PROC"))
    public PreServicoProcedimento getPreServicoProcedimento() {
        return this.preServicoProcedimento;
    }

    public void setPreServicoProcedimento(PreServicoProcedimento preServicoProcedimento) {
        this.preServicoProcedimento = preServicoProcedimento;
    }

    @OneToMany(mappedBy="servicoProcedimento", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<OcorrenciaCausa> getOcorrenciaCausa() {
        return this.ocorrenciaCausa;
    }

    public void setOcorrenciaCausa(List<OcorrenciaCausa> ocorrenciaCausa) {
        this.ocorrenciaCausa = ocorrenciaCausa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getServico()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DIAGNOSTICO_OS_AT_SERV", foreignKey=@ForeignKey(name="FK_SERVICO_PROCEDIMENTOS_5"))
    public DiagnosticoOSAtivoServico getDiagnosticoOSServico() {
        return this.diagnosticoOSServico;
    }

    public void setDiagnosticoOSServico(DiagnosticoOSAtivoServico diagnosticoOSServico) {
        this.diagnosticoOSServico = diagnosticoOSServico;
    }
}

