/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.controlepatchversao.EnumConstMaturidade;
import com.touchcomp.basementor.constants.enums.firebird.EnumConstFirebird;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.InformacoesTecnicasCliente;
import com.touchcomp.basementor.model.vo.LogAtualizacaoVersaoCli;
import com.touchcomp.basementor.model.vo.ServidorClienteConf;
import com.touchcomp.basementor.model.vo.ServidorClienteContSistCnpj;
import com.touchcomp.basementor.model.vo.ServidorClienteRestAtua;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Ignore
@Entity
@Table(name="SERVIDOR_CLIENTE")
public class ServidorCliente
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String observacao;
    private List<ServidorClienteConf> configuracoes = new LinkedList<ServidorClienteConf>();
    private List<ServidorClienteRestAtua> restricoesAtualizacao = new LinkedList<ServidorClienteRestAtua>();
    private InformacoesTecnicasCliente informacoesTecnicaCliente;
    private String usuarioBD;
    private String senhaBD;
    private String ipServidor;
    private String ipServidorExterno;
    private String nomeServidor;
    private Integer portaBDServidor = 3051;
    private Integer portaServidorInternoHttp = 8081;
    private Integer portaServidorInternoHttps = 8081;
    private Integer portaServidorExternoHttp = 8081;
    private Integer portaServidorExternoHttps = 8081;
    private Short usarIPServidorAcesso = 0;
    private List<ServidorClienteContSistCnpj> clientesCNPJ;
    private List<LogAtualizacaoVersaoCli> logsAtualizacao = new LinkedList<LogAtualizacaoVersaoCli>();
    private Short nivelMaturidade;
    private String macAddress;
    private Short sgbd;
    private String sgbdVersion;

    public ServidorCliente() {
        this.clientesCNPJ = new LinkedList<ServidorClienteContSistCnpj>();
        this.nivelMaturidade = EnumConstMaturidade.VERSAO_MATURIDADE_NIVEL_3.getValue();
        this.sgbd = EnumConstFirebird.SGBD_DESCONHECIDO.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_SERVIDOR_CLIENTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SERVIDOR_CLIENTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{ToolMethods.isStrWithData((String)this.getDescricao()) ? this.getDescricao() : this.getNomeServidor()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DESCRICAO")
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="servidorCliente", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ServidorClienteConf> getConfiguracoes() {
        return this.configuracoes;
    }

    public void setConfiguracoes(List<ServidorClienteConf> configuracoes) {
        this.configuracoes = configuracoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INFORMACOES_TEC_CLIENTES", foreignKey=@ForeignKey(name="FK_SERVIDOR_CLIENTE_INF_TEC"))
    public InformacoesTecnicasCliente getInformacoesTecnicaCliente() {
        return this.informacoesTecnicaCliente;
    }

    public void setInformacoesTecnicaCliente(InformacoesTecnicasCliente informacoesTecnicaCliente) {
        this.informacoesTecnicaCliente = informacoesTecnicaCliente;
    }

    @Column(name="USUARIO_BD", length=200)
    public String getUsuarioBD() {
        return this.usuarioBD;
    }

    public void setUsuarioBD(String usuarioBD) {
        this.usuarioBD = usuarioBD;
    }

    @Column(name="SENHA_BD", length=100)
    public String getSenhaBD() {
        return this.senhaBD;
    }

    public void setSenhaBD(String senhaBD) {
        this.senhaBD = senhaBD;
    }

    @Column(name="IP_SERVIDOR", length=200)
    public String getIpServidor() {
        return this.ipServidor;
    }

    public void setIpServidor(String ipServidor) {
        this.ipServidor = ipServidor;
    }

    @Column(name="PORTA_BD_SERVIDOR", length=20)
    public Integer getPortaBDServidor() {
        return this.portaBDServidor;
    }

    public void setPortaBDServidor(Integer portaBDServidor) {
        this.portaBDServidor = portaBDServidor;
    }

    @Column(name="NOME_SERVIDOR", length=200)
    public String getNomeServidor() {
        return this.nomeServidor;
    }

    public void setNomeServidor(String nomeServidor) {
        this.nomeServidor = nomeServidor;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="servidorCliente", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ServidorClienteContSistCnpj> getClientesCNPJ() {
        return this.clientesCNPJ;
    }

    public void setClientesCNPJ(List<ServidorClienteContSistCnpj> clientesCNPJ) {
        this.clientesCNPJ = clientesCNPJ;
    }

    @Column(name="IP_SERVIDOR_EXTERNO", length=200)
    public String getIpServidorExterno() {
        return this.ipServidorExterno;
    }

    public void setIpServidorExterno(String ipServidorExterno) {
        this.ipServidorExterno = ipServidorExterno;
    }

    @Column(name="PORTA_SERVIDOR_INTERNO_HTTP")
    public Integer getPortaServidorInternoHttp() {
        return this.portaServidorInternoHttp;
    }

    public void setPortaServidorInternoHttp(Integer portaServidorInternoHttp) {
        this.portaServidorInternoHttp = portaServidorInternoHttp;
    }

    @Column(name="PORTA_SERVIDOR_INTERNO_HTTPS")
    public Integer getPortaServidorInternoHttps() {
        return this.portaServidorInternoHttps;
    }

    public void setPortaServidorInternoHttps(Integer portaServidorInternoHttps) {
        this.portaServidorInternoHttps = portaServidorInternoHttps;
    }

    @Column(name="PORTA_SERVIDOR_EXTERNO_HTTP")
    public Integer getPortaServidorExternoHttp() {
        return this.portaServidorExternoHttp;
    }

    public void setPortaServidorExternoHttp(Integer portaServidorExternoHttp) {
        this.portaServidorExternoHttp = portaServidorExternoHttp;
    }

    @Column(name="PORTA_SERVIDOR_EXTERNO_HTTPS")
    public Integer getPortaServidorExternoHttps() {
        return this.portaServidorExternoHttps;
    }

    public void setPortaServidorExternoHttps(Integer portaServidorExternoHttps) {
        this.portaServidorExternoHttps = portaServidorExternoHttps;
    }

    @Column(name="USAR_IP_SERVIDOR_ACESSO")
    public Short getUsarIPServidorAcesso() {
        return this.usarIPServidorAcesso;
    }

    public void setUsarIPServidorAcesso(Short usarIPServidorAcesso) {
        this.usarIPServidorAcesso = usarIPServidorAcesso;
    }

    @Column(name="NIVEL_MATURIDADE")
    public Short getNivelMaturidade() {
        return this.nivelMaturidade;
    }

    public void setNivelMaturidade(Short nivelMaturidade) {
        this.nivelMaturidade = nivelMaturidade;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="servidorCliente", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<LogAtualizacaoVersaoCli> getLogsAtualizacaoCliente() {
        return this.logsAtualizacao;
    }

    public void setLogsAtualizacaoCliente(List<LogAtualizacaoVersaoCli> logsAtualizacao) {
        this.logsAtualizacao = logsAtualizacao;
    }

    @Column(name="mac_address")
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Column(name="SGBD")
    public Short getSgbd() {
        return this.sgbd;
    }

    public void setSgbd(Short sgbd) {
        this.sgbd = sgbd;
    }

    @Column(name="SGBD_VERSION")
    public String getSgbdVersion() {
        return this.sgbdVersion;
    }

    public void setSgbdVersion(String sgbdVersion) {
        this.sgbdVersion = sgbdVersion;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="servidorCliente", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ServidorClienteRestAtua> getRestricoesAtualizacao() {
        return this.restricoesAtualizacao;
    }

    public void setRestricoesAtualizacao(List<ServidorClienteRestAtua> restricoesAtualizacao) {
        this.restricoesAtualizacao = restricoesAtualizacao;
    }
}

