/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemEventoSindicato;
import com.touchcomp.basementor.model.vo.ItemFuncaoSindicato;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="SINDICATO", uniqueConstraints={@UniqueConstraint(name="UNQ1_SINDICATO", columnNames={"ID_PESSOA"})})
public class Sindicato
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Pessoa pessoa;
    private Timestamp dataAtualizacao;
    private Short iniciarFeriasSabado;
    private Short iniciarFeriasDomingo = EnumConstantsMentorSimNao.SIM.getValue();
    private Short iniciarFeriasFeriado = EnumConstantsMentorSimNao.SIM.getValue();
    private Double percHoraExtraFeriadoDSR = 100.0;
    private TipoCalculoEvento tpHrExtraFeriadoDSR;
    private Double percHoraExtraNormal = 100.0;
    private TipoCalculoEvento tpHrExtraNormal;
    private Short naoDescontarContribuicao;
    private Double percAddNoturno = 100.0;
    private TipoCalculoEvento tpAddNoturno;
    private Short mesDataBase;
    private String email;
    private String contato;
    private String codigoSindical;
    private Short sindicatoAcademico;
    private Short possuiBeneficioCesta;
    private Short possuiPagamentoRefeicao;
    private Short permitirAdmissaoFuncaoSind;
    private List<ItemFuncaoSindicato> funcoesSindicato;
    private Short possuiAdiantamentoSalario;
    private Double percentualAdiantamento = 0.0;
    private String cnpjSindicato;
    private List<ItemEventoSindicato> eventos;
    private Short calcularAvisoPrevioTrabalho;

    public Sindicato() {
        this.iniciarFeriasSabado = EnumConstantsMentorSimNao.SIM.getValue();
        this.naoDescontarContribuicao = EnumConstantsMentorSimNao.NAO.getValue();
        this.sindicatoAcademico = EnumConstantsMentorSimNao.SIM.getValue();
        this.possuiBeneficioCesta = EnumConstantsMentorSimNao.NAO.getValue();
        this.possuiPagamentoRefeicao = EnumConstantsMentorSimNao.NAO.getValue();
        this.permitirAdmissaoFuncaoSind = EnumConstantsMentorSimNao.NAO.getValue();
        this.funcoesSindicato = new ArrayList<ItemFuncaoSindicato>();
        this.possuiAdiantamentoSalario = EnumConstantsMentorSimNao.NAO.getValue();
        this.permitirAdmissaoFuncaoSind = EnumConstantsMentorSimNao.SIM.getValue();
        this.funcoesSindicato = new ArrayList<ItemFuncaoSindicato>();
        this.eventos = new ArrayList<ItemEventoSindicato>();
        this.calcularAvisoPrevioTrabalho = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_SINDICATO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SINDICATO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SINDICATO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPessoa() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_SINDICATO_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="INICIAR_FERIAS_SABADO")
    public Short getIniciarFeriasSabado() {
        return this.iniciarFeriasSabado;
    }

    public void setIniciarFeriasSabado(Short iniciarFeriasSabado) {
        this.iniciarFeriasSabado = iniciarFeriasSabado;
    }

    @Column(name="INICIAR_FERIAS_DOMINGO")
    public Short getIniciarFeriasDomingo() {
        return this.iniciarFeriasDomingo;
    }

    public void setIniciarFeriasDomingo(Short iniciarFeriasDomingo) {
        this.iniciarFeriasDomingo = iniciarFeriasDomingo;
    }

    @Column(name="INICIAR_FERIAS_FERIADO")
    public Short getIniciarFeriasFeriado() {
        return this.iniciarFeriasFeriado;
    }

    public void setIniciarFeriasFeriado(Short iniciarFeriasFeriado) {
        this.iniciarFeriasFeriado = iniciarFeriasFeriado;
    }

    @Column(name="HORA_EXTRA_FERIADO_DSR", precision=15, scale=2)
    public Double getPercHoraExtraFeriadoDSR() {
        return this.percHoraExtraFeriadoDSR;
    }

    public void setPercHoraExtraFeriadoDSR(Double percHoraExtraFeriadoDSR) {
        this.percHoraExtraFeriadoDSR = percHoraExtraFeriadoDSR;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_HR_EXTRA_FER_DSR", foreignKey=@ForeignKey(name="FK_SINDICATO_TP_HR_EXTRA_FERIAD"))
    public TipoCalculoEvento getTpHrExtraFeriadoDSR() {
        return this.tpHrExtraFeriadoDSR;
    }

    public void setTpHrExtraFeriadoDSR(TipoCalculoEvento tpHrExtraFeriadoDSR) {
        this.tpHrExtraFeriadoDSR = tpHrExtraFeriadoDSR;
    }

    @Column(name="PERC_HORA_EXTRA_NORMAL", precision=15, scale=2)
    public Double getPercHoraExtraNormal() {
        return this.percHoraExtraNormal;
    }

    public void setPercHoraExtraNormal(Double percHoraExtraNormal) {
        this.percHoraExtraNormal = percHoraExtraNormal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_HR_EXTRA_NORMAL", foreignKey=@ForeignKey(name="FK_SIND_TP_EVT_HR_EXTRA_NORMAL"))
    public TipoCalculoEvento getTpHrExtraNormal() {
        return this.tpHrExtraNormal;
    }

    public void setTpHrExtraNormal(TipoCalculoEvento tpHrExtraNormal) {
        this.tpHrExtraNormal = tpHrExtraNormal;
    }

    @Column(name="NAO_DESCONTAR_CONT_SINDICAL")
    public Short getNaoDescontarContribuicao() {
        return this.naoDescontarContribuicao;
    }

    public void setNaoDescontarContribuicao(Short naoDescontarContribuicao) {
        this.naoDescontarContribuicao = naoDescontarContribuicao;
    }

    @Column(name="PERC_ADD_NOTURNO", precision=15, scale=2)
    public Double getPercAddNoturno() {
        return this.percAddNoturno;
    }

    public void setPercAddNoturno(Double percAddNoturno) {
        this.percAddNoturno = percAddNoturno;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_ADD_NOTURNO", foreignKey=@ForeignKey(name="FK_TP_ADD_NOTURNO"))
    public TipoCalculoEvento getTpAddNoturno() {
        return this.tpAddNoturno;
    }

    public void setTpAddNoturno(TipoCalculoEvento tpAddNoturno) {
        this.tpAddNoturno = tpAddNoturno;
    }

    @Ignore
    @Column(name="MES_DATA_BASE")
    public Short getMesDataBase() {
        return this.mesDataBase;
    }

    public void setMesDataBase(Short mesDataBase) {
        this.mesDataBase = mesDataBase;
    }

    @Column(name="EMAIL", length=50)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="CONTATO", length=60)
    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    @Column(name="CODIGO_SINDICAL", length=14)
    public String getCodigoSindical() {
        return this.codigoSindical;
    }

    public void setCodigoSindical(String codigoSindical) {
        this.codigoSindical = codigoSindical;
    }

    @Column(name="SINDICATO_ACADEMICO")
    public Short getSindicatoAcademico() {
        return this.sindicatoAcademico;
    }

    public void setSindicatoAcademico(Short sindicatoAcademico) {
        this.sindicatoAcademico = sindicatoAcademico;
    }

    @Column(name="POSSUI_BENEFICIO_CESTA")
    public Short getPossuiBeneficioCesta() {
        return this.possuiBeneficioCesta;
    }

    public void setPossuiBeneficioCesta(Short possuiBeneficioCesta) {
        this.possuiBeneficioCesta = possuiBeneficioCesta;
    }

    @Column(name="POSSUI_PAGAMENTO_REFEICAO")
    public Short getPossuiPagamentoRefeicao() {
        return this.possuiPagamentoRefeicao;
    }

    public void setPossuiPagamentoRefeicao(Short possuiPagamentoRefeicao) {
        this.possuiPagamentoRefeicao = possuiPagamentoRefeicao;
    }

    @Column(name="PERMITIR_ADMISSAO_FUNCAO_SIND")
    public Short getPermitirAdmissaoFuncaoSind() {
        return this.permitirAdmissaoFuncaoSind;
    }

    public void setPermitirAdmissaoFuncaoSind(Short permitirAdmissaoFuncaoSind) {
        this.permitirAdmissaoFuncaoSind = permitirAdmissaoFuncaoSind;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="sindicato", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemFuncaoSindicato> getFuncoesSindicato() {
        return this.funcoesSindicato;
    }

    public void setFuncoesSindicato(List<ItemFuncaoSindicato> funcoesSindicato) {
        this.funcoesSindicato = funcoesSindicato;
    }

    @Column(name="POSSUI_ADIANTAMENTO_SALARIO")
    public Short getPossuiAdiantamentoSalario() {
        return this.possuiAdiantamentoSalario;
    }

    public void setPossuiAdiantamentoSalario(Short possuiAdiantamentoSalario) {
        this.possuiAdiantamentoSalario = possuiAdiantamentoSalario;
    }

    @Column(name="PERCENTUAL_ADD_SALARIO", precision=15, scale=2)
    public Double getPercentualAdiantamento() {
        return this.percentualAdiantamento;
    }

    public void setPercentualAdiantamento(Double percentualAdiantamento) {
        this.percentualAdiantamento = percentualAdiantamento;
    }

    @Column(name="CNPJ_SINDICATO", length=124)
    public String getCnpjSindicato() {
        return this.cnpjSindicato;
    }

    public void setCnpjSindicato(String cnpjSindicato) {
        this.cnpjSindicato = cnpjSindicato;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="sindicato", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemEventoSindicato> getEventos() {
        return this.eventos;
    }

    public void setEventos(List<ItemEventoSindicato> eventos) {
        this.eventos = eventos;
    }

    @Column(name="CALCULAR_AVISO_PREVIO_TRABALHO")
    public Short getCalcularAvisoPrevioTrabalho() {
        return this.calcularAvisoPrevioTrabalho;
    }

    public void setCalcularAvisoPrevioTrabalho(Short calcularAvisoPrevioTrabalho) {
        this.calcularAvisoPrevioTrabalho = calcularAvisoPrevioTrabalho;
    }
}

