/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="SITUACAO_COBRANCA", uniqueConstraints={@UniqueConstraint(name="UNQ1_SITUACAO_COBRANCA_NOME", columnNames={"NOME"})})
public class SituacaoCobranca
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private String codigoSituacao;
    private Short tipoCobranca;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short ativo;

    public SituacaoCobranca(Long identificador, String nome, Short tipoCobranca) {
        this.identificador = identificador;
        this.nome = nome;
        this.tipoCobranca = tipoCobranca;
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
    }

    public SituacaoCobranca() {
        this.tipoCobranca = EnumConstSituacaoCobranca.SIMPLES.getEnumId();
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
    }

    @Id
    @Column(name="ID_SITUACAO_COBRACA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SITUACAO_COBRANCA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long idSituacaoFinanceira) {
        this.identificador = idSituacaoFinanceira;
    }

    @Column(nullable=false, unique=true, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SITUACAO_COBRANCA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa emp) {
        this.empresa = emp;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="TIPO_COBRANCA")
    public Short getTipoCobranca() {
        return this.tipoCobranca;
    }

    public void setTipoCobranca(Short tipoCobranca) {
        this.tipoCobranca = tipoCobranca;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="CODIGO_SITUACAO", length=2)
    public String getCodigoSituacao() {
        return this.codigoSituacao;
    }

    public void setCodigoSituacao(String codigoSituacao) {
        this.codigoSituacao = codigoSituacao;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

