/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.datatransfer.IgnorePropEntityTransfer;
import com.touchcomp.basementor.constants.enums.smartcomponente.EnumConstSmartComponente;
import com.touchcomp.basementor.constants.enums.smartcomponente.EnumConstTipoExecSmartComp;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SmartComponentGrUsu;
import com.touchcomp.basementor.model.vo.SmartComponentNodo;
import com.touchcomp.basementor.model.vo.SmartComponentParams;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="SMART_COMPONENT")
public class SmartComponent
implements InterfaceVO {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(nullable=false, name="ID_SMART_COMPONENT")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SMART_COMPONENT")
    @IgnorePropEntityTransfer
    private Long identificador;
    @Column(name="DESCRICAO")
    private String descricao;
    @Column(name="PACOTE_CLASSE")
    private String pacoteClasse;
    @Column(name="CODIGO_VERSAO")
    private Long codigoVersao = 0L;
    @Column(name="CODIGO_SMART_COMPONENT")
    private String codigoSmartComponent;
    @Column(name="OBSERVACAO")
    private String observacao;
    @Column(name="CLASS_BYTECODE")
    private String classBytecode;
    @Column(name="SOURCE_CODE")
    private String sourceCode;
    @Column(name="TIPO_COMPONENTE")
    private String tipoComponente;
    @Column(name="TIPO_EXEC_COMPONENTE")
    private Short tipoExecComponente;
    @Column(name="PERMITE_PRE_VISUALIZAR")
    private Short permitePreVisualizar = 0;
    @OneToMany(mappedBy="smartComponente", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SmartComponentParams> parametros = new LinkedList<SmartComponentParams>();
    @OneToMany(mappedBy="smartComponente", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SmartComponentNodo> nodos = new LinkedList<SmartComponentNodo>();
    @OneToMany(mappedBy="smartComponente", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SmartComponentGrUsu> gruposUsuarios = new LinkedList<SmartComponentGrUsu>();
    @Column(name="NUMERO_CONTROLE")
    private String numeroControle;
    @Column(name="NR_VERSAO_ESTRUTURA")
    private Integer nrVersaoEstrutura = 0;
    @Column(name="NUMERO_VERSAO_REP")
    private Long numeroVersaoRep = 0L;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_SMART_COMPONENT_PESSOA"))
    @IgnorePropEntityTransfer
    private Pessoa pessoaResponsavel;
    @Column(name="SERIAL_LOCAL")
    private String serialLocal;
    @Version
    @Column(name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCadastro = new Date();

    public SmartComponent() {
        this.tipoComponente = EnumConstSmartComponente.SMART_FACTORY_GERACAO_COLETA.getValue();
        this.tipoExecComponente = EnumConstTipoExecSmartComp.EXECUCAO.getValue();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getPacoteClasse() {
        return this.pacoteClasse;
    }

    @Generated
    public Long getCodigoVersao() {
        return this.codigoVersao;
    }

    @Generated
    public String getCodigoSmartComponent() {
        return this.codigoSmartComponent;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getClassBytecode() {
        return this.classBytecode;
    }

    @Generated
    public String getSourceCode() {
        return this.sourceCode;
    }

    @Generated
    public String getTipoComponente() {
        return this.tipoComponente;
    }

    @Generated
    public Short getTipoExecComponente() {
        return this.tipoExecComponente;
    }

    @Generated
    public Short getPermitePreVisualizar() {
        return this.permitePreVisualizar;
    }

    @Generated
    public List<SmartComponentParams> getParametros() {
        return this.parametros;
    }

    @Generated
    public List<SmartComponentNodo> getNodos() {
        return this.nodos;
    }

    @Generated
    public List<SmartComponentGrUsu> getGruposUsuarios() {
        return this.gruposUsuarios;
    }

    @Generated
    public String getNumeroControle() {
        return this.numeroControle;
    }

    @Generated
    public Integer getNrVersaoEstrutura() {
        return this.nrVersaoEstrutura;
    }

    @Generated
    public Long getNumeroVersaoRep() {
        return this.numeroVersaoRep;
    }

    @Generated
    public Pessoa getPessoaResponsavel() {
        return this.pessoaResponsavel;
    }

    @Generated
    public String getSerialLocal() {
        return this.serialLocal;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setPacoteClasse(String pacoteClasse) {
        this.pacoteClasse = pacoteClasse;
    }

    @Generated
    public void setCodigoVersao(Long codigoVersao) {
        this.codigoVersao = codigoVersao;
    }

    @Generated
    public void setCodigoSmartComponent(String codigoSmartComponent) {
        this.codigoSmartComponent = codigoSmartComponent;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setClassBytecode(String classBytecode) {
        this.classBytecode = classBytecode;
    }

    @Generated
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    @Generated
    public void setTipoComponente(String tipoComponente) {
        this.tipoComponente = tipoComponente;
    }

    @Generated
    public void setTipoExecComponente(Short tipoExecComponente) {
        this.tipoExecComponente = tipoExecComponente;
    }

    @Generated
    public void setPermitePreVisualizar(Short permitePreVisualizar) {
        this.permitePreVisualizar = permitePreVisualizar;
    }

    @Generated
    public void setParametros(List<SmartComponentParams> parametros) {
        this.parametros = parametros;
    }

    @Generated
    public void setNodos(List<SmartComponentNodo> nodos) {
        this.nodos = nodos;
    }

    @Generated
    public void setGruposUsuarios(List<SmartComponentGrUsu> gruposUsuarios) {
        this.gruposUsuarios = gruposUsuarios;
    }

    @Generated
    public void setNumeroControle(String numeroControle) {
        this.numeroControle = numeroControle;
    }

    @Generated
    public void setNrVersaoEstrutura(Integer nrVersaoEstrutura) {
        this.nrVersaoEstrutura = nrVersaoEstrutura;
    }

    @Generated
    public void setNumeroVersaoRep(Long numeroVersaoRep) {
        this.numeroVersaoRep = numeroVersaoRep;
    }

    @Generated
    public void setPessoaResponsavel(Pessoa pessoaResponsavel) {
        this.pessoaResponsavel = pessoaResponsavel;
    }

    @Generated
    public void setSerialLocal(String serialLocal) {
        this.serialLocal = serialLocal;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }
}

