/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemTabelaINSS;
import com.touchcomp.basementor.model.vo.ItemTabelaINSSSalarioFamilia;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="TABELA_INSS")
public class TabelaINSS
implements InterfaceVO {
    private Long identificador;
    private Date dataInicial;
    private Date dataFinal;
    private Double vrSalarioMinimo = 0.0;
    private Double vrLimiteMaximoInss = 0.0;
    private List<ItemTabelaINSSSalarioFamilia> itensTabelaINSSSalarioFamilia = new ArrayList<ItemTabelaINSSSalarioFamilia>();
    private List<ItemTabelaINSS> itensTabelaINSS = new ArrayList<ItemTabelaINSS>();
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short calcularVrInssEscalonado = 0;

    @Id
    @Column(name="ID_TABELA_INSS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TABELA_INSS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TABELA_INSS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(nullable=false, name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(nullable=false, name="VR_SALARIO_MINIMO", precision=15, scale=2)
    public Double getVrSalarioMinimo() {
        return this.vrSalarioMinimo;
    }

    public void setVrSalarioMinimo(Double vrSalarioMinimo) {
        this.vrSalarioMinimo = vrSalarioMinimo;
    }

    @Column(nullable=false, name="VR_LIMITE_MAXIMO_INSS", precision=15, scale=2)
    public Double getVrLimiteMaximoInss() {
        return this.vrLimiteMaximoInss;
    }

    public void setVrLimiteMaximoInss(Double vrLimiteMaximoInss) {
        this.vrLimiteMaximoInss = vrLimiteMaximoInss;
    }

    @OneToMany(targetEntity=ItemTabelaINSSSalarioFamilia.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="tabela_item_tabela_inss_sf", joinColumns={@JoinColumn(name="id_tabela_inss")}, inverseJoinColumns={@JoinColumn(name="id_item_tabela_inss_sf")})
    @Fetch(value=FetchMode.SELECT)
    public List<ItemTabelaINSSSalarioFamilia> getItensTabelaINSSSalarioFamilia() {
        return this.itensTabelaINSSSalarioFamilia;
    }

    public void setItensTabelaINSSSalarioFamilia(List<ItemTabelaINSSSalarioFamilia> itensTabelaINSSSalarioFamilia) {
        this.itensTabelaINSSSalarioFamilia = itensTabelaINSSSalarioFamilia;
    }

    @OneToMany(targetEntity=ItemTabelaINSS.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="tabela_item_tabela_inss", joinColumns={@JoinColumn(name="id_tabela_inss")}, inverseJoinColumns={@JoinColumn(name="id_item_tabela_inss")})
    @Fetch(value=FetchMode.SELECT)
    public List<ItemTabelaINSS> getItensTabelaINSS() {
        return this.itensTabelaINSS;
    }

    public void setItensTabelaINSS(List<ItemTabelaINSS> itensTabelaINSS) {
        this.itensTabelaINSS = itensTabelaINSS;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CALCULAR_VR_ESCALONADO")
    public Short getCalcularVrInssEscalonado() {
        return this.calcularVrInssEscalonado;
    }

    public void setCalcularVrInssEscalonado(Short calcularVrInssEscalonado) {
        this.calcularVrInssEscalonado = calcularVrInssEscalonado;
    }
}

