/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BandeiraTEF;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoBandeiraTEFEmpresa;
import com.touchcomp.basementor.model.vo.TipoPagamento;
import com.touchcomp.basementor.model.vo.TipoPagamentoNFe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TIPO_BANDEIRA_TEF")
public class TipoBandeiraTEF
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private BandeiraTEF bandeiraTEF;
    private TipoPagamento tipoPagamento;
    private Double taxaCartao = 0.0;
    private Integer diasDeslocamento = 0;
    private Short deducaoTaxa = 0;
    private Short modoArredondamento = 0;
    private Short excluiSabado = 0;
    private Short excluiDomingo = 0;
    private Short excluiFeriado = 0;
    private Short dataFixa = 0;
    private Integer diaFixo = 0;
    private Integer diaVariavel = 0;
    private TipoPagamentoNFe tipoPagamentoNFe;
    private PlanoConta planoConta;
    private List<TipoBandeiraTEFEmpresa> empresas = new ArrayList<TipoBandeiraTEFEmpresa>();
    private Short creditoParcelado = 0;
    private Date dataAtualizacao;

    @Id
    @Column(nullable=false, name="ID_TIPO_BANDEIRA_TEF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_BANDEIRA_TEF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_TIPO_BANDEIRA_TEF_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @JoinColumn(name="ID_BANDEIRA_TEF", foreignKey=@ForeignKey(name="FK_TIPO_BANDEIRA_TEF_BANDEIRA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public BandeiraTEF getBandeiraTEF() {
        return this.bandeiraTEF;
    }

    public void setBandeiraTEF(BandeiraTEF bandeiraTEF) {
        this.bandeiraTEF = bandeiraTEF;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getBandeiraTEF() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getBandeiraTEF().getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_TIPO_BANDEIRA_TEF_TIPO_PAG"))
    public TipoPagamento getTipoPagamento() {
        return this.tipoPagamento;
    }

    public void setTipoPagamento(TipoPagamento tipoPagamento) {
        this.tipoPagamento = tipoPagamento;
    }

    @Column(nullable=false, name="TAXA_CARTAO", precision=15, scale=2)
    public Double getTaxaCartao() {
        return this.taxaCartao;
    }

    public void setTaxaCartao(Double taxaCartao) {
        this.taxaCartao = taxaCartao;
    }

    @Column(name="DIAS_DESLOCAMENTO")
    public Integer getDiasDeslocamento() {
        return this.diasDeslocamento;
    }

    public void setDiasDeslocamento(Integer diasDeslocamento) {
        this.diasDeslocamento = diasDeslocamento;
    }

    @Column(name="DEDUCAO_TAXA")
    public Short getDeducaoTaxa() {
        return this.deducaoTaxa;
    }

    public void setDeducaoTaxa(Short deducaoTaxa) {
        this.deducaoTaxa = deducaoTaxa;
    }

    @Column(name="EXCLUI_SABADO")
    public Short getExcluiSabado() {
        return this.excluiSabado;
    }

    public void setExcluiSabado(Short excluiSabado) {
        this.excluiSabado = excluiSabado;
    }

    @Column(name="EXCLUI_DOMINGO")
    public Short getExcluiDomingo() {
        return this.excluiDomingo;
    }

    public void setExcluiDomingo(Short excluiDomingo) {
        this.excluiDomingo = excluiDomingo;
    }

    @Column(name="EXCLUI_FERIADO")
    public Short getExcluiFeriado() {
        return this.excluiFeriado;
    }

    public void setExcluiFeriado(Short excluiFeriado) {
        this.excluiFeriado = excluiFeriado;
    }

    @Column(name="MODO_ARREDONDAMENTO")
    public Short getModoArredondamento() {
        return this.modoArredondamento;
    }

    public void setModoArredondamento(Short modoArredondamento) {
        this.modoArredondamento = modoArredondamento;
    }

    @Column(name="DATA_FIXA")
    public Short getDataFixa() {
        return this.dataFixa;
    }

    public void setDataFixa(Short dataFixa) {
        this.dataFixa = dataFixa;
    }

    @Column(name="DIA_FIXO")
    public Integer getDiaFixo() {
        return this.diaFixo;
    }

    public void setDiaFixo(Integer diaFixo) {
        this.diaFixo = diaFixo;
    }

    @Column(name="DIA_VARIAVEL")
    public Integer getDiaVariavel() {
        return this.diaVariavel;
    }

    public void setDiaVariavel(Integer diaVariavel) {
        this.diaVariavel = diaVariavel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO_NFE", foreignKey=@ForeignKey(name="FK_TIPO_BANDEIRA_TEF_TIPO_PAG_N"))
    public TipoPagamentoNFe getTipoPagamentoNFe() {
        return this.tipoPagamentoNFe;
    }

    public void setTipoPagamentoNFe(TipoPagamentoNFe tipoPagamentoNFe) {
        this.tipoPagamentoNFe = tipoPagamentoNFe;
    }

    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_TIPO_BANDEIRA_TEF_PL_CONTA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @OneToMany(mappedBy="tipoBandeiraTEF", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<TipoBandeiraTEFEmpresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<TipoBandeiraTEFEmpresa> empresas) {
        this.empresas = empresas;
    }

    @Column(name="CREDITO_PARCELADO")
    public Short getCreditoParcelado() {
        return this.creditoParcelado;
    }

    public void setCreditoParcelado(Short creditoParcelado) {
        this.creditoParcelado = creditoParcelado;
    }

    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }
}

