/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="TIPO_OPERACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_TIPO_OPERACAO", columnNames={"DESCRICAO"})})
public class TipoOperacao
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private PlanoConta planoConta;
    private PlanoContaGerencial planoContaGerencial;
    private List<Empresa> empresas;
    private Short ativo;

    public TipoOperacao() {
        this.empresas = new ArrayList<Empresa>();
        this.ativo = EnumConstantsMentorSimNao.SIM.value;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_TIPO_OPERACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_OPERACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TIPO_OPERACAO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public TipoOperacao(Long id, String n) {
        this.descricao = n;
        this.identificador = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_TIPO_OPERACAO_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_TIPO_OPERACAO_PC_GER"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @OneToMany(targetEntity=Empresa.class, fetch=FetchType.LAZY)
    @JoinTable(name="TIPO_OPERACAO_EMPRESA", joinColumns={@JoinColumn(name="ID_TIPO_OPERACAO")}, inverseJoinColumns={@JoinColumn(name="ID_EMPRESA")})
    public List<Empresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<Empresa> empresas) {
        this.empresas = empresas;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

