/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="TOMADOR_SERVICO_RH")
public class TomadorServicoRh
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private CentroCusto centroCusto;
    private Pessoa pessoa;
    private String descricao;
    private String codigoFGTS;
    private Short tomadorResponsavel = 0;
    private String numeroCEI;
    private String numeroGPS;
    private Short optanteSimples = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_TOMADOR_SERV")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TOMADOR_SERV")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TOMADOR_SERVICO_RH_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_TOMADOR_SERVICO_RH_CENTRO_CS"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_TOMADOR_SERVICO_RH_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="CODIGO_FGTS", length=100)
    public String getCodigoFGTS() {
        return this.codigoFGTS;
    }

    public void setCodigoFGTS(String codigoFGTS) {
        this.codigoFGTS = codigoFGTS;
    }

    @Column(name="TOMADOR_RESPONSAVEL")
    public Short getTomadorResponsavel() {
        return this.tomadorResponsavel;
    }

    public void setTomadorResponsavel(Short tomadorResponsavel) {
        this.tomadorResponsavel = tomadorResponsavel;
    }

    @Column(name="NUMERO_CEI", length=100)
    public String getNumeroCEI() {
        return this.numeroCEI;
    }

    public void setNumeroCEI(String numeroCEI) {
        this.numeroCEI = numeroCEI;
    }

    @Column(name="NUMERO_GPS", length=100)
    public String getNumeroGPS() {
        return this.numeroGPS;
    }

    public void setNumeroGPS(String numeroGPS) {
        this.numeroGPS = numeroGPS;
    }

    @Column(name="OPTANTE_SIMPLES")
    public Short getOptanteSimples() {
        return this.optanteSimples;
    }

    public void setOptanteSimples(Short optanteSimples) {
        this.optanteSimples = optanteSimples;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

