/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmox;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducaoOS;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PreFaturamentoNF;
import com.touchcomp.basementor.model.vo.TransFerenciaCCPreEvento;
import com.touchcomp.basementor.model.vo.TransfCentroEstoqueItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoque;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="TRANSF_CENTRO_EST")
public class TransferenciaCentroEstoque
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataTransferencia;
    private Date dataCadastro;
    private CentroEstoque origem;
    private CentroEstoque destino;
    private List<ItemTransfCentroEstoque> itemTransfCentroEstoque = new ArrayList<ItemTransfCentroEstoque>();
    private List<TransFerenciaCCPreEvento> preEventos;
    private List<TransfCentroEstoqueItemEmbalagemProducao> itemEmbalagemProducao;
    private Pedido pedido;
    private OrdemServico ordemServico;
    private AtendPedidoAlmox atendPedidoAlmox;
    private PreFaturamentoNF preFaturamentoNF;
    private ItemEmbalagemProducaoOS itemEmbalagemProdOS;
    private String observacao;
    private WmsSaidaEstoque wmsSaidaEstoque;
    private WmsEntradaEstoque wmsEntradaEstoque;

    public TransferenciaCentroEstoque() {
        this.dataTransferencia = new Date();
        this.dataCadastro = new Date();
        this.preEventos = new ArrayList<TransFerenciaCCPreEvento>();
        this.itemEmbalagemProducao = new ArrayList<TransfCentroEstoqueItemEmbalagemProducao>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_TRANSF_CENTRO_EST")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSF_CENTRO_EST")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSF_CENTRO_EST_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @OneToMany(mappedBy="transferenciaCentroEstoque")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<TransFerenciaCCPreEvento> getPreEventos() {
        return this.preEventos;
    }

    public void setPreEventos(List<TransFerenciaCCPreEvento> preEventos) {
        this.preEventos = preEventos;
    }

    @OneToMany(mappedBy="transferenciaCentroEstoque")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<TransfCentroEstoqueItemEmbalagemProducao> getItemEmbalagemProducao() {
        return this.itemEmbalagemProducao;
    }

    public void setItemEmbalagemProducao(List<TransfCentroEstoqueItemEmbalagemProducao> itemEmbalagemProducao) {
        this.itemEmbalagemProducao = itemEmbalagemProducao;
    }

    @OneToMany(mappedBy="transfCentroEstoque")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemTransfCentroEstoque> getItemTransfCentroEstoque() {
        return this.itemTransfCentroEstoque;
    }

    public void setItemTransfCentroEstoque(List<ItemTransfCentroEstoque> itemTransfCentroEstoque) {
        this.itemTransfCentroEstoque = itemTransfCentroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_EST_ORIGEM", foreignKey=@ForeignKey(name="FK_TRANSF_CENTRO_EST_CENT_EST_O"))
    public CentroEstoque getOrigem() {
        return this.origem;
    }

    public void setOrigem(CentroEstoque origem) {
        this.origem = origem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_EST_DESTINO", foreignKey=@ForeignKey(name="FK_TRANSF_CENTRO_EST_CENT_EST_D"))
    public CentroEstoque getDestino() {
        return this.destino;
    }

    public void setDestino(CentroEstoque destino) {
        this.destino = destino;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TRANSFERENCIA")
    public Date getDataTransferencia() {
        return this.dataTransferencia;
    }

    public void setDataTransferencia(Date dataTransferencia) {
        this.dataTransferencia = dataTransferencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_TRANSF_CENTRO_EST_PEDIDO"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_TRANSF_CENTRO_OS"))
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Id.:{0} - Data: {1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getDataTransferencia())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="transferenciaCentroEst", fetch=FetchType.LAZY)
    public AtendPedidoAlmox getAtendPedidoAlmox() {
        return this.atendPedidoAlmox;
    }

    public void setAtendPedidoAlmox(AtendPedidoAlmox atendPedidoAlmox) {
        this.atendPedidoAlmox = atendPedidoAlmox;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_FATURAMENTO_NF", foreignKey=@ForeignKey(name="FK_TRANSF_CENTRO_EST_PRE_FAT_NF"))
    public PreFaturamentoNF getPreFaturamentoNF() {
        return this.preFaturamentoNF;
    }

    public void setPreFaturamentoNF(PreFaturamentoNF preFaturamentoNF) {
        this.preFaturamentoNF = preFaturamentoNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_EMBALAGEM_PROD_OS", foreignKey=@ForeignKey(name="FK_ITEM_EMBALAGEM_PROD_OS_EM_OS"))
    public ItemEmbalagemProducaoOS getItemEmbalagemProdOS() {
        return this.itemEmbalagemProdOS;
    }

    public void setItemEmbalagemProdOS(ItemEmbalagemProducaoOS itemEmbalagemProdOS) {
        this.itemEmbalagemProdOS = itemEmbalagemProdOS;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_WMS_SAIDA_ESTOQUE", foreignKey=@ForeignKey(name="FK_TRANSF_CEN_EST_WMS_SAI"))
    public WmsSaidaEstoque getWmsSaidaEstoque() {
        return this.wmsSaidaEstoque;
    }

    public void setWmsSaidaEstoque(WmsSaidaEstoque wmsSaidaEstoque) {
        this.wmsSaidaEstoque = wmsSaidaEstoque;
    }

    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="transferenciaEstEntrada")
    public WmsEntradaEstoque getWmsEntradaEstoque() {
        return this.wmsEntradaEstoque;
    }

    public void setWmsEntradaEstoque(WmsEntradaEstoque wmsEntradaEstoque) {
        this.wmsEntradaEstoque = wmsEntradaEstoque;
    }
}

