/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObservacaoTransportador;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TransportadorPraca;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TRANSPORTADOR", uniqueConstraints={@UniqueConstraint(name="UNQ1_TRANSPORTADOR", columnNames={"ID_PESSOA"})})
public class Transportador
implements InterfaceVO {
    private Date dataCadastro;
    private Empresa empresa;
    private List<TransportadorPraca> praca;
    private Long identificador;
    private Pessoa pessoa;
    private PlanoConta planoConta;
    private Timestamp dataAtualizacao;
    private List<ObservacaoTransportador> observacaoFaturamento;
    private Short ativo;

    public Transportador() {
        this.praca = new ArrayList<TransportadorPraca>();
        this.observacaoFaturamento = new ArrayList<ObservacaoTransportador>();
        this.ativo = 1;
    }

    public Transportador(Long identificador, Pessoa pessoa) {
        this.identificador = identificador;
        this.setPessoa(pessoa);
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_TRASNPORTADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSPORTADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @OneToMany(mappedBy="transportador", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<TransportadorPraca> getPraca() {
        return this.praca;
    }

    public void setPraca(List<TransportadorPraca> praca) {
        this.praca = praca;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPessoa() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="transportador", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ObservacaoTransportador> getObservacaoFaturamento() {
        return this.observacaoFaturamento;
    }

    public void setObservacaoFaturamento(List<ObservacaoTransportador> observacaoFaturamento) {
        this.observacaoFaturamento = observacaoFaturamento;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

