/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FormaPagamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoTransportadorMDFe;
import com.touchcomp.basementor.model.vo.TransportadorAgregadoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="TRANSPORTADOR_AGREGADO", uniqueConstraints={@UniqueConstraint(name="UNQ1_TRANSPORTADOR_AGREGADO", columnNames={"ID_PESSOA"})})
public class TransportadorAgregado
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Date dataContrato;
    private PlanoConta planoConta;
    private String observacao;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;
    private FormaPagamento formaPagamento;
    private List<TransportadorAgregadoEvento> eventoTransportadorAgregado = new ArrayList<TransportadorAgregadoEvento>();
    private String rntrc;
    private Short tipoPropTranspAgreg = 0;
    private String ciot;
    private Pessoa responsavelCiot;
    private TipoTransportadorMDFe tipoTransportadorMDFe;

    @Id
    @Column(nullable=false, unique=true, name="ID_TRANSPORTADOR_AGREGADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSPORTADOR_AGREGADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_AGREGADO_PES"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Column(name="DATA_CONTRATO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataContrato() {
        return this.dataContrato;
    }

    @Column(name="OBSERVACAO", length=250)
    public String getObservacao() {
        return this.observacao;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_AGREGADO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_AGREGADO_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMA_PAGAMENTO", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_AGREGADO_F_PAG"))
    public FormaPagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public void setDataContrato(Date dataContrato) {
        this.dataContrato = dataContrato;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public void setFormaPagamento(FormaPagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="transportadorAgregado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TransportadorAgregadoEvento> getEventoTransportadorAgregado() {
        return this.eventoTransportadorAgregado;
    }

    public void setEventoTransportadorAgregado(List<TransportadorAgregadoEvento> eventoTransportadorAgregado) {
        this.eventoTransportadorAgregado = eventoTransportadorAgregado;
    }

    @Column(name="RNTRC", length=8)
    public String getRntrc() {
        return this.rntrc;
    }

    public void setRntrc(String rntrc) {
        this.rntrc = rntrc;
    }

    @Column(name="TIPO_PROP_TRANSP_AGREG")
    public Short getTipoPropTranspAgreg() {
        return this.tipoPropTranspAgreg;
    }

    public void setTipoPropTranspAgreg(Short tipoPropTranspAgreg) {
        this.tipoPropTranspAgreg = tipoPropTranspAgreg;
    }

    @Column(name="CIOT", length=12)
    public String getCiot() {
        return this.ciot;
    }

    public void setCiot(String ciot) {
        this.ciot = ciot;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESP_CIOT", foreignKey=@ForeignKey(name="FK_TRANSP_AGREGADO_PES_RESP_CIO"))
    public Pessoa getResponsavelCiot() {
        return this.responsavelCiot;
    }

    public void setResponsavelCiot(Pessoa responsavelCiot) {
        this.responsavelCiot = responsavelCiot;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_TRANSPORTADOR_MDFE", foreignKey=@ForeignKey(name="FK_TRANSP_AGRE_TIPO_TRANSP_MDFE"))
    public TipoTransportadorMDFe getTipoTransportadorMDFe() {
        return this.tipoTransportadorMDFe;
    }

    public void setTipoTransportadorMDFe(TipoTransportadorMDFe tipoTransportadorMDFe) {
        this.tipoTransportadorMDFe = tipoTransportadorMDFe;
    }
}

