/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WmsPedidoItem;
import com.touchcomp.basementor.model.vo.WmsPedidoItemReserva;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsStatusPedido;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;

@Entity
@Table(name="WMS_PEDIDO")
public class WmsPedido
implements InterfaceVO {
    @Id
    @Column(name="ID_WMS_PEDIDO", nullable=true, unique=false)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_WMS_PEDIDO")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO", nullable=true, unique=false)
    private Date dataCadastro;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO", nullable=true, unique=false)
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_PED_EMPRESA"))
    private Empresa empresa;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SOLICITACAO", nullable=true, unique=false)
    private Date dataSolicitacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_SOLICITANTE", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_PED_USU_SOLICITANTE"))
    private Usuario usuarioSolicitante;
    @Column(name="OBSERVACAO", nullable=true, unique=false, length=255)
    private String observacao;
    @OneToMany(mappedBy="wmsPedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WmsPedidoItem> itens = new LinkedList<WmsPedidoItem>();
    @OneToMany(mappedBy="wmsPedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WmsPedidoItemReserva> itensReserva = new LinkedList<WmsPedidoItemReserva>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_PEDIDO", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_PED_STAT_PED"))
    private WmsStatusPedido statusPedido;
    @Column(name="PESO_TOTAL", scale=15, precision=6)
    private Double pesoTotal = 0.0;
    @Column(name="VOLUME_TOTAL", scale=15, precision=6)
    private Double volumeTotal = 0.0;
    @Column(name="QUANTIDADE_TOTAL", scale=15, precision=6)
    private Double quantidadeTotal = 0.0;
    @Column(name="DESCRICAO", length=500)
    private String descricao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EXPEDICAO", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_PED_EXPEDICAO"))
    private Expedicao expedicao;
    @OneToOne(mappedBy="pedidoWms")
    private WmsSeparacaoPedido wmsSeparacaoPedido;
    @Column(name="RESERVAR_ESTOQUE")
    private Short reservarEstoque = EnumConstantsMentorSimNao.NAO.getEnumId();
    @Column(name="TIPO_MOVIMENTACAO")
    private Short tipoMovimentacao = EnumConstantsMentorSimNao.NAO.getEnumId();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    @Generated
    public void setUsuarioSolicitante(Usuario usuarioSolicitante) {
        this.usuarioSolicitante = usuarioSolicitante;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setItens(List<WmsPedidoItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setItensReserva(List<WmsPedidoItemReserva> itensReserva) {
        this.itensReserva = itensReserva;
    }

    @Generated
    public void setStatusPedido(WmsStatusPedido statusPedido) {
        this.statusPedido = statusPedido;
    }

    @Generated
    public void setPesoTotal(Double pesoTotal) {
        this.pesoTotal = pesoTotal;
    }

    @Generated
    public void setVolumeTotal(Double volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    @Generated
    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setExpedicao(Expedicao expedicao) {
        this.expedicao = expedicao;
    }

    @Generated
    public void setWmsSeparacaoPedido(WmsSeparacaoPedido wmsSeparacaoPedido) {
        this.wmsSeparacaoPedido = wmsSeparacaoPedido;
    }

    @Generated
    public void setReservarEstoque(Short reservarEstoque) {
        this.reservarEstoque = reservarEstoque;
    }

    @Generated
    public void setTipoMovimentacao(Short tipoMovimentacao) {
        this.tipoMovimentacao = tipoMovimentacao;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    @Generated
    public Usuario getUsuarioSolicitante() {
        return this.usuarioSolicitante;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<WmsPedidoItem> getItens() {
        return this.itens;
    }

    @Generated
    public List<WmsPedidoItemReserva> getItensReserva() {
        return this.itensReserva;
    }

    @Generated
    public WmsStatusPedido getStatusPedido() {
        return this.statusPedido;
    }

    @Generated
    public Double getPesoTotal() {
        return this.pesoTotal;
    }

    @Generated
    public Double getVolumeTotal() {
        return this.volumeTotal;
    }

    @Generated
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Expedicao getExpedicao() {
        return this.expedicao;
    }

    @Generated
    public WmsSeparacaoPedido getWmsSeparacaoPedido() {
        return this.wmsSeparacaoPedido;
    }

    @Generated
    public Short getReservarEstoque() {
        return this.reservarEstoque;
    }

    @Generated
    public Short getTipoMovimentacao() {
        return this.tipoMovimentacao;
    }
}

