/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.consultapessoas.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.touchcomp.basementorclientwebservices.consultapessoas.WEBConsultaPessoas;
import com.touchcomp.basementorclientwebservices.consultapessoas.constants.ConstEnumConsultaPessoasRegTrib;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsultaPessoaParams;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsutalPessoaResp;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.downloadweb.ToolDownloadWeb;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WEBConsultaPessoasApiBrasil {
    private final String URL = "https://gateway.apibrasil.io/api/v2/dados/cnpj/credits";
    private final String URL_FILE_MUN = "http://www.touchcomp.com.br/mentor/touch_comp_erp/codigo_municipios_TOM_receita_federal.csv";

    public DTOConsutalPessoaResp consultaDados(DTOConsultaPessoaParams param, WEBConsultaPessoas.Config config) throws ExceptionIO, ExceptionInvalidState {
        if (ToolMethods.isStrWithData((String)param.getInscricaoEstadual())) {
            throw new ExceptionInvalidState("E.ERP.0047.057", new Object[0]);
        }
        if (param.getCpfCnpj().length() >= 14) {
            return this.consultaCnpj(param.getCpfCnpj(), config);
        }
        throw new ExceptionInvalidState("E.ERP.0047.057", new Object[0]);
    }

    private DTOConsutalPessoaResp consultaCnpj(String cpfCnpj, WEBConsultaPessoas.Config config) throws ExceptionIO {
        DTOConsutalPessoaResp dTOConsutalPessoaResp;
        block12: {
            File tempCidades = this.downloadFile();
            cpfCnpj = ToolString.onlyNumbers((String)cpfCnpj);
            cpfCnpj = ToolFormatter.formatCNPJCPF((String)cpfCnpj);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            rootNode.put("tipo", "cnpj");
            rootNode.put("cnpj", cpfCnpj);
            String jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).build();
            RequestBody body = RequestBody.create((String)jsonString, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
            Request request = new Request.Builder().url("https://gateway.apibrasil.io/api/v2/dados/cnpj/credits").post(body).addHeader("Authorization", "Bearer " + config.getToken()).build();
            Response response = client.newCall(request).execute();
            try {
                String ret = response.body().string();
                Map m = ToolJson.readJsonAsMap((String)ret);
                dTOConsutalPessoaResp = this.converterRetorno(m, tempCidades);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MalformedURLException ex) {
                        throw new ExceptionIO((IOException)ex);
                    }
                    catch (IOException ex) {
                        throw new ExceptionIO(ex);
                    }
                }
                catch (JsonProcessingException ex) {
                    throw new ExceptionErroProgramacao("Erro ao gerar o json: " + ex.getMessage(), (Throwable)ex);
                }
            }
            response.close();
        }
        return dTOConsutalPessoaResp;
    }

    DTOConsutalPessoaResp converterRetorno(Map<String, Object> m, File tempCidades) throws ExceptionIO {
        DTOConsutalPessoaResp resp = new DTOConsutalPessoaResp();
        Boolean erro = (Boolean)m.get("error");
        String message = (String)m.get("message");
        resp.setDescricaoRetorno(message);
        resp.setErro(erro);
        if (erro != null && erro.booleanValue()) {
            return resp;
        }
        Map response = (Map)m.get("response");
        erro = (Boolean)response.get("erro");
        resp.setErro(erro);
        if (erro != null && erro.booleanValue()) {
            return resp;
        }
        Map cnpj = (Map)response.get("cnpj");
        Map empresa = (Map)cnpj.get("empresa");
        String cnpj_basico = (String)cnpj.get("cnpj_basico");
        String cnpj_ordem = (String)cnpj.get("cnpj_ordem");
        String cnpj_dv = (String)cnpj.get("cnpj_dv");
        String matriz_filial = (String)cnpj.get("matriz_filial");
        String nome_fantasia = (String)cnpj.get("nome_fantasia");
        String data_situacao_cadastral = (String)cnpj.get("data_situacao_cadastral");
        String motivo_situacao_cadastral = (String)cnpj.get("motivo_situacao_cadastral");
        String situacao_cadastral = (String)cnpj.get("situacao_cadastral");
        String data_inicio_atividades = (String)cnpj.get("data_inicio_atividades");
        String cnae_fiscal = (String)cnpj.get("cnae_fiscal");
        String cnae_fiscal_secundaria = (String)cnpj.get("cnae_fiscal_secundaria");
        Double capital_social = empresa.get("capital_social") != null ? ((Number)empresa.get("capital_social")).doubleValue() : 0.0;
        String razao_social = (String)empresa.get("razao_social");
        DTOConsutalPessoaResp.Pessoa pessoa = new DTOConsutalPessoaResp.Pessoa();
        pessoa.setCapitalSocial(capital_social);
        pessoa.setCnaePrincipal(cnae_fiscal);
        pessoa.setCnaeSecundario(cnae_fiscal_secundaria);
        pessoa.setCpfCnpj(cnpj_basico + cnpj_ordem + cnpj_dv);
        if (data_inicio_atividades.length() == 8) {
            pessoa.setDataInicioAtividades(ToolDate.strToDate((String)data_inicio_atividades, (String)"yyyyMMdd"));
        }
        if (data_situacao_cadastral.length() == 8) {
            pessoa.setDataSituacaoCadastral(ToolDate.strToDate((String)data_situacao_cadastral, (String)"yyyyMMdd"));
        }
        pessoa.setMatriz(Short.valueOf(matriz_filial));
        pessoa.setMotivoSituacaoCadastral(motivo_situacao_cadastral);
        pessoa.setSituacaoCadastral(situacao_cadastral);
        pessoa.setNome(razao_social);
        pessoa.setNomeFantasia(nome_fantasia);
        resp.getPessoas().add(pessoa);
        String ddd1 = (String)cnpj.get("ddd1");
        String telefone1 = (String)cnpj.get("telefone1");
        String ddd2 = (String)cnpj.get("ddd2");
        String telefone2 = (String)cnpj.get("telefone2");
        String email = (String)cnpj.get("correio_eletronico");
        DTOConsutalPessoaResp.Contato contato = new DTOConsutalPessoaResp.Contato();
        contato.setEmail(email);
        contato.setTelefone1(ddd1 + telefone1);
        contato.setTelefone2(ddd2 + telefone2);
        pessoa.setContato(contato);
        String tipo_logradouro = (String)cnpj.get("tipo_logradouro");
        String logradouro = (String)cnpj.get("logradouro");
        String numero = (String)cnpj.get("numero");
        String complemento = (String)cnpj.get("complemento");
        String bairro = (String)cnpj.get("bairro");
        String cep = (String)cnpj.get("cep");
        String uf = (String)cnpj.get("uf");
        Map municipio = (Map)cnpj.get("municipio");
        String codigoCid = (String)municipio.get("codigo");
        String cidade = (String)municipio.get("descricao");
        DTOConsutalPessoaResp.Endereco endereco = new DTOConsutalPessoaResp.Endereco();
        endereco.setBairro(bairro);
        endereco.setCep(cep);
        endereco.setCodigoMunicipio(this.getCodigoIbge(tempCidades, codigoCid));
        endereco.setCodigoMunicipioReceita(codigoCid);
        endereco.setComplemento(complemento);
        endereco.setLogradouro(tipo_logradouro + " " + logradouro);
        endereco.setMunicipio(cidade);
        endereco.setNumero(numero);
        endereco.setTipoLogradouro(tipo_logradouro);
        endereco.setUf(uf);
        pessoa.setEndereco(endereco);
        Map simples = (Map)cnpj.get("simples");
        ConstEnumConsultaPessoasRegTrib regime = ConstEnumConsultaPessoasRegTrib.NORMAL;
        Date dataOpcao = null;
        if (simples != null) {
            if (ToolMethods.isEquals((Object)"S", simples.get("opcao_simples"))) {
                String data_opcao_simples = (String)simples.get("data_opcao_simples");
                regime = ConstEnumConsultaPessoasRegTrib.SIMPLES;
                if (data_opcao_simples.length() == 8) {
                    dataOpcao = ToolDate.strToDate((String)data_opcao_simples, (String)"yyyyMMdd");
                }
            } else if (ToolMethods.isEquals((Object)"S", simples.get("opcao_mei"))) {
                String data_opcao_mei = (String)simples.get("data_opcao_mei");
                regime = ConstEnumConsultaPessoasRegTrib.MEI;
                if (data_opcao_mei.length() == 8) {
                    dataOpcao = ToolDate.strToDate((String)((String)simples.get("data_opcao_mei")), (String)"yyyyMMdd");
                }
            }
        }
        DTOConsutalPessoaResp.Tributacao tributacao = new DTOConsutalPessoaResp.Tributacao();
        tributacao.setRegimeTrib(regime);
        tributacao.setDataOpcao(dataOpcao);
        pessoa.setTributacao(tributacao);
        List socios = (List)cnpj.get("socios");
        LinkedList<DTOConsutalPessoaResp.Socio> aux = new LinkedList<DTOConsutalPessoaResp.Socio>();
        for (Map socio : socios) {
            String cnpj_cpf_socio = (String)socio.get("cnpj_cpf_socio");
            String codigo_qualificacao_socio = (String)socio.get("qualificacao_socio");
            String nome_socio = (String)socio.get("nome_socio");
            DTOConsutalPessoaResp.Socio s = new DTOConsutalPessoaResp.Socio();
            s.setCodigoQualificacao(codigo_qualificacao_socio);
            s.setCpfCnpj(cnpj_cpf_socio);
            s.setNome(nome_socio);
            Map qualificacao = (Map)socio.get("qualificacao");
            if (qualificacao != null) {
                String descricao = (String)qualificacao.get("descricao");
                s.setQualificacao(descricao);
            }
            aux.add(s);
        }
        pessoa.setSocios(aux);
        return resp;
    }

    protected File downloadFile() throws ExceptionIO {
        try {
            File temp = new File("arquivo_municipios_tom.csv");
            if (!temp.exists()) {
                ToolDownloadWeb.downloadFileToServer((File)temp, (String)"http://www.touchcomp.com.br/mentor/touch_comp_erp/codigo_municipios_TOM_receita_federal.csv");
            }
            return temp;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getCodigoIbge(File tempCidades, String codigoCid) throws ExceptionIO {
        if (tempCidades == null) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(tempCidades));){
            String line;
            StringTokenizer sk;
            String codigoCidPlanilha;
            do {
                if ((line = br.readLine()) == null) return codigoCid;
            } while (!ToolMethods.isEquals((Object)(codigoCidPlanilha = (sk = new StringTokenizer(line, ";")).nextToken()), (Object)codigoCid) && !ToolMethods.isEquals((Object)codigoCidPlanilha, (Object)ToolString.removerZerosAEsquerda((String)codigoCid)));
            String string = sk.nextToken();
            return string;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }
}

