/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.cte.cte400.enviocte400.impl;

import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostos;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosIBSCBS;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeTRed;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeTTribRegular;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteItemCbs;
import com.touchcomp.basementor.model.vo.CteItemIbs;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class UtilEnvioCteIBSCBS {
    void calcularImpostoReformaTributaria(CTeNotaInfoInformacoesRelativasImpostos c, Cte cte) {
        if (!ToolMethods.isAffirmative((Number)cte.getInformarDadosReformaTributaria())) {
            return;
        }
        c.setIbsCbs(this.getIbsCbs(cte));
    }

    private CTeNotaInfoInformacoesRelativasImpostosIBSCBS getIbsCbs(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosIBSCBS c = new CTeNotaInfoInformacoesRelativasImpostosIBSCBS();
        c.setCClassTrib(cte.getCteVlrImpostos().getImpostoCBS().getIncidenciaTributariaClass().getCodigo());
        c.setCST(cte.getCteVlrImpostos().getImpostoCBS().getIncidenciaTributaria().getCodigo());
        if (ToolMethods.isAffirmative((Number)cte.getCteVlrImpostos().getImpostoCBS().getIncidenciaTributariaClass().getCalcularCbsIbs())) {
            c.setGIBSCBS(this.getGIbsCbs(cte.getCteVlrImpostos().getImpostoIBS(), cte.getCteVlrImpostos().getImpostoCBS()));
        }
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS getGIbsCbs(CteItemIbs impostoIBS, CteItemCbs impostoCBS) {
        CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS t = new CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS();
        t.setVBC(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getValorBaseCalcIBS(), (int)2));
        if (ToolMethods.isNotNull((Object)impostoCBS).booleanValue()) {
            t.setGCBS(this.getGCBS(impostoCBS));
        }
        t.setGIBSMun(this.getGIbsMun(impostoIBS));
        t.setGIBSUF(this.getGIbsUF(impostoIBS));
        if (ToolMethods.isAffirmative((Number)impostoCBS.getIncidenciaTributariaClass().getIndGrupoTribReg())) {
            t.setGTribRegular(this.getGTribRegular(impostoCBS, impostoIBS));
        }
        t.setVIBS(ToolFormatter.arrredondarNumeroBigDecimal((Double)(impostoIBS.getValorIBSMun() + impostoIBS.getValorIBSUF()), (int)2));
        return t;
    }

    private CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GCBS getGCBS(CteItemCbs impostoCBS) {
        CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GCBS g = new CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GCBS();
        g.setVCBS(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoCBS.getValorCBS(), (int)2));
        g.setPCBS(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoCBS.getAliquotaCBS(), (int)4));
        if (impostoCBS.getPercRedAliquotaCBS() > 0.0) {
            g.setGRed(this.getGRed(impostoCBS.getPercRedAliquotaCBS(), impostoCBS.getAliquotaEfetivaCBS()));
        }
        return g;
    }

    private CTeTRed getGRed(Double percRedAliquotaCBS, Double aliquotaEfetivaCBS) {
        CTeTRed c = new CTeTRed();
        c.setPAliqEfet(ToolFormatter.arrredondarNumeroBigDecimal((Double)aliquotaEfetivaCBS, (int)2));
        c.setPRedAliq(ToolFormatter.arrredondarNumeroBigDecimal((Double)percRedAliquotaCBS, (int)2));
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GIBSMun getGIbsMun(CteItemIbs impostoIBS) {
        CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GIBSMun g = new CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GIBSMun();
        g.setVIBSMun(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getValorIBSMun(), (int)2));
        g.setPIBSMun(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getAliquotaIBSMun(), (int)4));
        if (impostoIBS.getPercRedAliquotaIBSMun() > 0.0) {
            g.setGRed(this.getGRed(impostoIBS.getPercRedAliquotaIBSMun(), impostoIBS.getAliquotaEfetivaIBSMun()));
        }
        return g;
    }

    private CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GIBSUF getGIbsUF(CteItemIbs impostoIBS) {
        CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GIBSUF g = new CTeNotaInfoInformacoesRelativasImpostosIBSCBS.TCIBS.GIBSUF();
        g.setVIBSUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getValorIBSUF(), (int)2));
        g.setPIBSUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getAliquotaIBSUF(), (int)4));
        if (impostoIBS.getPercRedAliquotaIBSUF() > 0.0) {
            g.setGRed(this.getGRed(impostoIBS.getPercRedAliquotaIBSUF(), impostoIBS.getAliquotaEfetivaIBSUF()));
        }
        return g;
    }

    private CTeTTribRegular getGTribRegular(CteItemCbs impostoCBS, CteItemIbs impostoIBS) {
        CTeTTribRegular c = new CTeTTribRegular();
        c.setCClassTribReg(impostoCBS.getIncidenciaTributariaClass().getCodigo());
        c.setCSTReg(impostoCBS.getIncidenciaTributaria().getCodigo());
        c.setPAliqEfetRegCBS(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoCBS.getAliquotaEfetivaCBS(), (int)4));
        c.setVTribRegCBS(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoCBS.getValorCBS(), (int)2));
        c.setPAliqEfetRegIBSMun(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getAliquotaEfetivaIBSMun(), (int)4));
        c.setVTribRegIBSMun(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getValorIBSMun(), (int)2));
        c.setPAliqEfetRegIBSUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getAliquotaEfetivaIBSUF(), (int)4));
        c.setVTribRegIBSUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)impostoIBS.getValorIBSUF(), (int)2));
        return c;
    }
}

