/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ecommercelojaintegrada;

import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.WebLojaIntegInterface;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.categorias.DTOLojaIntegAlterCategoria;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.categorias.DTOLojaIntegCategoria;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.categorias.DTOLojaIntegCategoriaRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.estoque.DTOLojaIntegEstoque;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.estoque.DTOLojaIntegEstoqueRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.grades.DTOLojaIntegGrade;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.grades.DTOLojaIntegGradeRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.marcas.DTOLojaIntegAlterMarca;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.marcas.DTOLojaIntegMarca;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.marcas.DTOLojaIntegMarcaRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.produtos.DTOLojaIntegAlterProduto;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.produtos.DTOLojaIntegProduto;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.produtos.DTOLojaIntegProdutoRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.tabelaprecos.DTOLojaIntegTabelaPrecos;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.tabelaprecos.DTOLojaIntegTabelaPrecosRes;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.json.ToolJson;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Component
public class WebLojaIntegrada {
    private Parametros paramsConexao;

    public DTOLojaIntegCategoriaRes inserirCategoria(DTOLojaIntegCategoria dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.inserirCategoria(this.getParamsConexao(), dto);
    }

    public DTOLojaIntegCategoriaRes inserirCategoria(Parametros paramsConexao, DTOLojaIntegCategoria dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("categoria", paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegCategoriaRes> books = bookResource.cadastrarCategoria(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegCategoriaRes ret = (DTOLojaIntegCategoriaRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegCategoriaRes alterarCategoria(String idCategoriaSite, DTOLojaIntegAlterCategoria dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("categoria/" + idCategoriaSite, this.paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(this.paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegCategoriaRes> books = bookResource.alterarCategoria(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegCategoriaRes ret = (DTOLojaIntegCategoriaRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegEstoqueRes alterarEstoque(String idProduto, DTOLojaIntegEstoque dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.alterarEstoque(this.getParamsConexao(), idProduto, dto);
    }

    public DTOLojaIntegEstoqueRes alterarEstoque(Parametros paramsConexao, String idProduto, DTOLojaIntegEstoque dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("produto_estoque/" + idProduto, paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegEstoqueRes> books = bookResource.alterarEstoqueProduto(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegEstoqueRes ret = (DTOLojaIntegEstoqueRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegGradeRes cadastrarGrade(DTOLojaIntegGrade dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.cadastrarGrade(this.getParamsConexao(), dto);
    }

    public DTOLojaIntegGradeRes cadastrarGrade(Parametros paramsConexao, DTOLojaIntegGrade dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("grades", paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegGradeRes> books = bookResource.cadastrarGrades(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegGradeRes ret = (DTOLojaIntegGradeRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegMarcaRes cadastrarMarca(DTOLojaIntegMarca dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.cadastrarMarca(this.getParamsConexao(), dto);
    }

    public DTOLojaIntegMarcaRes cadastrarMarca(Parametros paramsConexao, DTOLojaIntegMarca dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("marca", paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegMarcaRes> books = bookResource.cadastrarMarca(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegMarcaRes ret = (DTOLojaIntegMarcaRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegMarcaRes alterarMarca(Long idMarcaSite, DTOLojaIntegAlterMarca dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.alterarMarca(this.getParamsConexao(), idMarcaSite, dto);
    }

    public DTOLojaIntegMarcaRes alterarMarca(Parametros paramsConexao, Long idMarcaSite, DTOLojaIntegAlterMarca dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("marca/" + idMarcaSite, paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegMarcaRes> books = bookResource.alterarMarca(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegMarcaRes ret = (DTOLojaIntegMarcaRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegProdutoRes cadastrarProduto(DTOLojaIntegProduto dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.cadastrarProduto(this.getParamsConexao(), dto);
    }

    public DTOLojaIntegProdutoRes cadastrarProduto(Parametros paramsConexao, DTOLojaIntegProduto dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("produto", paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegProdutoRes> books = bookResource.cadastrarProduto(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegProdutoRes ret = (DTOLojaIntegProdutoRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegProdutoRes alterarProduto(Long idProduto, DTOLojaIntegAlterProduto dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.alterarProduto(this.getParamsConexao(), idProduto, dto);
    }

    public DTOLojaIntegProdutoRes alterarProduto(Parametros paramsConexao, Long idProduto, DTOLojaIntegAlterProduto dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("produto/" + idProduto, paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegProdutoRes> books = bookResource.alterarProduto(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegProdutoRes ret = (DTOLojaIntegProdutoRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOLojaIntegTabelaPrecosRes cadastrarPrecoProduto(Long idProduto, DTOLojaIntegTabelaPrecos dto) throws ExceptionIO, ExceptionValidacaoDados {
        return this.cadastrarPrecoProduto(this.getParamsConexao(), idProduto, dto);
    }

    public DTOLojaIntegTabelaPrecosRes cadastrarPrecoProduto(Parametros paramsConexao, Long idProduto, DTOLojaIntegTabelaPrecos dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.getUrl("produto_preco/" + idProduto, paramsConexao);
            WebLojaIntegInterface bookResource = (WebLojaIntegInterface)this.getRetrofit(paramsConexao).create(WebLojaIntegInterface.class);
            Call<DTOLojaIntegTabelaPrecosRes> books = bookResource.cadastrarPrecoProduto(url, dto);
            retrofit2.Response res = books.execute();
            DTOLojaIntegTabelaPrecosRes ret = (DTOLojaIntegTabelaPrecosRes)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{"Houve um erro ao executar a opera\u00e7\u00e3o. Consulte suporte. Dados Enviados: \n" + ToolJson.toJson((Object)dto) + "Dados Recebidos: \n" + res.raw().toString() + "Retorno: \n" + String.valueOf(res.errorBody()) != null ? res.errorBody().string() : "NACodigo: \n" + res.code() + "Mensagem: \n" + res.raw().message()});
            }
            return ret;
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public Retrofit getRetrofit(Parametros config) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        httpClient.addInterceptor((Interceptor)logging);
        httpClient.addInterceptor((Interceptor)new WebLojaIntegradaInterceptor(this, config));
        OkHttpClient client = httpClient.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(config.getBaseURL()).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        return retrofit;
    }

    public Parametros getParamsConexao() {
        return this.paramsConexao;
    }

    public void setParamsConexao(Parametros paramsConexao) {
        this.paramsConexao = paramsConexao;
    }

    private String getUrl(String relativePath, Parametros paramsConexao) {
        StringBuilder sb = new StringBuilder();
        sb.append(paramsConexao.getBaseURL());
        sb.append(relativePath);
        sb.append("/?format=json");
        sb.append("&");
        sb.append("chave_api=");
        sb.append(paramsConexao.chaveAPI);
        sb.append("&");
        sb.append("chave_aplicacao=");
        sb.append(paramsConexao.chaveAplicacao);
        return sb.toString();
    }

    public static class Parametros {
        private String chaveAPI;
        private String chaveAplicacao;
        private String baseURL;

        public Parametros(String chaveAPI, String chaveAplicacao, String baseURL) {
            this.chaveAPI = chaveAPI;
            this.chaveAplicacao = chaveAplicacao;
            this.baseURL = baseURL;
        }

        @Generated
        public String getChaveAPI() {
            return this.chaveAPI;
        }

        @Generated
        public String getChaveAplicacao() {
            return this.chaveAplicacao;
        }

        @Generated
        public String getBaseURL() {
            return this.baseURL;
        }

        @Generated
        public void setChaveAPI(String chaveAPI) {
            this.chaveAPI = chaveAPI;
        }

        @Generated
        public void setChaveAplicacao(String chaveAplicacao) {
            this.chaveAplicacao = chaveAplicacao;
        }

        @Generated
        public void setBaseURL(String baseURL) {
            this.baseURL = baseURL;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parametros)) {
                return false;
            }
            Parametros other = (Parametros)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$chaveAPI = this.getChaveAPI();
            String other$chaveAPI = other.getChaveAPI();
            if (this$chaveAPI == null ? other$chaveAPI != null : !this$chaveAPI.equals(other$chaveAPI)) {
                return false;
            }
            String this$chaveAplicacao = this.getChaveAplicacao();
            String other$chaveAplicacao = other.getChaveAplicacao();
            if (this$chaveAplicacao == null ? other$chaveAplicacao != null : !this$chaveAplicacao.equals(other$chaveAplicacao)) {
                return false;
            }
            String this$baseURL = this.getBaseURL();
            String other$baseURL = other.getBaseURL();
            return !(this$baseURL == null ? other$baseURL != null : !this$baseURL.equals(other$baseURL));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Parametros;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $chaveAPI = this.getChaveAPI();
            result = result * 59 + ($chaveAPI == null ? 43 : $chaveAPI.hashCode());
            String $chaveAplicacao = this.getChaveAplicacao();
            result = result * 59 + ($chaveAplicacao == null ? 43 : $chaveAplicacao.hashCode());
            String $baseURL = this.getBaseURL();
            result = result * 59 + ($baseURL == null ? 43 : $baseURL.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebLojaIntegrada.Parametros(chaveAPI=" + this.getChaveAPI() + ", chaveAplicacao=" + this.getChaveAplicacao() + ", baseURL=" + this.getBaseURL() + ")";
        }
    }

    class WebLojaIntegradaInterceptor
    implements Interceptor {
        private final Parametros parametros;

        public WebLojaIntegradaInterceptor(WebLojaIntegrada this$0, Parametros params) {
            this.parametros = params;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request original = chain.request();
            Request request = original.newBuilder().header("chave_api", this.parametros.getChaveAPI()).header("aplicacao", this.parametros.getChaveAplicacao()).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }
    }
}

