/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtTabProcesso;

import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabprocesso.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabprocesso.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabprocesso.TDadosProc;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabprocesso.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabprocesso.TIdeCadastro;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabprocesso.TIdeProcesso;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabprocesso.TPeriodoValidade;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.math.BigInteger;
import java.util.Date;

public class ImpTabProcesso
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        TabelaProcessosEsoc processo = preEvento.getTabelaProcesso();
        ESocial root = this.getFact().createESocial();
        root.setEvtTabProcesso(this.getTabProcesso(preEvento, processo, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTabProcesso getTabProcesso(EsocPreEvento preEvento, TabelaProcessosEsoc processo, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtTabProcesso evtTabProcesso = this.getFact().createESocialEvtTabProcesso();
        evtTabProcesso.setIdeEmpregador(this.getEmpregador(opcoes));
        evtTabProcesso.setIdeEvento(this.getIdEvento(preEvento, opcoes));
        evtTabProcesso.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evtTabProcesso.setInfoProcesso(this.getInfoProcesso(preEvento, processo));
        return evtTabProcesso;
    }

    private TEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador tEmpregador = this.getFact().createTEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeCadastro getIdEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeCadastro cadastro = this.getFact().createTIdeCadastro();
        cadastro.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private ESocial.EvtTabProcesso.InfoProcesso getInfoProcesso(EsocPreEvento preEvento, TabelaProcessosEsoc processo) {
        ESocial.EvtTabProcesso.InfoProcesso info = this.getFact().createESocialEvtTabProcessoInfoProcesso();
        if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            info.setInclusao(this.getInclusao(processo, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            info.setAlteracao(this.getAlteracao(processo, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            info.setExclusao(this.getExclusao(processo, preEvento));
        }
        return info;
    }

    private ESocial.EvtTabProcesso.InfoProcesso.Inclusao getInclusao(TabelaProcessosEsoc processo, EsocPreEvento preEvento) {
        ESocial.EvtTabProcesso.InfoProcesso.Inclusao inclusao = this.getFact().createESocialEvtTabProcessoInfoProcessoInclusao();
        inclusao.setIdeProcesso(this.getIdProcesso(processo, preEvento));
        inclusao.setDadosProc(this.getDadosProcesso(processo));
        return inclusao;
    }

    private TIdeProcesso getIdProcesso(TabelaProcessosEsoc processo, EsocPreEvento preEvento) {
        TIdeProcesso tiProcesso = this.getFact().createTIdeProcesso();
        tiProcesso.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiProcesso.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        tiProcesso.setTpProc(Byte.parseByte(processo.getIdProcesso().getCodigo()));
        tiProcesso.setNrProc(processo.getNumeroProcesso());
        return tiProcesso;
    }

    private TDadosProc getDadosProcesso(TabelaProcessosEsoc processo) {
        TDadosProc dados = this.getFact().createTDadosProc();
        dados.setIndAutoria(Byte.valueOf(processo.getIndicativoAutoria().toString()));
        dados.setIndMatProc(Byte.parseByte(processo.getMateriaProcesso().getCodigo()));
        if (processo.getObservacoes() != null && processo.getObservacoes().length() > 0) {
            dados.setObservacao(processo.getObservacoes());
        }
        if (processo.getIdProcesso().getCodigo().equals("2")) {
            dados.setDadosProcJud(this.getDadosProcJudicial(processo));
        }
        if (processo.getMateriaProcesso().getCodigo().equals("1")) {
            dados.getInfoSusp().add(this.getInfoSuspensao(processo));
        }
        return dados;
    }

    private TDadosProc.DadosProcJud getDadosProcJudicial(TabelaProcessosEsoc processo) {
        TDadosProc.DadosProcJud dadosProc = this.getFact().createTDadosProcDadosProcJud();
        dadosProc.setCodMunic(new BigInteger(processo.getCidadeVara().getCodIbgeCompleto()));
        dadosProc.setIdVara(new BigInteger(processo.getCodigoIdentificacaoVara()));
        dadosProc.setUfVara(processo.getUfVara().getSigla());
        return dadosProc;
    }

    private ESocial.EvtTabProcesso.InfoProcesso.Alteracao getAlteracao(TabelaProcessosEsoc processo, EsocPreEvento preEvento) {
        ESocial.EvtTabProcesso.InfoProcesso.Alteracao alteracao = this.getFact().createESocialEvtTabProcessoInfoProcessoAlteracao();
        alteracao.setDadosProc(this.getDadosProcesso(processo));
        alteracao.setIdeProcesso(this.getIdProcesso(processo, preEvento));
        alteracao.setNovaValidade(this.getNovaValidade(preEvento));
        return alteracao;
    }

    private TPeriodoValidade getNovaValidade(EsocPreEvento preEvento) {
        TPeriodoValidade tPeriodo = this.getFact().createTPeriodoValidade();
        tPeriodo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tPeriodo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return tPeriodo;
    }

    private ESocial.EvtTabProcesso.InfoProcesso.Exclusao getExclusao(TabelaProcessosEsoc processo, EsocPreEvento preEvento) {
        ESocial.EvtTabProcesso.InfoProcesso.Exclusao exclusao = this.getFact().createESocialEvtTabProcessoInfoProcessoExclusao();
        exclusao.setIdeProcesso(this.getIdProcesso(processo, preEvento));
        return exclusao;
    }

    private TDadosProc.InfoSusp getInfoSuspensao(TabelaProcessosEsoc processo) {
        TDadosProc.InfoSusp info = this.getFact().createTDadosProcInfoSusp();
        info.setCodSusp(new BigInteger(processo.getCodigoIndicativoSuspencao()));
        info.setDtDecisao(ToolEsocial.converteData(processo.getDataDecisao()));
        if (processo.getIndicativoDeposito().equals((short)1)) {
            info.setIndDeposito("S");
        } else {
            info.setIndDeposito("N");
        }
        info.setIndSusp(processo.getIndicativoSuspensao().getCodigo());
        return info;
    }
}

