/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtcontproc;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.BenefPensao;
import com.touchcomp.basementor.model.vo.DeducaoDependente;
import com.touchcomp.basementor.model.vo.DeducaoSuspensaProcesso;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocInfoTributosDecorrentesProcessoTrab;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.IdentificacaoTrabalhador;
import com.touchcomp.basementor.model.vo.InformacaoCodigoReceitaCrontribuicao;
import com.touchcomp.basementor.model.vo.InformacaoCodigoReceitaIRRF;
import com.touchcomp.basementor.model.vo.InformacaoProcessoRetido;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.PensaoAlimenticia;
import com.touchcomp.basementor.model.vo.ValoresCalculoTributario;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcontproc.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcontproc.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcontproc.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.math.BigInteger;
import java.util.Date;

public class ImpEvtContProc
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocInfoTributosDecorrentesProcessoTrab procTrab = preEvento.getInfoTributosDecorrentesProcessoTrab();
        ESocial root = this.getFact().createESocial();
        root.setEvtContProc(this.getEvtContProc(opcoes, preEvento, procTrab));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtContProc getEvtContProc(OpcoesESocial opcoes, EsocPreEvento preEvento, EsocInfoTributosDecorrentesProcessoTrab procTrab) throws ExceptionEsocial {
        ESocial.EvtContProc e = new ESocial.EvtContProc();
        e.setIdeEmpregador(this.getIdEmpregador(opcoes));
        e.setIdeEvento(this.getIdeEvento(preEvento.getEsocEvento(), opcoes));
        e.setIdeProc(this.getIdeProc(procTrab));
        for (IdentificacaoTrabalhador identificacaoTrabalhador : procTrab.getIdeTrab()) {
            e.getIdeTrab().add(this.getIdeTrab(identificacaoTrabalhador));
        }
        e.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        return e;
    }

    private ESocial.EvtContProc.IdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtContProc.IdeEmpregador i = new ESocial.EvtContProc.IdeEmpregador();
        i.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        i.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return i;
    }

    private TIdeEventoTrab getIdeEvento(EsocEvento esocEvento, OpcoesESocial opcoes) {
        TIdeEventoTrab t = new TIdeEventoTrab();
        t.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        t.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        t.setVerProc(this.getVersaoEsocialSistema());
        if (ToolMethods.isEquals((Object)esocEvento.getPreEvento().getEventoRetificacao(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            t.setIndRetif(Byte.parseByte("2"));
            t.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            t.setIndRetif(Byte.parseByte("1"));
        }
        return t;
    }

    private ESocial.EvtContProc.IdeProc getIdeProc(EsocInfoTributosDecorrentesProcessoTrab procTrab) {
        ESocial.EvtContProc.IdeProc i = new ESocial.EvtContProc.IdeProc();
        i.setNrProcTrab(procTrab.getNrProcTrab());
        i.setPerApurPgto(ToolDate.formatDateAnoMes((Date)procTrab.getPerApurPgto()));
        i.setObs(procTrab.getObs());
        return i;
    }

    private ESocial.EvtContProc.IdeTrab getIdeTrab(IdentificacaoTrabalhador identificacaoTrabalhador) {
        ESocial.EvtContProc.IdeTrab i = new ESocial.EvtContProc.IdeTrab();
        i.setCpfTrab(identificacaoTrabalhador.getProcesso().getRecisao().getColaborador().getPessoa().getComplemento().getCnpj());
        for (ValoresCalculoTributario valoresCalculoTributario : identificacaoTrabalhador.getValorCalcTrib()) {
            i.getCalcTrib().add(this.getCalcTrib(valoresCalculoTributario));
        }
        for (InformacaoCodigoReceitaIRRF informacaoCodigoReceitaIRRF : identificacaoTrabalhador.getInfoCRIRRF()) {
            i.getInfoCRIRRF().add(this.getInfoCRIRRF(informacaoCodigoReceitaIRRF));
        }
        if (ToolMethods.isNotNull((Object)identificacaoTrabalhador.getDtLaudo()).booleanValue()) {
            i.setInfoIRComplem(this.getInfoIRComplem(identificacaoTrabalhador));
        }
        return i;
    }

    private ESocial.EvtContProc.IdeTrab.CalcTrib getCalcTrib(ValoresCalculoTributario valoresCalculoTributario) {
        ESocial.EvtContProc.IdeTrab.CalcTrib c = new ESocial.EvtContProc.IdeTrab.CalcTrib();
        c.setPerRef(ToolDate.formatDateAnoMes((Date)valoresCalculoTributario.getPerRef()));
        c.setVrBcCpMensal(ToolFormatter.arrredondarNumeroBigDecimal((Double)valoresCalculoTributario.getVrBcCpMensal(), (int)2));
        c.setVrBcCp13(ToolFormatter.arrredondarNumeroBigDecimal((Double)valoresCalculoTributario.getVrBcCp13(), (int)2));
        for (InformacaoCodigoReceitaCrontribuicao informacaoCodigoReceitaCrontribuicao : valoresCalculoTributario.getInfCodReceita()) {
            c.getInfoCRContrib().add(this.getInfoCRContrib(informacaoCodigoReceitaCrontribuicao));
        }
        return c;
    }

    private ESocial.EvtContProc.IdeTrab.CalcTrib.InfoCRContrib getInfoCRContrib(InformacaoCodigoReceitaCrontribuicao informacaoCodigoReceitaCrontribuicao) {
        ESocial.EvtContProc.IdeTrab.CalcTrib.InfoCRContrib i = new ESocial.EvtContProc.IdeTrab.CalcTrib.InfoCRContrib();
        i.setTpCR(new BigInteger(informacaoCodigoReceitaCrontribuicao.getTpCR()));
        i.setVrCR(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaCrontribuicao.getVrCR(), (int)2));
        return i;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF getInfoCRIRRF(InformacaoCodigoReceitaIRRF informacaoCodigoReceitaIRRF) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF i = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF();
        i.setTpCR(new BigInteger(informacaoCodigoReceitaIRRF.getTpCR()));
        i.setVrCR(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrCR(), (int)2));
        i.setInfoIR(this.getInfoIR(informacaoCodigoReceitaIRRF));
        for (DeducaoDependente deducaoDependente : informacaoCodigoReceitaIRRF.getDedDepen()) {
            i.getDedDepen().add(this.getDedDepen(deducaoDependente));
        }
        for (InformacaoProcessoRetido informacaoProcessoRetido : informacaoCodigoReceitaIRRF.getInfoProcRet()) {
            i.getInfoProcRet().add(this.getInfoProcRet(informacaoProcessoRetido));
        }
        for (PensaoAlimenticia pensaoAlimenticia : informacaoCodigoReceitaIRRF.getPenAlim()) {
            i.getPenAlim().add(this.getPenAlim(pensaoAlimenticia));
        }
        return i;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoIR getInfoIR(InformacaoCodigoReceitaIRRF informacaoCodigoReceitaIRRF) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoIR i = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoIR();
        i.setDescIsenNTrib(informacaoCodigoReceitaIRRF.getDescIsenNTrib());
        i.setVrJurosMora(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrJurosMora(), (int)2));
        i.setVrPrevOficial(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrPrevOficial(), (int)2));
        i.setVrRendIsen65(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrRendIsen65(), (int)2));
        i.setVrRendIsenNTrib(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrRendIsenNTrib(), (int)2));
        i.setVrRendMoleGrave(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrRendMoleGrave(), (int)2));
        i.setVrRendTrib(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrRendTrib(), (int)2));
        i.setVrRendTrib13(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoCodigoReceitaIRRF.getVrRendTrib13(), (int)2));
        return i;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF.DedDepen getDedDepen(DeducaoDependente deducaoDependente) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF.DedDepen d = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF.DedDepen();
        d.setTpRend(Byte.valueOf(String.valueOf(deducaoDependente.getTpRend())));
        d.setCpfDep(deducaoDependente.getCpfDep());
        d.setVlrDeducao(ToolFormatter.arrredondarNumeroBigDecimal((Double)deducaoDependente.getVlrDeducao(), (int)2));
        return d;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet getInfoProcRet(InformacaoProcessoRetido informacaoProcessoRetido) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet i = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet();
        i.setTpProcRet(Byte.valueOf(String.valueOf(informacaoProcessoRetido.getTpProcRet())));
        i.setNrProcRet(informacaoProcessoRetido.getNrProcRet());
        i.setCodSusp(new BigInteger(informacaoProcessoRetido.getCodSusp()));
        i.getInfoValores().add(this.getInfoValores(informacaoProcessoRetido));
        return i;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores getInfoValores(InformacaoProcessoRetido informacaoProcessoRetido) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores i = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores();
        i.setIndApuracao(Byte.valueOf(String.valueOf(informacaoProcessoRetido.getIndApuracao())));
        i.setVlrNRetido(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoProcessoRetido.getVlrNRetido(), (int)2));
        i.setVlrDepJud(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoProcessoRetido.getVlrDepJud(), (int)2));
        i.setVlrCmpAnoCal(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoProcessoRetido.getVlrCmpAnoCal(), (int)2));
        i.setVlrCmpAnoAnt(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoProcessoRetido.getVlrCmpAnoAnt(), (int)2));
        i.setVlrRendSusp(ToolFormatter.arrredondarNumeroBigDecimal((Double)informacaoProcessoRetido.getVlrRendSusp(), (int)2));
        for (DeducaoSuspensaProcesso deducaoSuspensaProcesso : informacaoProcessoRetido.getDedSusp()) {
            i.getDedSusp().add(this.getDedSusp(deducaoSuspensaProcesso));
        }
        return i;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores.DedSusp getDedSusp(DeducaoSuspensaProcesso deducaoSuspensaProcesso) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores.DedSusp d = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores.DedSusp();
        d.setIndTpDeducao(Byte.valueOf(String.valueOf(deducaoSuspensaProcesso.getIndTpDeducao())));
        d.setVlrDedSusp(ToolFormatter.arrredondarNumeroBigDecimal((Double)deducaoSuspensaProcesso.getVlrDedSusp(), (int)2));
        for (BenefPensao benefPensao : deducaoSuspensaProcesso.getBenefPen()) {
            d.getBenefPen().add(this.getBenefPen(benefPensao));
        }
        return d;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores.DedSusp.BenefPen getBenefPen(BenefPensao benefPensao) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores.DedSusp.BenefPen b = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF.InfoProcRet.InfoValores.DedSusp.BenefPen();
        b.setCpfDep(benefPensao.getCpfBenef());
        b.setVlrDepenSusp(ToolFormatter.arrredondarNumeroBigDecimal((Double)benefPensao.getVlrDepenSusp(), (int)2));
        return b;
    }

    private ESocial.EvtContProc.IdeTrab.InfoCRIRRF.PenAlim getPenAlim(PensaoAlimenticia pensaoAlimenticia) {
        ESocial.EvtContProc.IdeTrab.InfoCRIRRF.PenAlim p = new ESocial.EvtContProc.IdeTrab.InfoCRIRRF.PenAlim();
        p.setTpRend(Byte.valueOf(String.valueOf(pensaoAlimenticia.getTpRend())));
        p.setCpfDep(pensaoAlimenticia.getCpfDep());
        p.setVlrPensao(ToolFormatter.arrredondarNumeroBigDecimal((Double)pensaoAlimenticia.getVlrPensao(), (int)2));
        return p;
    }

    private ESocial.EvtContProc.IdeTrab.InfoIRComplem getInfoIRComplem(IdentificacaoTrabalhador identificacaoTrabalhador) {
        ESocial.EvtContProc.IdeTrab.InfoIRComplem i = new ESocial.EvtContProc.IdeTrab.InfoIRComplem();
        i.setDtLaudo(ToolEsocial.converteData(identificacaoTrabalhador.getDtLaudo()));
        return i;
    }
}

