/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtdesligamento;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocRubricaIrrf;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.ItemRecisaoComplementarPeriodo;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.PagamentoFolhaCompColaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.RecisaoComplementarPeriodo;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.Rubricas2299;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TDescFolha;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TDetVerbasDescFolha;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeEstabLot;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeEstabLotInfoPerAnt;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeEventoTrabIndGuia;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeVinculo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TInfoAgNocivo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TInfoInterm;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TInfoSimples;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.util.Date;

public class ImpEvtDesligamento
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtDeslig(this.getEvtDesligamento(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtDeslig getEvtDesligamento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtDeslig evt = this.getFact().createESocialEvtDeslig();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.geEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(preEvento.getEsocEvento(), opcoes));
        evt.setIdeVinculo(this.getVinculo(preEvento.getRecisao().getColaborador()));
        evt.setInfoDeslig(this.getInfoDesligamento(preEvento, opcoes));
        return evt;
    }

    private TIdeEmpregador geEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrabIndGuia getIdEvento(EsocEvento esocEvento, OpcoesESocial opcoes) {
        TIdeEventoTrabIndGuia tiTrab = this.getFact().createTIdeEventoTrabIndGuia();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private TIdeVinculo getVinculo(Colaborador colaborador) {
        TIdeVinculo vinculo = this.getFact().createTIdeVinculo();
        vinculo.setCpfTrab(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj()));
        vinculo.setMatricula(colaborador.getNumeroRegistroESocial());
        return vinculo;
    }

    private ESocial.EvtDeslig.InfoDeslig getInfoDesligamento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        Recisao recisao = preEvento.getRecisao();
        ESocial.EvtDeslig.InfoDeslig desligamento = this.getFact().createESocialEvtDesligInfoDeslig();
        desligamento.setMtvDeslig(recisao.getCadastroRecisao().getEsocMotivoDesligamento().getCodigo());
        desligamento.setDtDeslig(ToolEsocial.converteData(recisao.getDataAfastamento()));
        desligamento.setDtAvPrv(ToolEsocial.converteData(recisao.getDataDemissao()));
        if (recisao.getAvisoIndenizado().equals((short)0)) {
            desligamento.setIndPagtoAPI(TSSimNao.S);
            desligamento.setDtProjFimAPI(ToolEsocial.converteData(recisao.getDataFimAviso()));
        } else {
            desligamento.setIndPagtoAPI(TSSimNao.N);
        }
        if (recisao.getIndicativoPagamentoAviso().equals((short)1)) {
            desligamento.setDtProjFimAPI(ToolEsocial.converteData(recisao.getDataFimAviso()));
        }
        desligamento.setPensAlim(Byte.valueOf(recisao.getIndicativoPensao().getCodigo()));
        if (recisao.getPercPensao() > 0.0) {
            desligamento.setPercAliment(ToolFormatter.arrredondarNumeroBigDecimal((Double)recisao.getPercPensao(), (int)2));
        }
        if (recisao.getValorPensao() > 0.0) {
            desligamento.setVrAlim(ToolFormatter.arrredondarNumeroBigDecimal((Double)recisao.getValorPensao(), (int)2));
        }
        if (recisao.getNumeroProcTrabalhista() != null && !recisao.getNumeroProcTrabalhista().isEmpty()) {
            desligamento.setNrProcTrab(recisao.getNumeroProcTrabalhista());
        }
        if (recisao.getObservacoes() != null && !recisao.getObservacoes().isEmpty()) {
            desligamento.getObservacoes().add(this.createObservacoes(recisao.getObservacoes()));
        }
        if (recisao.getDataAfastamento().after(this.getInicioObrigatoriedadeProducao(opcoes)) && this.verificarInsercaoRubricas(recisao)) {
            desligamento.setVerbasResc(this.getInfoVerbas(recisao, opcoes, preEvento));
        }
        if (recisao.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            desligamento.getInfoInterm().add(this.createInfoIntermitente(recisao));
        }
        return desligamento;
    }

    private Date getInicioObrigatoriedadeProducao(OpcoesESocial opcoes) {
        return opcoes.getDataTerceiraFase();
    }

    private String getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return "S";
        }
        return "N";
    }

    private ESocial.EvtDeslig.InfoDeslig.Observacoes createObservacoes(String observacoes) {
        ESocial.EvtDeslig.InfoDeslig.Observacoes o = this.getFact().createESocialEvtDesligInfoDesligObservacoes();
        o.setObservacao(observacoes);
        return o;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc getInfoVerbas(Recisao recisao, OpcoesESocial opcoes, EsocPreEvento esoc) throws ExceptionEsocial {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc verbas = this.getFact().createESocialEvtDesligInfoDesligVerbasResc();
        verbas.getDmDev().add(this.getDmDev(recisao, opcoes, esoc));
        if (esoc.getMovimentoFolhaRecisao() != null) {
            verbas.getDmDev().add(this.getDmDevFolhaAdd(esoc.getMovimentoFolhaRecisao(), opcoes, esoc));
        }
        return verbas;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev getDmDev(Recisao recisao, OpcoesESocial opcoes, EsocPreEvento esoc) throws ExceptionEsocial {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev dm = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDev();
        dm.setIdeDmDev(recisao.getIdentificador().toString());
        if (recisao.getRecisaoComplementar().equals((short)0)) {
            dm.setInfoPerApur(this.getPeriodoApuracao(recisao, opcoes));
        } else {
            dm.setInfoPerAnt(this.getPeriodoApuracaoAnterior(recisao, opcoes));
        }
        if (esoc.getFolhaComplementar() != null) {
            dm.setInfoPerAnt(this.getInfoAnteriorFolhaComplementar(esoc.getFolhaComplementar(), opcoes));
        }
        return dm;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerApur getPeriodoApuracao(Recisao recisao, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerApur info = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerApur();
        info.getIdeEstabLot().add(this.getEstLotacao(recisao, opcoes));
        return info;
    }

    private TIdeEstabLot getEstLotacao(Recisao recisao, OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEstabLot idEst = this.getFact().createTIdeEstabLot();
        idEst.setTpInsc(Byte.parseByte("1"));
        idEst.setNrInsc(recisao.getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj());
        idEst.setCodLotacao(recisao.getColaborador().getLotacaoTributaria().getCodigo());
        for (Rubricas2299 r : recisao.getRubricas()) {
            if (!(r.getValorRubrica() > 0.0) || r.getTipoCalculo().getEvento().getCodigo().equals(ConstantsESocial.LIQUIDO_DESLIGAMENTO)) continue;
            idEst.getDetVerbas().add(this.getVerbas(r));
        }
        idEst.setInfoAgNocivo(this.getInfoAgNocivo(recisao.getColaborador()));
        if (opcoes.getClassificacaoTributaria().getCodigo().equals("03")) {
            idEst.setInfoSimples(this.getInfoSimples(opcoes.getClassificacaoTributaria().getCodigo()));
        }
        return idEst;
    }

    private TDetVerbasDescFolha getVerbas(Rubricas2299 r) throws ExceptionEsocial {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
        TDetVerbasDescFolha det = this.getFact().createTDetVerbasDescFolha();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
        }
        if (r.getFatorRubrica() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getFatorRubrica(), (int)2));
        }
        det.setIndApurIR(Byte.valueOf("0"));
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValorRubrica(), (int)2));
        if (r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.EMPRESTIMO_ESOCIAL_ECONSIGNADO) && r.getConsignado() == null) {
            throw new ExceptionEsocial("Emprestimo Consignado nao informado no Desligamento.");
        }
        if (r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.EMPRESTIMO_ESOCIAL_ECONSIGNADO)) {
            det.setDescFolha(this.getDescFolha(r));
        }
        return det;
    }

    private TInfoAgNocivo getInfoAgNocivo(Colaborador colaborador) {
        TInfoAgNocivo infoAg = this.getFact().createTInfoAgNocivo();
        infoAg.setGrauExp(Byte.parseByte(colaborador.getGrauExposicao().getCodigo()));
        return infoAg;
    }

    private TInfoSimples getInfoSimples(String codigo) {
        TInfoSimples infoSimples = this.getFact().createTInfoSimples();
        infoSimples.setIndSimples(Byte.parseByte(codigo));
        return infoSimples;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt getPeriodoApuracaoAnterior(Recisao recisao, OpcoesESocial opcoes) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt infoAnt = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerAnt();
        infoAnt.getIdeADC().add(this.criarIdeAc(recisao, opcoes));
        return infoAnt;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC criarIdeAc(Recisao recisao, OpcoesESocial opcoes) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC ideAdc = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerAntIdeADC();
        ideAdc.setDtAcConv(ToolEsocial.converteData(recisao.getRecisaoComplementarAc().getDataAcordo()));
        ideAdc.setTpAcConv(recisao.getRecisaoComplementarAc().getTipoAcordoConvencao().getCodigo());
        ideAdc.setDsc(recisao.getRecisaoComplementarAc().getTipoAcordoConvencao().getDescricao());
        for (RecisaoComplementarPeriodo r : recisao.getRecisaoComplementarAc().getRecisaoPeriodo()) {
            ideAdc.getIdePeriodo().add(this.getPeriodo(r, opcoes));
        }
        return ideAdc;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC.IdePeriodo getPeriodo(RecisaoComplementarPeriodo r, OpcoesESocial opcoes) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC.IdePeriodo idePeriodo = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerAntIdeADCIdePeriodo();
        idePeriodo.setPerRef(ToolDate.formatDateAnoMes((Date)r.getPeriodo()));
        idePeriodo.getIdeEstabLot().add(this.getEstLotacaoAnt(r, opcoes));
        return idePeriodo;
    }

    private TIdeEstabLotInfoPerAnt getEstLotacaoAnt(RecisaoComplementarPeriodo r, OpcoesESocial opcoes) {
        TIdeEstabLotInfoPerAnt idEst = this.getFact().createTIdeEstabLotInfoPerAnt();
        idEst.setTpInsc(Byte.parseByte("1"));
        idEst.setNrInsc(r.getRecisaoComplementar().getRecisaoOriginal().getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj());
        idEst.setCodLotacao(r.getRecisaoComplementar().getRecisaoOriginal().getColaborador().getLotacaoTributaria().getCodigo());
        for (ItemRecisaoComplementarPeriodo rr : r.getRecisaoPeriodo()) {
            if (rr.getTipoCalculoEvento().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA) || !(rr.getValor() > 0.0) || rr.getTipoCalculoEvento().getEvento().getCodigo().equals(ConstantsESocial.LIQUIDO_DESLIGAMENTO)) continue;
            idEst.getDetVerbas().add(this.getVerbasAnterior(rr));
        }
        idEst.setInfoAgNocivo(this.getInfoAgNocivoAnt(r.getRecisaoComplementar().getRecisaoOriginal().getColaborador()));
        if (opcoes.getClassificacaoTributaria().getCodigo().equals("01") || opcoes.getClassificacaoTributaria().getCodigo().equals("02") || opcoes.getClassificacaoTributaria().getCodigo().equals("03")) {
            idEst.setInfoSimples(this.getInfoSimplesAnterior(opcoes.getClassificacaoTributaria().getCodigo()));
        }
        return idEst;
    }

    private TDetVerbasDescFolha getVerbasAnt(ItemMovimentoRescisao item) {
        TipoCalculoEvento tipoCalculo = item.getEventoColaborador().getTipoCalculoEvento();
        TDetVerbasDescFolha det = this.getFact().createTDetVerbasDescFolha();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
            det.setIndApurIR(Byte.valueOf("0"));
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
            det.setIndApurIR(Byte.valueOf("0"));
        }
        if (item.getReferencia() > 0.0) {
            det.setQtdRubr(new BigDecimal(item.getReferencia()));
        }
        det.setIndApurIR(Byte.valueOf("0"));
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)item.getValor(), (int)2));
        return det;
    }

    private TInfoAgNocivo getInfoAgNocivoAnt(Colaborador colaborador) {
        TInfoAgNocivo infoAg = this.getFact().createTInfoAgNocivo();
        infoAg.setGrauExp(Byte.parseByte(colaborador.getGrauExposicao().getCodigo()));
        return infoAg;
    }

    private boolean getRubricaDifIrrf(EsocRubricaIrrf esocRubricaIrrf) {
        String codigoIrrf = esocRubricaIrrf.getCodigo();
        return !codigoIrrf.equals("31") && !codigoIrrf.equals("32") && !codigoIrrf.equals("33") && !codigoIrrf.equals("34") && !codigoIrrf.equals("35") && !codigoIrrf.equals("51") && !codigoIrrf.equals("52") && !codigoIrrf.equals("53") && !codigoIrrf.equals("54") && !codigoIrrf.equals("55") && !codigoIrrf.equals("81") && !codigoIrrf.equals("82") && !codigoIrrf.equals("83");
    }

    private boolean verificarInsercaoRubricas(Recisao recisao) {
        boolean retValue = false;
        for (Rubricas2299 r : recisao.getRubricas()) {
            if (!(r.getValorRubrica() > 0.0)) continue;
            return true;
        }
        return retValue;
    }

    private TDetVerbasDescFolha getVerbasAnterior(ItemRecisaoComplementarPeriodo r) {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculoEvento();
        TDetVerbasDescFolha det = this.getFact().createTDetVerbasDescFolha();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
            det.setIndApurIR(Byte.valueOf("0"));
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
            det.setIndApurIR(Byte.valueOf("0"));
        }
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValor(), (int)2));
        return det;
    }

    private TInfoSimples getInfoSimplesAnterior(String codigo) {
        TInfoSimples infoSimples = this.getFact().createTInfoSimples();
        infoSimples.setIndSimples(Byte.parseByte(codigo));
        return infoSimples;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt getInfoAnteriorFolhaComplementar(PagamentoFolhaCompColaborador folhaComplementar, OpcoesESocial opcoes) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt infoAnt = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerAnt();
        infoAnt.getIdeADC().add(this.criarIdeAcAnterior(folhaComplementar, opcoes));
        return infoAnt;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC criarIdeAcAnterior(PagamentoFolhaCompColaborador folhaComplementar, OpcoesESocial opcoes) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC ideAdc = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerAntIdeADC();
        ideAdc.setDtAcConv(ToolEsocial.converteData(folhaComplementar.getCalculoComplementoSalario().getDataAcordo()));
        ideAdc.setTpAcConv(folhaComplementar.getCalculoComplementoSalario().getTipoAcordoConvencao().getCodigo());
        ideAdc.setDsc(folhaComplementar.getCalculoComplementoSalario().getDescricao());
        for (FolhaComplementarPeriodo f : folhaComplementar.getFolhaComplementares()) {
            ideAdc.getIdePeriodo().add(this.getPeriodoAnterior(f, opcoes));
        }
        return ideAdc;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC.IdePeriodo getPeriodoAnterior(FolhaComplementarPeriodo f, OpcoesESocial opcoes) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerAnt.IdeADC.IdePeriodo idePeriodo = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerAntIdeADCIdePeriodo();
        idePeriodo.setPerRef(ToolDate.formatDateAnoMes((Date)f.getPeriodo()));
        idePeriodo.getIdeEstabLot().add(this.getEstLotacaoAnterior(f, opcoes));
        return idePeriodo;
    }

    private TIdeEstabLotInfoPerAnt getEstLotacaoAnterior(FolhaComplementarPeriodo f, OpcoesESocial opcoes) {
        TIdeEstabLotInfoPerAnt idEst = this.getFact().createTIdeEstabLotInfoPerAnt();
        idEst.setTpInsc(Byte.parseByte("1"));
        idEst.setNrInsc(f.getPagamentoComplementar().getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj());
        idEst.setCodLotacao(f.getPagamentoComplementar().getColaborador().getLotacaoTributaria().getCodigo());
        for (FolhaComplementarPeriodoItem ff : f.getFolhaComplementarPeriodoItem()) {
            if (ff.getTipoCalculoEvento().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA) || !(ff.getValorComplemento() > 0.0) || !this.getRubricaDifIrrf(ff.getTipoCalculoEvento().getEsocRubricaIrrf()) || ff.getTipoCalculoEvento().getEvento().getCodigo().equals(ConstantsESocial.LIQUIDO_DESLIGAMENTO)) continue;
            idEst.getDetVerbas().add(this.getVerbasAnteriorFolha(ff));
        }
        if (f.getVrInss() > 0.0) {
            TipoCalculoEvento tp = opcoes.getEmpresaRh().getTpInss();
            TDetVerbasDescFolha det = this.getFact().createTDetVerbasDescFolha();
            if (tp.getEvento().getInformarCodigoEsocial().equals((short)0)) {
                det.setCodRubr(tp.getEvento().getCodigo().toString());
                det.setIdeTabRubr(tp.getEvento().getIdentificador().toString());
                det.setIndApurIR(Byte.valueOf("0"));
            } else {
                det.setCodRubr(tp.getEvento().getCodigoEsocial());
                det.setIdeTabRubr(tp.getEvento().getIdeTabelaRubrica());
                det.setIndApurIR(Byte.valueOf("0"));
            }
            det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)f.getVrInss(), (int)2));
            idEst.getDetVerbas().add(det);
        }
        idEst.setInfoAgNocivo(this.getInfoAgNocivoAnt(f.getPagamentoComplementar().getColaborador()));
        if (opcoes.getClassificacaoTributaria().getCodigo().equals("01") || opcoes.getClassificacaoTributaria().getCodigo().equals("02") || opcoes.getClassificacaoTributaria().getCodigo().equals("03")) {
            idEst.setInfoSimples(this.getInfoSimplesAnterior(opcoes.getClassificacaoTributaria().getCodigo()));
        }
        return idEst;
    }

    private TDetVerbasDescFolha getVerbasAnteriorFolha(FolhaComplementarPeriodoItem ff) {
        TipoCalculoEvento tipoCalculo = ff.getTipoCalculoEvento();
        TDetVerbasDescFolha det = this.getFact().createTDetVerbasDescFolha();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
            det.setIndApurIR(Byte.valueOf("0"));
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
            det.setIndApurIR(Byte.valueOf("0"));
        }
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)ff.getValorComplemento(), (int)2));
        return det;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev getDmDevFolhaAdd(MovimentoFolha m, OpcoesESocial opcoes, EsocPreEvento esoc) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev dm = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDev();
        dm.setIdeDmDev(m.getIdentificador().toString());
        dm.setInfoPerApur(this.getPeriodoApuracao(m, opcoes));
        if (esoc.getFolhaComplementar() != null) {
            dm.setInfoPerAnt(this.getInfoAnteriorFolhaComplementar(esoc.getFolhaComplementar(), opcoes));
        }
        return dm;
    }

    private ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerApur getPeriodoApuracao(MovimentoFolha m, OpcoesESocial opcoes) {
        ESocial.EvtDeslig.InfoDeslig.VerbasResc.DmDev.InfoPerApur info = this.getFact().createESocialEvtDesligInfoDesligVerbasRescDmDevInfoPerApur();
        info.getIdeEstabLot().add(this.getEstLotacao(m, opcoes));
        return info;
    }

    private TIdeEstabLot getEstLotacao(MovimentoFolha m, OpcoesESocial opcoes) {
        TIdeEstabLot idEst = this.getFact().createTIdeEstabLot();
        idEst.setTpInsc(Byte.parseByte("1"));
        idEst.setNrInsc(m.getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj());
        idEst.setCodLotacao(m.getColaborador().getLotacaoTributaria().getCodigo());
        for (Rubricas1200 r : m.getRubricas1200()) {
            if (!(r.getValorRubrica() > 0.0) || r.getTipoCalculo().getEvento().getCodigo().equals(ConstantsESocial.LIQUIDO_DESLIGAMENTO)) continue;
            idEst.getDetVerbas().add(this.getVerbas(r));
        }
        idEst.setInfoAgNocivo(this.getInfoAgNocivo(m.getColaborador()));
        if (opcoes.getClassificacaoTributaria().getCodigo().equals("03")) {
            idEst.setInfoSimples(this.getInfoSimples(opcoes.getClassificacaoTributaria().getCodigo()));
        }
        return idEst;
    }

    private TDetVerbasDescFolha getVerbas(Rubricas1200 r) {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
        TDetVerbasDescFolha det = this.getFact().createTDetVerbasDescFolha();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
        }
        if (r.getFatorRubrica() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getFatorRubrica(), (int)2));
        }
        det.setIndApurIR(Byte.valueOf("0"));
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValorRubrica(), (int)2));
        return det;
    }

    private TInfoInterm createInfoIntermitente(Recisao recisao) {
        TInfoInterm info = this.getFact().createTInfoInterm();
        info.setDia(recisao.getDiasContratoIntermitente().byteValue());
        return info;
    }

    private TDescFolha getDescFolha(Rubricas2299 r) throws ExceptionEsocial {
        TDescFolha dest = this.getFact().createTDescFolha();
        if (r.getConsignado().getCodigoBanco().isEmpty()) {
            throw new ExceptionEsocial("Informe o Codigo do Banco no Cadastro do Emprestimo referente ao evento:" + r.getTipoCalculo().getEvento().getDescricao());
        }
        if (r.getConsignado().getNumeroContratoEmprestimo().isEmpty()) {
            throw new ExceptionEsocial("Informe o numero do Contrato no Cadastro do Emprestimo referente ao evento:" + r.getTipoCalculo().getEvento().getDescricao());
        }
        dest.setInstFinanc(r.getConsignado().getCodigoBanco());
        dest.setNrDoc(r.getConsignado().getNumeroContratoEmprestimo());
        dest.setTpDesc(Byte.parseByte("1"));
        return dest;
    }
}

