/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtexclusaoeventos;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ExclusaoEventosEsocial;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexclusao.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexclusao.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexclusao.v_s_01_03_00.TIdeEmpregadorExclusao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexclusao.v_s_01_03_00.TIdeEventoExclusao;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;

public class ImpEvtExclusaoEventos
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtExclusao(this.getEvtExclusao(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtExclusao getEvtExclusao(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtExclusao evt = this.getFact().createESocialEvtExclusao();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento, opcoes));
        evt.setInfoExclusao(this.getInfoExclusao(preEvento));
        return evt;
    }

    private TIdeEmpregadorExclusao getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregadorExclusao tEmpregador = this.getFact().createTIdeEmpregadorExclusao();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private ESocial.EvtExclusao.InfoExclusao getInfoExclusao(EsocPreEvento preEvento) {
        ExclusaoEventosEsocial exclusao = preEvento.getExclusaoEventos();
        ESocial.EvtExclusao.InfoExclusao infoExclusao = this.getFact().createESocialEvtExclusaoInfoExclusao();
        infoExclusao.setNrRecEvt(exclusao.getNumeroRecibo());
        infoExclusao.setTpEvento(exclusao.getTipoEventoEsocial().getCodigo().trim());
        if (exclusao.getColaborador() != null) {
            infoExclusao.setIdeTrabalhador(this.getIdeTrabalhador(exclusao.getColaborador()));
        } else if (exclusao.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2190)) {
            infoExclusao.setIdeTrabalhador(this.getIdeTrabalhadorAdmissaoPreliminar(exclusao));
        }
        if (exclusao.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1210) || exclusao.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1200) || exclusao.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1280) || exclusao.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1250)) {
            infoExclusao.setIdeFolhaPagto(this.getIdeFolhaPagamento(exclusao));
        }
        return infoExclusao;
    }

    private ESocial.EvtExclusao.InfoExclusao.IdeTrabalhador getIdeTrabalhador(Colaborador colaborador) {
        ESocial.EvtExclusao.InfoExclusao.IdeTrabalhador ideTrabalhador = this.getFact().createESocialEvtExclusaoInfoExclusaoIdeTrabalhador();
        ideTrabalhador.setCpfTrab(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj()));
        return ideTrabalhador;
    }

    private ESocial.EvtExclusao.InfoExclusao.IdeTrabalhador getIdeTrabalhadorAdmissaoPreliminar(ExclusaoEventosEsocial e) {
        ESocial.EvtExclusao.InfoExclusao.IdeTrabalhador ideTrabalhador = this.getFact().createESocialEvtExclusaoInfoExclusaoIdeTrabalhador();
        ideTrabalhador.setCpfTrab(ToolString.refina((String)e.getCpf()));
        return ideTrabalhador;
    }

    private TIdeEventoExclusao getIdeEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeEventoExclusao tiTrab = this.getFact().createTIdeEventoExclusao();
        tiTrab.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        return tiTrab;
    }

    private ESocial.EvtExclusao.InfoExclusao.IdeFolhaPagto getIdeFolhaPagamento(ExclusaoEventosEsocial exclusao) {
        ESocial.EvtExclusao.InfoExclusao.IdeFolhaPagto i = this.getFact().createESocialEvtExclusaoInfoExclusaoIdeFolhaPagto();
        if (exclusao.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1200) || exclusao.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1280)) {
            i.setIndApuracao(Byte.valueOf("1"));
        }
        i.setPerApur(DateUtil.formatDate((Date)exclusao.getPeriodoApuracao(), (String)"yyyy-MM"));
        return i;
    }
}

