/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtexprisco;

import com.touchcomp.basementor.model.vo.EsocCondAmbTrabAmbTrab;
import com.touchcomp.basementor.model.vo.EsocCondAmbTrabEquipIn;
import com.touchcomp.basementor.model.vo.EsocCondAmbTrabFatRisco;
import com.touchcomp.basementor.model.vo.EsocCondAmbTrabMedico;
import com.touchcomp.basementor.model.vo.EsocCondicoesAmbientaisTrabalho;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexprisco.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexprisco.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexprisco.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexprisco.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexprisco.v_s_01_03_00.TIdeVinculoSst;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexprisco.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtexprisco.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;

public class ImpExpRisco
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocCondicoesAmbientaisTrabalho vo = preEvento.getCondicoes();
        ESocial root = this.getFact().createESocial();
        root.setEvtExpRisco(this.getEvtRiscoCondicoes(preEvento, opcoes, vo));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtExpRisco getEvtRiscoCondicoes(EsocPreEvento preEvento, OpcoesESocial opcoes, EsocCondicoesAmbientaisTrabalho vo) throws ExceptionEsocial {
        ESocial.EvtExpRisco evt = this.getFact().createESocialEvtExpRisco();
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEvento(this.getIdeEvento(preEvento, opcoes));
        evt.setIdeVinculo(this.getVinculoColaborador(vo));
        evt.setInfoExpRisco(this.getInfoExpRisco(vo));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getIdeEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeEventoTrab cadastro = this.getFact().createTIdeEventoTrab();
        cadastro.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif(Byte.parseByte("2"));
            cadastro.setNrRecibo(preEvento.getNumeroReciboRetificado());
        } else {
            cadastro.setIndRetif(Byte.parseByte("1"));
        }
        return cadastro;
    }

    private TIdeVinculoSst getVinculoColaborador(EsocCondicoesAmbientaisTrabalho pre) {
        TIdeVinculoSst evt = this.getFact().createTIdeVinculoSst();
        evt.setCpfTrab(pre.getColaborador().getPessoa().getComplemento().getCnpj());
        evt.setMatricula(pre.getColaborador().getNumeroRegistroESocial());
        return evt;
    }

    private ESocial.EvtExpRisco.InfoExpRisco getInfoExpRisco(EsocCondicoesAmbientaisTrabalho vo) throws ExceptionEsocial {
        ESocial.EvtExpRisco.InfoExpRisco info = this.getFact().createESocialEvtExpRiscoInfoExpRisco();
        info.setDtIniCondicao(ToolEsocial.converteData(vo.getDataInicio()));
        info.getInfoAmb().add(this.getInfoAmb(vo));
        info.setInfoAtiv(this.getInfoAtividade(vo));
        for (EsocCondAmbTrabFatRisco esoc : vo.getEsocCondAmbTrabFatRisco()) {
            info.getAgNoc().add(this.createInfoRisco(esoc));
        }
        for (EsocCondAmbTrabFatRisco esoc : vo.getEsocCondAmbTrabMedico()) {
            info.getRespReg().add(this.createResponsavel((EsocCondAmbTrabMedico)esoc));
        }
        return info;
    }

    private ESocial.EvtExpRisco.InfoExpRisco.InfoAmb getInfoAmb(EsocCondicoesAmbientaisTrabalho vo) {
        ESocial.EvtExpRisco.InfoExpRisco.InfoAmb info = this.getFact().createESocialEvtExpRiscoInfoExpRiscoInfoAmb();
        info.setLocalAmb(Byte.parseByte(((EsocCondAmbTrabAmbTrab)vo.getEsocCondAmbTrabAmbTrab().get(0)).getEsocAmbienteTrabalho().getEsocLocalAmbiente().getCodigo()));
        if (((EsocCondAmbTrabAmbTrab)vo.getEsocCondAmbTrabAmbTrab().get(0)).getEsocAmbienteTrabalho().getDescricaoAmbiente().length() < 100) {
            info.setDscSetor(ToolString.clearSpecialCharacXML((String)((EsocCondAmbTrabAmbTrab)vo.getEsocCondAmbTrabAmbTrab().get(0)).getEsocAmbienteTrabalho().getDescricaoAmbiente()));
        } else {
            info.setDscSetor(ToolString.clearSpecialCharacXML((String)((EsocCondAmbTrabAmbTrab)vo.getEsocCondAmbTrabAmbTrab().get(0)).getEsocAmbienteTrabalho().getDescricaoAmbiente().substring(0, 99)));
        }
        info.setTpInsc(Byte.parseByte("1"));
        info.setNrInsc(((EsocCondAmbTrabAmbTrab)vo.getEsocCondAmbTrabAmbTrab().get(0)).getEsocAmbienteTrabalho().getEmpresa().getPessoa().getComplemento().getCnpj());
        return info;
    }

    private ESocial.EvtExpRisco.InfoExpRisco.InfoAtiv getInfoAtividade(EsocCondicoesAmbientaisTrabalho vo) {
        ESocial.EvtExpRisco.InfoExpRisco.InfoAtiv info = this.getFact().createESocialEvtExpRiscoInfoExpRiscoInfoAtiv();
        info.setDscAtivDes(ToolString.clearSpecialCharacXML((String)vo.getDescricaoAtividades()));
        return info;
    }

    private ESocial.EvtExpRisco.InfoExpRisco.AgNoc createInfoRisco(EsocCondAmbTrabFatRisco esoc) {
        ESocial.EvtExpRisco.InfoExpRisco.AgNoc ag = this.getFact().createESocialEvtExpRiscoInfoExpRiscoAgNoc();
        ag.setCodAgNoc(esoc.getEsocFatoresRiscosMeioAmbTrab().getCodigo().trim());
        if (!esoc.getEsocFatoresRiscosMeioAmbTrab().getCodigo().trim().equals("09.01.001")) {
            ag.setTpAval(Byte.valueOf(esoc.getEsocTipoAvaliacaoFatorRisco().getCodigo()));
            ag.setDscAgNoc(esoc.getEsocFatoresRiscosMeioAmbTrab().getDescricao().trim());
        }
        if (esoc.getIntensidadeConcentracao() > 0.0) {
            BigDecimal valor = ToolFormatter.arrredondarNumeroBigDecimal((Double)esoc.getIntensidadeConcentracao(), (int)4);
            ag.setIntConc(valor.setScale(4));
        }
        if (esoc.getLimiteTolerancia() > 0.0) {
            ag.setLimTol(ToolFormatter.arrredondarNumeroBigDecimal((Double)esoc.getLimiteTolerancia(), (int)4).setScale(4));
        }
        if (esoc.getEsocDoseUnidadeMedida() != null) {
            ag.setUnMed(Byte.valueOf(esoc.getEsocDoseUnidadeMedida().getCodigo()));
        }
        if (esoc.getEsocTipoAvaliacaoFatorRisco() != null && esoc.getEsocTipoAvaliacaoFatorRisco().getCodigo().equals("1")) {
            ag.setTecMedicao(ToolString.clearSpecialCharacXML((String)esoc.getTecnicaMedicao()));
        }
        if (!esoc.getEsocFatoresRiscosMeioAmbTrab().getCodigo().trim().equals("09.01.001")) {
            ag.setEpcEpi(this.getEPI(esoc.getEsocCondicoesAmbientaisTrabalho()));
        }
        return ag;
    }

    private ESocial.EvtExpRisco.InfoExpRisco.AgNoc.EpcEpi getEPI(EsocCondicoesAmbientaisTrabalho esoc) {
        ESocial.EvtExpRisco.InfoExpRisco.AgNoc.EpcEpi epi = this.getFact().createESocialEvtExpRiscoInfoExpRiscoAgNocEpcEpi();
        epi.setUtilizEPC(Byte.parseByte(esoc.getEsocUtilizaEpc().getCodigo()));
        epi.setUtilizEPI(Byte.parseByte(esoc.getEsocUtilizaEpi().getCodigo()));
        if (esoc.getEsocUtilizaEpc().getCodigo().equals("2")) {
            epi.setEficEpc(this.getSimOrNao(esoc.getEficazEpc()));
        }
        if (esoc.getEsocUtilizaEpi().getCodigo().equals("2")) {
            epi.setEficEpi(this.getSimOrNao(esoc.getEficazEpi()));
            for (EsocCondAmbTrabEquipIn equi : esoc.getEsocCondAmbTrabEquipIn()) {
                epi.getEpi().add(this.createEPI(equi));
            }
            if (!esoc.getEsocCondAmbTrabEquipIn().isEmpty()) {
                epi.setEpiCompl(this.getEPIComplementar((EsocCondAmbTrabEquipIn)esoc.getEsocCondAmbTrabEquipIn().get(0)));
            }
        }
        return epi;
    }

    private TSSimNao getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return TSSimNao.S;
        }
        return TSSimNao.N;
    }

    private ESocial.EvtExpRisco.InfoExpRisco.AgNoc.EpcEpi.Epi createEPI(EsocCondAmbTrabEquipIn equi) {
        ESocial.EvtExpRisco.InfoExpRisco.AgNoc.EpcEpi.Epi epi = this.getFact().createESocialEvtExpRiscoInfoExpRiscoAgNocEpcEpiEpi();
        if (!equi.getEsocCadastroEquipamentoIndividualEpi().getCertificadoAprovacaoEpi().isEmpty()) {
            epi.setDocAval(equi.getEsocCadastroEquipamentoIndividualEpi().getCertificadoAprovacaoEpi());
        }
        return epi;
    }

    private ESocial.EvtExpRisco.InfoExpRisco.AgNoc.EpcEpi.EpiCompl getEPIComplementar(EsocCondAmbTrabEquipIn esoc) {
        ESocial.EvtExpRisco.InfoExpRisco.AgNoc.EpcEpi.EpiCompl epi = this.getFact().createESocialEvtExpRiscoInfoExpRiscoAgNocEpcEpiEpiCompl();
        epi.setMedProtecao(this.getSimOrNao(esoc.getEsocCadastroEquipamentoIndividualEpi().getImplemMedidasProtecaoCol()));
        epi.setCondFuncto(this.getSimOrNao(esoc.getEsocCadastroEquipamentoIndividualEpi().getObservCondFuncionamentoEpi()));
        epi.setUsoInint(this.getSimOrNao(esoc.getEsocCadastroEquipamentoIndividualEpi().getObservUsoIninterruptoEpi()));
        epi.setPrzValid(this.getSimOrNao(esoc.getEsocCadastroEquipamentoIndividualEpi().getObservPrazoValidadeCertApro()));
        epi.setPeriodicTroca(this.getSimOrNao(esoc.getEsocCadastroEquipamentoIndividualEpi().getObservPeriodicidadeTroca()));
        epi.setHigienizacao(this.getSimOrNao(esoc.getEsocCadastroEquipamentoIndividualEpi().getObservHigienizacao()));
        return epi;
    }

    private ESocial.EvtExpRisco.InfoExpRisco.RespReg createResponsavel(EsocCondAmbTrabMedico esoc) throws ExceptionEsocial {
        ESocial.EvtExpRisco.InfoExpRisco.RespReg resp = this.getFact().createESocialEvtExpRiscoInfoExpRiscoRespReg();
        if (esoc.getEsocCadastroMedicoResponsavel().getPessoa().getComplemento().getCnpj().isEmpty()) {
            throw new ExceptionEsocial("Medico: " + esoc.getEsocCadastroMedicoResponsavel().getPessoa().getNome() + " sem CPF cadastrado");
        }
        resp.setCpfResp(esoc.getEsocCadastroMedicoResponsavel().getPessoa().getComplemento().getCnpj());
        resp.setIdeOC(Byte.valueOf(esoc.getEsocCadastroMedicoResponsavel().getEsocOrgaoClasse().getCodigo()));
        resp.setNrOC(esoc.getEsocCadastroMedicoResponsavel().getNumeroOrgaoClasse());
        resp.setUfOC(this.getUF(esoc.getEsocCadastroMedicoResponsavel().getUfOrgaoClasse().getSigla()));
        return resp;
    }

    private TSUf getUF(String sigla) {
        return TSUf.fromValue(sigla);
    }
}

