/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtinfcompper;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfocomplper.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfocomplper.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfocomplper.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfocomplper.v_s_01_03_00.TIdeEventoFolha;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;

public class ImpEvtInfoCompPer
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtInfoComplPer(this.getEvtInfoCompPer(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtInfoComplPer getEvtInfoCompPer(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtInfoComplPer evt = this.getFact().createESocialEvtInfoComplPer();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento));
        evt.setInfoSubstPatr(this.getSubstituicaoPatronal(preEvento));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoFolha getIdEvento(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        TIdeEventoFolha tiTrab = this.getFact().createTIdeEventoFolha();
        tiTrab.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(preEvento.getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        if (!preEvento.getEsocFechamentoFolha().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
            tiTrab.setIndApuracao(Byte.parseByte("1"));
            tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getEsocFechamentoFolha().getPeriodoApuracao(), (String)"yyyy-MM"));
        } else {
            tiTrab.setIndApuracao(Byte.parseByte("2"));
            tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getEsocFechamentoFolha().getPeriodoApuracao(), (String)"yyyy"));
        }
        return tiTrab;
    }

    private ESocial.EvtInfoComplPer.InfoSubstPatr getSubstituicaoPatronal(EsocPreEvento preEvento) {
        ESocial.EvtInfoComplPer.InfoSubstPatr info = this.getFact().createESocialEvtInfoComplPerInfoSubstPatr();
        info.setIndSubstPatr(Byte.parseByte(preEvento.getEsocFechamentoFolha().getTipoSubstituicao().toString()));
        if (preEvento.getEsocFechamentoFolha().getTipoSubstituicao().equals(ConstantsESocial.S1280_SUBSTITUIDA_INTEGRALMENTE)) {
            info.setPercRedContrib(ToolFormatter.arrredondarNumeroBigDecimal((Double)0.0, (int)0));
        } else {
            info.setPercRedContrib(ToolFormatter.arrredondarNumeroBigDecimal((Double)preEvento.getEsocFechamentoFolha().getPercentualReducao(), (int)2));
        }
        return info;
    }
}

