/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttransferenciaadmissao;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TAprend;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TContato;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TEnderecoBrasil;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.THorContratual;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TIdeEventoTrabAdmissao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TLocalTrabGeral;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TNascimento;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TRemuneracao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TSSexo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmissao.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class ImpEvtTransferenciaAdmissao
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        TransferenciaColaborador transferencia = preEvento.getTransferenciaColaborador();
        ESocial root = this.getFact().createESocial();
        root.setEvtAdmissao(this.getEvtAdmissao(preEvento, transferencia, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAdmissao getEvtAdmissao(EsocPreEvento preEvento, TransferenciaColaborador transferencia, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtAdmissao evt = this.getFact().createESocialEvtAdmissao();
        Colaborador colaborador = transferencia.getColaborador();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        evt.setTrabalhador(this.getTrabalhador(colaborador));
        evt.setVinculo(this.getVinculo(preEvento, transferencia));
        return evt;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrabAdmissao getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEventoTrabAdmissao tiTrab = this.getFact().createTIdeEventoTrabAdmissao();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private ESocial.EvtAdmissao.Trabalhador getTrabalhador(Colaborador colaborador) {
        ESocial.EvtAdmissao.Trabalhador trabalhador = this.getFact().createESocialEvtAdmissaoTrabalhador();
        trabalhador.setCpfTrab(colaborador.getPessoa().getComplemento().getCnpj());
        trabalhador.setNmTrab(colaborador.getPessoa().getNome());
        trabalhador.setSexo(this.getSexo(colaborador.getSexo()));
        trabalhador.setRacaCor(Byte.parseByte(colaborador.getRacaCor().getCodigoEsocial()));
        if (colaborador.getEstadoCivil() != null) {
            trabalhador.setEstCiv(Byte.valueOf(colaborador.getEstadoCivil().getCodigoEsocial()));
        }
        trabalhador.setGrauInstr(colaborador.getGrauInstrucao().getCodigo());
        if (colaborador.getNomeSocialTravesti() != null && colaborador.getNomeSocialTravesti().length() > 0) {
            trabalhador.setNmSoc(colaborador.getNomeSocialTravesti());
        }
        trabalhador.setNascimento(this.getNascimento(colaborador));
        trabalhador.setEndereco(this.getEndereco(colaborador));
        if (colaborador.getTipoDeficiencia() != null) {
            trabalhador.setInfoDeficiencia(this.getInfoDeficiencia(colaborador));
        }
        HelperColaborador helper = new HelperColaborador();
        List deps = helper.build(colaborador).getDependentesSalFamIRRF(new Date());
        for (ColaboradorDependente dep : deps) {
            ESocial.EvtAdmissao.Trabalhador.Dependente d = this.getFact().createESocialEvtAdmissaoTrabalhadorDependente();
            d.setTpDep(dep.getTipoDependente().getCodigo());
            d.setNmDep(ToolString.clearInvalidUTF8Char((String)dep.getNomeDependente()));
            d.setDtNascto(ToolEsocial.converteData(dep.getDataNascimento()));
            if (ToolMethods.isStrWithData((String)dep.getCpf())) {
                d.setCpfDep(ToolString.refina((String)dep.getCpf()));
            }
            d.setDepSF(this.getSimOrNao(dep.getDependenteSalarioFamilia()));
            d.setDepIRRF(this.getSimOrNao(dep.getDependenteIRRF()));
            d.setIncTrab(this.getSimOrNao(dep.getDependenteIncapacitado()));
            trabalhador.getDependente().add(d);
        }
        if (colaborador.getPessoa().getComplemento().getFone1() != null && colaborador.getPessoa().getComplemento().getFone1().length() > 0 || colaborador.getPessoa().getComplemento().getEmailPrincipal() != null && colaborador.getPessoa().getComplemento().getEmailPrincipal().length() > 0) {
            trabalhador.setContato(this.getContato(colaborador));
        }
        return trabalhador;
    }

    private TSSexo getSexo(Short sexo) {
        if (sexo.equals((short)1)) {
            return TSSexo.F;
        }
        return TSSexo.M;
    }

    private TSSimNao getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return TSSimNao.S;
        }
        return TSSimNao.N;
    }

    private TNascimento getNascimento(Colaborador colaborador) {
        TNascimento nascimento = this.getFact().createTNascimento();
        nascimento.setDtNascto(ToolEsocial.converteData(colaborador.getPessoa().getComplemento().getDataNascimento()));
        if (colaborador.getCidadeNascimento() != null) {
            nascimento.setPaisNac("105");
            nascimento.setPaisNascto("105");
        } else {
            nascimento.setPaisNac(colaborador.getNacionalidade().getCodigoESocial());
            nascimento.setPaisNac(colaborador.getNacionalidade().getCodigoESocial());
        }
        return nascimento;
    }

    private ESocial.EvtAdmissao.Trabalhador.Endereco getEndereco(Colaborador colaborador) {
        ESocial.EvtAdmissao.Trabalhador.Endereco endereco = this.getFact().createESocialEvtAdmissaoTrabalhadorEndereco();
        if (colaborador.getNacionalidade().getCodigoESocial().equals("105")) {
            endereco.setBrasil(this.getEnderecoBrasil(colaborador));
        }
        return endereco;
    }

    private TEnderecoBrasil getEnderecoBrasil(Colaborador colaborador) {
        TEnderecoBrasil endereco = this.getFact().createTEnderecoBrasil();
        endereco.setBairro(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getBairro()));
        endereco.setCep(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getCep()));
        endereco.setCodMunic(new BigInteger(colaborador.getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        if (colaborador.getPessoa().getEndereco().getComplemento() != null && colaborador.getPessoa().getEndereco().getComplemento().length() > 0) {
            endereco.setComplemento(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getComplemento()));
        }
        endereco.setDscLograd(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getLogradouro()));
        endereco.setNrLograd(colaborador.getPessoa().getEndereco().getNumero());
        endereco.setTpLograd(colaborador.getTipoLogradouroEndereco().getSigla());
        endereco.setUf(TSUf.fromValue(colaborador.getPessoa().getEndereco().getCidade().getUf().getSigla()));
        return endereco;
    }

    private ESocial.EvtAdmissao.Trabalhador.InfoDeficiencia getInfoDeficiencia(Colaborador colaborador) {
        ESocial.EvtAdmissao.Trabalhador.InfoDeficiencia infoDeficiencia = this.getFact().createESocialEvtAdmissaoTrabalhadorInfoDeficiencia();
        if (colaborador.getTipoDeficiencia().getCodigo().equals("2")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.S);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("1")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.S);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("7")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.S);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("4")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.S);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("6")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.S);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("3")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.S);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        }
        infoDeficiencia.setInfoCota(this.getSimOrNao(colaborador.getColaboradorIncapaz()));
        return infoDeficiencia;
    }

    private TContato getContato(Colaborador colaborador) {
        TContato contato = this.getFact().createTContato();
        if (colaborador.getPessoa().getComplemento().getFone1() != null && colaborador.getPessoa().getComplemento().getFone1().length() > 0) {
            contato.setFonePrinc(ToolString.refina((String)colaborador.getPessoa().getComplemento().getFone1()));
        }
        if (colaborador.getPessoa().getComplemento().getCel1() != null && colaborador.getPessoa().getComplemento().getCel1().length() > 0) {
            contato.setFonePrinc(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCel1()));
        }
        if (colaborador.getPessoa().getComplemento().getEmailPrincipal() != null && colaborador.getPessoa().getComplemento().getEmailPrincipal().length() > 0) {
            contato.setEmailPrinc(colaborador.getPessoa().getComplemento().getEmailPrincipal());
        }
        return contato;
    }

    private ESocial.EvtAdmissao.Vinculo getVinculo(EsocPreEvento preEvento, TransferenciaColaborador t) {
        Colaborador colaborador = t.getColaborador();
        ESocial.EvtAdmissao.Vinculo vinculo = this.getFact().createESocialEvtAdmissaoVinculo();
        vinculo.setMatricula(colaborador.getNumeroRegistroESocial());
        vinculo.setTpRegTrab(Byte.parseByte(colaborador.getRegimeTrabalhista().getCodigo()));
        vinculo.setTpRegPrev(Byte.parseByte(colaborador.getRegimePrevidenciario().getCodigo()));
        vinculo.setCadIni("N");
        vinculo.setInfoRegimeTrab(this.getInfoRegimeTrabalhista(t));
        vinculo.setInfoContrato(this.getInfoContrato(colaborador, preEvento));
        if (preEvento.getDataAfastamento() != null) {
            vinculo.setAfastamento(this.getAfastamento(preEvento));
        }
        vinculo.setSucessaoVinc(this.getSucessaoVinculo(t));
        return vinculo;
    }

    private Date getInicioObrigatoriedadeProducao(OpcoesESocial opcoes) {
        return opcoes.getDataSegundaFase();
    }

    private Date getInicioObrigatoriedadeProducaoRestrita() {
        GregorianCalendar g = new GregorianCalendar();
        g.set(5, 1);
        g.set(2, 0);
        g.set(1, 2017);
        return g.getTime();
    }

    private ESocial.EvtAdmissao.Vinculo.InfoRegimeTrab getInfoRegimeTrabalhista(TransferenciaColaborador t) {
        ESocial.EvtAdmissao.Vinculo.InfoRegimeTrab infoRegime = this.getFact().createESocialEvtAdmissaoVinculoInfoRegimeTrab();
        infoRegime.setInfoCeletista(this.getInfoRegimeCeletista(t));
        return infoRegime;
    }

    private ESocial.EvtAdmissao.Vinculo.InfoRegimeTrab.InfoCeletista getInfoRegimeCeletista(TransferenciaColaborador t) {
        ESocial.EvtAdmissao.Vinculo.InfoRegimeTrab.InfoCeletista infoCeletista = this.getFact().createESocialEvtAdmissaoVinculoInfoRegimeTrabInfoCeletista();
        infoCeletista.setDtAdm(ToolEsocial.converteData(t.getColaborador().getDataAdmissao()));
        infoCeletista.setTpAdmissao(Byte.parseByte(t.getTipoAdmissaoEsocial().getCodigo()));
        infoCeletista.setIndAdmissao(Byte.parseByte(t.getIndicativoAdmissao().getCodigo()));
        infoCeletista.setTpRegJor(Byte.parseByte(t.getColaborador().getRegimeJornadaTrabalho().getCodigo()));
        infoCeletista.setNatAtividade(Byte.parseByte(t.getColaborador().getNaturezaAtividade().getCodigo()));
        if (t.getColaborador().getSindicato() != null) {
            if (t.getColaborador().getSindicato().getMesDataBase() != null) {
                infoCeletista.setDtBase(Byte.valueOf(t.getColaborador().getSindicato().getMesDataBase().toString()));
            }
            if (t.getColaborador().getSindicato().getPessoa().getComplemento().getCnpj() != null && t.getColaborador().getSindicato().getPessoa().getComplemento().getCnpj().length() > 0) {
                infoCeletista.setCnpjSindCategProf(ToolString.refina((String)t.getColaborador().getSindicato().getPessoa().getComplemento().getCnpj()));
            } else if (t.getColaborador().getSindicato().getCnpjSindicato() != null && t.getColaborador().getSindicato().getCnpjSindicato().length() > 0) {
                infoCeletista.setCnpjSindCategProf(ToolString.refina((String)t.getColaborador().getSindicato().getCnpjSindicato()));
            }
        }
        if (t.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("103") && t.getColaborador().getEstabelecimento().getContratacaoAPrendizSocEducativa().equals((short)1)) {
            infoCeletista.setAprend(this.getAprend(t.getColaborador().getEstabelecimento()));
        }
        if (t.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("103")) {
            infoCeletista.setAprend(this.getAprend(t.getColaborador()));
        }
        return infoCeletista;
    }

    private TAprend getAprend(Colaborador colaborador) {
        TAprend aprendiz = this.getFact().createTAprend();
        aprendiz.setIndAprend(Byte.parseByte("1"));
        aprendiz.setCnpjEntQual(ToolString.refina((String)colaborador.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj()));
        return aprendiz;
    }

    private ESocial.EvtAdmissao.Vinculo.InfoContrato getInfoContrato(Colaborador colaborador, EsocPreEvento esoc) {
        ESocial.EvtAdmissao.Vinculo.InfoContrato tDados = this.getFact().createESocialEvtAdmissaoVinculoInfoContrato();
        tDados.setCBOCargo(ToolString.refina((String)colaborador.getFuncao().getCbo().getCodigo()));
        tDados.setNmCargo(colaborador.getFuncao().getDescricao());
        tDados.setCodCateg(new BigInteger(colaborador.getEsocCategoriaTrabalhador().getCodigo()));
        tDados.setRemuneracao(this.getRemuneracao(colaborador, esoc));
        tDados.setDuracao(this.getDuracao(colaborador, esoc));
        tDados.setLocalTrabalho(this.getLocalTrabalho(colaborador));
        tDados.setHorContratual(this.getHorarioTrabalho(colaborador));
        return tDados;
    }

    private TRemuneracao getRemuneracao(Colaborador colaborador, EsocPreEvento esocPreEvento) {
        TRemuneracao r = this.getFact().createTRemuneracao();
        r.setUndSalFixo(Byte.parseByte(colaborador.getTipoSalario().getCodigoEsocial()));
        if (colaborador.getTipoSalario().getCodigoEsocial().equals("7")) {
            r.setDscSalVar(colaborador.getDescricaoSalario());
            r.setVrSalFx(new BigDecimal(0));
        } else {
            Double valorSalario = esocPreEvento.getSalarioColaborador();
            r.setVrSalFx(ToolFormatter.arrredondarNumeroBigDecimal((Double)valorSalario, (int)2));
        }
        return r;
    }

    private ESocial.EvtAdmissao.Vinculo.InfoContrato.Duracao getDuracao(Colaborador colaborador, EsocPreEvento esoc) {
        ESocial.EvtAdmissao.Vinculo.InfoContrato.Duracao duracao = this.getFact().createESocialEvtAdmissaoVinculoInfoContratoDuracao();
        if (colaborador.getPrimeiraDataExperiencia() == null && colaborador.getSegundaDataExperiencia() == null) {
            duracao.setTpContr(Byte.parseByte("1"));
            return duracao;
        }
        if (colaborador.getPrimeiraDataExperiencia() != null && colaborador.getPrimeiraDataExperiencia().after(new Date())) {
            duracao.setTpContr(Byte.parseByte("2"));
            duracao.setDtTerm(ToolEsocial.converteData(colaborador.getPrimeiraDataExperiencia()));
            duracao.setClauAssec(this.getSimOrNao(colaborador.getClausulaAssecuratoria()));
        } else if (colaborador.getSegundaDataExperiencia() != null && colaborador.getSegundaDataExperiencia().after(new Date())) {
            duracao.setTpContr(Byte.parseByte("2"));
            duracao.setDtTerm(ToolEsocial.converteData(colaborador.getSegundaDataExperiencia()));
            duracao.setClauAssec(this.getSimOrNao(colaborador.getClausulaAssecuratoria()));
        } else {
            duracao.setTpContr(Byte.parseByte("1"));
        }
        return duracao;
    }

    private ESocial.EvtAdmissao.Vinculo.InfoContrato.LocalTrabalho getLocalTrabalho(Colaborador colaborador) {
        ESocial.EvtAdmissao.Vinculo.InfoContrato.LocalTrabalho local = this.getFact().createESocialEvtAdmissaoVinculoInfoContratoLocalTrabalho();
        local.setLocalTrabGeral(this.getLocalTrabalhoGeral(colaborador));
        return local;
    }

    private TLocalTrabGeral getLocalTrabalhoGeral(Colaborador colaborador) {
        TLocalTrabGeral l = this.getFact().createTLocalTrabGeral();
        l.setTpInsc(Byte.parseByte("1"));
        l.setNrInsc(ToolString.refina((String)colaborador.getEmpresa().getPessoa().getComplemento().getCnpj()));
        return l;
    }

    private THorContratual getHorarioTrabalho(Colaborador colaborador) {
        THorContratual h = this.getFact().createTHorContratual();
        if (!colaborador.getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            h.setQtdHrsSem(new BigDecimal(colaborador.getJornadaSemanal()));
        }
        h.setTpJornada(Byte.parseByte(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo()));
        h.setTmpParc(Byte.parseByte(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getEsocTipoContrato().getCodigo()));
        h.setHorNoturno(this.getSimOrNao(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getPossuiHoraNoturna()));
        h.setDscJorn(ToolString.clearSpecialCharacXML((String)colaborador.getHorarioTrabalho().getDescricao().toUpperCase()));
        return h;
    }

    private ESocial.EvtAdmissao.Vinculo.SucessaoVinc getSucessao(Colaborador colaborador) {
        ESocial.EvtAdmissao.Vinculo.SucessaoVinc s = this.getFact().createESocialEvtAdmissaoVinculoSucessaoVinc();
        s.setMatricAnt(colaborador.getMatriculaAnterior());
        s.setDtTransf(ToolEsocial.converteData(colaborador.getDataTransferenciaEmpregado()));
        return s;
    }

    private ESocial.EvtAdmissao.Vinculo.Desligamento getDesligamento(Colaborador colaborador) {
        ESocial.EvtAdmissao.Vinculo.Desligamento d = this.getFact().createESocialEvtAdmissaoVinculoDesligamento();
        d.setDtDeslig(ToolEsocial.converteData(colaborador.getDataDemissao()));
        return d;
    }

    private ESocial.EvtAdmissao.Vinculo.Afastamento getAfastamento(EsocPreEvento preEvento) {
        ESocial.EvtAdmissao.Vinculo.Afastamento afastamento = this.getFact().createESocialEvtAdmissaoVinculoAfastamento();
        afastamento.setDtIniAfast(ToolEsocial.converteData(preEvento.getDataAfastamento()));
        afastamento.setCodMotAfast(preEvento.getCodigoAfastamento());
        return afastamento;
    }

    private TAprend getAprend(EsocCadastroEstabelcimento e) {
        TAprend aprendiz = this.getFact().createTAprend();
        aprendiz.setNrInsc(ToolString.refina((String)e.getCnpjSocEducativa()));
        aprendiz.setTpInsc(Byte.valueOf("1"));
        return aprendiz;
    }

    private ESocial.EvtAdmissao.Vinculo.SucessaoVinc getSucessaoVinculo(TransferenciaColaborador t) {
        ESocial.EvtAdmissao.Vinculo.SucessaoVinc sucessao = this.getFact().createESocialEvtAdmissaoVinculoSucessaoVinc();
        sucessao.setTpInsc(Byte.parseByte("1"));
        sucessao.setNrInsc(ToolString.refina((String)t.getEmpresa().getPessoa().getComplemento().getCnpj()));
        sucessao.setMatricAnt(ToolString.refina((String)t.getMatriculaAnterior()));
        sucessao.setDtTransf(ToolEsocial.converteData(t.getDataTransferenciaEntrada()));
        if (t.getObservacao() != null && t.getObservacao().length() > 0) {
            sucessao.setObservacao(t.getObservacao());
        }
        return sucessao;
    }
}

